/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.io.IOException;
import java.io.OutputStream;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.FSTObjectSerializer;

public class FSTObjectOutputNoShared
extends FSTObjectOutput {
    public FSTObjectOutputNoShared(OutputStream out) {
        super(out);
        this.objects.disabled = true;
    }

    public FSTObjectOutputNoShared(OutputStream out, FSTConfiguration conf) {
        super(out, conf);
        conf.setShareReferences(false);
        this.objects.disabled = true;
    }

    public FSTObjectOutputNoShared(FSTConfiguration conf) {
        super(conf);
        conf.setShareReferences(false);
        this.objects.disabled = true;
    }

    public FSTObjectOutputNoShared() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FSTClazzInfo writeObjectWithContext(FSTClazzInfo.FSTFieldInfo referencee, Object toWrite) throws IOException {
        int startPosition = this.getCodec().getWritten();
        boolean dontShare = true;
        this.objectWillBeWritten(toWrite, startPosition);
        try {
            String s2;
            if (toWrite == null) {
                this.getCodec().writeTag((byte)-1, null, 0L, toWrite, this);
                FSTClazzInfo fSTClazzInfo = null;
                return fSTClazzInfo;
            }
            Class<?> clazz = toWrite.getClass();
            if (clazz == String.class) {
                String[] oneOf = referencee.getOneOf();
                if (oneOf != null) {
                    for (int i = 0; i < oneOf.length; ++i) {
                        s2 = oneOf[i];
                        if (!s2.equals(toWrite)) continue;
                        this.getCodec().writeTag((byte)-18, oneOf, i, toWrite, this);
                        this.getCodec().writeFByte(i);
                        FSTClazzInfo fSTClazzInfo = null;
                        return fSTClazzInfo;
                    }
                }
                if (dontShare) {
                    this.getCodec().writeTag((byte)-4, toWrite, 0L, toWrite, this);
                    this.getCodec().writeStringUTF((String)toWrite);
                    FSTClazzInfo i = null;
                    return i;
                }
            } else {
                if (clazz == Integer.class) {
                    this.getCodec().writeTag((byte)-9, null, 0L, toWrite, this);
                    this.getCodec().writeFInt((Integer)toWrite);
                    FSTClazzInfo oneOf = null;
                    return oneOf;
                }
                if (clazz == Long.class) {
                    this.getCodec().writeTag((byte)-10, null, 0L, toWrite, this);
                    this.getCodec().writeFLong((Long)toWrite);
                    FSTClazzInfo oneOf = null;
                    return oneOf;
                }
                if (clazz == Boolean.class) {
                    this.getCodec().writeTag((Boolean)toWrite != false ? (byte)-16 : -17, null, 0L, toWrite, this);
                    FSTClazzInfo oneOf = null;
                    return oneOf;
                }
                if (referencee.getType() != null && referencee.getType().isEnum() || toWrite instanceof Enum) {
                    if (!this.getCodec().writeTag((byte)-6, toWrite, 0L, toWrite, this)) {
                        boolean isEnumClass = toWrite.getClass().isEnum();
                        if (!isEnumClass) {
                            Class<?> c = toWrite.getClass();
                            while (c != null && !c.isEnum()) {
                                c = toWrite.getClass().getSuperclass();
                            }
                            if (c == null) {
                                throw new RuntimeException("Can't handle this enum: " + toWrite.getClass());
                            }
                            this.getCodec().writeClass(c);
                        } else {
                            this.getCodec().writeClass(this.getFstClazzInfo(referencee, toWrite.getClass()));
                        }
                        this.getCodec().writeFInt(((Enum)toWrite).ordinal());
                    }
                    FSTClazzInfo isEnumClass = null;
                    return isEnumClass;
                }
            }
            FSTClazzInfo serializationInfo = this.getFstClazzInfo(referencee, clazz);
            FSTObjectSerializer ser = serializationInfo.getSer();
            if (clazz.isArray()) {
                if (this.getCodec().writeTag((byte)-5, toWrite, 0L, toWrite, this)) {
                    s2 = null;
                    return s2;
                }
                this.writeArray(referencee, toWrite);
            } else if (ser == null) {
                if (!this.writeObjectHeader(serializationInfo, referencee, toWrite)) {
                    this.defaultWriteObject(toWrite, serializationInfo);
                    if (serializationInfo.isExternalizable()) {
                        this.getCodec().externalEnd(serializationInfo);
                    }
                }
            } else {
                int pos = this.getCodec().getWritten();
                if (!this.writeObjectHeader(serializationInfo, referencee, toWrite)) {
                    ser.writeObject(this, toWrite, serializationInfo, referencee, pos);
                    this.getCodec().externalEnd(serializationInfo);
                }
            }
            FSTClazzInfo fSTClazzInfo = serializationInfo;
            return fSTClazzInfo;
        }
        finally {
            this.objectHasBeenWritten(toWrite, startPosition, this.getCodec().getWritten());
        }
    }

    @Override
    public void resetForReUse(OutputStream out) {
        if (this.closed) {
            throw new RuntimeException("Can't reuse closed stream");
        }
        this.getCodec().reset(null);
        if (out != null) {
            this.getCodec().setOutstream(out);
        }
    }

    @Override
    public void resetForReUse(byte[] out) {
        if (this.closed) {
            throw new RuntimeException("Can't reuse closed stream");
        }
        this.getCodec().reset(out);
    }
}

