#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
"""Malloy schema icons"""

average_icon = """
<svg width="16px" height="16px" viewBox="3 3 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>malloy-icon-average</title>
    <g id="malloy-icon-average" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <path d="M4.41498506,4.47102819 L5.41498506,4.47102819 L5.41498506,7.60902819 L6.38998506,7.60902819 L6.483244,7.05041648 L6.54364821,6.70726068 C6.55375344,6.65243195 6.5638915,6.59877378 6.57408328,6.54626903 L6.57408328,6.54626903 L6.63604534,6.24494478 C6.91927717,4.95003854 7.27208445,4.47102819 8.10517978,4.47102819 C8.80685946,4.47102819 9.17751923,4.83392314 9.44530059,5.71673347 L9.44530059,5.71673347 L9.51297288,5.95892899 L9.57687776,6.2253318 C9.60803835,6.36468828 9.63812368,6.5133548 9.66764002,6.6716798 L9.66764002,6.6716798 L9.72606405,7.00131102 L9.81937671,7.57326138 L9.82498506,7.60902819 L11.5850149,7.60974536 L11.5850149,8.60974536 L10.0252776,8.61151943 C10.2757427,9.61923038 10.5930546,10.0190062 11.1557069,10.0190062 C11.393522,10.0190062 11.5850149,10.212488 11.5850149,10.4495815 C11.5850149,10.476647 11.5825195,10.5031442 11.5777446,10.5288501 L11.5850149,10.5289718 L11.5850149,11.5289718 L4.41498506,11.5289718 L4.41498506,4.47102819 Z M9.14183678,8.61032799 L7.06953368,8.61055285 C6.85505955,9.56758449 6.5955838,10.1843572 6.18252219,10.5298281 L10.0788576,10.5296645 C9.63436973,10.1674352 9.34864848,9.52569813 9.14183678,8.61032799 Z M6.19098506,8.60902819 L5.41498506,8.60902819 L5.41611605,9.94762989 C5.73820917,9.80412788 5.96190884,9.43735727 6.14461991,8.78552705 L6.19098506,8.60902819 Z M8.10517978,5.33217898 C7.85286852,5.33217898 7.68100552,5.58113011 7.51762732,6.24210504 L7.51762732,6.24210504 L7.46623231,6.46472024 C7.4576855,6.50416886 7.44914122,6.54480636 7.44058896,6.58665653 L7.44058896,6.58665653 L7.38909582,6.85249973 L7.33690774,7.14858809 L7.26098506,7.60902819 L8.95598506,7.60902819 L8.87526449,7.12113673 L8.82259674,6.82795881 L8.7707472,6.56506868 L8.71919413,6.3312772 L8.66741574,6.12539524 L8.61489027,5.94623366 C8.47336247,5.50303964 8.31830033,5.33217898 8.10517978,5.33217898 Z" id="Combined-Shape-Copy" fill="#FF9472" fill-rule="nonzero"></path>
    </g>
</svg>
"""

boolean_icon = """
<svg width="16px" height="16px" viewBox="3 3 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>malloy-icon-on-off</title>
    <g id="malloy-icon-on-off" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Group-Copy" transform="translate(4.000000, 4.500000)" fill="#85B0F7" fill-rule="nonzero">
            <path d="M1.91456839,3.19128704 L6.08543161,3.19128704 C6.97964906,3.19128704 7.70455553,2.50020954 7.70455553,1.64772223 C7.70455553,0.795234931 6.97964906,0.104157428 6.08543161,0.104157428 L1.91456839,0.104157428 C1.02035094,0.104157428 0.295444466,0.795234931 0.295444466,1.64772223 C0.295444466,2.50020954 1.02035094,3.19128704 1.91456839,3.19128704 Z M1.91456839,0.72158335 L6.08543161,0.72158335 C6.62196208,0.72158335 7.05690596,1.13622985 7.05690596,1.64772223 C7.05690596,2.15921461 6.62196208,2.57386112 6.08543161,2.57386112 L1.91456839,2.57386112 C1.37803792,2.57386112 0.943094035,2.15921461 0.943094035,1.64772223 C0.943094035,1.13622985 1.37803792,0.72158335 1.91456839,0.72158335 Z" id="Shape-Copy-20"></path>
            <path d="M2.13289582,2.24100941 C2.3830645,2.24304337 2.60973321,2.09391109 2.70688127,1.86336684 C2.80402933,1.63282258 2.75245196,1.36644163 2.57627365,1.18881942 C2.40009535,1.01119721 2.13414403,0.957447111 1.90281418,1.05270987 C1.67148434,1.14797263 1.52049829,1.37341617 1.52049829,1.62359286 C1.52049829,1.96263189 1.79386765,2.23825299 2.13289582,2.24100941 L2.13289582,2.24100941 Z" id="Path-Copy-14"></path>
            <path d="M6.0854316,3.80871296 L1.91456836,3.80871296 C1.02035092,3.80871296 0.295444466,4.49979048 0.295444466,5.35227777 C0.295444466,6.20476506 1.02035092,6.89584257 1.91456836,6.89584257 L6.0854316,6.89584257 C6.97964906,6.89584257 7.70455553,6.20476507 7.70455553,5.35227777 C7.70455553,4.49979046 6.97964906,3.80871296 6.0854316,3.80871296 L6.0854316,3.80871296 Z M6.0854316,6.27841665 L1.91456836,6.27841665 C1.37803789,6.27841665 0.943094004,5.86377015 0.943094004,5.35227777 C0.943094004,4.84078539 1.37803789,4.42613888 1.91456836,4.42613888 L6.0854316,4.42613888 C6.62196208,4.42613888 7.05690596,4.84078539 7.05690596,5.35227777 C7.05690596,5.86377015 6.62196208,6.27841665 6.0854316,6.27841665 L6.0854316,6.27841665 Z" id="Shape-Copy-21"></path>
            <path d="M5.83936825,4.78190288 C5.58919957,4.77986892 5.36253086,4.9290012 5.2653828,5.15954545 C5.16823474,5.39008971 5.21981211,5.65647067 5.39599042,5.83409287 C5.57216872,6.01171508 5.83812004,6.06546518 6.06944989,5.97020242 C6.30077973,5.87493966 6.45176578,5.64949612 6.45176578,5.39931943 C6.45176578,5.0602804 6.17839642,4.7846593 5.83936825,4.78190288 Z" id="Path-Copy-15"></path>
        </g>
    </g>
</svg>
"""

database_icon = """
<svg width="78px" height="73px" viewBox="-20 -20 116 112" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>database_b</title>
    <g id="icons" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="database_b" transform="translate(-0.000189, 0.800000)" fill="#000000" fill-rule="nonzero">
            <g id="Shape-2">
                <path d="M38.9978747,0 C49.4323909,0 58.8817175,1.35601948 65.8935492,3.63769481 C69.399635,4.77856169 72.3064537,6.14483766 74.4415973,7.78792208 C76.5767408,9.43100649 78,11.4644805 78,13.7176948 L78,59.1428571 C77.5289095,61.1095617 75.9098694,63.0619481 74.4415973,64.2103247 C72.3064537,65.8534091 69.3994651,67.2213799 65.8935492,68.3623052 C58.8808682,70.6440097 49.4317114,72 38.9978747,72 C28.564038,72 19.1123333,70.6439805 12.0988029,68.3623052 C8.59271719,67.2214383 5.68589845,65.8534091 3.55075491,64.2103247 C1.77316722,62.6163312 0.466092472,61.0553571 0.000162359918,59.1428571 L0.000162359918,12.826461 C-0.00497251122,12.4857468 0.111806422,12.1513003 0.334077073,11.8687938 C0.867540225,10.3512127 2.01808874,8.96790097 3.55089079,7.78869643 C5.68603434,6.14561201 8.59302294,4.77924838 12.0989388,3.63846916 C19.1116199,1.35676461 28.562815,0.000774350649 38.9980106,0.000774350649 L38.9978747,0 Z M38.9980026,4.39968547 C29.1795807,4.39968547 20.2971169,5.97898133 14.0341392,8.43960024 C10.9023181,9.66989245 8.43317659,11.1339692 6.85248078,12.602151 C3.94393403,15.3862114 4.29446142,18.3655235 6.85248078,20.7802963 C8.43327627,22.2484263 10.9024843,23.7104505 14.0341392,24.9407772 C20.2982797,27.4014306 29.1795807,28.9827618 38.9980026,28.9827618 C48.8164245,28.9827618 57.7038721,27.4014306 63.968511,24.9407772 C67.1003321,23.710485 69.5714672,22.2484781 71.152163,20.7802963 C74.08729,18.0024452 73.4953805,14.8214996 71.152163,12.602151 C69.5713675,11.1340209 67.100166,9.66992695 63.968511,8.43960024 C57.705035,5.97894683 48.8172551,4.39968547 38.9980026,4.39968547 Z M73.3181233,24.4886668 C71.264963,26.4046321 68.5511168,28.0180283 65.3038377,29.3722628 C58.4452957,32.2325658 49.203832,33.9324103 38.9993316,33.9324103 C28.7948312,33.9324103 19.5508756,32.2325291 12.691503,29.3722628 C9.44422385,28.0179367 6.73170664,26.4046321 4.67921092,24.4886668 L4.67921092,34.5578783 C4.85118531,35.7254798 5.51373193,36.9581006 6.85314528,38.278818 C8.43394077,39.8377628 10.9031488,41.3838137 14.0348037,42.6902452 C20.2989442,45.3031082 29.1802452,46.9886668 38.9986671,46.9886668 C48.817089,46.9886668 57.7045366,45.3030899 63.9691755,42.6902452 C67.1009966,41.3838503 69.5721317,39.8378178 71.1528275,38.278818 C72.4811934,36.9688517 73.1398693,35.7461761 73.3189539,34.5871829 L73.3181233,24.4886668 Z M73.3181233,43.1016944 C71.264963,44.782251 68.5517813,46.1967717 65.3038377,47.3852582 C58.4452957,49.8941247 49.203832,51.3851147 38.9993316,51.3851147 C28.7948312,51.3851147 19.5508756,49.8940926 12.691503,47.3852582 C9.44422385,46.197334 6.73170664,44.7841788 4.67921092,43.1036222 L4.67921092,55.7057886 C4.85118531,56.7299305 5.51373193,57.811103 6.85314528,58.9695481 C8.43394077,60.3369502 10.9031488,61.6911148 14.0348037,62.8370291 C20.2989442,65.1288579 29.1802452,66.6016944 38.9986671,66.6016944 C48.817089,66.6016944 57.7045366,65.1288579 63.9691755,62.8370291 C67.1009966,61.6911469 69.5721317,60.3369984 71.1528275,58.9695481 C72.4811934,57.8205331 73.1398693,56.7480839 73.3189539,55.7314925 L73.3181233,43.1016944 Z" id="Shape"></path>
            </g>
        </g>
    </g>
</svg>
"""

distance_icon = """
<svg width="16px" height="16px" viewBox="3 3 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>malloy-icon-distance</title>
    <g id="malloy-icon-distance" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <path d="M7.99610114,4.10113525 C5.8439278,4.10113525 4.10113525,5.84782666 4.10113525,8 C4.10113525,10.1521733 5.8439278,11.8988647 7.99610114,11.8988647 C10.1521733,11.8988647 11.8988647,10.1521733 11.8988647,8 C11.8988647,5.84782666 10.1521733,4.10113525 7.99610114,4.10113525 Z M10.6980144,6.4404541 L9.5478493,6.4404541 C9.42308563,5.95309601 9.24373785,5.48523224 9.00980597,5.05245825 C9.72719708,5.29808673 10.3237234,5.79714142 10.6980144,6.4404541 Z M8,4.89650366 C8.32360577,5.36436743 8.57703198,5.88291644 8.74468317,6.4404541 L7.25531683,6.4404541 C7.42296802,5.88291644 7.67639423,5.36436743 8,4.89650366 Z M4.98227869,8.77977295 C4.91989685,8.53024561 4.8809082,8.26902167 4.8809082,8 C4.8809082,7.73097833 4.91989685,7.46975439 4.98227869,7.22022705 L6.30009497,7.22022705 C6.26890405,7.47755212 6.24551086,7.7348772 6.24551086,8 C6.24551086,8.2651228 6.26890405,8.52244788 6.30009497,8.77977295 L4.98227869,8.77977295 Z M5.3019856,9.5595459 L6.4521507,9.5595459 C6.57691437,10.046904 6.75626215,10.5147678 6.99019403,10.9475417 C6.27280292,10.7019133 5.67627661,10.2067574 5.3019856,9.5595459 L5.3019856,9.5595459 Z M6.4521507,6.4404541 L5.3019856,6.4404541 C5.67627661,5.79324255 6.27280292,5.29808673 6.99019403,5.05245825 C6.75626215,5.48523224 6.57691437,5.95309601 6.4521507,6.4404541 L6.4521507,6.4404541 Z M8,11.1034963 C7.67639423,10.6356326 7.42296802,10.1170836 7.25531683,9.5595459 L8.74468317,9.5595459 C8.57703198,10.1170836 8.32360577,10.6356326 8,11.1034963 Z M8.91233435,8.77977295 L7.08766565,8.77977295 C7.05257587,8.52244788 7.02528381,8.2651228 7.02528381,8 C7.02528381,7.7348772 7.05257587,7.47365326 7.08766565,7.22022705 L8.91233435,7.22022705 C8.94742413,7.47365326 8.97471619,7.7348772 8.97471619,8 C8.97471619,8.2651228 8.94742413,8.52244788 8.91233435,8.77977295 Z M9.00980597,10.9475417 C9.24373785,10.5147678 9.42308563,10.046904 9.5478493,9.5595459 L10.6980144,9.5595459 C10.3237234,10.2028586 9.72719708,10.7019133 9.00980597,10.9475417 L9.00980597,10.9475417 Z M9.69990503,8.77977295 C9.73109595,8.52244788 9.75448914,8.2651228 9.75448914,8 C9.75448914,7.7348772 9.73109595,7.47755212 9.69990503,7.22022705 L11.0177213,7.22022705 C11.0801031,7.46975439 11.1190918,7.73097833 11.1190918,8 C11.1190918,8.26902167 11.0801031,8.53024561 11.0177213,8.77977295 L9.69990503,8.77977295 Z" id="Shape-Copy-26" fill="#85B0F7" fill-rule="nonzero"></path>
    </g>
</svg>
"""

location_icon = """
<svg width="16px" height="16px" viewBox="3 3 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>malloy-icon-location</title>
    <g id="malloy-icon-location" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Group-2" transform="translate(5.000000, 4.000000)" fill="#85B0F7" fill-rule="nonzero">
            <path d="M3,8.8817842e-16 C1.5225738,8.8817842e-16 0.327652872,1.20819783 0.327652872,2.70203987 C0.327652872,4.72856978 3,7.72011393 3,7.72011393 C3,7.72011393 5.67234713,4.72856978 5.67234713,2.70203987 C5.67234713,1.20819783 4.4774262,8.8817842e-16 3,8.8817842e-16 Z M1.09118062,2.70203987 C1.09118062,1.63666415 1.9463317,0.772011393 3,0.772011393 C4.0536683,0.772011393 4.90881938,1.63666415 4.90881938,2.70203987 C4.90881938,3.81373628 3.80933942,5.47742083 3,6.51577615 C2.20593114,5.48514094 1.09118062,3.80215611 1.09118062,2.70203987 Z" id="Shape-Copy-22"></path>
            <path d="M3,3.5631295 C3.49196129,3.5631295 3.89078238,3.16430842 3.89078238,2.67234713 C3.89078238,2.18038227 3.49196129,1.78156475 3,1.78156475 C2.50803871,1.78156475 2.10921762,2.18038227 2.10921762,2.67234713 C2.10921762,3.16430842 2.50803871,3.5631295 3,3.5631295 Z" id="Path-Copy-16"></path>
        </g>
    </g>
</svg>
"""

malloy_icon_field_info_icon = """
<svg width="16px" height="16px" viewBox="0 0 16 16" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>malloy-icon-field-info</title>
    <g id="malloy-icon-field-info" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <circle id="Oval" stroke="#4285F4" cx="8" cy="8.0015734" r="6.65099589"></circle>
        <text id="i" font-family="TimesNewRomanPS-BoldItalicMT, Times New Roman" font-size="12" font-style="italic" font-weight="bold" fill="#4285F4">
            <tspan x="6.2022124" y="11.8474307">i</tspan>
        </text>
    </g>
</svg>"""

malloy_icon_percent_icon = """
<svg width="16px" height="16px" viewBox="3 3 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>malloy-icon-percent</title>
    <g id="malloy-icon-percent" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <path d="M5.86494374,7.83686592 C6.19341393,7.83686592 6.49280083,7.75869751 6.76310443,7.60236068 C7.03340802,7.44602385 7.24725581,7.23360969 7.40464777,6.96511818 C7.56203974,6.69662668 7.64073573,6.4060441 7.64073573,6.09337044 C7.64073573,5.78069679 7.56203974,5.49011421 7.40464777,5.22162271 C7.24725581,4.9531312 7.03340802,4.74071703 6.76310443,4.58438021 C6.49280083,4.42804338 6.19341393,4.34987497 5.86494374,4.34987497 C5.53647354,4.34987497 5.23708665,4.42804338 4.96678305,4.58438021 C4.69647945,4.74071703 4.48263167,4.9531312 4.3252397,5.22162271 C4.16784774,5.49011421 4.08915175,5.78069679 4.08915175,6.09337044 C4.08915175,6.4060441 4.16784774,6.69662668 4.3252397,6.96511818 C4.48263167,7.23360969 4.69647945,7.44602385 4.96678305,7.60236068 C5.23708665,7.75869751 5.53647354,7.83686592 5.86494374,7.83686592 Z M6.05997292,11.5991456 L10.6174969,4.84947309 L9.94002708,4.40085437 L5.37223845,11.1607228 L6.05997292,11.5991456 Z M5.86494374,7.02119552 C5.61859109,7.02119552 5.41158644,6.93283123 5.24392978,6.75610264 C5.07627312,6.57937406 4.99244479,6.35846332 4.99244479,6.09337044 C4.99244479,5.82148031 5.07627312,5.59887027 5.24392978,5.42554031 C5.41158644,5.25221035 5.61859109,5.16554537 5.86494374,5.16554537 C6.11813951,5.16554537 6.32856573,5.25221035 6.49622239,5.42554031 C6.66387905,5.59887027 6.74770739,5.82148031 6.74770739,6.09337044 C6.74770739,6.36526058 6.66387905,6.58787062 6.49622239,6.76120058 C6.32856573,6.93453054 6.11813951,7.02119552 5.86494374,7.02119552 Z M10.1350563,11.650125 C10.4635265,11.650125 10.7629134,11.5719566 11.0332169,11.4156198 C11.3035205,11.259283 11.5173683,11.0468688 11.6747603,10.7783773 C11.8321523,10.5098858 11.9108482,10.2193032 11.9108482,9.90662956 C11.9108482,9.5939559 11.8321523,9.30337332 11.6747603,9.03488182 C11.5173683,8.76639031 11.3035205,8.55397615 11.0332169,8.39763932 C10.7629134,8.24130249 10.4635265,8.16313408 10.1350563,8.16313408 C9.80658607,8.16313408 9.50719917,8.24130249 9.23689557,8.39763932 C8.96659198,8.55397615 8.75274419,8.76639031 8.59535223,9.03488182 C8.43796026,9.30337332 8.35926427,9.5939559 8.35926427,9.90662956 C8.35926427,10.2193032 8.43796026,10.5098858 8.59535223,10.7783773 C8.75274419,11.0468688 8.96659198,11.259283 9.23689557,11.4156198 C9.50719917,11.5719566 9.80658607,11.650125 10.1350563,11.650125 Z M10.1350563,10.8344546 C9.88870362,10.8344546 9.68169896,10.7460903 9.5140423,10.5693618 C9.34638564,10.3926332 9.26255731,10.1717224 9.26255731,9.90662956 C9.26255731,9.63473942 9.34638564,9.41212938 9.5140423,9.23879942 C9.68169896,9.06546946 9.88870362,8.97880448 10.1350563,8.97880448 C10.388252,8.97880448 10.5986783,9.06546946 10.7663349,9.23879942 C10.9339916,9.41212938 11.0178199,9.63473942 11.0178199,9.90662956 C11.0178199,10.1717224 10.9322808,10.3926332 10.7612026,10.5693618 C10.5901243,10.7460903 10.3814089,10.8344546 10.1350563,10.8344546 Z" id="%-copy-6" fill="#FF9472" fill-rule="nonzero"></path>
    </g>
</svg>"""

many_to_one_icon = """
<svg width="16px" height="16px" viewBox="0 0 25 25" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>join_icon_one_to_many</title>
    <g id="join_icon_one_to_many" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Group" transform="translate(12.759300, 12.500000) rotate(-180.000000) translate(-12.759300, -12.500000) translate(4.000000, 3.712487)" fill="#4284F3">
            <polygon id="Path-Copy-15" fill-rule="nonzero" transform="translate(6.382256, 8.736227) scale(-1, 1) rotate(180.000000) translate(-6.382256, -8.736227) " points="2.80570594 3.41828749 3.48860316 2.68777302 9.95880577 8.73622728 3.48860316 14.7846815 2.80570594 14.0541671 8.494 8.736"></polygon>
            <rect id="Rectangle-Copy-91" transform="translate(2.000000, 2.000000) scale(-1, 1) translate(-2.000000, -2.000000) " x="0" y="0" width="4" height="4"></rect>
            <rect id="Rectangle-Copy-92" transform="translate(2.000000, 8.736227) scale(-1, 1) translate(-2.000000, -8.736227) " x="0" y="6.73622728" width="4" height="4"></rect>
            <rect id="Rectangle-Copy-86" transform="translate(15.518600, 8.736227) scale(-1, 1) translate(-15.518600, -8.736227) " x="13.5186005" y="6.73622728" width="4" height="4"></rect>
            <rect id="Rectangle-Copy-87" transform="translate(2.000000, 15.575026) scale(-1, 1) translate(-2.000000, -15.575026) " x="0" y="13.5750258" width="4" height="4"></rect>
            <polygon id="Line-3-Copy-68" fill-rule="nonzero" transform="translate(8.495445, 8.736227) scale(-1, 1) translate(-8.495445, -8.736227) " points="14.9954453 8.23622728 14.9954453 9.23622728 1.99544525 9.23622728 1.99544525 8.23622728"></polygon>
        </g>
    </g>
</svg>"""

number_aggregate_icon = """
<?xml version="1.0" encoding="UTF-8"?>
<svg width="16px" height="16px" viewBox="3 3 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>malloy-icon-number</title>
    <g id="malloy-icon-number" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <path d="M12,7 L12,6 L10,6 L10,4 L9,4 L9,6 L7,6 L7,4 L6,4 L6,6 L4,6 L4,7 L6,7 L6,9 L4,9 L4,10 L6,10 L6,12 L7,12 L7,10 L9,10 L9,12 L10,12 L10,10 L12,10 L12,9 L10,9 L10,7 L12,7 Z M9,9 L7,9 L7,7 L9,7 L9,9 Z" id="Shape-Copy-21" fill="#FF9472" fill-rule="nonzero"></path>
    </g>
</svg>
"""

number_icon = """
<svg width="16px" height="16px" viewBox="3 3 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>malloy-icon-number</title>
    <g id="malloy-icon-number" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <path d="M12,7 L12,6 L10,6 L10,4 L9,4 L9,6 L7,6 L7,4 L6,4 L6,6 L4,6 L4,7 L6,7 L6,9 L4,9 L4,10 L6,10 L6,12 L7,12 L7,10 L9,10 L9,12 L10,12 L10,10 L12,10 L12,9 L10,9 L10,7 L12,7 Z M9,9 L7,9 L7,7 L9,7 L9,9 Z" id="Shape-Copy-21" fill="#85B0F7" fill-rule="nonzero"></path>
    </g>
</svg>
"""

one_to_many_icon = """
<svg width="16px" height="16px" viewBox="0 0 25 25" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>join_icon_many_to_one</title>
    <g id="join_icon_many_to_one" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <polygon id="Path-Copy-14" fill="#4284F3" fill-rule="nonzero" transform="translate(10.382256, 12.736227) scale(-1, 1) rotate(180.000000) translate(-10.382256, -12.736227) " points="6.80570594 7.41828749 7.48860316 6.68777302 13.9588058 12.7362273 7.48860316 18.7846815 6.80570594 18.0541671 12.494 12.736"></polygon>
        <rect id="Rectangle-Copy-90" fill="#4284F3" x="4" y="4" width="4" height="4"></rect>
        <rect id="Rectangle-Copy-89" fill="#4284F3" x="4" y="10.7362273" width="4" height="4"></rect>
        <rect id="Rectangle-Copy-85" fill="#4284F3" x="17.5186005" y="10.7362273" width="4" height="4"></rect>
        <rect id="Rectangle-Copy-84" fill="#4284F3" x="4" y="17.5750258" width="4" height="4"></rect>
        <polygon id="Line-3-Copy-67" fill="#4284F3" fill-rule="nonzero" points="18.9954453 12.2362273 18.9954453 13.2362273 5.99544525 13.2362273 5.99544525 12.2362273"></polygon>
    </g>
</svg>
"""

one_to_one_icon = """
<svg width="16px" height="16px" viewBox="0 0 25 25" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>join_icon_one_to_one</title>
    <g id="join_icon_one_to_one" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <rect id="Rectangle-Copy-89" fill="#4284F3" x="4" y="10.7362273" width="4" height="4"></rect>
        <rect id="Rectangle-Copy-85" fill="#4284F3" x="17.5186005" y="10.7362273" width="4" height="4"></rect>
        <polygon id="Line-3-Copy-67" fill="#4284F3" fill-rule="nonzero" points="18.9954453 12.2362273 18.9954453 13.2362273 5.99544525 13.2362273 5.99544525 12.2362273"></polygon>
    </g>
</svg>"""

string_icon = """
<svg width="16px" height="16px" viewBox="3 3 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>malloy-icon-string</title>
    <g id="malloy-icon-string" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <path d="M4.8045,10.45 L5.2245,9.253 L7.1425,9.253 L7.5625,10.45 L8.6055,10.45 L6.7225,5.438 L5.6375,5.438 L3.7615,10.45 L4.8045,10.45 Z M6.8345,8.385 L5.5255,8.385 L5.9735,7.125 L6.1555,6.523 L6.2115,6.523 L6.3935,7.125 L6.8345,8.385 Z M10.2505,10.562 C10.4791667,10.562 10.681,10.5176667 10.856,10.429 C11.031,10.3403333 11.1721667,10.226 11.2795,10.086 L11.2795,10.086 L11.3355,10.086 L11.3355,10.45 L12.2385,10.45 L12.2385,8.252 C12.2385,7.76666667 12.0961667,7.398 11.8115,7.146 C11.5268333,6.894 11.1115,6.768 10.5655,6.768 C10.2575,6.768 9.97283333,6.82866667 9.7115,6.95 C9.45016667,7.07133333 9.23316667,7.244 9.0605,7.468 L9.0605,7.468 L9.6485,7.93 C9.75116667,7.804 9.88066667,7.7025 10.037,7.6255 C10.1933333,7.5485 10.3555,7.51 10.5235,7.51 C10.7708333,7.51 10.968,7.57066667 11.115,7.692 C11.262,7.81333333 11.3355,7.972 11.3355,8.168 L11.3355,8.168 L11.3355,8.322 C11.0741667,8.21466667 10.7591667,8.161 10.3905,8.161 C10.1245,8.161 9.88183333,8.21 9.6625,8.308 C9.44316667,8.406 9.2705,8.546 9.1445,8.728 C9.0185,8.91 8.9555,9.12 8.9555,9.358 C8.9555,9.71733333 9.07683333,10.0078333 9.3195,10.2295 C9.56216667,10.4511667 9.8725,10.562 10.2505,10.562 Z M10.4675,9.848 C10.2761667,9.848 10.1291667,9.8025 10.0265,9.7115 C9.92383333,9.6205 9.8725,9.50266667 9.8725,9.358 C9.8725,9.00333333 10.1105,8.826 10.5865,8.826 C10.8478333,8.826 11.0975,8.882 11.3355,8.994 C11.3355,9.22266667 11.2573333,9.42216667 11.101,9.5925 C10.9446667,9.76283333 10.7335,9.848 10.4675,9.848 Z" id="Aa-Copy" fill="#85B0F7" fill-rule="nonzero"></path>
    </g>
</svg>
"""

struct_icon = """
<svg width="15px" height="14px" viewBox="0 0 15 14" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <g id="window-org" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="z" transform="translate(-76.000000, -86.000000)" fill="#939BA5" fill-rule="nonzero" stroke="#939BA5" stroke-width="0.25">
            <g id="noun_explore_2232152-copy" transform="translate(77.058375, 86.177891)">
                <path d="M1.89319474,1.8964973 C0.960203984,2.8308601 0.313970678,4.05198036 0.0958154857,5.35679538 C-0.0112040426,5.99754051 -0.0331567664,6.6465179 0.0532820834,7.29137916 C0.142465024,7.96642542 0.327691131,8.61128668 0.614448585,9.22870704 C1.17698713,10.4429671 2.14839516,11.4761171 3.3173777,12.1264666 C4.44794297,12.7562353 5.77471072,13.0416207 7.06443324,12.9153926 C7.7092945,12.8522785 8.33769122,12.7054697 8.93590294,12.4543854 C9.58350829,12.1840925 10.1734877,11.8218725 10.7072133,11.3636094 C11.7101784,10.501965 12.4373624,9.31651793 12.7529328,8.03228359 C13.0602709,6.77960629 12.9944127,5.42814173 12.5388937,4.21936988 C12.0518177,2.92964736 11.1737087,1.82240685 10.0239348,1.06092175 C8.94139112,0.34334209 7.62834383,-0.0284821691 6.32901699,0.00170282605 C5.02557402,0.0318878212 3.72761922,0.457221844 2.67526053,1.23105536 C2.39810739,1.43411805 2.13604675,1.65364529 1.89319474,1.8964973 C1.74089772,2.04879432 1.72992136,2.32869155 1.89319474,2.47824448 C2.05784017,2.62916945 2.31166854,2.64014581 2.47494192,2.47824448 C2.61763463,2.33555177 2.76718756,2.19971929 2.92222867,2.07211909 C2.95790185,2.04330614 2.99494707,2.01449319 3.03062024,1.98568024 C3.08550205,1.94177479 2.9414373,2.05291045 3.02650411,1.98979637 C3.04296865,1.97744797 3.05806115,1.9664716 3.07452569,1.9541232 C3.15410432,1.89512525 3.23368294,1.8388714 3.31600565,1.78398959 C3.6329481,1.57269462 3.97047123,1.39158465 4.32171481,1.24340376 C4.28878573,1.25712422 4.25585664,1.27084467 4.22292755,1.28456512 C4.71411975,1.07875834 5.2313808,0.937437677 5.75961822,0.864719279 C5.722573,0.87020746 5.68689982,0.874323596 5.6498546,0.879811777 C6.19318451,0.807093379 6.7447467,0.807093379 7.28807661,0.879811777 C7.25103139,0.874323596 7.21535821,0.87020746 7.17831299,0.864719279 C7.70655041,0.937437677 8.22381146,1.07875834 8.71500366,1.28456512 C8.68207457,1.27084467 8.64914549,1.25712422 8.6162164,1.24340376 C8.8892534,1.35865556 9.15405813,1.493116 9.4078865,1.64815711 C9.53685875,1.72636369 9.66171487,1.8086864 9.7838269,1.8964973 C9.81538394,1.91982207 9.84831302,1.94314683 9.87987006,1.9664716 C9.90593892,1.98568024 10.0019821,2.06388682 9.89084642,1.97470388 C9.95258846,2.0240975 10.0157025,2.07349113 10.0760725,2.12562885 C10.3134364,2.32457541 10.5343356,2.5427306 10.7387704,2.77597829 C10.786792,2.8308601 10.8348135,2.88711396 10.8814631,2.94473986 C10.9061599,2.97492485 10.9308567,3.00648189 10.9555535,3.03803893 C10.9953428,3.08743256 10.9281126,3.00236576 10.9281126,3.00236576 C10.9445772,3.02294644 10.9596697,3.04489916 10.9761342,3.06547984 C11.0666892,3.18621982 11.151756,3.31107593 11.2327067,3.4373041 C11.4124446,3.71994541 11.5688577,4.01905128 11.699202,4.32776145 C11.6854816,4.29483237 11.6717611,4.26190328 11.6580407,4.2289742 C11.8638475,4.72016639 12.0051681,5.23742745 12.0778865,5.76566486 C12.0723983,5.72861964 12.0682822,5.69294646 12.062794,5.65590124 C12.1355124,6.19923116 12.1355124,6.75079334 12.062794,7.29412325 C12.0682822,7.25707803 12.0723983,7.22140486 12.0778865,7.18435964 C12.0051681,7.71259705 11.8638475,8.2298581 11.6580407,8.7210503 C11.6717611,8.68812121 11.6854816,8.65519213 11.699202,8.62226304 C11.5839502,8.89530004 11.4494898,9.16010477 11.2944487,9.41393314 C11.2162421,9.5429054 11.1339194,9.66776151 11.0461085,9.78987354 C11.0227837,9.82143058 10.999459,9.85435966 10.9761342,9.8859167 C10.9569256,9.91198556 10.878719,10.0080287 10.9679019,9.89689307 C10.9185083,9.9586351 10.8691147,10.0217492 10.816977,10.0821192 C10.6180304,10.319483 10.3998752,10.5403823 10.1666275,10.744817 C10.1117457,10.7928386 10.0554919,10.8408602 9.99786595,10.8875097 C9.96768096,10.9122065 9.93612392,10.9369034 9.90456688,10.9616002 C9.85517325,11.0013895 9.94024005,10.9341593 9.94024005,10.9341593 C9.91965937,10.9506238 9.89770665,10.9657163 9.87712597,10.9821808 C9.75638599,11.0727358 9.63152987,11.1578026 9.50530171,11.2387533 C9.22266039,11.4184912 8.92355453,11.5749044 8.61484435,11.7052487 C8.64777344,11.6915282 8.68070253,11.6778078 8.71363161,11.6640873 C8.22243942,11.8698941 7.70517836,12.0112148 7.17694095,12.0839332 C7.21398617,12.078445 7.24965934,12.0743289 7.28670457,12.0688407 C6.74337465,12.1415591 6.19181247,12.1415591 5.64848255,12.0688407 C5.68552778,12.0743289 5.72120095,12.078445 5.75824617,12.0839332 C5.23000876,12.0112148 4.7127477,11.8698941 4.22155551,11.6640873 C4.2544846,11.6778078 4.28741368,11.6915282 4.32034277,11.7052487 C4.04730576,11.5899969 3.78250103,11.4555365 3.52867267,11.3004953 C3.39970041,11.2222888 3.2748443,11.139966 3.15273227,11.0521552 C3.12117523,11.0288304 3.08824614,11.0055056 3.0566891,10.9821808 C3.03062024,10.9629722 2.93457708,10.8847656 3.04571274,10.9739486 C2.98397071,10.9245549 2.92085663,10.8751613 2.86048664,10.8230236 C2.62312281,10.624077 2.40222353,10.4059218 2.19778879,10.1726742 C2.1497672,10.1177923 2.10174562,10.0615385 2.05509608,10.0039126 C2.03039927,9.9737276 2.00570245,9.94217056 1.98100564,9.91061352 C1.94121633,9.86121989 2.00844654,9.94628669 2.00844654,9.94628669 C1.991982,9.92570602 1.9768895,9.90375329 1.96042496,9.88317261 C1.86986998,9.76243263 1.78480317,9.63757652 1.7038525,9.51134835 C1.52411458,9.22870704 1.36770142,8.92960118 1.23735712,8.620891 C1.25107757,8.65382008 1.26479803,8.68674917 1.27851848,8.71967825 C1.07271169,8.22848606 0.931391034,7.71122501 0.858672637,7.18298759 C0.864160818,7.22003281 0.868276953,7.25570599 0.873765134,7.29275121 C0.801046737,6.7494213 0.801046737,6.19785911 0.873765134,5.6545292 C0.868276953,5.69157442 0.864160818,5.72724759 0.858672637,5.76429282 C0.931391034,5.2360554 1.07271169,4.71879435 1.27851848,4.22760215 C1.26479803,4.26053124 1.25107757,4.29346032 1.23735712,4.32638941 C1.38553801,3.97514583 1.56664798,3.6376227 1.77794294,3.32068025 C1.83282475,3.23835754 1.88907861,3.15877891 1.94807655,3.07920029 C1.96042496,3.06273575 1.97140132,3.04764325 1.98374973,3.03117871 C2.04686381,2.94748395 1.93572815,3.0915487 1.97963359,3.03529484 C2.00844654,2.99824962 2.03725949,2.96257644 2.06607244,2.92690327 C2.19367265,2.77049011 2.32950513,2.62230923 2.47219783,2.47961652 C2.62449486,2.3273195 2.63684326,2.04742227 2.47219783,1.89786934 C2.3102965,1.74557232 2.05509608,1.73322391 1.89319474,1.8964973 Z" id="Path"></path>
                <path d="M6.16836964,6.17066644 C6.09118278,6.2541117 6.04424482,6.35633213 6.04320176,6.47211242 C6.04320176,6.58372045 6.08909665,6.69428542 6.16836964,6.77355841 C6.33004482,6.93731972 6.60854336,6.93731972 6.77126161,6.77355841 C6.93397986,6.60875403 6.93606599,6.33547082 6.77126161,6.17066644 C6.69198862,6.09139345 6.58142365,6.04549856 6.46981562,6.04549856 C6.35403533,6.04654162 6.25285796,6.09347958 6.16836964,6.17066644 C6.11100103,6.22386279 6.07657986,6.31460951 6.07657986,6.39179637 C6.07657986,6.46898323 6.11100103,6.55972994 6.16836964,6.61292629 C6.29770979,6.73183578 6.48233241,6.73183578 6.61062949,6.61292629 C6.61480176,6.60875403 6.62001708,6.60458177 6.62418935,6.60145257 C6.60332803,6.61814162 6.58246672,6.63378761 6.56056234,6.65047666 C6.5678638,6.64526133 6.57516526,6.64108907 6.58350978,6.63795987 C6.55847621,6.64839053 6.53344263,6.65882118 6.50840905,6.66925184 C6.51675358,6.66612264 6.52509811,6.66403651 6.53344263,6.66195038 C6.50527986,6.66612264 6.47816015,6.66925184 6.44999738,6.6734241 C6.4614711,6.67238104 6.47294482,6.67238104 6.48441854,6.6734241 C6.45625577,6.66925184 6.42913606,6.66612264 6.40097329,6.66195038 C6.41036088,6.66403651 6.41766234,6.66612264 6.42600687,6.66925184 C6.40097329,6.65882118 6.37593971,6.64839053 6.35090614,6.63795987 C6.35925066,6.64213213 6.36655212,6.6463044 6.37385358,6.65047666 C6.35299227,6.63378761 6.33213095,6.61814162 6.31022657,6.60145257 C6.32065723,6.60875403 6.32795869,6.61709856 6.33630322,6.62752921 C6.31961416,6.6066679 6.30396818,6.58580659 6.28727913,6.56390221 C6.29249446,6.57120367 6.29666672,6.57850513 6.29979592,6.58684965 C6.28936526,6.56181607 6.2789346,6.5367825 6.26850395,6.51174892 C6.27163314,6.52009345 6.27371927,6.52843797 6.27580541,6.5367825 C6.27163314,6.50861972 6.26850395,6.48150002 6.26433168,6.45333724 C6.26537475,6.46481096 6.26537475,6.47628469 6.26433168,6.48775841 C6.26850395,6.45959564 6.27163314,6.43247593 6.27580541,6.40431315 C6.27371927,6.41370075 6.27163314,6.42100221 6.26850395,6.42934673 C6.2789346,6.40431315 6.28936526,6.37927958 6.29979592,6.354246 C6.29562365,6.36259053 6.29145139,6.36989199 6.28727913,6.37719345 C6.30396818,6.35633213 6.31961416,6.33547082 6.33630322,6.31356644 C6.32900176,6.3239971 6.32065723,6.33129856 6.31022657,6.33964308 C6.33108789,6.32295403 6.3519492,6.30730805 6.37385358,6.29061899 C6.36655212,6.29583432 6.35925066,6.30000659 6.35090614,6.30313578 C6.37593971,6.29270513 6.40097329,6.28227447 6.42600687,6.27184381 C6.41766234,6.27497301 6.40931781,6.27705914 6.40097329,6.27914527 C6.42913606,6.27497301 6.45625577,6.27184381 6.48441854,6.26767155 C6.47294482,6.26871461 6.4614711,6.26871461 6.44999738,6.26767155 C6.47816015,6.27184381 6.50527986,6.27497301 6.53344263,6.27914527 C6.52405504,6.27705914 6.51675358,6.27497301 6.50840905,6.27184381 C6.53344263,6.28227447 6.55847621,6.29270513 6.58350978,6.30313578 C6.57516526,6.29896352 6.5678638,6.29479126 6.56056234,6.29061899 C6.58142365,6.30730805 6.60228497,6.32295403 6.62418935,6.33964308 C6.61375869,6.33234162 6.60645723,6.3239971 6.5981127,6.31356644 C6.61480176,6.33442775 6.63044774,6.35528907 6.64713679,6.37719345 C6.64192146,6.36989199 6.6377492,6.36259053 6.63462,6.354246 C6.64505066,6.37927958 6.65548132,6.40431315 6.66591197,6.42934673 C6.66278278,6.42100221 6.66069665,6.41265768 6.65861051,6.40431315 C6.66278278,6.43247593 6.66591197,6.45959564 6.67008424,6.48775841 C6.66904117,6.47628469 6.66904117,6.46481096 6.67008424,6.45333724 C6.66591197,6.48150002 6.66278278,6.50861972 6.65861051,6.5367825 C6.66069665,6.52739491 6.66278278,6.52009345 6.66591197,6.51174892 C6.65548132,6.5367825 6.64505066,6.56181607 6.63462,6.58684965 C6.63879227,6.57850513 6.64296453,6.57120367 6.64713679,6.56390221 C6.63044774,6.58476352 6.61480176,6.60562483 6.5981127,6.62752921 C6.6012419,6.62231388 6.60541416,6.61814162 6.60958643,6.61396936 C6.66591197,6.55347155 6.70137621,6.47628469 6.70137621,6.39283943 C6.70137621,6.31565257 6.66695504,6.22490586 6.60958643,6.17170951 C6.55013168,6.11747009 6.47190176,6.07679053 6.3884565,6.07991972 C6.30918351,6.08304892 6.22573825,6.11016863 6.16836964,6.17066644 Z" id="Path"></path>
                <path d="M3.68710555,9.70849202 C3.82738583,9.65557928 3.96889665,9.60389707 4.10917694,9.55098433 C4.44634184,9.42547039 4.78350674,9.29995644 5.12067165,9.1744425 C5.52551563,9.02308746 5.93159015,8.87296294 6.33643414,8.72160789 C6.68221275,8.59240236 7.02676082,8.46442736 7.37253943,8.33522183 C7.53004712,8.27615645 7.68878534,8.21955212 7.8450625,8.15925621 C7.84629303,8.15925621 7.84629303,8.15925621 7.84752356,8.15802568 C7.92504688,8.12726246 7.98780385,8.09280765 8.03948606,8.02512856 C8.07024928,7.98575164 8.08747668,7.94637472 8.10593462,7.89961462 C8.10716514,7.89592304 8.10839567,7.89346198 8.1096262,7.88977039 C8.11700938,7.8688514 8.12562308,7.84916294 8.13300625,7.82824395 C8.16746106,7.73841534 8.20068534,7.64981727 8.23514014,7.55998866 C8.3569625,7.24128169 8.47755433,6.92134419 8.59937668,6.60263722 C8.75196226,6.20025429 8.90577836,5.79787136 9.05836394,5.3942579 C9.19618317,5.03248242 9.3340024,4.67070694 9.47182163,4.30770093 C9.54688389,4.11081632 9.62194615,3.91270118 9.69700841,3.71581656 C9.70069999,3.70720286 9.70439158,3.69735863 9.70685264,3.68874493 C9.80283389,3.43648651 9.50504591,3.13869853 9.2527875,3.23467978 C9.11373774,3.28759252 8.97591851,3.34050526 8.83686875,3.393418 C8.50339543,3.52016248 8.16992212,3.64690695 7.8364488,3.77365142 C7.43283534,3.92746752 7.02799135,4.08128363 6.62437789,4.23509973 C6.27367717,4.36799685 5.92297645,4.50212449 5.57227573,4.63502161 C5.39877116,4.70147016 5.2252666,4.76545766 5.05176203,4.83313675 C5.04930097,4.83436728 5.04560939,4.83559781 5.04314833,4.83682834 C4.99638823,4.85528627 4.95701131,4.87251367 4.91763439,4.90327689 C4.85118583,4.9549591 4.81550049,5.01771608 4.78473727,5.09523939 C4.78473727,5.09646992 4.78473727,5.09646992 4.78350674,5.09770045 C4.7773541,5.1124668 4.77243198,5.12846367 4.76627934,5.14323002 C4.73551612,5.22444492 4.70598343,5.30689035 4.67522021,5.38810526 C4.55955049,5.69942905 4.44265025,6.01075285 4.32698054,6.32330718 C4.17685602,6.72569011 4.02673151,7.12807304 3.87660699,7.53045597 C3.74001829,7.89592304 3.60466011,8.2613901 3.46807141,8.62685717 C3.39300915,8.82743337 3.31917742,9.02677904 3.24411516,9.22735524 C3.24042358,9.23719947 3.23673199,9.24581318 3.23427093,9.25565741 C3.20227718,9.3405639 3.22688776,9.46484731 3.2711868,9.53990957 C3.31548584,9.61620236 3.40408391,9.69003409 3.49145146,9.70972255 C3.70064136,9.75771317 3.8729154,9.64573505 3.9455166,9.45131149 C3.99719881,9.31349226 4.04888103,9.1744425 4.10056324,9.03662327 C4.22361612,8.70684154 4.346669,8.37582928 4.46972189,8.04604755 C4.61984641,7.64489515 4.7687404,7.24374275 4.91886492,6.84135982 C5.04807044,6.49558121 5.17604544,6.14980261 5.30525097,5.80525453 C5.36800794,5.63667208 5.43568703,5.46932016 5.49352188,5.29827665 C5.49475241,5.29581559 5.49475241,5.29335454 5.49598294,5.29089348 C5.40984592,5.3770305 5.3237089,5.46316752 5.23757189,5.54930454 C5.37785217,5.4963918 5.51690193,5.44347905 5.65718222,5.38933579 C5.99065554,5.26259132 6.32535938,5.13584684 6.6588327,5.00787185 C7.06490722,4.85405574 7.47098173,4.69900911 7.87705625,4.545193 C8.22775697,4.41229589 8.57968822,4.27816824 8.93038894,4.14527113 C9.10020192,4.08128363 9.27247596,4.02098771 9.44105841,3.95084757 C9.44351947,3.94961704 9.44598052,3.94838651 9.44844158,3.94838651 C9.29708653,3.79703146 9.14573149,3.64567642 8.99437644,3.49432137 C8.9414637,3.63460166 8.88855096,3.77365142 8.83440769,3.9139317 C8.70766322,4.24740502 8.58091875,4.58210887 8.45294375,4.91558218 C8.29912764,5.3216567 8.14408101,5.72773122 7.9902649,6.13380574 C7.85736779,6.48450645 7.72324015,6.8364377 7.59034303,7.18713842 C7.52635553,7.3569514 7.45621539,7.52553385 7.39591947,7.69780789 C7.39468895,7.70026895 7.39345842,7.70273001 7.39345842,7.70519107 C7.47959544,7.61905405 7.56573245,7.53291703 7.65186947,7.44678001 C7.51405024,7.49846222 7.37500048,7.55014443 7.23718125,7.60182664 C6.90739952,7.72487953 6.57638727,7.84793241 6.24660554,7.9709853 C5.84545313,8.12110981 5.44430073,8.2700038 5.0419178,8.42012832 C4.6961392,8.54933385 4.35036059,8.67730885 4.00581252,8.80651438 C3.83723006,8.86927135 3.66741708,8.93079779 3.49883463,8.99478529 C3.49637358,8.99601582 3.49391252,8.99601582 3.49145146,8.99724635 C3.3991618,9.03170116 3.32163848,9.07969178 3.2711868,9.16705933 C3.2244267,9.24581318 3.20473824,9.36271342 3.23427093,9.45131149 C3.29087526,9.62850765 3.49391252,9.78109322 3.68710555,9.70849202 Z" id="Path"></path>
            </g>
        </g>
    </g>
</svg>
"""

time_icon = """
<svg width="16px" height="16px" viewBox="3 3 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <g id="malloy-icon-date" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Group-Copy-22" transform="translate(4.500000, 4.000000)" fill="#85B0F7" fill-rule="nonzero">
            <path d="M6.09698937,0.743966277 L5.7723657,0.743966277 L5.7723657,0.0947189331 L5.12311836,0.0947189331 L5.12311836,0.743966277 L1.87688164,0.743966277 L1.87688164,0.0947189331 L1.2276343,0.0947189331 L1.2276343,0.743966277 L0.903010626,0.743966277 C0.545924587,0.743966277 0.253763282,1.03612758 0.253763282,1.39321362 L0.253763282,6.58719237 C0.253763282,6.94427841 0.545924587,7.23643971 0.903010626,7.23643971 L6.09698937,7.23643971 C6.45407541,7.23643971 6.74623672,6.94427841 6.74623672,6.58719237 L6.74623672,1.39321362 C6.74623672,1.03612758 6.45407541,0.743966277 6.09698937,0.743966277 Z M6.09698937,6.58719237 L0.903010626,6.58719237 L0.903010626,2.36708464 L6.09698937,2.36708464 L6.09698937,6.58719237 Z" id="Shape"></path>
        </g>
    </g>
</svg>
"""

timestamp_icon = """
<svg width="16px" height="16px" viewBox="3 3 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <g id="malloy-icon-date" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Group-Copy-22" transform="translate(4.500000, 4.000000)" fill="#85B0F7" fill-rule="nonzero">
            <path d="M6.09698937,0.743966277 L5.7723657,0.743966277 L5.7723657,0.0947189331 L5.12311836,0.0947189331 L5.12311836,0.743966277 L1.87688164,0.743966277 L1.87688164,0.0947189331 L1.2276343,0.0947189331 L1.2276343,0.743966277 L0.903010626,0.743966277 C0.545924587,0.743966277 0.253763282,1.03612758 0.253763282,1.39321362 L0.253763282,6.58719237 C0.253763282,6.94427841 0.545924587,7.23643971 0.903010626,7.23643971 L6.09698937,7.23643971 C6.45407541,7.23643971 6.74623672,6.94427841 6.74623672,6.58719237 L6.74623672,1.39321362 C6.74623672,1.03612758 6.45407541,0.743966277 6.09698937,0.743966277 Z M6.09698937,6.58719237 L0.903010626,6.58719237 L0.903010626,2.36708464 L6.09698937,2.36708464 L6.09698937,6.58719237 Z" id="Shape"></path>
        </g>
    </g>
</svg>
"""

turtle_icon = """
<svg width="16px" height="16px" viewBox="3 3 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <g id="malloy-icon-projection" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" fill-opacity="0.532508263">
        <path d="M11.3362588,4 L11.3362588,12 L8,9.90676786 L4.6637412,12 L4.6637412,4 L11.3362588,4 Z M10.336,5 L5.663,5 L5.663,10.191 L8,8.72623637 L10.336,10.191 L10.336,5 Z" id="Rectangle" fill="#34A853" fill-rule="nonzero"></path>
    </g>
</svg>
"""

view_container_icon = """
<svg width="15px" height="14px" viewBox="0 0 15 14" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <g id="window-org" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="z" transform="translate(-76.000000, -86.000000)" fill="#939BA5" fill-rule="nonzero" stroke="#939BA5" stroke-width="0.25">
            <g id="noun_explore_2232152-copy" transform="translate(77.058375, 86.177891)">
                <path d="M1.89319474,1.8964973 C0.960203984,2.8308601 0.313970678,4.05198036 0.0958154857,5.35679538 C-0.0112040426,5.99754051 -0.0331567664,6.6465179 0.0532820834,7.29137916 C0.142465024,7.96642542 0.327691131,8.61128668 0.614448585,9.22870704 C1.17698713,10.4429671 2.14839516,11.4761171 3.3173777,12.1264666 C4.44794297,12.7562353 5.77471072,13.0416207 7.06443324,12.9153926 C7.7092945,12.8522785 8.33769122,12.7054697 8.93590294,12.4543854 C9.58350829,12.1840925 10.1734877,11.8218725 10.7072133,11.3636094 C11.7101784,10.501965 12.4373624,9.31651793 12.7529328,8.03228359 C13.0602709,6.77960629 12.9944127,5.42814173 12.5388937,4.21936988 C12.0518177,2.92964736 11.1737087,1.82240685 10.0239348,1.06092175 C8.94139112,0.34334209 7.62834383,-0.0284821691 6.32901699,0.00170282605 C5.02557402,0.0318878212 3.72761922,0.457221844 2.67526053,1.23105536 C2.39810739,1.43411805 2.13604675,1.65364529 1.89319474,1.8964973 C1.74089772,2.04879432 1.72992136,2.32869155 1.89319474,2.47824448 C2.05784017,2.62916945 2.31166854,2.64014581 2.47494192,2.47824448 C2.61763463,2.33555177 2.76718756,2.19971929 2.92222867,2.07211909 C2.95790185,2.04330614 2.99494707,2.01449319 3.03062024,1.98568024 C3.08550205,1.94177479 2.9414373,2.05291045 3.02650411,1.98979637 C3.04296865,1.97744797 3.05806115,1.9664716 3.07452569,1.9541232 C3.15410432,1.89512525 3.23368294,1.8388714 3.31600565,1.78398959 C3.6329481,1.57269462 3.97047123,1.39158465 4.32171481,1.24340376 C4.28878573,1.25712422 4.25585664,1.27084467 4.22292755,1.28456512 C4.71411975,1.07875834 5.2313808,0.937437677 5.75961822,0.864719279 C5.722573,0.87020746 5.68689982,0.874323596 5.6498546,0.879811777 C6.19318451,0.807093379 6.7447467,0.807093379 7.28807661,0.879811777 C7.25103139,0.874323596 7.21535821,0.87020746 7.17831299,0.864719279 C7.70655041,0.937437677 8.22381146,1.07875834 8.71500366,1.28456512 C8.68207457,1.27084467 8.64914549,1.25712422 8.6162164,1.24340376 C8.8892534,1.35865556 9.15405813,1.493116 9.4078865,1.64815711 C9.53685875,1.72636369 9.66171487,1.8086864 9.7838269,1.8964973 C9.81538394,1.91982207 9.84831302,1.94314683 9.87987006,1.9664716 C9.90593892,1.98568024 10.0019821,2.06388682 9.89084642,1.97470388 C9.95258846,2.0240975 10.0157025,2.07349113 10.0760725,2.12562885 C10.3134364,2.32457541 10.5343356,2.5427306 10.7387704,2.77597829 C10.786792,2.8308601 10.8348135,2.88711396 10.8814631,2.94473986 C10.9061599,2.97492485 10.9308567,3.00648189 10.9555535,3.03803893 C10.9953428,3.08743256 10.9281126,3.00236576 10.9281126,3.00236576 C10.9445772,3.02294644 10.9596697,3.04489916 10.9761342,3.06547984 C11.0666892,3.18621982 11.151756,3.31107593 11.2327067,3.4373041 C11.4124446,3.71994541 11.5688577,4.01905128 11.699202,4.32776145 C11.6854816,4.29483237 11.6717611,4.26190328 11.6580407,4.2289742 C11.8638475,4.72016639 12.0051681,5.23742745 12.0778865,5.76566486 C12.0723983,5.72861964 12.0682822,5.69294646 12.062794,5.65590124 C12.1355124,6.19923116 12.1355124,6.75079334 12.062794,7.29412325 C12.0682822,7.25707803 12.0723983,7.22140486 12.0778865,7.18435964 C12.0051681,7.71259705 11.8638475,8.2298581 11.6580407,8.7210503 C11.6717611,8.68812121 11.6854816,8.65519213 11.699202,8.62226304 C11.5839502,8.89530004 11.4494898,9.16010477 11.2944487,9.41393314 C11.2162421,9.5429054 11.1339194,9.66776151 11.0461085,9.78987354 C11.0227837,9.82143058 10.999459,9.85435966 10.9761342,9.8859167 C10.9569256,9.91198556 10.878719,10.0080287 10.9679019,9.89689307 C10.9185083,9.9586351 10.8691147,10.0217492 10.816977,10.0821192 C10.6180304,10.319483 10.3998752,10.5403823 10.1666275,10.744817 C10.1117457,10.7928386 10.0554919,10.8408602 9.99786595,10.8875097 C9.96768096,10.9122065 9.93612392,10.9369034 9.90456688,10.9616002 C9.85517325,11.0013895 9.94024005,10.9341593 9.94024005,10.9341593 C9.91965937,10.9506238 9.89770665,10.9657163 9.87712597,10.9821808 C9.75638599,11.0727358 9.63152987,11.1578026 9.50530171,11.2387533 C9.22266039,11.4184912 8.92355453,11.5749044 8.61484435,11.7052487 C8.64777344,11.6915282 8.68070253,11.6778078 8.71363161,11.6640873 C8.22243942,11.8698941 7.70517836,12.0112148 7.17694095,12.0839332 C7.21398617,12.078445 7.24965934,12.0743289 7.28670457,12.0688407 C6.74337465,12.1415591 6.19181247,12.1415591 5.64848255,12.0688407 C5.68552778,12.0743289 5.72120095,12.078445 5.75824617,12.0839332 C5.23000876,12.0112148 4.7127477,11.8698941 4.22155551,11.6640873 C4.2544846,11.6778078 4.28741368,11.6915282 4.32034277,11.7052487 C4.04730576,11.5899969 3.78250103,11.4555365 3.52867267,11.3004953 C3.39970041,11.2222888 3.2748443,11.139966 3.15273227,11.0521552 C3.12117523,11.0288304 3.08824614,11.0055056 3.0566891,10.9821808 C3.03062024,10.9629722 2.93457708,10.8847656 3.04571274,10.9739486 C2.98397071,10.9245549 2.92085663,10.8751613 2.86048664,10.8230236 C2.62312281,10.624077 2.40222353,10.4059218 2.19778879,10.1726742 C2.1497672,10.1177923 2.10174562,10.0615385 2.05509608,10.0039126 C2.03039927,9.9737276 2.00570245,9.94217056 1.98100564,9.91061352 C1.94121633,9.86121989 2.00844654,9.94628669 2.00844654,9.94628669 C1.991982,9.92570602 1.9768895,9.90375329 1.96042496,9.88317261 C1.86986998,9.76243263 1.78480317,9.63757652 1.7038525,9.51134835 C1.52411458,9.22870704 1.36770142,8.92960118 1.23735712,8.620891 C1.25107757,8.65382008 1.26479803,8.68674917 1.27851848,8.71967825 C1.07271169,8.22848606 0.931391034,7.71122501 0.858672637,7.18298759 C0.864160818,7.22003281 0.868276953,7.25570599 0.873765134,7.29275121 C0.801046737,6.7494213 0.801046737,6.19785911 0.873765134,5.6545292 C0.868276953,5.69157442 0.864160818,5.72724759 0.858672637,5.76429282 C0.931391034,5.2360554 1.07271169,4.71879435 1.27851848,4.22760215 C1.26479803,4.26053124 1.25107757,4.29346032 1.23735712,4.32638941 C1.38553801,3.97514583 1.56664798,3.6376227 1.77794294,3.32068025 C1.83282475,3.23835754 1.88907861,3.15877891 1.94807655,3.07920029 C1.96042496,3.06273575 1.97140132,3.04764325 1.98374973,3.03117871 C2.04686381,2.94748395 1.93572815,3.0915487 1.97963359,3.03529484 C2.00844654,2.99824962 2.03725949,2.96257644 2.06607244,2.92690327 C2.19367265,2.77049011 2.32950513,2.62230923 2.47219783,2.47961652 C2.62449486,2.3273195 2.63684326,2.04742227 2.47219783,1.89786934 C2.3102965,1.74557232 2.05509608,1.73322391 1.89319474,1.8964973 Z" id="Path"></path>
                <path d="M6.16836964,6.17066644 C6.09118278,6.2541117 6.04424482,6.35633213 6.04320176,6.47211242 C6.04320176,6.58372045 6.08909665,6.69428542 6.16836964,6.77355841 C6.33004482,6.93731972 6.60854336,6.93731972 6.77126161,6.77355841 C6.93397986,6.60875403 6.93606599,6.33547082 6.77126161,6.17066644 C6.69198862,6.09139345 6.58142365,6.04549856 6.46981562,6.04549856 C6.35403533,6.04654162 6.25285796,6.09347958 6.16836964,6.17066644 C6.11100103,6.22386279 6.07657986,6.31460951 6.07657986,6.39179637 C6.07657986,6.46898323 6.11100103,6.55972994 6.16836964,6.61292629 C6.29770979,6.73183578 6.48233241,6.73183578 6.61062949,6.61292629 C6.61480176,6.60875403 6.62001708,6.60458177 6.62418935,6.60145257 C6.60332803,6.61814162 6.58246672,6.63378761 6.56056234,6.65047666 C6.5678638,6.64526133 6.57516526,6.64108907 6.58350978,6.63795987 C6.55847621,6.64839053 6.53344263,6.65882118 6.50840905,6.66925184 C6.51675358,6.66612264 6.52509811,6.66403651 6.53344263,6.66195038 C6.50527986,6.66612264 6.47816015,6.66925184 6.44999738,6.6734241 C6.4614711,6.67238104 6.47294482,6.67238104 6.48441854,6.6734241 C6.45625577,6.66925184 6.42913606,6.66612264 6.40097329,6.66195038 C6.41036088,6.66403651 6.41766234,6.66612264 6.42600687,6.66925184 C6.40097329,6.65882118 6.37593971,6.64839053 6.35090614,6.63795987 C6.35925066,6.64213213 6.36655212,6.6463044 6.37385358,6.65047666 C6.35299227,6.63378761 6.33213095,6.61814162 6.31022657,6.60145257 C6.32065723,6.60875403 6.32795869,6.61709856 6.33630322,6.62752921 C6.31961416,6.6066679 6.30396818,6.58580659 6.28727913,6.56390221 C6.29249446,6.57120367 6.29666672,6.57850513 6.29979592,6.58684965 C6.28936526,6.56181607 6.2789346,6.5367825 6.26850395,6.51174892 C6.27163314,6.52009345 6.27371927,6.52843797 6.27580541,6.5367825 C6.27163314,6.50861972 6.26850395,6.48150002 6.26433168,6.45333724 C6.26537475,6.46481096 6.26537475,6.47628469 6.26433168,6.48775841 C6.26850395,6.45959564 6.27163314,6.43247593 6.27580541,6.40431315 C6.27371927,6.41370075 6.27163314,6.42100221 6.26850395,6.42934673 C6.2789346,6.40431315 6.28936526,6.37927958 6.29979592,6.354246 C6.29562365,6.36259053 6.29145139,6.36989199 6.28727913,6.37719345 C6.30396818,6.35633213 6.31961416,6.33547082 6.33630322,6.31356644 C6.32900176,6.3239971 6.32065723,6.33129856 6.31022657,6.33964308 C6.33108789,6.32295403 6.3519492,6.30730805 6.37385358,6.29061899 C6.36655212,6.29583432 6.35925066,6.30000659 6.35090614,6.30313578 C6.37593971,6.29270513 6.40097329,6.28227447 6.42600687,6.27184381 C6.41766234,6.27497301 6.40931781,6.27705914 6.40097329,6.27914527 C6.42913606,6.27497301 6.45625577,6.27184381 6.48441854,6.26767155 C6.47294482,6.26871461 6.4614711,6.26871461 6.44999738,6.26767155 C6.47816015,6.27184381 6.50527986,6.27497301 6.53344263,6.27914527 C6.52405504,6.27705914 6.51675358,6.27497301 6.50840905,6.27184381 C6.53344263,6.28227447 6.55847621,6.29270513 6.58350978,6.30313578 C6.57516526,6.29896352 6.5678638,6.29479126 6.56056234,6.29061899 C6.58142365,6.30730805 6.60228497,6.32295403 6.62418935,6.33964308 C6.61375869,6.33234162 6.60645723,6.3239971 6.5981127,6.31356644 C6.61480176,6.33442775 6.63044774,6.35528907 6.64713679,6.37719345 C6.64192146,6.36989199 6.6377492,6.36259053 6.63462,6.354246 C6.64505066,6.37927958 6.65548132,6.40431315 6.66591197,6.42934673 C6.66278278,6.42100221 6.66069665,6.41265768 6.65861051,6.40431315 C6.66278278,6.43247593 6.66591197,6.45959564 6.67008424,6.48775841 C6.66904117,6.47628469 6.66904117,6.46481096 6.67008424,6.45333724 C6.66591197,6.48150002 6.66278278,6.50861972 6.65861051,6.5367825 C6.66069665,6.52739491 6.66278278,6.52009345 6.66591197,6.51174892 C6.65548132,6.5367825 6.64505066,6.56181607 6.63462,6.58684965 C6.63879227,6.57850513 6.64296453,6.57120367 6.64713679,6.56390221 C6.63044774,6.58476352 6.61480176,6.60562483 6.5981127,6.62752921 C6.6012419,6.62231388 6.60541416,6.61814162 6.60958643,6.61396936 C6.66591197,6.55347155 6.70137621,6.47628469 6.70137621,6.39283943 C6.70137621,6.31565257 6.66695504,6.22490586 6.60958643,6.17170951 C6.55013168,6.11747009 6.47190176,6.07679053 6.3884565,6.07991972 C6.30918351,6.08304892 6.22573825,6.11016863 6.16836964,6.17066644 Z" id="Path"></path>
                <path d="M3.68710555,9.70849202 C3.82738583,9.65557928 3.96889665,9.60389707 4.10917694,9.55098433 C4.44634184,9.42547039 4.78350674,9.29995644 5.12067165,9.1744425 C5.52551563,9.02308746 5.93159015,8.87296294 6.33643414,8.72160789 C6.68221275,8.59240236 7.02676082,8.46442736 7.37253943,8.33522183 C7.53004712,8.27615645 7.68878534,8.21955212 7.8450625,8.15925621 C7.84629303,8.15925621 7.84629303,8.15925621 7.84752356,8.15802568 C7.92504688,8.12726246 7.98780385,8.09280765 8.03948606,8.02512856 C8.07024928,7.98575164 8.08747668,7.94637472 8.10593462,7.89961462 C8.10716514,7.89592304 8.10839567,7.89346198 8.1096262,7.88977039 C8.11700938,7.8688514 8.12562308,7.84916294 8.13300625,7.82824395 C8.16746106,7.73841534 8.20068534,7.64981727 8.23514014,7.55998866 C8.3569625,7.24128169 8.47755433,6.92134419 8.59937668,6.60263722 C8.75196226,6.20025429 8.90577836,5.79787136 9.05836394,5.3942579 C9.19618317,5.03248242 9.3340024,4.67070694 9.47182163,4.30770093 C9.54688389,4.11081632 9.62194615,3.91270118 9.69700841,3.71581656 C9.70069999,3.70720286 9.70439158,3.69735863 9.70685264,3.68874493 C9.80283389,3.43648651 9.50504591,3.13869853 9.2527875,3.23467978 C9.11373774,3.28759252 8.97591851,3.34050526 8.83686875,3.393418 C8.50339543,3.52016248 8.16992212,3.64690695 7.8364488,3.77365142 C7.43283534,3.92746752 7.02799135,4.08128363 6.62437789,4.23509973 C6.27367717,4.36799685 5.92297645,4.50212449 5.57227573,4.63502161 C5.39877116,4.70147016 5.2252666,4.76545766 5.05176203,4.83313675 C5.04930097,4.83436728 5.04560939,4.83559781 5.04314833,4.83682834 C4.99638823,4.85528627 4.95701131,4.87251367 4.91763439,4.90327689 C4.85118583,4.9549591 4.81550049,5.01771608 4.78473727,5.09523939 C4.78473727,5.09646992 4.78473727,5.09646992 4.78350674,5.09770045 C4.7773541,5.1124668 4.77243198,5.12846367 4.76627934,5.14323002 C4.73551612,5.22444492 4.70598343,5.30689035 4.67522021,5.38810526 C4.55955049,5.69942905 4.44265025,6.01075285 4.32698054,6.32330718 C4.17685602,6.72569011 4.02673151,7.12807304 3.87660699,7.53045597 C3.74001829,7.89592304 3.60466011,8.2613901 3.46807141,8.62685717 C3.39300915,8.82743337 3.31917742,9.02677904 3.24411516,9.22735524 C3.24042358,9.23719947 3.23673199,9.24581318 3.23427093,9.25565741 C3.20227718,9.3405639 3.22688776,9.46484731 3.2711868,9.53990957 C3.31548584,9.61620236 3.40408391,9.69003409 3.49145146,9.70972255 C3.70064136,9.75771317 3.8729154,9.64573505 3.9455166,9.45131149 C3.99719881,9.31349226 4.04888103,9.1744425 4.10056324,9.03662327 C4.22361612,8.70684154 4.346669,8.37582928 4.46972189,8.04604755 C4.61984641,7.64489515 4.7687404,7.24374275 4.91886492,6.84135982 C5.04807044,6.49558121 5.17604544,6.14980261 5.30525097,5.80525453 C5.36800794,5.63667208 5.43568703,5.46932016 5.49352188,5.29827665 C5.49475241,5.29581559 5.49475241,5.29335454 5.49598294,5.29089348 C5.40984592,5.3770305 5.3237089,5.46316752 5.23757189,5.54930454 C5.37785217,5.4963918 5.51690193,5.44347905 5.65718222,5.38933579 C5.99065554,5.26259132 6.32535938,5.13584684 6.6588327,5.00787185 C7.06490722,4.85405574 7.47098173,4.69900911 7.87705625,4.545193 C8.22775697,4.41229589 8.57968822,4.27816824 8.93038894,4.14527113 C9.10020192,4.08128363 9.27247596,4.02098771 9.44105841,3.95084757 C9.44351947,3.94961704 9.44598052,3.94838651 9.44844158,3.94838651 C9.29708653,3.79703146 9.14573149,3.64567642 8.99437644,3.49432137 C8.9414637,3.63460166 8.88855096,3.77365142 8.83440769,3.9139317 C8.70766322,4.24740502 8.58091875,4.58210887 8.45294375,4.91558218 C8.29912764,5.3216567 8.14408101,5.72773122 7.9902649,6.13380574 C7.85736779,6.48450645 7.72324015,6.8364377 7.59034303,7.18713842 C7.52635553,7.3569514 7.45621539,7.52553385 7.39591947,7.69780789 C7.39468895,7.70026895 7.39345842,7.70273001 7.39345842,7.70519107 C7.47959544,7.61905405 7.56573245,7.53291703 7.65186947,7.44678001 C7.51405024,7.49846222 7.37500048,7.55014443 7.23718125,7.60182664 C6.90739952,7.72487953 6.57638727,7.84793241 6.24660554,7.9709853 C5.84545313,8.12110981 5.44430073,8.2700038 5.0419178,8.42012832 C4.6961392,8.54933385 4.35036059,8.67730885 4.00581252,8.80651438 C3.83723006,8.86927135 3.66741708,8.93079779 3.49883463,8.99478529 C3.49637358,8.99601582 3.49391252,8.99601582 3.49145146,8.99724635 C3.3991618,9.03170116 3.32163848,9.07969178 3.2711868,9.16705933 C3.2244267,9.24581318 3.20473824,9.36271342 3.23427093,9.45131149 C3.29087526,9.62850765 3.49391252,9.78109322 3.68710555,9.70849202 Z" id="Path"></path>
            </g>
        </g>
    </g>
</svg>
"""


def get_icon_path(field_type: str, is_aggregate: bool):
  if is_aggregate:
    image_file_name = number_aggregate_icon
  else:
    if field_type == "number":
      image_file_name = number_icon
    elif field_type == "string":
      image_file_name = string_icon
    elif field_type in ["date", "timestamp"]:
      image_file_name = time_icon
    elif field_type in ["struct_base", "basetable"]:
      image_file_name = ""
    elif field_type == "one":
      image_file_name = one_to_many_icon
    elif field_type == "inline":
      image_file_name = one_to_one_icon
    elif field_type in ["many", "cross", "nested"]:
      image_file_name = many_to_one_icon
    elif field_type == "boolean":
      image_file_name = boolean_icon
    elif field_type in ["query", "turtle"]:
      image_file_name = turtle_icon
    else:
      image_file_name = field_type

  return image_file_name
