# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from onfido.models.check_status import CheckStatus
from typing import Optional, Set
from typing_extensions import Self

class Check(BaseModel):
    """
    Check
    """ # noqa: E501
    webhook_ids: Optional[List[StrictStr]] = Field(default=None, description="An array of webhook ids describing which webhooks to trigger for this check.")
    applicant_id: StrictStr = Field(description="The ID of the applicant to do the check on.")
    applicant_provides_data: Optional[StrictBool] = Field(default=None, description="Send an applicant form to applicant to complete to proceed with check. Defaults to false. ")
    tags: Optional[List[StrictStr]] = Field(default=None, description="Array of tags being assigned to this check.")
    redirect_uri: Optional[StrictStr] = Field(default=None, description="For checks where `applicant_provides_data` is `true`, redirect to this URI when the applicant has submitted their data.")
    privacy_notices_read_consent_given: Optional[StrictBool] = None
    id: StrictStr = Field(description="The unique identifier for the check.")
    created_at: Optional[datetime] = Field(default=None, description="The date and time when this check was created.")
    href: Optional[StrictStr] = Field(default=None, description="The uri of this resource.")
    status: Optional[StrictStr] = None
    result: Optional[StrictStr] = Field(default=None, description="The overall result of the check, based on the results of the constituent reports.")
    form_uri: Optional[StrictStr] = Field(default=None, description="A link to the applicant form, if `applicant_provides_data` is `true`.")
    results_uri: Optional[StrictStr] = Field(default=None, description="A link to the corresponding results page on the Onfido dashboard.")
    report_ids: Optional[List[StrictStr]] = Field(default=None, description="An array of report ids.")
    sandbox: Optional[StrictBool] = Field(default=None, description="Indicates whether the object was created in the sandbox or not.")
    paused: Optional[StrictBool] = None
    version: Optional[StrictStr] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["webhook_ids", "applicant_id", "applicant_provides_data", "tags", "redirect_uri", "privacy_notices_read_consent_given", "id", "created_at", "href", "status", "result", "form_uri", "results_uri", "report_ids", "sandbox", "paused", "version"]

    @field_validator('result')
    def result_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['clear', 'consider']):
            raise ValueError("must be one of enum values ('clear', 'consider')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Check from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Check from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "webhook_ids": obj.get("webhook_ids"),
            "applicant_id": obj.get("applicant_id"),
            "applicant_provides_data": obj.get("applicant_provides_data"),
            "tags": obj.get("tags"),
            "redirect_uri": obj.get("redirect_uri"),
            "privacy_notices_read_consent_given": obj.get("privacy_notices_read_consent_given"),
            "id": obj.get("id"),
            "created_at": obj.get("created_at"),
            "href": obj.get("href"),
            "status": obj.get("status"),
            "result": obj.get("result"),
            "form_uri": obj.get("form_uri"),
            "results_uri": obj.get("results_uri"),
            "report_ids": obj.get("report_ids"),
            "sandbox": obj.get("sandbox"),
            "paused": obj.get("paused"),
            "version": obj.get("version")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


