# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DocumentIQReasons(BaseModel):
    """
    DocumentIQReasons
    """ # noqa: E501
    dark_photo: Optional[StrictStr] = Field(default=None, description="When an image of the document is too dark to be able to see data points.")
    glare_on_photo: Optional[StrictStr] = Field(default=None, description="When there is light reflecting on the document causing glare to obstruct data points.")
    blurred_photo: Optional[StrictStr] = Field(default=None, description="When data points are blurred and no reference can be made elsewhere in the document or if the data points are too blurry and 'they could be something else'.")
    covered_photo: Optional[StrictStr] = Field(default=None, description="When data points have been covered either by the applicant or by another object such as a sticker.")
    other_photo_issue: Optional[StrictStr] = Field(default=None, description="Any other reason not listed, such as when holograms are obscuring data points.")
    damaged_document: Optional[StrictStr] = Field(default=None, description="When a document is damaged and we are unable to make out data points.")
    incorrect_side: Optional[StrictStr] = Field(default=None, description="When the incorrect side of a document has been uploaded, and we have not received the front.")
    cut_off_document: Optional[StrictStr] = Field(default=None, description="When data points are not included in the image due to the document being cut off.")
    no_document_in_image: Optional[StrictStr] = Field(default=None, description="If no document has been uploaded or there is a blank image.")
    two_documents_uploaded: Optional[StrictStr] = Field(default=None, description="When 2 different documents are submitted in the same check.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["dark_photo", "glare_on_photo", "blurred_photo", "covered_photo", "other_photo_issue", "damaged_document", "incorrect_side", "cut_off_document", "no_document_in_image", "two_documents_uploaded"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocumentIQReasons from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocumentIQReasons from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dark_photo": obj.get("dark_photo"),
            "glare_on_photo": obj.get("glare_on_photo"),
            "blurred_photo": obj.get("blurred_photo"),
            "covered_photo": obj.get("covered_photo"),
            "other_photo_issue": obj.get("other_photo_issue"),
            "damaged_document": obj.get("damaged_document"),
            "incorrect_side": obj.get("incorrect_side"),
            "cut_off_document": obj.get("cut_off_document"),
            "no_document_in_image": obj.get("no_document_in_image"),
            "two_documents_uploaded": obj.get("two_documents_uploaded")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


