import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleworkspaceUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * The unique ID for the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/d/user#id DataGoogleworkspaceUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The user's primary email address. The primaryEmail must be unique and cannot be an alias of another user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/d/user#primary_email DataGoogleworkspaceUser#primary_email}
    */
    readonly primaryEmail?: string;
}
export interface DataGoogleworkspaceUserAddresses {
}
export declare function dataGoogleworkspaceUserAddressesToTerraform(struct?: DataGoogleworkspaceUserAddresses): any;
export declare class DataGoogleworkspaceUserAddressesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUserAddresses | undefined;
    set internalValue(value: DataGoogleworkspaceUserAddresses | undefined);
    get country(): string;
    get countryCode(): string;
    get customType(): string;
    get extendedAddress(): string;
    get formatted(): string;
    get locality(): string;
    get poBox(): string;
    get postalCode(): string;
    get primary(): cdktf.IResolvable;
    get region(): string;
    get sourceIsStructured(): cdktf.IResolvable;
    get streetAddress(): string;
    get type(): string;
}
export declare class DataGoogleworkspaceUserAddressesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUserAddressesOutputReference;
}
export interface DataGoogleworkspaceUserCustomSchemas {
}
export declare function dataGoogleworkspaceUserCustomSchemasToTerraform(struct?: DataGoogleworkspaceUserCustomSchemas): any;
export declare class DataGoogleworkspaceUserCustomSchemasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUserCustomSchemas | undefined;
    set internalValue(value: DataGoogleworkspaceUserCustomSchemas | undefined);
    get schemaName(): string;
    private _schemaValues;
    get schemaValues(): cdktf.StringMap;
}
export declare class DataGoogleworkspaceUserCustomSchemasList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUserCustomSchemasOutputReference;
}
export interface DataGoogleworkspaceUserEmails {
}
export declare function dataGoogleworkspaceUserEmailsToTerraform(struct?: DataGoogleworkspaceUserEmails): any;
export declare class DataGoogleworkspaceUserEmailsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUserEmails | undefined;
    set internalValue(value: DataGoogleworkspaceUserEmails | undefined);
    get address(): string;
    get customType(): string;
    get primary(): cdktf.IResolvable;
    get type(): string;
}
export declare class DataGoogleworkspaceUserEmailsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUserEmailsOutputReference;
}
export interface DataGoogleworkspaceUserExternalIds {
}
export declare function dataGoogleworkspaceUserExternalIdsToTerraform(struct?: DataGoogleworkspaceUserExternalIds): any;
export declare class DataGoogleworkspaceUserExternalIdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUserExternalIds | undefined;
    set internalValue(value: DataGoogleworkspaceUserExternalIds | undefined);
    get customType(): string;
    get type(): string;
    get value(): string;
}
export declare class DataGoogleworkspaceUserExternalIdsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUserExternalIdsOutputReference;
}
export interface DataGoogleworkspaceUserIms {
}
export declare function dataGoogleworkspaceUserImsToTerraform(struct?: DataGoogleworkspaceUserIms): any;
export declare class DataGoogleworkspaceUserImsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUserIms | undefined;
    set internalValue(value: DataGoogleworkspaceUserIms | undefined);
    get customProtocol(): string;
    get customType(): string;
    get im(): string;
    get primary(): cdktf.IResolvable;
    get protocol(): string;
    get type(): string;
}
export declare class DataGoogleworkspaceUserImsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUserImsOutputReference;
}
export interface DataGoogleworkspaceUserKeywords {
}
export declare function dataGoogleworkspaceUserKeywordsToTerraform(struct?: DataGoogleworkspaceUserKeywords): any;
export declare class DataGoogleworkspaceUserKeywordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUserKeywords | undefined;
    set internalValue(value: DataGoogleworkspaceUserKeywords | undefined);
    get customType(): string;
    get type(): string;
    get value(): string;
}
export declare class DataGoogleworkspaceUserKeywordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUserKeywordsOutputReference;
}
export interface DataGoogleworkspaceUserLanguages {
}
export declare function dataGoogleworkspaceUserLanguagesToTerraform(struct?: DataGoogleworkspaceUserLanguages): any;
export declare class DataGoogleworkspaceUserLanguagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUserLanguages | undefined;
    set internalValue(value: DataGoogleworkspaceUserLanguages | undefined);
    get customLanguage(): string;
    get languageCode(): string;
    get preference(): string;
}
export declare class DataGoogleworkspaceUserLanguagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUserLanguagesOutputReference;
}
export interface DataGoogleworkspaceUserLocations {
}
export declare function dataGoogleworkspaceUserLocationsToTerraform(struct?: DataGoogleworkspaceUserLocations): any;
export declare class DataGoogleworkspaceUserLocationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUserLocations | undefined;
    set internalValue(value: DataGoogleworkspaceUserLocations | undefined);
    get area(): string;
    get buildingId(): string;
    get customType(): string;
    get deskCode(): string;
    get floorName(): string;
    get floorSection(): string;
    get type(): string;
}
export declare class DataGoogleworkspaceUserLocationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUserLocationsOutputReference;
}
export interface DataGoogleworkspaceUserName {
}
export declare function dataGoogleworkspaceUserNameToTerraform(struct?: DataGoogleworkspaceUserName): any;
export declare class DataGoogleworkspaceUserNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUserName | undefined;
    set internalValue(value: DataGoogleworkspaceUserName | undefined);
    get familyName(): string;
    get fullName(): string;
    get givenName(): string;
}
export declare class DataGoogleworkspaceUserNameList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUserNameOutputReference;
}
export interface DataGoogleworkspaceUserOrganizations {
}
export declare function dataGoogleworkspaceUserOrganizationsToTerraform(struct?: DataGoogleworkspaceUserOrganizations): any;
export declare class DataGoogleworkspaceUserOrganizationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUserOrganizations | undefined;
    set internalValue(value: DataGoogleworkspaceUserOrganizations | undefined);
    get costCenter(): string;
    get customType(): string;
    get department(): string;
    get description(): string;
    get domain(): string;
    get fullTimeEquivalent(): number;
    get location(): string;
    get name(): string;
    get primary(): cdktf.IResolvable;
    get symbol(): string;
    get title(): string;
    get type(): string;
}
export declare class DataGoogleworkspaceUserOrganizationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUserOrganizationsOutputReference;
}
export interface DataGoogleworkspaceUserPhones {
}
export declare function dataGoogleworkspaceUserPhonesToTerraform(struct?: DataGoogleworkspaceUserPhones): any;
export declare class DataGoogleworkspaceUserPhonesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUserPhones | undefined;
    set internalValue(value: DataGoogleworkspaceUserPhones | undefined);
    get customType(): string;
    get primary(): cdktf.IResolvable;
    get type(): string;
    get value(): string;
}
export declare class DataGoogleworkspaceUserPhonesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUserPhonesOutputReference;
}
export interface DataGoogleworkspaceUserPosixAccounts {
}
export declare function dataGoogleworkspaceUserPosixAccountsToTerraform(struct?: DataGoogleworkspaceUserPosixAccounts): any;
export declare class DataGoogleworkspaceUserPosixAccountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUserPosixAccounts | undefined;
    set internalValue(value: DataGoogleworkspaceUserPosixAccounts | undefined);
    get accountId(): string;
    get gecos(): string;
    get gid(): string;
    get homeDirectory(): string;
    get operatingSystemType(): string;
    get primary(): cdktf.IResolvable;
    get shell(): string;
    get systemId(): string;
    get uid(): string;
    get username(): string;
}
export declare class DataGoogleworkspaceUserPosixAccountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUserPosixAccountsOutputReference;
}
export interface DataGoogleworkspaceUserRelations {
}
export declare function dataGoogleworkspaceUserRelationsToTerraform(struct?: DataGoogleworkspaceUserRelations): any;
export declare class DataGoogleworkspaceUserRelationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUserRelations | undefined;
    set internalValue(value: DataGoogleworkspaceUserRelations | undefined);
    get customType(): string;
    get type(): string;
    get value(): string;
}
export declare class DataGoogleworkspaceUserRelationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUserRelationsOutputReference;
}
export interface DataGoogleworkspaceUserSshPublicKeys {
}
export declare function dataGoogleworkspaceUserSshPublicKeysToTerraform(struct?: DataGoogleworkspaceUserSshPublicKeys): any;
export declare class DataGoogleworkspaceUserSshPublicKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUserSshPublicKeys | undefined;
    set internalValue(value: DataGoogleworkspaceUserSshPublicKeys | undefined);
    get expirationTimeUsec(): string;
    get fingerprint(): string;
    get key(): string;
}
export declare class DataGoogleworkspaceUserSshPublicKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUserSshPublicKeysOutputReference;
}
export interface DataGoogleworkspaceUserWebsites {
}
export declare function dataGoogleworkspaceUserWebsitesToTerraform(struct?: DataGoogleworkspaceUserWebsites): any;
export declare class DataGoogleworkspaceUserWebsitesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUserWebsites | undefined;
    set internalValue(value: DataGoogleworkspaceUserWebsites | undefined);
    get customType(): string;
    get primary(): cdktf.IResolvable;
    get type(): string;
    get value(): string;
}
export declare class DataGoogleworkspaceUserWebsitesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUserWebsitesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/googleworkspace/d/user googleworkspace_user}
*/
export declare class DataGoogleworkspaceUser extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "googleworkspace_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/googleworkspace/d/user googleworkspace_user} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleworkspaceUserConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleworkspaceUserConfig);
    private _addresses;
    get addresses(): DataGoogleworkspaceUserAddressesList;
    get agreedToTerms(): cdktf.IResolvable;
    get aliases(): string[];
    get archived(): cdktf.IResolvable;
    get changePasswordAtNextLogin(): cdktf.IResolvable;
    get creationTime(): string;
    private _customSchemas;
    get customSchemas(): DataGoogleworkspaceUserCustomSchemasList;
    get customerId(): string;
    get deletionTime(): string;
    private _emails;
    get emails(): DataGoogleworkspaceUserEmailsList;
    get etag(): string;
    private _externalIds;
    get externalIds(): DataGoogleworkspaceUserExternalIdsList;
    get hashFunction(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ims;
    get ims(): DataGoogleworkspaceUserImsList;
    get includeInGlobalAddressList(): cdktf.IResolvable;
    get ipAllowlist(): cdktf.IResolvable;
    get isAdmin(): cdktf.IResolvable;
    get isDelegatedAdmin(): cdktf.IResolvable;
    get isEnforcedIn2StepVerification(): cdktf.IResolvable;
    get isEnrolledIn2StepVerification(): cdktf.IResolvable;
    get isMailboxSetup(): cdktf.IResolvable;
    private _keywords;
    get keywords(): DataGoogleworkspaceUserKeywordsList;
    private _languages;
    get languages(): DataGoogleworkspaceUserLanguagesList;
    get lastLoginTime(): string;
    private _locations;
    get locations(): DataGoogleworkspaceUserLocationsList;
    private _name;
    get name(): DataGoogleworkspaceUserNameList;
    get nonEditableAliases(): string[];
    get orgUnitPath(): string;
    private _organizations;
    get organizations(): DataGoogleworkspaceUserOrganizationsList;
    get password(): string;
    private _phones;
    get phones(): DataGoogleworkspaceUserPhonesList;
    private _posixAccounts;
    get posixAccounts(): DataGoogleworkspaceUserPosixAccountsList;
    private _primaryEmail?;
    get primaryEmail(): string;
    set primaryEmail(value: string);
    resetPrimaryEmail(): void;
    get primaryEmailInput(): string | undefined;
    get recoveryEmail(): string;
    get recoveryPhone(): string;
    private _relations;
    get relations(): DataGoogleworkspaceUserRelationsList;
    private _sshPublicKeys;
    get sshPublicKeys(): DataGoogleworkspaceUserSshPublicKeysList;
    get suspended(): cdktf.IResolvable;
    get suspensionReason(): string;
    get thumbnailPhotoEtag(): string;
    get thumbnailPhotoUrl(): string;
    private _websites;
    get websites(): DataGoogleworkspaceUserWebsitesList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
