from _nxlu.config import _config

__all__ = ["get_info"]


def get_info():
    """Provide information about the backend.

    Returns
    -------
    Dict[str, Any]
        A dictionary containing metadata about the backend.
    """
    return {
        "name": "Network Language Understanding",
        "version": "1.0",
        "description": (
            "A backend that provides natural language explanations of graph network "
            "topology"
        ),
        "author": "Derek Alexander",
        "url": "https://github.com/dpys/gar",
        "graph_class": "gar.interface:LLMGraph",
        "functions": {
            "approximate_current_flow_betweenness_centrality": {},
            "betweenness_centrality": {},
            "betweenness_centrality_subset": {},
            "closeness_centrality": {},
            "communicability_betweenness_centrality": {},
            "current_flow_betweenness_centrality": {},
            "current_flow_betweenness_centrality_subset": {},
            "current_flow_closeness_centrality": {},
            "degree_centrality": {},
            "dispersion": {},
            "edge_betweenness_centrality": {},
            "edge_betweenness_centrality_subset": {},
            "edge_current_flow_betweenness_centrality": {},
            "edge_current_flow_betweenness_centrality_subset": {},
            "edge_load_centrality": {},
            "eigenvector_centrality": {},
            "eigenvector_centrality_numpy": {},
            "estrada_index": {},
            "global_reaching_centrality": {},
            "group_betweenness_centrality": {},
            "group_closeness_centrality": {},
            "group_degree_centrality": {},
            "group_in_degree_centrality": {},
            "group_out_degree_centrality": {},
            "harmonic_centrality": {},
            "in_degree_centrality": {},
            "incremental_closeness_centrality": {},
            "information_centrality": {},
            "katz_centrality": {},
            "katz_centrality_numpy": {},
            "laplacian_centrality": {},
            "load_centrality": {},
            "local_reaching_centrality": {},
            "out_degree_centrality": {},
            "percolation_centrality": {},
            "prominent_group": {},
            "second_order_centrality": {},
            "subgraph_centrality": {},
            "subgraph_centrality_exp": {},
            "trophic_differences": {},
            "trophic_incoherence_parameter": {},
            "trophic_levels": {},
            "voterank": {},
            "enumerate_all_cliques": {},
            "max_weight_clique": {},
            "node_clique_number": {},
            "number_of_cliques": {},
            "average_clustering": {},
            "clustering": {},
            "generalized_degree": {},
            "square_clustering": {},
            "transitivity": {},
            "triangles": {},
            "articulation_points": {},
            "attracting_components": {},
            "biconnected_component_edges": {},
            "biconnected_components": {},
            "condensation": {},
            "density": {},
            "connected_components": {},
            "kosaraju_strongly_connected_components": {},
            "node_connected_component": {},
            "number_attracting_components": {},
            "number_connected_components": {},
            "number_strongly_connected_components": {},
            "number_weakly_connected_components": {},
            "strongly_connected_components": {},
            "strongly_connected_components_recursive": {},
            "weakly_connected_components": {},
            "all_node_cuts": {},
            "all_pairs_node_connectivity": {},
            "average_node_connectivity": {},
            "bridge_components": {},
            "edge_connectivity": {},
            "edge_disjoint_paths": {},
            "k_components": {},
            "k_edge_augmentation": {},
            "k_edge_components": {},
            "k_edge_subgraphs": {},
            "local_edge_connectivity": {},
            "local_node_connectivity": {},
            "minimum_edge_cut": {},
            "minimum_node_cut": {},
            "minimum_st_edge_cut": {},
            "minimum_st_node_cut": {},
            "node_connectivity": {},
            "node_disjoint_paths": {},
            "stoer_wagner": {},
            "chordless_cycles": {},
            "cycle_basis": {},
            "girth": {},
            "minimum_cycle_basis": {},
            "recursive_simple_cycles": {},
            "simple_cycles": {},
            "boykov_kolmogorov": {},
            "capacity_scaling": {},
            "cost_of_flow": {},
            "dinitz": {},
            "edmonds_karp": {},
            "gomory_hu_tree": {},
            "max_flow_min_cost": {},
            "maximum_flow": {},
            "maximum_flow_value": {},
            "min_cost_flow": {},
            "min_cost_flow_cost": {},
            "minimum_cut": {},
            "minimum_cut_value": {},
            "network_simplex": {},
            "preflow_push": {},
            "shortest_augmenting_path": {},
            "all_pairs_all_shortest_paths": {},
            "all_pairs_bellman_ford_path": {},
            "all_pairs_bellman_ford_path_length": {},
            "all_pairs_dijkstra": {},
            "all_pairs_dijkstra_path": {},
            "all_pairs_dijkstra_path_length": {},
            "all_pairs_shortest_path": {},
            "all_pairs_shortest_path_length": {},
            "all_shortest_paths": {},
            "astar_path": {},
            "astar_path_length": {},
            "average_shortest_path_length": {},
            "bellman_ford_path": {},
            "bellman_ford_path_length": {},
            "bellman_ford_predecessor_and_distance": {},
            "bidirectional_dijkstra": {},
            "bidirectional_shortest_path": {},
            "dijkstra_path": {},
            "dijkstra_path_length": {},
            "dijkstra_predecessor_and_distance": {},
            "floyd_warshall": {},
            "floyd_warshall_numpy": {},
            "floyd_warshall_predecessor_and_distance": {},
            "goldberg_radzik": {},
            "johnson": {},
            "multi_source_dijkstra": {},
            "multi_source_dijkstra_path": {},
            "multi_source_dijkstra_path_length": {},
            "negative_edge_cycle": {},
            "predecessor": {},
            "reconstruct_path": {},
            "shortest_path": {},
            "shortest_path_length": {},
            "single_source_all_shortest_paths": {},
            "single_source_bellman_ford": {},
            "single_source_bellman_ford_path": {},
            "single_source_bellman_ford_path_length": {},
            "single_source_dijkstra": {},
            "single_source_dijkstra_path": {},
            "single_source_dijkstra_path_length": {},
            "single_source_shortest_path": {},
            "single_source_shortest_path_length": {},
            "single_target_shortest_path": {},
            "single_target_shortest_path_length": {},
            "asyn_fluidc": {},
            "asyn_lpa_communities": {},
            "edge_betweenness_partition": {},
            "edge_current_flow_betweenness_partition": {},
            "fast_label_propagation_communities": {},
            "girvan_newman": {},
            "greedy_modularity_communities": {},
            "k_clique_communities": {},
            "kernighan_lin_bisection": {},
            "label_propagation_communities": {},
            "louvain_communities": {},
            "louvain_partitions": {},
            "lukes_partitioning": {},
            "modularity": {},
            "naive_greedy_modularity_communities": {},
            "partition_quality": {},
            "equitable_color": {},
            "greedy_color": {},
            "strategy_connected_sequential": {},
            "strategy_connected_sequential_bfs": {},
            "strategy_connected_sequential_dfs": {},
            "strategy_independent_set": {},
            "strategy_largest_first": {},
            "strategy_random_sequential": {},
            "strategy_saturation_largest_first": {},
            "strategy_smallest_last": {},
            "categorical_edge_match": {},
            "categorical_multiedge_match": {},
            "categorical_node_match": {},
            "could_be_isomorphic": {},
            "fast_could_be_isomorphic": {},
            "faster_could_be_isomorphic": {},
            "generic_edge_match": {},
            "generic_multiedge_match": {},
            "generic_node_match": {},
            "numerical_edge_match": {},
            "numerical_multiedge_match": {},
            "numerical_node_match": {},
            "rooted_tree_isomorphism": {},
            "tree_isomorphism": {},
            "vf2pp_all_isomorphisms": {},
            "vf2pp_is_isomorphic": {},
            "vf2pp_isomorphism": {},
            "is_connected": {},
            "matching_dict_to_set": {},
            "max_weight_matching": {},
            "maximal_matching": {},
            "min_weight_matching": {},
            "all_topological_sorts": {},
            "ancestors": {},
            "antichains": {},
            "compute_v_structures": {},
            "dag_longest_path": {},
            "dag_longest_path_length": {},
            "dag_to_branching": {},
            "descendants": {},
            "lexicographical_topological_sort": {},
            "root_to_leaf_paths": {},
            "topological_generations": {},
            "topological_sort": {},
            "transitive_closure": {},
            "transitive_closure_dag": {},
            "transitive_reduction": {},
            "branching_weight": {},
            "greedy_branching": {},
            "join": {},
            "join_trees": {},
            "junction_tree": {},
            "maximum_spanning_edges": {},
            "maximum_spanning_tree": {},
            "minimum_spanning_edges": {},
            "minimum_spanning_tree": {},
            "number_of_spanning_trees": {},
            "partition_spanning_tree": {},
            "random_spanning_tree": {},
            "asadpour_atsp": {},
            "christofides": {},
            "clique_removal": {},
            "diameter": {},
            "greedy_tsp": {},
            "large_clique_size": {},
            "max_clique": {},
            "maximum_independent_set": {},
            "metric_closure": {},
            "min_edge_dominating_set": {},
            "min_maximal_matching": {},
            "min_weighted_dominating_set": {},
            "min_weighted_vertex_cover": {},
            "one_exchange": {},
            "ramsey_R2": {},
            "randomized_partitioning": {},
            "simulated_annealing_tsp": {},
            "steiner_tree": {},
            "threshold_accepting_tsp": {},
            "traveling_salesman_problem": {},
            "treewidth_min_degree": {},
            "treewidth_min_fill_in": {},
            "google_matrix": {},
            "hits": {},
            "pagerank": {},
            "bfs_beam_edges": {},
            "bfs_edges": {},
            "bfs_labeled_edges": {},
            "bfs_layers": {},
            "bfs_predecessors": {},
            "bfs_successors": {},
            "bfs_tree": {},
            "descendants_at_distance": {},
            "dfs_edges": {},
            "dfs_labeled_edges": {},
            "dfs_postorder_nodes": {},
            "dfs_predecessors": {},
            "dfs_preorder_nodes": {},
            "dfs_successors": {},
            "dfs_tree": {},
            "edge_bfs": {},
            "edge_dfs": {},
            "generic_bfs_edges": {},
            "best_partition": {},
        },
        "default_config": _config,
    }
