"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DetectorModel = exports.EventEvaluation = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
const aws_iotevents_1 = require("aws-cdk-lib/aws-iotevents");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
/**
 * Information about the order in which events are evaluated and how actions are executed.
 */
var EventEvaluation;
(function (EventEvaluation) {
    /**
     * When setting to BATCH, variables within a state are updated and events within a state are
     * performed only after all event conditions are evaluated.
     */
    EventEvaluation["BATCH"] = "BATCH";
    /**
     * When setting to SERIAL, variables are updated and event conditions are evaluated in the order
     * that the events are defined.
     */
    EventEvaluation["SERIAL"] = "SERIAL";
})(EventEvaluation || (exports.EventEvaluation = EventEvaluation = {}));
/**
 * Defines an AWS IoT Events detector model in this stack.
 */
let DetectorModel = class DetectorModel extends core_1.Resource {
    /**
     * Import an existing detector model.
     */
    static fromDetectorModelName(scope, id, detectorModelName) {
        return new class extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.detectorModelName = detectorModelName;
            }
        }(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.detectorModelName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_DetectorModelProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DetectorModel);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (!props.initialState._onEnterEventsHaveAtLeastOneCondition()) {
            throw new Error('Detector Model must have at least one Input with a condition');
        }
        const role = props.role ?? new iam.Role(this, 'DetectorModelRole', {
            assumedBy: new iam.ServicePrincipal('iotevents.amazonaws.com'),
        });
        const resource = new aws_iotevents_1.CfnDetectorModel(this, 'Resource', {
            detectorModelName: this.physicalName,
            detectorModelDescription: props.description,
            evaluationMethod: props.evaluationMethod,
            key: props.detectorKey,
            detectorModelDefinition: {
                initialStateName: props.initialState.stateName,
                states: props.initialState._collectStateJsons(this, { role }, new Set()),
            },
            roleArn: role.roleArn,
        });
        this.detectorModelName = this.getResourceNameAttribute(resource.ref);
    }
};
exports.DetectorModel = DetectorModel;
_a = JSII_RTTI_SYMBOL_1;
DetectorModel[_a] = { fqn: "@aws-cdk/aws-iotevents-alpha.DetectorModel", version: "2.200.2-alpha.0" };
/** Uniquely identifies this class. */
DetectorModel.PROPERTY_INJECTION_ID = '@aws-cdk.aws-iotevents-alpha.DetectorModel';
exports.DetectorModel = DetectorModel = __decorate([
    prop_injectable_1.propertyInjectable
], DetectorModel);
//# sourceMappingURL=data:application/json;base64,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