"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Input = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
const aws_iotevents_1 = require("aws-cdk-lib/aws-iotevents");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
class InputBase extends core_1.Resource {
    grantWrite(grantee) {
        return this.grant(grantee, 'iotevents:BatchPutMessage');
    }
    grant(grantee, ...actions) {
        return iam.Grant.addToPrincipal({
            grantee,
            actions,
            resourceArns: [this.inputArn],
        });
    }
}
/**
 * Defines an AWS IoT Events input in this stack.
 */
let Input = class Input extends InputBase {
    /**
     * Import an existing input.
     */
    static fromInputName(scope, id, inputName) {
        return new class Import extends InputBase {
            constructor() {
                super(...arguments);
                this.inputName = inputName;
                this.inputArn = this.stack.formatArn({
                    service: 'iotevents',
                    resource: 'input',
                    resourceName: inputName,
                });
            }
        }(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.inputName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_InputProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Input);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (props.attributeJsonPaths.length === 0) {
            throw new Error('attributeJsonPaths property cannot be empty');
        }
        const resource = new aws_iotevents_1.CfnInput(this, 'Resource', {
            inputName: this.physicalName,
            inputDefinition: {
                attributes: props.attributeJsonPaths.map(path => ({ jsonPath: path })),
            },
        });
        this.inputName = this.getResourceNameAttribute(resource.ref);
        this.inputArn = this.getResourceArnAttribute(arnForInput(resource.ref), {
            service: 'iotevents',
            resource: 'input',
            resourceName: this.physicalName,
        });
    }
};
exports.Input = Input;
_a = JSII_RTTI_SYMBOL_1;
Input[_a] = { fqn: "@aws-cdk/aws-iotevents-alpha.Input", version: "2.200.2-alpha.0" };
/** Uniquely identifies this class. */
Input.PROPERTY_INJECTION_ID = '@aws-cdk.aws-iotevents-alpha.Input';
exports.Input = Input = __decorate([
    prop_injectable_1.propertyInjectable
], Input);
function arnForInput(inputName) {
    return `arn:${core_1.Aws.PARTITION}:iotevents:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:input/${inputName}`;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5wdXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnB1dC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7QUFBQSwyQ0FBMkM7QUFDM0MsMkNBQTREO0FBRTVELDZEQUFxRDtBQUNyRCw4RUFBOEU7QUFDOUUsMEVBQTBFO0FBb0MxRSxNQUFlLFNBQVUsU0FBUSxlQUFRO0lBS2hDLFVBQVUsQ0FBQyxPQUF1QjtRQUN2QyxPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLDJCQUEyQixDQUFDLENBQUM7S0FDekQ7SUFFTSxLQUFLLENBQUMsT0FBdUIsRUFBRSxHQUFHLE9BQWlCO1FBQ3hELE9BQU8sR0FBRyxDQUFDLEtBQUssQ0FBQyxjQUFjLENBQUM7WUFDOUIsT0FBTztZQUNQLE9BQU87WUFDUCxZQUFZLEVBQUUsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDO1NBQzlCLENBQUMsQ0FBQztLQUNKO0NBQ0Y7QUF1QkQ7O0dBRUc7QUFFSSxJQUFNLEtBQUssR0FBWCxNQUFNLEtBQU0sU0FBUSxTQUFTO0lBSWxDOztPQUVHO0lBQ0ksTUFBTSxDQUFDLGFBQWEsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSxTQUFpQjtRQUN6RSxPQUFPLElBQUksTUFBTSxNQUFPLFNBQVEsU0FBUztZQUE5Qjs7Z0JBQ08sY0FBUyxHQUFHLFNBQVMsQ0FBQztnQkFDdEIsYUFBUSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDO29CQUM5QyxPQUFPLEVBQUUsV0FBVztvQkFDcEIsUUFBUSxFQUFFLE9BQU87b0JBQ2pCLFlBQVksRUFBRSxTQUFTO2lCQUN4QixDQUFDLENBQUM7WUFDTCxDQUFDO1NBQUEsQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7S0FDZDtJQU1ELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBaUI7UUFDekQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixZQUFZLEVBQUUsS0FBSyxDQUFDLFNBQVM7U0FDOUIsQ0FBQyxDQUFDOzs7Ozs7K0NBekJNLEtBQUs7Ozs7UUEwQmQsbUNBQW1DO1FBQ25DLElBQUEsd0NBQW9CLEVBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRWxDLElBQUksS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUUsQ0FBQztZQUMxQyxNQUFNLElBQUksS0FBSyxDQUFDLDZDQUE2QyxDQUFDLENBQUM7UUFDakUsQ0FBQztRQUVELE1BQU0sUUFBUSxHQUFHLElBQUksd0JBQVEsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQzlDLFNBQVMsRUFBRSxJQUFJLENBQUMsWUFBWTtZQUM1QixlQUFlLEVBQUU7Z0JBQ2YsVUFBVSxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7YUFDdkU7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDN0QsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsdUJBQXVCLENBQUMsV0FBVyxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsRUFBRTtZQUN0RSxPQUFPLEVBQUUsV0FBVztZQUNwQixRQUFRLEVBQUUsT0FBTztZQUNqQixZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7U0FDaEMsQ0FBQyxDQUFDO0tBQ0o7O0FBOUNVLHNCQUFLOzs7QUFDaEIsc0NBQXNDO0FBQ2YsMkJBQXFCLEdBQVcsb0NBQW9DLEFBQS9DLENBQWdEO2dCQUZqRixLQUFLO0lBRGpCLG9DQUFrQjtHQUNOLEtBQUssQ0ErQ2pCO0FBRUQsU0FBUyxXQUFXLENBQUMsU0FBaUI7SUFDcEMsT0FBTyxPQUFPLFVBQUcsQ0FBQyxTQUFTLGNBQWMsVUFBRyxDQUFDLE1BQU0sSUFBSSxVQUFHLENBQUMsVUFBVSxVQUFVLFNBQVMsRUFBRSxDQUFDO0FBQzdGLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBSZXNvdXJjZSwgSVJlc291cmNlLCBBd3MgfSBmcm9tICdhd3MtY2RrLWxpYi9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2ZuSW5wdXQgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaW90ZXZlbnRzJztcbmltcG9ydCB7IGFkZENvbnN0cnVjdE1ldGFkYXRhIH0gZnJvbSAnYXdzLWNkay1saWIvY29yZS9saWIvbWV0YWRhdGEtcmVzb3VyY2UnO1xuaW1wb3J0IHsgcHJvcGVydHlJbmplY3RhYmxlIH0gZnJvbSAnYXdzLWNkay1saWIvY29yZS9saWIvcHJvcC1pbmplY3RhYmxlJztcblxuLyoqXG4gKiBSZXByZXNlbnRzIGFuIEFXUyBJb1QgRXZlbnRzIGlucHV0LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElJbnB1dCBleHRlbmRzIElSZXNvdXJjZSB7XG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgaW5wdXQuXG4gICAqXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IGlucHV0TmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgQVJOIG9mIHRoZSBpbnB1dC5cbiAgICpcbiAgICogQGF0dHJpYnV0ZVxuICAgKi9cbiAgcmVhZG9ubHkgaW5wdXRBcm46IHN0cmluZztcblxuICAvKipcbiAgICogR3JhbnQgd3JpdGUgcGVybWlzc2lvbnMgb24gdGhpcyBpbnB1dCBhbmQgaXRzIGNvbnRlbnRzIHRvIGFuIElBTSBwcmluY2lwYWwgKFJvbGUvR3JvdXAvVXNlcikuXG4gICAqXG4gICAqIEBwYXJhbSBncmFudGVlIHRoZSBwcmluY2lwYWxcbiAgICovXG4gIGdyYW50V3JpdGUoZ3JhbnRlZTogaWFtLklHcmFudGFibGUpOiBpYW0uR3JhbnQ7XG5cbiAgLyoqXG4gICAqIEdyYW50IHRoZSBpbmRpY2F0ZWQgcGVybWlzc2lvbnMgb24gdGhpcyBpbnB1dCB0byB0aGUgZ2l2ZW4gSUFNIHByaW5jaXBhbCAoUm9sZS9Hcm91cC9Vc2VyKS5cbiAgICpcbiAgICogQHBhcmFtIGdyYW50ZWUgdGhlIHByaW5jaXBhbFxuICAgKiBAcGFyYW0gYWN0aW9ucyB0aGUgc2V0IG9mIGFjdGlvbnMgdG8gYWxsb3cgKGkuZS4gXCJpb3RldmVudHM6QmF0Y2hQdXRNZXNzYWdlXCIpXG4gICAqL1xuICBncmFudChncmFudGVlOiBpYW0uSUdyYW50YWJsZSwgLi4uYWN0aW9uczogc3RyaW5nW10pOiBpYW0uR3JhbnQ7XG59XG5cbmFic3RyYWN0IGNsYXNzIElucHV0QmFzZSBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSUlucHV0IHtcbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IGlucHV0TmFtZTogc3RyaW5nO1xuXG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBpbnB1dEFybjogc3RyaW5nO1xuXG4gIHB1YmxpYyBncmFudFdyaXRlKGdyYW50ZWU6IGlhbS5JR3JhbnRhYmxlKSB7XG4gICAgcmV0dXJuIHRoaXMuZ3JhbnQoZ3JhbnRlZSwgJ2lvdGV2ZW50czpCYXRjaFB1dE1lc3NhZ2UnKTtcbiAgfVxuXG4gIHB1YmxpYyBncmFudChncmFudGVlOiBpYW0uSUdyYW50YWJsZSwgLi4uYWN0aW9uczogc3RyaW5nW10pIHtcbiAgICByZXR1cm4gaWFtLkdyYW50LmFkZFRvUHJpbmNpcGFsKHtcbiAgICAgIGdyYW50ZWUsXG4gICAgICBhY3Rpb25zLFxuICAgICAgcmVzb3VyY2VBcm5zOiBbdGhpcy5pbnB1dEFybl0sXG4gICAgfSk7XG4gIH1cbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhbiBBV1MgSW9UIEV2ZW50cyBpbnB1dC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJbnB1dFByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBpbnB1dC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBDbG91ZEZvcm1hdGlvbiB3aWxsIGdlbmVyYXRlIGEgdW5pcXVlIG5hbWUgb2YgdGhlIGlucHV0XG4gICAqL1xuICByZWFkb25seSBpbnB1dE5hbWU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEFuIGV4cHJlc3Npb24gdGhhdCBzcGVjaWZpZXMgYW4gYXR0cmlidXRlLXZhbHVlIHBhaXIgaW4gYSBKU09OIHN0cnVjdHVyZS5cbiAgICogVXNlIHRoaXMgdG8gc3BlY2lmeSBhbiBhdHRyaWJ1dGUgZnJvbSB0aGUgSlNPTiBwYXlsb2FkIHRoYXQgaXMgbWFkZSBhdmFpbGFibGVcbiAgICogYnkgdGhlIGlucHV0LiBJbnB1dHMgYXJlIGRlcml2ZWQgZnJvbSBtZXNzYWdlcyBzZW50IHRvIEFXUyBJb1QgRXZlbnRzIChCYXRjaFB1dE1lc3NhZ2UpLlxuICAgKiBFYWNoIHN1Y2ggbWVzc2FnZSBjb250YWlucyBhIEpTT04gcGF5bG9hZC4gVGhlIGF0dHJpYnV0ZSAoYW5kIGl0cyBwYWlyZWQgdmFsdWUpXG4gICAqIHNwZWNpZmllZCBoZXJlIGFyZSBhdmFpbGFibGUgZm9yIHVzZSBpbiB0aGUgY29uZGl0aW9uIGV4cHJlc3Npb25zIHVzZWQgYnkgZGV0ZWN0b3JzLlxuICAgKi9cbiAgcmVhZG9ubHkgYXR0cmlidXRlSnNvblBhdGhzOiBzdHJpbmdbXTtcbn1cblxuLyoqXG4gKiBEZWZpbmVzIGFuIEFXUyBJb1QgRXZlbnRzIGlucHV0IGluIHRoaXMgc3RhY2suXG4gKi9cbkBwcm9wZXJ0eUluamVjdGFibGVcbmV4cG9ydCBjbGFzcyBJbnB1dCBleHRlbmRzIElucHV0QmFzZSB7XG4gIC8qKiBVbmlxdWVseSBpZGVudGlmaWVzIHRoaXMgY2xhc3MuICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUFJPUEVSVFlfSU5KRUNUSU9OX0lEOiBzdHJpbmcgPSAnQGF3cy1jZGsuYXdzLWlvdGV2ZW50cy1hbHBoYS5JbnB1dCc7XG5cbiAgLyoqXG4gICAqIEltcG9ydCBhbiBleGlzdGluZyBpbnB1dC5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUlucHV0TmFtZShzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBpbnB1dE5hbWU6IHN0cmluZyk6IElJbnB1dCB7XG4gICAgcmV0dXJuIG5ldyBjbGFzcyBJbXBvcnQgZXh0ZW5kcyBJbnB1dEJhc2Uge1xuICAgICAgcHVibGljIHJlYWRvbmx5IGlucHV0TmFtZSA9IGlucHV0TmFtZTtcbiAgICAgIHB1YmxpYyByZWFkb25seSBpbnB1dEFybiA9IHRoaXMuc3RhY2suZm9ybWF0QXJuKHtcbiAgICAgICAgc2VydmljZTogJ2lvdGV2ZW50cycsXG4gICAgICAgIHJlc291cmNlOiAnaW5wdXQnLFxuICAgICAgICByZXNvdXJjZU5hbWU6IGlucHV0TmFtZSxcbiAgICAgIH0pO1xuICAgIH0oc2NvcGUsIGlkKTtcbiAgfVxuXG4gIHB1YmxpYyByZWFkb25seSBpbnB1dE5hbWU6IHN0cmluZztcblxuICBwdWJsaWMgcmVhZG9ubHkgaW5wdXRBcm46IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogSW5wdXRQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgcGh5c2ljYWxOYW1lOiBwcm9wcy5pbnB1dE5hbWUsXG4gICAgfSk7XG4gICAgLy8gRW5oYW5jZWQgQ0RLIEFuYWx5dGljcyBUZWxlbWV0cnlcbiAgICBhZGRDb25zdHJ1Y3RNZXRhZGF0YSh0aGlzLCBwcm9wcyk7XG5cbiAgICBpZiAocHJvcHMuYXR0cmlidXRlSnNvblBhdGhzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdhdHRyaWJ1dGVKc29uUGF0aHMgcHJvcGVydHkgY2Fubm90IGJlIGVtcHR5Jyk7XG4gICAgfVxuXG4gICAgY29uc3QgcmVzb3VyY2UgPSBuZXcgQ2ZuSW5wdXQodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgaW5wdXROYW1lOiB0aGlzLnBoeXNpY2FsTmFtZSxcbiAgICAgIGlucHV0RGVmaW5pdGlvbjoge1xuICAgICAgICBhdHRyaWJ1dGVzOiBwcm9wcy5hdHRyaWJ1dGVKc29uUGF0aHMubWFwKHBhdGggPT4gKHsganNvblBhdGg6IHBhdGggfSkpLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIHRoaXMuaW5wdXROYW1lID0gdGhpcy5nZXRSZXNvdXJjZU5hbWVBdHRyaWJ1dGUocmVzb3VyY2UucmVmKTtcbiAgICB0aGlzLmlucHV0QXJuID0gdGhpcy5nZXRSZXNvdXJjZUFybkF0dHJpYnV0ZShhcm5Gb3JJbnB1dChyZXNvdXJjZS5yZWYpLCB7XG4gICAgICBzZXJ2aWNlOiAnaW90ZXZlbnRzJyxcbiAgICAgIHJlc291cmNlOiAnaW5wdXQnLFxuICAgICAgcmVzb3VyY2VOYW1lOiB0aGlzLnBoeXNpY2FsTmFtZSxcbiAgICB9KTtcbiAgfVxufVxuXG5mdW5jdGlvbiBhcm5Gb3JJbnB1dChpbnB1dE5hbWU6IHN0cmluZyk6IHN0cmluZyB7XG4gIHJldHVybiBgYXJuOiR7QXdzLlBBUlRJVElPTn06aW90ZXZlbnRzOiR7QXdzLlJFR0lPTn06JHtBd3MuQUNDT1VOVF9JRH06aW5wdXQvJHtpbnB1dE5hbWV9YDtcbn1cbiJdfQ==