# -*- coding: utf-8 -*-
"""
# how's the NAIVE_NEG_CHAR_TRANSITION generated:
from nltk.corpus import words, brown, webtext, reuters, inaugural
import itertools
import hao

words_all = words.words() + brown.words() + webtext.words() + inaugural.words()
chars = set('abcdefghijklmnopqrstuvwxyz')
chars2 = set([f"{a}{b}" for a, b in itertools.permutation(chars, 2)])

transitions = collections.defaultdict(set)
for word in tqdm.tqdm(words_all):
    size = len(word)
    if size < 3:
        continue
    for i, c in enumerate(word):
        if i >= size - 2:
            continue
        c = c.lower()
        if c not in chars:
            continue
        chunk = word[i+1:i+3].lower()
        if hao.strings.count_alpha(chunk) != len(chunk):
            continue
        transitions[c].add(chunk)
NAIVE_NEG_CHAR_TRANSITION = {c: chars2 - followings for c, followings in transitions.items()}
"""
from . import logs, strings

LOGGER = logs.get_logger(__name__)

NAIVE_NEG_CHAR_TRANSITION = {
    'a': {
        'xj', 'wv', 'cj', 'fq', 'qt', 'gz', 'zq', 'jv', 'az', 'vm', 'jf', 'qc', 'kq', 'fj', 'qj', 'qs', 'tq', 'zp', 'qm', 'qk', 'gj',
        'ql', 'px', 'hx', 'jy', 'zc', 'ej', 'fp', 'xz', 'qn', 'jq', 'qg', 'qr', 'qd', 'vf', 'ao', 'zv', 'ax', 'tx', 'aq', 'yq', 'zj',
        'uo', 'vw', 'jg', 'yk', 'vq', 'oa', 'zk', 'xq', 'qy', 'qp', 'vz', 'hq', 'cx', 'xv', 'jx', 'qb', 'wj', 'vh', 'gx', 'qo', 'vj',
        'pv', 'mq', 'mj', 'fv', 'kj', 'qf', 'qz', 'kv', 'oq', 'pz', 'gq', 'wx', 'mx', 'js', 'vt', 'jt', 'sx', 'qh', 'jw', 'vx', 'zr',
        'qx', 'cz', 'fx', 'aj', 'cv', 'kg', 'zx', 'oj', 'gc', 'bq', 'qe', 'kx', 'qa', 'bx', 'yx', 'jc', 'xr', 'vp', 'vk', 'zb', 'dx',
        'jz'},
    'l': {
        'xk', 'jb', 'gb', 'bn', 'jk', 'lq', 'xj', 'xo', 'wv', 'sr', 'zg', 'nt', 'bv', 'cj', 'fq', 'qt', 'mk', 'gz', 'pc', 'ws', 'zq',
        'zn', 'hw', 'hj', 'wp', 'cm', 'nj', 'jv', 'hn', 'vm', 'nk', 'jf', 'hr', 'qc', 'tk', 'wl', 'kq', 'qi', 'zd', 'cg', 'bp', 'jl',
        'vg', 'fj', 'xs', 'qj', 'tq', 'qs', 'jd', 'zp', 'hz', 'qm', 'vn', 'qk', 'nb', 'gj', 'ql', 'rn', 'np', 'jz', 'hd', 'cn', 'px',
        'hx', 'mt', 'je', 'zc', 'bf', 'jy', 'wg', 'xa', 'wz', 'vc', 'hp', 'xz', 'rq', 'qn', 'vb', 'pk', 'mv', 'jq', 'xu', 'qg', 'rw',
        'qr', 'rj', 'wt', 'gn', 'qd', 'wd', 'gp', 'vf', 'rx', 'hs', 'mz', 'zv', 'jr', 'cp', 'pg', 'wq', 'gk', 'bm', 'gf', 'nw', 'sz',
        'nx', 'tv', 'xg', 'tx', 'xm', 'kp', 'xl', 'yq', 'zj', 'bw', 'rp', 'vw', 'jg', 'jn', 'rt', 'vq', 'jp', 'bd', 'hm', 'bk', 'zk',
        'hf', 'gw', 'xq', 'rh', 'bg', 'qy', 'lx', 'qp', 'vz', 'wk', 'hg', 'hq', 'cx', 'cb', 'bz', 'xv', 'cs', 'gm', 'rk', 'jx', 'qb',
        'wj', 'xf', 'rg', 'vh', 'zt', 'gx', 'qo', 'vj', 'pv', 'mq', 'mj', 'qw', 'wb', 'hk', 'gd', 'fv', 'bj', 'rz', 'rc', 'wf', 'qf',
        'qz', 'pz', 'ny', 'xd', 'xb', 'gq', 'wx', 'wc', 'js', 'jh', 'mx', 'dz', 'vt', 'jt', 'zw', 'fz', 'sx', 'qh', 'qv', 'jw', 'zl',
        'rm', 'yj', 'vx', 'kz', 'hl', 'gt', 'wm', 'tg', 'qx', 'cz', 'fx', 'hb', 'nf', 'xi', 'nv', 'xe', 'bc', 'cv', 'xc', 'dj', 'zx',
        'ht', 'vl', 'xn', 'gv', 'bh', 'xp', 'pd', 'zs', 'bq', 'wu', 'hc', 'sj', 'qe', 'vr', 'kx', 'cf', 'qa', 'hv', 'cd', 'xw', 'wn',
        'bx', 'pq', 'lz', 'xh', 'gs', 'jc', 'pj', 'cw', 'xr', 'rl', 'vp', 'rv', 'nq', 'rs', 'vk', 'rf', 'nz', 'cq', 'bt', 'dx',
        'xt'},
    'r': {
        'xk', 'jb', 'gb', 'jk', 'lq', 'xj', 'xo', 'wv', 'sr', 'zg', 'bv', 'cj', 'fq', 'qt', 'gz', 'pc', 'lr', 'zq', 'zn', 'hj', 'wp',
        'jv', 'nj', 'vm', 'hn', 'hr', 'jf', 'qc', 'wl', 'kq', 'qi', 'zd', 'bp', 'jl', 'vg', 'fj', 'xs', 'qj', 'qs', 'jd', 'zp', 'hz',
        'qm', 'vn', 'qk', 'gj', 'ql', 'jz', 'hd', 'px', 'hx', 'jy', 'zc', 'bf', 'wg', 'xa', 'wz', 'vc', 'xz', 'rq', 'qn', 'vb', 'pk',
        'jq', 'lv', 'xu', 'qg', 'qr', 'rj', 'wt', 'qd', 'wd', 'gp', 'vf', 'rx', 'mz', 'jr', 'zv', 'cp', 'pg', 'lj', 'wq', 'gf', 'sz',
        'nx', 'xg', 'tx', 'xm', 'xl', 'yq', 'uq', 'rb', 'zh', 'zj', 'rp', 'vw', 'jg', 'tj', 'jn', 'rt', 'vq', 'jp', 'bk', 'hf', 'xq',
        'bg', 'lx', 'qy', 'qp', 'vz', 'wk', 'hg', 'hq', 'cx', 'ln', 'cb', 'bz', 'xv', 'jx', 'qb', 'wj', 'xf', 'vh', 'gx', 'qo', 'vj',
        'pv', 'mq', 'mj', 'qw', 'wb', 'hk', 'bj', 'kj', 'rz', 'wf', 'rc', 'qf', 'qz', 'kv', 'pz', 'xd', 'gq', 'xb', 'vd', 'wx', 'wc',
        'js', 'jh', 'mx', 'dz', 'vt', 'jt', 'zw', 'fz', 'sx', 'qh', 'qv', 'jw', 'zl', 'yj', 'vx', 'kz', 'hl', 'gt', 'wm', 'qx', 'cz',
        'fx', 'hb', 'fk', 'nv', 'pf', 'xe', 'bc', 'cv', 'xc', 'dj', 'zx', 'xn', 'gv', 'xp', 'pd', 'zs', 'gc', 'bq', 'hc', 'sj', 'pb',
        'vs', 'qe', 'vr', 'kx', 'cf', 'qa', 'hv', 'cd', 'xw', 'wn', 'bx', 'pq', 'lz', 'xh', 'jc', 'pj', 'cw', 'xr', 'vp', 'nq', 'zm',
        'vk', 'rf', 'rd', 'cq', 'bt', 'jm', 'dx', 'xt'},
    'd': {
        'xk', 'gb', 'bn', 'xj', 'wv', 'yv', 'zg', 'fq', 'gz', 'nr', 'zn', 'hw', 'kh', 'qc', 'kq', 'cg', 'lc', 'jd', 'hz', 'nb', 'gj',
        'zf', 'sf', 'hd', 'zc', 'bf', 'fp', 'xz', 'nm', 'nc', 'ct', 'qg', 'qr', 'gn', 'kt', 'mz', 'zv', 'dq', 'pg', 'mr', 'yz', 'nw',
        'nx', 'tx', 'kp', 'yq', 'pn', 'qy', 'ku', 'pu', 'bz', 'sq', 'jx', 'qb', 'sg', 'wj', 'gx', 'mb', 'pv', 'qw', 'dv', 'bj', 'tu',
        'qz', 'dc', 'js', 'fz', 'vx', 'zr', 'pt', 'qx', 'ft', 'kg', 'xn', 'lf', 'wu', 'lw', 'qe', 'kx', 'tw', 'ng', 'qa', 'ci', 'wn',
        'ky', 'bx', 'uw', 'gs', 'xr', 'rl', 'zb', 'jm', 'mp', 'nh', 'dt', 'fm', 'lr', 'cm', 'hn', 'jf', 'bp', 'vg', 'fj', 'xs', 'mw',
        'qj', 'qs', 'tq', 'zp', 'qm', 'vn', 'ql', 'rn', 'xa', 'rq', 'vb', 'xu', 'cp', 'gf', 'tv', 'xg', 'vu', 'jg', 'lt', 'rt', 'vq',
        'rh', 'bg', 'lx', 'hq', 'rk', 'rg', 'vj', 'fc', 'xb', 'vt', 'fg', 'sx', 'cz', 'fx', 'fk', 'mn', 'pf', 'cv', 'vl', 'ms', 'kr',
        'xp', 'pd', 'hc', 'cf', 'cd', 'xw', 'tc', 'pj', 'fn', 'vp', 'rf', 'cq', 'bt', 'dx', 'xt', 'jb', 'jk', 'kf', 'lq', 'bv', 'cj',
        'qt', 'ck', 'zq', 'nj', 'py', 'nk', 'ls', 'tk', 'wl', 'qi', 'zd', 'jl', 'qk', 'np', 'cn', 'px', 'hx', 'mt', 'qn', 'pk', 'lv',
        'dk', 'rj', 'qd', 'vf', 'rx', 'fh', 'lj', 'wq', 'sz', 'xl', 'rb', 'lp', 'fd', 'zj', 'kc', 'jn', 'xy', 'jp', 'bd', 'hm', 'bk',
        'xq', 'qp', 'cx', 'ln', 'tp', 'xv', 'kd', 'vh', 'tz', 'zt', 'qo', 'wb', 'hk', 'lm', 'kj', 'rz', 'wf', 'mf', 'fb', 'ps', 'ny',
        'xd', 'wx', 'zw', 'zl', 'wm', 'fw', 'xe', 'xc', 'dj', 'bh', 'bs', 'bq', 'vy', 'sj', 'vs', 'vr', 'kl', 'pq', 'xh', 'jc', 'cw',
        'nq', 'lk', 'vk', 'jz', 'xo', 'mk', 'pc', 'dg', 'wp', 'tb', 'jv', 'vm', 'fy', 'tm', 'km', 'mc', 'uz', 'wg', 'wz', 'pm', 'vc',
        'jq', 'md', 'wt', 'wd', 'gp', 'jr', 'bm', 'xm', 'zh', 'kw', 'bw', 'rp', 'vw', 'dw', 'tj', 'zk', 'hf', 'vz', 'nl', 'wk', 'lh',
        'hg', 'cb', 'cs', 'xf', 'mq', 'mj', 'gd', 'fv', 'rc', 'qf', 'kv', 'pz', 'ty', 'gq', 'wc', 'jh', 'dz', 'jt', 'qh', 'qv', 'jw',
        'rm', 'yj', 'kz', 'hl', 'gt', 'tg', 'hb', 'nf', 'xi', 'nv', 'mh', 'zx', 'tn', 'gv', 'zs', 'gc', 'pb', 'yx', 'lz', 'lb', 'ml',
        'my', 'ks', 'nz', 'zm', 'kb'},
    'v': {
        'xk', 'gb', 'bn', 'xj', 'wv', 'yv', 'zg', 'fq', 'gz', 'nr', 'sm', 'zn', 'hw', 'qc', 'kq', 'cg', 'lc', 'sw', 'jd', 'hz', 'bl',
        'nb', 'gj', 'zf', 'ma', 'sf', 'hd', 'ko', 'je', 'zc', 'bf', 'fp', 'xz', 'nm', 'ld', 'nc', 'ct', 'qg', 'qr', 'gn', 'dn', 'kt',
        'ry', 'hs', 'mz', 'zv', 'dq', 'ha', 'pg', 'mr', 'yz', 'nw', 'nx', 'uk', 'tx', 'kp', 'yq', 'iw', 'gw', 'sa', 'qy', 'ku', 'pu',
        'bz', 'da', 'ye', 'dl', 'gm', 'sq', 'jx', 'qb', 'sg', 'wj', 'gx', 'mb', 'pv', 'qw', 'dv', 'bj', 'gr', 'tu', 'qz', 'tl', 'dc',
        'fo', 'pw', 'js', 'ja', 'fi', 'ym', 'fz', 'we', 'fu', 'uj', 'vx', 'zr', 'nd', 'pt', 'qx', 'ft', 'bc', 'kg', 'oj', 'xn', 'lf',
        'ta', 'wu', 'ga', 'lw', 'qe', 'kx', 'tw', 'yp', 'ng', 'qa', 'pe', 'wn', 'pa', 'ky', 'bx', 'uw', 'ru', 'gs', 'xr', 'rl', 'rd',
        'ka', 'zb', 'jm', 'mo', 'mp', 'so', 'nh', 'dt', 'sr', 'nt', 'gu', 'fm', 'lr', 'go', 'cm', 'hn', 'df', 'jf', 'dp', 'bp', 'vg',
        'fj', 'xs', 'mw', 'qj', 'qs', 'uy', 'tq', 'gi', 'zp', 'zi', 'qm', 'vn', 'de', 'ql', 'rn', 'jy', 'no', 'xa', 'fe', 'mu', 'rq',
        'vb', 'mv', 'xu', 'cp', 'ze', 'gk', 'gf', 'tv', 'xg', 'uq', 'vu', 'tf', 'jg', 'lt', 'rt', 'vq', 'hi', 'rh', 'bg', 'lx', 'fr',
        'hq', 'rk', 'bi', 'rg', 'vo', 'vj', 'af', 'po', 'ys', 'wy', 'fc', 'uc', 'xb', 'ph', 'vt', 'me', 'fg', 'sx', 'sn', 'su', 'he',
        'cz', 'fx', 'wr', 'fk', 'mn', 'pf', 'mi', 'cv', 'ht', 'ms', 'nu', 'tr', 'kr', 'sc', 'xp', 'pd', 'sl', 'hc', 'yt', 'co', 'se',
        'cf', 'cd', 'xw', 'tc', 'pj', 'fn', 'vp', 'rv', 'rf', 'cq', 'bt', 'ju', 'th', 'dx', 'xt', 'jb', 'sv', 'mg', 'hy', 'jk', 'kf',
        'lq', 'up', 'bv', 'cj', 'yo', 'qt', 'ck', 'zq', 'hj', 'nj', 'py', 'nk', 'pi', 'ls', 'tk', 'wl', 'qi', 'zd', 'jl', 'du', 'hu',
        'db', 'qk', 'np', 'cn', 'px', 'hx', 'mt', 'ti', 'ua', 'sp', 'qn', 'pk', 'lv', 'rw', 'dk', 'rj', 'gy', 'qd', 'vf', 'rx', 'fh',
        'yd', 'sd', 'lj', 'wq', 'dy', 'xl', 'lp', 'fd', 'jo', 'zj', 'kc', 'yk', 'jn', 'sy', 'xy', 'jp', 'bd', 'hm', 'bk', 'by', 'xq',
        'fl', 'qp', 'dm', 'uv', 'cx', 'ln', 'tp', 'xv', 'kd', 'za', 'vh', 'tz', 'zt', 'qo', 'ux', 'wb', 'hk', 'lm', 'kj', 'rz', 'wf',
        'mf', 'fb', 'ps', 'ny', 'xd', 'ce', 'fa', 'wx', 'zw', 'zl', 'pr', 'wm', 'yr', 'yc', 'ki', 'fw', 'xe', 'xc', 'dj', 'bh', 'bq',
        'zy', 'sj', 'vs', 'vr', 'ns', 'kl', 'pq', 'xh', 'yg', 'jc', 'cw', 'nq', 'lk', 'rs', 'vk', 'jz', 'wh', 'br', 'cl', 'xo', 'mk',
        'ji', 'pc', 'dg', 'ws', 'wp', 'tb', 'jv', 'vm', 'fy', 'hr', 'tm', 'km', 'va', 'mc', 'uz', 'cy', 'wg', 'wz', 'pm', 'vc', 'hp',
        'jq', 'md', 'wt', 'oh', 'wo', 'wd', 'jr', 'ca', 'cu', 'dh', 'bm', 'xm', 'zh', 'kw', 'bw', 'rp', 'uo', 'vw', 'dw', 'tj', 'ts',
        'zk', 'hf', 'uf', 'vz', 'nl', 'wk', 'lh', 'hg', 'cb', 'cs', 'lg', 'oz', 'xf', 'st', 'mq', 'lu', 'mj', 'qu', 'gd', 'fv', 'rc',
        'qf', 'kv', 'td', 'pz', 'ty', 'gq', 'vd', 'wc', 'jh', 'mx', 'dz', 'ge', 'jt', 'ke', 'qh', 'qv', 'jw', 'ho', 'rm', 'yj', 'kz',
        'hl', 'gt', 'tg', 'hb', 'nf', 'xi', 'nv', 'mh', 'zx', 'tn', 'gv', 'kn', 'zs', 'gc', 'pb', 'hv', 'wi', 'yx', 'dr', 'wa', 'lz',
        'lb', 'gl', 'ml', 'my', 'ks', 'nz', 'zm', 'te', 'kb'},
    'w': {
        'xk', 'gb', 'bn', 'xj', 'wv', 'zg', 'fq', 'gz', 'zn', 'hw', 'qc', 'kq', 'cg', 'lc', 'jd', 'hz', 'gj', 'zf', 'hd', 'ko', 'je',
        'zc', 'bf', 'fp', 'xz', 'ct', 'qg', 'qr', 'gn', 'kt', 'zv', 'dq', 'pg', 'mr', 'yz', 'nx', 'uk', 'tx', 'kp', 'yq', 'pn', 'gw',
        'qy', 'ku', 'bz', 'gm', 'sq', 'jx', 'qb', 'wj', 'gx', 'mb', 'pv', 'qw', 'dv', 'bj', 'qz', 'tl', 'dc', 'pw', 'js', 'ja', 'fz',
        'uj', 'vx', 'zr', 'pt', 'qx', 'ft', 'bc', 'ih', 'kg', 'oj', 'xn', 'wu', 'qe', 'kx', 'qa', 'wn', 'bx', 'eu', 'uw', 'gs', 'xr',
        'rd', 'zb', 'jm', 've', 'dt', 'fm', 'cm', 'df', 'jf', 'dp', 'bp', 'vg', 'fj', 'xs', 'mw', 'qj', 'qs', 'uy', 'tq', 'yf', 'zp',
        'qm', 'vn', 'ql', 'rn', 'jy', 'xa', 'mu', 'rq', 'vb', 'xu', 'cp', 'gk', 'gf', 'xg', 'aq', 'uq', 'vu', 'tf', 'jg', 'vq', 'rh',
        'bg', 'lx', 'hq', 'rk', 'rg', 'vo', 'vj', 'wy', 'fc', 'xb', 'vt', 'fg', 'cz', 'fx', 'fk', 'mn', 'pf', 'cv', 'ht', 'vl', 'ms',
        'xp', 'pd', 'hc', 'yt', 'cf', 'cd', 'xw', 'pj', 'fn', 'vp', 'rv', 'rf', 'cq', 'bt', 'ju', 'dx', 'xt', 'jb', 'sv', 'mg', 'jk',
        'kf', 'lq', 'bv', 'cj', 'qt', 'ck', 'zq', 'hj', 'nj', 'nk', 'tk', 'wl', 'qi', 'zd', 'jl', 'db', 'qk', 'zo', 'cn', 'px', 'hx',
        'mt', 'ua', 'ij', 'qn', 'pk', 'lv', 'rw', 'dk', 'rj', 'ue', 'gy', 'qd', 'iq', 'vf', 'rx', 'fh', 'sd', 'lj', 'wq', 'xl', 'rb',
        'fd', 'zj', 'kc', 'jn', 'xy', 'jp', 'bd', 'hm', 'bk', 'xq', 'qp', 'dm', 'io', 'uv', 'cx', 'tp', 'xv', 'kd', 'za', 'vh', 'tz',
        'zt', 'qo', 'ux', 'yi', 'wb', 'hk', 'kj', 'rz', 'wf', 'mf', 'fb', 'ps', 'oq', 'xd', 'wx', 'zw', 'wm', 'fw', 'xe', 'xc', 'dj',
        'bh', 'iu', 'bs', 'bq', 'vy', 'sj', 'vs', 'vr', 'pq', 'xh', 'jc', 'cw', 'nq', 'lk', 'rs', 'vk', 'yw', 'jz', 'xo', 'mk', 'ji',
        'pc', 'dg', 'ws', 'wp', 'tb', 'jv', 'vm', 'fy', 'tm', 'km', 'va', 'mc', 'cy', 'wg', 'wz', 'pm', 'vc', 'hp', 'yu', 'jq', 'md',
        'wt', 'wd', 'gp', 'jr', 'dh', 'bm', 'xm', 'zh', 'rp', 'uo', 'vw', 'tj', 'ox', 'zk', 'hf', 'uf', 'vz', 'wk', 'hg', 'cb', 'cs',
        'xf', 'mq', 'mj', 'gd', 'fv', 'rc', 'qf', 'kv', 'td', 'pz', 'gq', 'vd', 'wc', 'jh', 'mx', 'dz', 'jt', 'qh', 'qv', 'jw', 'rm',
        'yj', 'kz', 'hl', 'gt', 'tg', 'hb', 'eo', 'zu', 'eq', 'xi', 'nv', 'mh', 'zx', 'tn', 'gv', 'zs', 'gc', 'pb', 'hv', 'ub', 'fs',
        'yx', 'lz', 'ml', 'my', 'nz', 'zm'},
    'o': {
        'jb', 'jk', 'xj', 'yv', 'cj', 'fq', 'qt', 'gz', 'zq', 'zn', 'hw', 'hj', 'jv', 'vm', 'jf', 'qc', 'kq', 'qi', 'cg', 'jl', 'vg',
        'fj', 'qj', 'qs', 'jd', 'zp', 'hz', 'qm', 'qk', 'gj', 'ql', 'zf', 'sf', 'px', 'hx', 'jy', 'ej', 'xz', 'qn', 'iy', 'vb', 'jq',
        'qg', 'qr', 'qd', 'iq', 'vf', 'fh', 'hs', 'mz', 'zv', 'jr', 'dq', 'cp', 'lj', 'yz', 'gk', 'tv', 'tx', 'yq', 'zj', 'vw', 'jg',
        'yk', 'jn', 'vq', 'iw', 'zk', 'hf', 'xq', 'qy', 'qp', 'vz', 'hg', 'hq', 'cx', 'cb', 'bz', 'jx', 'qb', 'vh', 'zt', 'gx', 'qo',
        'vj', 'mq', 'qw', 'ay', 'hk', 'dv', 'fv', 'kj', 'qf', 'qz', 'fc', 'kv', 'oq', 'pz', 'gq', 'wx', 'jh', 'js', 'mx', 'vt', 'jt',
        'fg', 'fz', 'qh', 'qv', 'jw', 'yj', 'vx', 'kz', 'qx', 'fx', 'hb', 'fk', 'ih', 'cv', 'kg', 'ht', 'vl', 'zx', 'iu', 'zs', 'bq',
        'hc', 'qe', 'kx', 'cf', 'qa', 'hv', 'cd', 'bx', 'yx', 'pq', 'jc', 'cw', 'vp', 'zm', 'jm', 'dx', 'jz'},
    'n': {
        'xk', 'jb', 'mg', 'bn', 'mp', 'jk', 'lq', 'xj', 'xo', 'wv', 'bv', 'zg', 'cj', 'mk', 'fq', 'qt', 'gz', 'pc', 'fm', 'nr', 'zq',
        'zn', 'hj', 'ws', 'wp', 'nj', 'jv', 'vm', 'hn', 'fy', 'hr', 'jf', 'qc', 'ls', 'wl', 'kq', 'qi', 'cg', 'bp', 'jl', 'lc', 'vg',
        'fj', 'qj', 'mw', 'qs', 'tq', 'mc', 'jd', 'qm', 'hz', 'vn', 'qk', 'nb', 'ql', 'zf', 'rn', 'np', 'hd', 'cn', 'px', 'hx', 'mt',
        'zc', 'bf', 'wg', 'xa', 'wz', 'pm', 'fp', 'vc', 'hp', 'xz', 'rq', 'qn', 'nm', 'ld', 'vb', 'pk', 'mv', 'lv', 'jq', 'xu', 'qg',
        'rw', 'qr', 'rj', 'md', 'wt', 'qd', 'wd', 'vf', 'rx', 'fh', 'hs', 'mz', 'zv', 'pg', 'lj', 'wq', 'yz', 'bm', 'sz', 'nx', 'xg',
        'tx', 'lp', 'yq', 'rb', 'fd', 'zj', 'bw', 'rp', 'vw', 'jg', 'lt', 'yk', 'jn', 'xy', 'rt', 'vq', 'jp', 'bd', 'hm', 'bk', 'zk',
        'hf', 'xq', 'bg', 'qy', 'lx', 'qp', 'vz', 'wk', 'lh', 'hg', 'hq', 'cx', 'ln', 'cb', 'bz', 'xv', 'lg', 'rk', 'jx', 'qb', 'wj',
        'xf', 'rg', 'vh', 'gx', 'mb', 'vj', 'pv', 'qo', 'mq', 'qw', 'mj', 'wb', 'hk', 'lm', 'fv', 'bj', 'kj', 'rz', 'wf', 'rc', 'qf',
        'mf', 'wy', 'fb', 'qz', 'fc', 'pz', 'xd', 'gq', 'xb', 'vd', 'wx', 'wc', 'pw', 'js', 'jh', 'mx', 'vt', 'jt', 'fg', 'fz', 'qh',
        'qv', 'jw', 'zl', 'uj', 'rm', 'yj', 'vx', 'kz', 'zr', 'hl', 'nd', 'wm', 'qx', 'fx', 'hb', 'ft', 'fw', 'fk', 'nv', 'mh', 'xc',
        'cv', 'zx', 'ht', 'vl', 'xn', 'bh', 'pd', 'lf', 'bq', 'wu', 'hc', 'lw', 'pb', 'vs', 'qe', 'vr', 'kx', 'cf', 'qa', 'hv', 'cd',
        'wn', 'bx', 'pq', 'lz', 'uw', 'xh', 'lb', 'jc', 'ml', 'pj', 'fn', 'vp', 'rv', 'cw', 'nq', 'lk', 'rs', 'vk', 'rf', 'nz', 'zm',
        'rd', 'cq', 'bt', 'jm', 'dx', 'jz'},
    'i': {
        'xk', 'kf', 'xj', 'wv', 'yv', 'bv', 'cj', 'fq', 'qt', 'fm', 'ws', 'zq', 'zn', 'hw', 'hj', 'wp', 'jv', 'vm', 'jf', 'qc', 'km',
        'wl', 'kq', 'uh', 'qi', 'cg', 'vg', 'fj', 'qj', 'qs', 'uy', 'tq', 'yl', 'uz', 'jd', 'yf', 'hz', 'qm', 'qk', 'gj', 'zf', 'px',
        'hx', 'jy', 'bf', 'wg', 'wz', 'fp', 'vc', 'hp', 'xz', 'qn', 'iy', 'vb', 'mv', 'jq', 'qg', 'rj', 'wt', 'ug', 'qd', 'wd', 'iq',
        'vf', 'rx', 'fh', 'mz', 'yd', 'jr', 'dq', 'ir', 'lj', 'wq', 'yz', 'gk', 'tx', 'kp', 'yq', 'uq', 'zh', 'zj', 'uo', 'kc', 'jg',
        'vw', 'yk', 'jn', 'yh', 'vq', 'jp', 'zk', 'ie', 'xq', 'uf', 'lx', 'qy', 'qp', 'wk', 'hg', 'hq', 'cx', 'bz', 'xv', 'ui', 'ix',
        'yb', 'jx', 'qb', 'wj', 'vh', 'gx', 'qo', 'vj', 'pv', 'mq', 'ux', 'qw', 'ay', 'wb', 'hk', 'fv', 'kj', 'wf', 'qf', 'ys', 'fb',
        'qz', 'fc', 'pz', 'xd', 'gq', 'vd', 'wx', 'jh', 'js', 'mx', 'dz', 'vt', 'jt', 'zw', 'ym', 'fz', 'sx', 'qh', 'qv', 'jw', 'uj',
        'yj', 'vx', 'kz', 'ib', 'wm', 'qx', 'fx', 'wr', 'yr', 'yc', 'hb', 'eo', 'fk', 'xc', 'cv', 'kg', 'zx', 'oy', 'gv', 'iu', 'zs',
        'gc', 'bq', 'wu', 'hc', 'yt', 'qe', 'kx', 'yp', 'hv', 'wn', 'yx', 'pq', 'uw', 'yg', 'jc', 'xr', 'vp', 'vk', 'yw', 'iz', 'kb',
        'zb', 'dx', 'jz'},
    'c': {
        'xk', 'gb', 'bn', 'xj', 'wv', 'yv', 'zg', 'fq', 'gz', 'nr', 'sm', 'zn', 'qc', 'uh', 'cg', 'lc', 'sw', 'jd', 'nb', 'gj', 'zf',
        'je', 'zc', 'bf', 'fp', 'xz', 'iy', 'nm', 'ld', 'nc', 'qg', 'qr', 'gn', 'dn', 'mz', 'zv', 'dq', 'pg', 'mr', 'nw', 'nx', 'tx',
        'yq', 'pn', 'gw', 'qy', 'bz', 'dl', 'gm', 'sq', 'jx', 'qb', 'sg', 'vi', 'wj', 'gx', 'mb', 'pv', 'qw', 'dv', 'bj', 'qz', 'fo',
        'pw', 'ja', 'fi', 'fz', 'vx', 'zr', 'nd', 'pt', 'qx', 'ft', 'bc', 'ih', 'xn', 'lf', 'wu', 'ga', 'lw', 'qe', 'kx', 'ng', 'qa',
        'pe', 'wn', 'bx', 'uw', 'gs', 'xr', 'rl', 'zb', 'jm', 've', 'nh', 'ex', 'dt', 'sr', 'nt', 'gu', 'lr', 'cm', 'df', 'jf', 'dp',
        'bp', 'vg', 'fj', 'xs', 'mw', 'qj', 'qs', 'tq', 'yf', 'zp', 'zi', 'vn', 'qm', 'ql', 'rn', 'jy', 'xa', 'rq', 'vb', 'mv', 'xu',
        'cp', 'gk', 'gf', 'pl', 'xg', 'uq', 'vu', 'jg', 'lt', 'vq', 'rh', 'lx', 'fr', 'hq', 'rk', 'bi', 'rg', 'vo', 'vj', 'po', 'wy',
        'fc', 'xb', 'vt', 'fg', 'sx', 'sn', 'cz', 'fx', 'wr', 'fk', 'pf', 'cv', 'vl', 'ms', 'nu', 'sc', 'xp', 'pd', 'se', 'cf', 'cd',
        'xw', 'pj', 'fn', 'vp', 'rv', 'rf', 'cq', 'bt', 'ju', 'dx', 'xt', 'jb', 'mg', 'jk', 'lq', 'bv', 'cj', 'qt', 'zq', 'nj', 'py',
        'nk', 'ls', 'tk', 'wl', 'qi', 'zd', 'jl', 'db', 'qk', 'np', 'zo', 'cn', 'px', 'hx', 'mt', 'sp', 'qn', 'pk', 'lv', 'rw', 'dk',
        'rj', 'gy', 'qd', 'vf', 'rx', 'fh', 'sd', 'lj', 'wq', 'sz', 'xl', 'rb', 'lp', 'fd', 'jo', 'zj', 'jn', 'xy', 'jp', 'bd', 'bk',
        'by', 'xq', 'qp', 'dm', 'cx', 'ln', 'xv', 'vh', 'tz', 'zt', 'sk', 'qo', 'ux', 'wb', 'lm', 'rz', 'wf', 'mf', 'fb', 'ny', 'xd',
        'wx', 'zw', 'zl', 'fw', 'xe', 'xc', 'dj', 'sb', 'bh', 'bq', 'vy', 'sj', 'vr', 'ns', 'pq', 'xh', 'jc', 'cw', 'nq', 'vk', 'jz',
        'xo', 'mk', 'ji', 'pc', 'dg', 'ws', 'wp', 'tb', 'jv', 'vm', 'fy', 'va', 'mc', 'wg', 'ej', 'wz', 'pm', 'vc', 'yu', 'jq', 'wd',
        'gp', 'jr', 'dh', 'xm', 'zh', 'bw', 'rp', 'vw', 'dw', 'tj', 'zk', 'vz', 'nl', 'wk', 'cb', 'cs', 'lg', 'ik', 'xf', 'mq', 'mj',
        'gd', 'fv', 'rc', 'qf', 'di', 'pz', 'gq', 'vd', 'wc', 'jh', 'mx', 'dz', 'jt', 'qh', 'qv', 'jw', 'rm', 'yj', 'kz', 'gt', 'tg',
        'nf', 'zu', 'xi', 'nv', 'mh', 'zx', 'gv', 'zs', 'gc', 'pb', 'fs', 'lz', 'lb', 'ml', 'nz', 'zm'},
    't': {
        'xk', 'jb', 'gb', 'bn', 'mg', 'jk', 'kf', 'lq', 'xj', 'nh', 'xo', 'dt', 'wv', 'yv', 'bv', 'cj', 'mk', 'fq', 'qt', 'gz', 'dg',
        'fm', 'nr', 'lr', 'kh', 'zq', 'hj', 'ws', 'cm', 'nj', 'wp', 'df', 'jv', 'nk', 'jf', 'vm', 'qc', 'fy', 'dp', 'ls', 'km', 'tk',
        'wl', 'kq', 'qi', 'zd', 'cg', 'bp', 'jl', 'vg', 'fj', 'xs', 'mw', 'qj', 'qs', 'tq', 'mc', 'jd', 'db', 'zp', 'hz', 'qm', 'vn',
        'qk', 'nb', 'gj', 'ql', 'zf', 'rn', 'np', 'cn', 'px', 'hx', 'mt', 'jy', 'bf', 'wg', 'xa', 'wz', 'pm', 'fp', 'vc', 'xz', 'rq',
        'qn', 'nm', 'vb', 'pk', 'mv', 'nc', 'lv', 'jq', 'ct', 'qg', 'rw', 'dk', 'qr', 'rj', 'md', 'wt', 'gy', 'qd', 'wd', 'dn', 'gp',
        'vf', 'kt', 'rx', 'fh', 'mz', 'jr', 'dq', 'dh', 'pg', 'lj', 'mr', 'yz', 'gk', 'wq', 'bm', 'gf', 'nw', 'sz', 'nx', 'xg', 'tx',
        'xm', 'kp', 'xl', 'rb', 'lp', 'kw', 'fd', 'zj', 'bw', 'rp', 'kc', 'jg', 'lt', 'vw', 'jn', 'tj', 'rt', 'vq', 'jp', 'bd', 'bk',
        'gw', 'xq', 'bg', 'qy', 'qp', 'dm', 'vz', 'nl', 'uv', 'wk', 'lh', 'cx', 'cb', 'ln', 'bz', 'xv', 'cs', 'kd', 'sq', 'lg', 'rk',
        'jx', 'qb', 'sg', 'wj', 'xf', 'rg', 'vh', 'zt', 'gx', 'mb', 'vj', 'pv', 'qo', 'mq', 'qw', 'mj', 'wb', 'dv', 'gd', 'fv', 'bj',
        'kj', 'rc', 'wf', 'qf', 'mf', 'fb', 'qz', 'fc', 'kv', 'pz', 'ny', 'xd', 'xb', 'gq', 'wx', 'vd', 'pw', 'js', 'wc', 'jh', 'mx',
        'vt', 'dz', 'jt', 'fg', 'zw', 'fz', 'sx', 'qh', 'qv', 'jw', 'uj', 'rm', 'yj', 'vx', 'kz', 'gt', 'nd', 'wm', 'pt', 'qx', 'fx',
        'nf', 'ft', 'xi', 'fw', 'fk', 'mn', 'pf', 'nv', 'xe', 'bc', 'cv', 'xc', 'mh', 'dj', 'kg', 'zx', 'vl', 'xn', 'ms', 'gv', 'bh',
        'kr', 'gh', 'xp', 'lf', 'bs', 'gc', 'bq', 'lw', 'pb', 'qe', 'vr', 'kx', 'cf', 'kl', 'ng', 'qa', 'cd', 'xw', 'wn', 'ky', 'bx',
        'fs', 'tc', 'pq', 'lz', 'xh', 'lb', 'gs', 'jc', 'pj', 'fn', 'xr', 'vp', 'rv', 'cw', 'nq', 'lk', 'vk', 'rf', 'nz', 'rd', 'cq',
        'bt', 'kb', 'jm', 'dx', 'jz'},
    'b': {
        'xk', 'bn', 'xj', 'wv', 'yv', 'zg', 'fq', 'gz', 'nr', 'zn', 'hw', 'qc', 'kq', 'cg', 'sw', 'hz', 'nb', 'gj', 'zf', 'hd', 'zc',
        'ds', 'bf', 'fp', 'xz', 'nm', 'nc', 'qg', 'qr', 'gn', 'kt', 'hs', 'mz', 'zv', 'dq', 'pg', 'mr', 'nw', 'nx', 'tx', 'kp', 'yq',
        'pn', 'qy', 'ku', 'bz', 'dl', 'gm', 'jx', 'qb', 'sg', 'wj', 'gx', 'mb', 'pv', 'qw', 'dv', 'bj', 'qz', 'dc', 'pw', 'js', 'fz',
        'vx', 'zr', 'nd', 'pt', 'qx', 'ft', 'kg', 'xn', 'lf', 'wu', 'lw', 'qe', 'kx', 'ng', 'qa', 'wn', 'ky', 'bx', 'uw', 'xr', 'rl',
        'rd', 'zb', 'jm', 'nh', 'dt', 'sr', 'nt', 'fm', 'lr', 'cm', 'hn', 'df', 'jf', 'dp', 'bp', 'vg', 'fj', 'xs', 'qj', 'tq', 'zp',
        'qm', 'vn', 'ql', 'rn', 'jy', 'xa', 'rq', 'vb', 'mv', 'xu', 'cp', 'ze', 'gf', 'tv', 'xg', 'uq', 'vu', 'jg', 'rt', 'vq', 'bg',
        'lx', 'hq', 'rk', 'rg', 'vj', 'wy', 'fc', 'xb', 'vt', 'fg', 'sx', 'cz', 'fx', 'fk', 'mn', 'pf', 'cv', 'ht', 'vl', 'kr', 'gh',
        'pd', 'hc', 'cf', 'xw', 'tc', 'pj', 'fn', 'vp', 'rv', 'rf', 'cq', 'bt', 'dx', 'xt', 'jb', 'mg', 'jk', 'kf', 'lq', 'bv', 'cj',
        'qt', 'ck', 'zq', 'hj', 'nj', 'ls', 'tk', 'wl', 'qi', 'zd', 'jl', 'db', 'qk', 'np', 'cn', 'px', 'hx', 'qn', 'pk', 'dk', 'rj',
        'qd', 'vf', 'rx', 'fh', 'lj', 'wq', 'sz', 'dy', 'xl', 'rb', 'lp', 'fd', 'zj', 'kc', 'yk', 'jn', 'xy', 'jp', 'hm', 'bk', 'xq',
        'qp', 'dm', 'uv', 'cx', 'tp', 'xv', 'kd', 'za', 'vh', 'tz', 'zt', 'qo', 'wb', 'hk', 'lm', 'kj', 'rz', 'wf', 'mf', 'fb', 'ps',
        'ny', 'xd', 'wx', 'zw', 'zl', 'wm', 'fw', 'xe', 'xc', 'dj', 'bh', 'vy', 'sj', 'vs', 'vr', 'kl', 'pq', 'xh', 'jc', 'cw', 'nq',
        'lk', 'rs', 'vk', 'jz', 'xo', 'mk', 'pc', 'dg', 'ws', 'wp', 'tb', 'jv', 'vm', 'fy', 'km', 'mc', 'wg', 'wz', 'pm', 'vc', 'hp',
        'jq', 'md', 'wt', 'wd', 'jr', 'dh', 'xm', 'zh', 'kw', 'bw', 'rp', 'vw', 'dw', 'tj', 'zk', 'hf', 'vz', 'nl', 'wk', 'lh', 'lg',
        'xf', 'mq', 'mj', 'gd', 'fv', 'rc', 'qf', 'kv', 'td', 'pz', 'gq', 'vd', 'wc', 'jh', 'dz', 'jt', 'qh', 'qv', 'jw', 'rm', 'yj',
        'kz', 'hl', 'gt', 'tg', 'hb', 'nf', 'zu', 'xi', 'nv', 'zx', 'tn', 'gv', 'kn', 'zs', 'gc', 'pb', 'hv', 'fs', 'lz', 'lb', 'ml',
        'ks', 'nz', 'zm', 'kb'},
    's': {
        'xk', 'jb', 'mg', 'bn', 'jk', 'lq', 'xj', 'nh', 'xo', 'dt', 'wv', 'yv', 'zg', 'bv', 'cj', 'mk', 'fq', 'qt', 'gz', 'ck', 'dg',
        'fm', 'nr', 'lr', 'zn', 'zq', 'hj', 'ws', 'cm', 'nj', 'wp', 'df', 'jv', 'nk', 'jf', 'vm', 'qc', 'dp', 'ls', 'tk', 'wl', 'kq',
        'qi', 'zd', 'cg', 'bp', 'jl', 'lc', 'fj', 'xs', 'mw', 'qj', 'qs', 'tq', 'mc', 'jd', 'db', 'zp', 'hz', 'qm', 'vn', 'qk', 'gj',
        'ql', 'zf', 'rn', 'jz', 'mt', 'hx', 'jy', 'zc', 'ds', 'bf', 'wg', 'xa', 'wz', 'pm', 'fp', 'xz', 'rq', 'qn', 'nm', 'ld', 'vb',
        'pk', 'mv', 'nc', 'lv', 'jq', 'ct', 'qg', 'rw', 'qr', 'rj', 'wt', 'gy', 'qd', 'wd', 'gp', 'vf', 'rx', 'fh', 'mz', 'jr', 'zv',
        'dq', 'dh', 'cp', 'pg', 'lj', 'wq', 'gk', 'bm', 'gf', 'nw', 'sz', 'nx', 'dy', 'xg', 'xm', 'xl', 'yq', 'rb', 'lp', 'zh', 'fd',
        'zj', 'bw', 'rp', 'kc', 'jg', 'lt', 'vw', 'jn', 'dw', 'xy', 'rt', 'vq', 'bd', 'bk', 'gw', 'xq', 'bg', 'qy', 'lx', 'qp', 'dm',
        'vz', 'nl', 'wk', 'lh', 'cx', 'cb', 'ln', 'bz', 'xv', 'dl', 'gm', 'kd', 'lg', 'rk', 'jx', 'qb', 'wj', 'xf', 'rg', 'vh', 'gx',
        'mb', 'vj', 'pv', 'qo', 'mq', 'qw', 'mj', 'wb', 'lm', 'dv', 'gd', 'fv', 'bj', 'rz', 'qf', 'mf', 'wy', 'fb', 'qz', 'fc', 'kv',
        'dc', 'pz', 'xd', 'gq', 'xb', 'vd', 'wx', 'jh', 'pw', 'mx', 'dz', 'vt', 'jt', 'fg', 'zw', 'fz', 'sx', 'qh', 'qv', 'jw', 'rm',
        'yj', 'vx', 'kz', 'zr', 'gt', 'nd', 'qx', 'cz', 'fx', 'nf', 'zu', 'ft', 'xi', 'fw', 'fk', 'nv', 'xe', 'xc', 'cv', 'dj', 'kg',
        'zx', 'vl', 'xn', 'gv', 'bh', 'pd', 'zs', 'lf', 'bs', 'gc', 'bq', 'vy', 'lw', 'vs', 'qe', 'vr', 'kx', 'cf', 'ns', 'ng', 'qa',
        'cd', 'xw', 'wn', 'bx', 'fs', 'yx', 'pq', 'lz', 'xh', 'lb', 'gs', 'jc', 'pj', 'fn', 'vp', 'rl', 'rv', 'cw', 'nq', 'lk', 'vk',
        'rf', 'nz', 'zm', 'rd', 'cq', 'bt', 'zb', 'jm', 'dx', 'xt'},
    'u': {
        'xk', 'jb', 'wh', 'jk', 'kf', 'xj', 'wv', 'zg', 'cj', 'fq', 'qt', 'fm', 'ws', 'zq', 'zn', 'hw', 'hj', 'wp', 'cm', 'jv', 'vm',
        'jf', 'qc', 'km', 'wl', 'kq', 'qi', 'zd', 'cg', 'jl', 'vg', 'fj', 'qj', 'qs', 'uy', 'uz', 'yf', 'hz', 'zp', 'vn', 'qm', 'qk',
        'gj', 'oe', 'ql', 'zf', 'ek', 'hd', 'hx', 'wg', 'ua', 'wz', 'fp', 'vc', 'hp', 'xz', 'qn', 'iy', 'vb', 'jq', 'qg', 'qr', 'wt',
        'ue', 'qd', 'wd', 'vf', 'rx', 'fh', 'dq', 'cp', 'lj', 'wq', 'yz', 'gk', 'uk', 'xg', 'tx', 'yq', 'uq', 'kw', 'fd', 'zj', 'uo',
        'vw', 'jg', 'jn', 'yh', 'ox', 'vq', 'iw', 'jp', 'zk', 'hf', 'xq', 'uf', 'lx', 'qy', 'qp', 'vz', 'wk', 'hg', 'hq', 'cx', 'xv',
        'ui', 'of', 'yb', 'jx', 'qb', 'wj', 'xf', 'vh', 'zt', 'gx', 'qo', 'vj', 'ux', 'qw', 'hk', 'dv', 'fv', 'kj', 'wf', 'qf', 'wy',
        'qz', 'fc', 'kv', 'oq', 'pz', 'xd', 'gq', 'vd', 'wx', 'wc', 'js', 'jh', 'mx', 'vt', 'fg', 'ym', 'fz', 'sx', 'zw', 'qh', 'qv',
        'jw', 'uj', 'yj', 'vx', 'kz', 'zr', 'wm', 'qx', 'cz', 'fx', 'wr', 'yr', 'yc', 'hb', 'eq', 'fw', 'fk', 'xc', 'cv', 'dj', 'kg',
        'zx', 'oj', 'xn', 'vl', 'gv', 'xp', 'kn', 'zs', 'gc', 'wu', 'hc', 'sj', 'vs', 'qe', 'kx', 'cf', 'yp', 'qa', 'hv', 'ub', 'wn',
        'bx', 'yx', 'uw', 'jc', 'cw', 'vp', 'vk', 'cq', 'yw', 'jm', 'dx', 'jz'},
    'e': {
        'xk', 'jb', 'bn', 'jk', 'lq', 'xj', 'wv', 'bv', 'cj', 'qt', 'gz', 'zq', 'hj', 'jv', 'vm', 'jf', 'qc', 'kq', 'qi', 'jl', 'vg',
        'fj', 'qj', 'qs', 'uy', 'tq', 'qm', 'hz', 'qk', 'gj', 'ql', 'zf', 'hd', 'hx', 'jy', 'wz', 'hp', 'yu', 'vb', 'jq', 'qg', 'qr',
        'qd', 'iq', 'mz', 'jr', 'wq', 'yz', 'gk', 'tx', 'yq', 'uq', 'zh', 'zj', 'vw', 'jg', 'jn', 'vq', 'iw', 'jp', 'bg', 'lx', 'qy',
        'qp', 'wk', 'hq', 'cx', 'bz', 'xv', 'jx', 'qb', 'wj', 'vh', 'zt', 'gx', 'qo', 'vj', 'pv', 'mq', 'qw', 'gd', 'fv', 'bj', 'kj',
        'qf', 'fb', 'qz', 'kv', 'oq', 'pz', 'gq', 'wx', 'jh', 'js', 'mx', 'vt', 'jt', 'zw', 'sx', 'qh', 'qv', 'jw', 'uj', 'vx', 'kz',
        'gt', 'qx', 'fx', 'hb', 'eq', 'aj', 'fk', 'ih', 'cv', 'kg', 'zx', 'oj', 'gv', 'bh', 'zs', 'gc', 'bq', 'hc', 'kx', 'cf', 'qa',
        'hv', 'xw', 'bx', 'pq', 'jc', 'pj', 'vp', 'zm', 'vk', 'jm', 'dx', 'jz'},
    'm': {
        'xk', 'gb', 'xj', 'wv', 'yv', 'zg', 'fq', 'gz', 'nr', 'zn', 'hw', 'qc', 'kq', 'lc', 'jd', 'gj', 'zf', 'hd', 'je', 'zc', 'ds',
        'fp', 'xz', 'nm', 'ct', 'qg', 'qr', 'gn', 'kt', 'hs', 'mz', 'zv', 'dq', 'mr', 'nx', 'tx', 'kp', 'yq', 'gw', 'qy', 'ku', 'bz',
        'sq', 'jx', 'qb', 'wj', 'gx', 'mb', 'pv', 'qw', 'dv', 'bj', 'qz', 'tl', 'dc', 'js', 'fz', 'vx', 'zr', 'nd', 'qx', 'ft', 'kg',
        'xn', 'lf', 'wu', 'lw', 'qe', 'kx', 'tw', 'qa', 'wn', 'ky', 'bx', 'uw', 'gs', 'xr', 'rl', 'rd', 'zb', 'jm', 'mp', 'nh', 'dt',
        'fm', 'lr', 'cm', 'hn', 'df', 'jf', 'dp', 'vg', 'fj', 'xs', 'mw', 'qj', 'qs', 'tq', 'zp', 'qm', 'vn', 'ql', 'rn', 'jy', 'xa',
        'rq', 'vb', 'mv', 'xu', 'gk', 'gf', 'xg', 'tf', 'vu', 'jg', 'lt', 'rt', 'vq', 'rh', 'bg', 'lx', 'hq', 'rg', 'vj', 'wy', 'fc',
        'xb', 'vt', 'sx', 'cz', 'fx', 'wr', 'fk', 'mn', 'cv', 'vl', 'kr', 'gh', 'xp', 'hc', 'xw', 'tc', 'pj', 'fn', 'rv', 'rf', 'dx',
        'xt', 'jb', 'mg', 'jk', 'kf', 'lq', 'bv', 'cj', 'qt', 'zq', 'hj', 'nj', 'nk', 'wl', 'qi', 'zd', 'jl', 'qk', 'np', 'zo', 'px',
        'hx', 'mt', 'qn', 'lv', 'rw', 'dk', 'rj', 'qd', 'vf', 'rx', 'fh', 'lj', 'wq', 'sz', 'dy', 'xl', 'rb', 'lp', 'fd', 'zj', 'kc',
        'jn', 'xy', 'jp', 'xq', 'qp', 'dm', 'uv', 'cx', 'ln', 'tp', 'xv', 'kd', 'vh', 'tz', 'zt', 'qo', 'wb', 'hk', 'lm', 'rz', 'wf',
        'mf', 'xd', 'wx', 'zw', 'zl', 'wm', 'fw', 'xe', 'xc', 'dj', 'bq', 'zy', 'vy', 'sj', 'vs', 'vr', 'kl', 'xh', 'jc', 'lk', 'nq',
        'vk', 'jz', 'xo', 'ji', 'dg', 'ws', 'wp', 'tb', 'jv', 'vm', 'km', 'mc', 'wg', 'wz', 'vc', 'yu', 'jq', 'md', 'wt', 'wd', 'gp',
        'jr', 'dh', 'xm', 'zh', 'kw', 'rp', 'vw', 'dw', 'tj', 'zk', 'hf', 'vz', 'wk', 'lh', 'hg', 'lg', 'xf', 'mq', 'mj', 'gd', 'fv',
        'rc', 'qf', 'kv', 'td', 'pz', 'gq', 'vd', 'wc', 'jh', 'mx', 'dz', 'jt', 'qh', 'qv', 'jw', 'rm', 'yj', 'kz', 'hl', 'gt', 'tg',
        'hb', 'nf', 'zu', 'xi', 'nv', 'zx', 'tn', 'gv', 'kn', 'zs', 'gc', 'hv', 'fs', 'lz', 'lb', 'ks', 'nz', 'zm', 'kb'},
    'p': {
        'xk', 'gb', 'bn', 'xj', 'wv', 'zg', 'fq', 'gz', 'nr', 'zn', 'kh', 'qc', 'kq', 'cg', 'lc', 'jd', 'nb', 'gj', 'zf', 'sf', 'ko',
        'zc', 'ds', 'bf', 'fp', 'xz', 'iy', 'nm', 'ld', 'ct', 'qg', 'qr', 'gn', 'dn', 'kt', 'mz', 'zv', 'dq', 'pg', 'yz', 'nw', 'nx',
        'tx', 'kp', 'yq', 'gw', 'qy', 'ku', 'bz', 'dl', 'gm', 'sq', 'jx', 'qb', 'wj', 'gx', 'mb', 'pv', 'qw', 'dv', 'bj', 'qz', 'dc',
        'pw', 'js', 'fz', 'vx', 'zr', 'nd', 'qx', 'ft', 'bc', 'kg', 'xn', 'lf', 'wu', 'lw', 'qe', 'kx', 'qa', 'wn', 'ky', 'bx', 'uw',
        'gs', 'xr', 'rl', 'zb', 'jm', 'mp', 've', 'nh', 'dt', 'sr', 'nt', 'fm', 'lr', 'cm', 'jf', 'dp', 'bp', 'vg', 'fj', 'xs', 'mw',
        'qj', 'qs', 'tq', 'zp', 'zi', 'qm', 'vn', 'ql', 'jy', 'xa', 'rq', 'vb', 'mv', 'xu', 'ze', 'gk', 'gf', 'xg', 'vu', 'jg', 'lt',
        'vq', 'rh', 'bg', 'lx', 'hq', 'rk', 'rg', 'vj', 'af', 'wy', 'xb', 'fg', 'sx', 'cz', 'fx', 'fk', 'mn', 'pf', 'cv', 'vl', 'kr',
        'gh', 'xp', 'hc', 'cf', 'cd', 'xw', 'pj', 'fn', 'vp', 'rv', 'rf', 'cq', 'bt', 'ju', 'dx', 'xt', 'jb', 'sv', 'mg', 'jk', 'kf',
        'lq', 'bv', 'cj', 'qt', 'ck', 'zq', 'hj', 'nj', 'nk', 'tk', 'wl', 'qi', 'zd', 'jl', 'du', 'db', 'qk', 'np', 'zo', 'cn', 'px',
        'hx', 'mt', 'qn', 'lv', 'rw', 'dk', 'rj', 'gy', 'qd', 'vf', 'rx', 'fh', 'sd', 'lj', 'wq', 'sz', 'dy', 'xl', 'rb', 'lp', 'fd',
        'zj', 'kc', 'jn', 'xy', 'jp', 'bd', 'bk', 'by', 'xq', 'qp', 'dm', 'uv', 'cx', 'ln', 'tp', 'xv', 'kd', 'za', 'vh', 'tz', 'zt',
        'qo', 'wb', 'hk', 'lm', 'kj', 'rz', 'wf', 'mf', 'fb', 'ny', 'xd', 'wx', 'zw', 'zl', 'wm', 'fw', 'xe', 'xc', 'dj', 'bh', 'bq',
        'zy', 'vy', 'sj', 'vs', 'vr', 'kl', 'pq', 'xh', 'jc', 'lk', 'nq', 'rs', 'vk', 'jz', 'xo', 'mk', 'ji', 'dg', 'ws', 'wp', 'jv',
        'vm', 'fy', 'km', 'mc', 'cy', 'wg', 'wz', 'vc', 'jq', 'md', 'wt', 'jr', 'dh', 'bm', 'xm', 'zh', 'kw', 'bw', 'uo', 'vw', 'dw',
        'tj', 'zk', 'hf', 'vz', 'nl', 'wk', 'lh', 'hg', 'cb', 'lg', 'xf', 'mq', 'mj', 'fv', 'rc', 'qf', 'kv', 'td', 'pz', 'gq', 'vd',
        'wc', 'jh', 'mx', 'dz', 'jt', 'qh', 'qv', 'jw', 'kz', 'tg', 'nf', 'zu', 'xi', 'nv', 'mh', 'zx', 'gv', 'zs', 'gc', 'pb', 'hv',
        'fs', 'lz', 'lb', 'ks', 'nz', 'zm', 'kb'},
    'h': {
        'xk', 'gb', 'bn', 'xj', 'wv', 'zg', 'fq', 'gz', 'nr', 'zn', 'hw', 'qc', 'kq', 'cg', 'lc', 'jd', 'hz', 'nb', 'gj', 'zf', 'sf',
        'hd', 'zc', 'ds', 'bf', 'fp', 'xz', 'nm', 'ld', 'nc', 'ct', 'qg', 'qr', 'gn', 'dn', 'kt', 'hs', 'mz', 'zv', 'dq', 'pg', 'mr',
        'nw', 'nx', 'tx', 'kp', 'yq', 'pn', 'gw', 'qy', 'bz', 'dl', 'gm', 'sq', 'jx', 'qb', 'wj', 'gx', 'mb', 'pv', 'qw', 'dv', 'bj',
        'qz', 'dc', 'js', 'fz', 'vx', 'zr', 'pt', 'qx', 'ft', 'bc', 'kg', 'xn', 'lf', 'qe', 'kx', 'qa', 'wn', 'bx', 'uw', 'gs', 'xr',
        'zb', 'jm', 'nh', 'dt', 'sr', 'nt', 'fm', 'cm', 'hn', 'df', 'jf', 'dp', 'bp', 'vg', 'fj', 'xs', 'mw', 'qj', 'qs', 'tq', 'zp',
        'qm', 'vn', 'ql', 'rn', 'jy', 'xa', 'rq', 'vb', 'mv', 'xu', 'cp', 'gk', 'gf', 'tv', 'xg', 'uq', 'vu', 'jg', 'rt', 'vq', 'rh',
        'bg', 'lx', 'hq', 'rk', 'rg', 'vo', 'vj', 'fc', 'xb', 'vt', 'fg', 'sx', 'cz', 'fx', 'fk', 'pf', 'cv', 'ht', 'vl', 'kr', 'gh',
        'xp', 'pd', 'hc', 'cf', 'cd', 'xw', 'pj', 'fn', 'vp', 'rv', 'rf', 'cq', 'bt', 'dx', 'xt', 'jb', 'sv', 'mg', 'jk', 'kf', 'lq',
        'bv', 'cj', 'qt', 'ck', 'zq', 'hj', 'nj', 'py', 'ls', 'wl', 'qi', 'zd', 'jl', 'db', 'qk', 'np', 'zo', 'cn', 'px', 'hx', 'mt',
        'qn', 'pk', 'lv', 'dk', 'rj', 'gy', 'qd', 'vf', 'rx', 'fh', 'lj', 'wq', 'sz', 'dy', 'xl', 'lp', 'fd', 'zj', 'jn', 'xy', 'jp',
        'bd', 'hm', 'bk', 'xq', 'qp', 'dm', 'cx', 'ln', 'xv', 'kd', 'vh', 'tz', 'zt', 'qo', 'wb', 'hk', 'lm', 'kj', 'rz', 'wf', 'mf',
        'fb', 'ps', 'xd', 'wx', 'zw', 'zl', 'wm', 'fw', 'xe', 'xc', 'dj', 'sb', 'bh', 'bq', 'zy', 'vy', 'sj', 'vs', 'vr', 'pq', 'xh',
        'jc', 'cw', 'nq', 'lk', 'vk', 'jz', 'xo', 'mk', 'ji', 'pc', 'dg', 'ws', 'wp', 'jv', 'vm', 'fy', 'hr', 'km', 'mc', 'wg', 'wz',
        'vc', 'hp', 'jq', 'md', 'wt', 'wd', 'gp', 'jr', 'dh', 'bm', 'xm', 'zh', 'kw', 'bw', 'vw', 'dw', 'zk', 'hf', 'vz', 'wk', 'hg',
        'cb', 'cs', 'lg', 'xf', 'mq', 'mj', 'gd', 'fv', 'rc', 'qf', 'kv', 'pz', 'gq', 'vd', 'wc', 'jh', 'mx', 'dz', 'jt', 'qh', 'qv',
        'jw', 'yj', 'kz', 'hl', 'gt', 'hb', 'zu', 'xi', 'nv', 'mh', 'zx', 'gv', 'zs', 'gc', 'hv', 'fs', 'lz', 'ks', 'nz', 'zm',
        'kb'},
    'x': {
        'xk', 'gb', 'bn', 'xj', 'wv', 'yv', 'zg', 'fq', 'gz', 'nr', 'sm', 'zn', 'hw', 'kh', 'qc', 'kq', 'uh', 'cg', 'lc', 'jd', 'hz',
        'nb', 'ev', 'gj', 'zf', 'sf', 'hd', 'ko', 'je', 'zc', 'ds', 'bf', 'fp', 'xz', 'iy', 'nm', 'ld', 'nc', 'ct', 'qg', 'qr', 'gn',
        'dn', 'kt', 'ao', 'ry', 'hs', 'mz', 'zv', 'dq', 'mr', 'yz', 'nw', 'nx', 'uk', 'tx', 'kp', 'pn', 'iw', 'gw', 'qy', 'ku', 'bz',
        'da', 'dl', 'gm', 'sq', 'ui', 'jx', 'qb', 'sg', 'wj', 'gx', 'mb', 'pv', 'qw', 'dv', 'bj', 'gr', 'qz', 'ov', 'dc', 'pw', 'js',
        'ja', 'fz', 'uj', 'vx', 'zr', 'nd', 'qx', 'aj', 'bc', 'kg', 'oj', 'xn', 'lf', 'wu', 'lw', 'qe', 'kx', 'ng', 'qa', 'wn', 'ky',
        'bx', 'uw', 'gs', 'xr', 'rl', 'rd', 'iz', 'ka', 'zb', 'jm', 'mp', 've', 'nh', 'ex', 'dt', 'sr', 'nt', 'fm', 'lr', 'cm', 'hn',
        'df', 'jf', 'dp', 'bp', 'vg', 'fj', 'xs', 'mw', 'qj', 'qs', 'uy', 'tq', 'gi', 'zp', 'zi', 'qm', 'vn', 'ql', 'rn', 'jy', 'no',
        'xa', 'mu', 'rq', 'vb', 'mv', 'xu', 'ug', 'ef', 'cp', 'ze', 'gk', 'gf', 'tv', 'xg', 'aq', 'uq', 'vu', 'ut', 'jg', 'lt', 'rt',
        'vq', 'rh', 'bg', 'lx', 'hq', 'rk', 'rg', 'vo', 'vj', 'ay', 'wy', 'fc', 'uc', 'vt', 'fg', 'sx', 'sn', 'cz', 'fx', 'wr', 'fk',
        'mn', 'cv', 'vl', 'ms', 'nu', 'kr', 'gh', 'xp', 'pd', 'hc', 'ni', 'cf', 'cd', 'xw', 'tc', 'pj', 'fn', 'vp', 'rv', 'rf', 'cq',
        'bt', 'ju', 'dx', 'xt', 'eh', 'jb', 'sv', 'mg', 'jk', 'kf', 'lq', 'bv', 'cj', 'qt', 'ck', 'zq', 'hj', 'nj', 'py', 'nk', 'tk',
        'wl', 'qi', 'zd', 'jl', 'du', 'db', 'qk', 'np', 'cn', 'px', 'hx', 'mt', 'ij', 'qn', 'pk', 'lv', 'rw', 'dk', 'rj', 'ue', 'gy',
        'qd', 'iq', 'vf', 'rx', 'ez', 'fh', 'sd', 'lj', 'wq', 'sz', 'dy', 'xl', 'rb', 'lp', 'fd', 'jo', 'zj', 'kc', 'jn', 'sy', 'xy',
        'jp', 'bd', 'bk', 'xq', 'qp', 'dm', 'cx', 'ln', 'tp', 'xv', 'kd', 'za', 'vh', 'tz', 'zt', 'qo', 'ux', 'ow', 'wb', 'hk', 'lm',
        'kj', 'rz', 'wf', 'mf', 'fb', 'ps', 'oq', 'ny', 'xd', 'wx', 'zw', 'zl', 'wm', 'fw', 'xe', 'xc', 'dj', 'sb', 'bh', 'bs', 'bq',
        'zy', 'vy', 'sj', 'vs', 'vr', 'ns', 'kl', 'pq', 'xh', 'jc', 'cw', 'nq', 'lk', 'rs', 'vk', 'jz', 'wh', 'xo', 'mk', 'ji', 'dg',
        'ws', 'wp', 'jv', 'vm', 'fy', 'hr', 'km', 'va', 'mc', 'uz', 'ek', 'wg', 'ej', 'wz', 'vc', 'hp', 'ew', 'jq', 'md', 'wt', 'aw',
        'wd', 'gp', 'jr', 'dh', 'bm', 'ep', 'ax', 'xm', 'zh', 'kw', 'bw', 'rp', 'vw', 'dw', 'tj', 'ox', 'zk', 'hf', 'uf', 'vz', 'nl',
        'wk', 'lh', 'hg', 'cb', 'cs', 'lg', 'ik', 'xf', 'mq', 'lu', 'mj', 'gd', 'fv', 'rc', 'qf', 'kv', 'td', 'pz', 'gq', 'vd', 'wc',
        'jh', 'mx', 'dz', 'ge', 'jt', 'qh', 'qv', 'jw', 'rm', 'yj', 'kz', 'gt', 'do', 'tg', 'hb', 'nf', 'zu', 'xi', 'nv', 'mh', 'zx',
        'gv', 'kn', 'zs', 'gc', 'pb', 'hv', 'yx', 'lz', 'lb', 'my', 'ks', 'nz', 'zm', 'kb'},
    'y': {
        'xk', 'gb', 'bn', 'xj', 'wv', 'yv', 'fq', 'gz', 'zn', 'hw', 'qc', 'kq', 'cg', 'jd', 'hz', 'gj', 'zf', 'hd', 'je', 'zc', 'ds',
        'bf', 'fp', 'xz', 'iy', 'qg', 'qr', 'hs', 'mz', 'zv', 'dq', 'pg', 'yz', 'iv', 'tx', 'kp', 'yq', 'yh', 'iw', 'qy', 'bz', 'dl',
        'sq', 'jx', 'qb', 'wj', 'gx', 'pv', 'qw', 'dv', 'bj', 'qz', 'dc', 'pw', 'js', 'ym', 'vx', 'zr', 'qx', 'ft', 'bc', 'ih', 'kg',
        'xn', 'wu', 'lw', 'qe', 'kx', 'tw', 'yp', 'qa', 'wn', 'ky', 'bx', 'uw', 'gs', 'xr', 'zb', 'jm', 'dt', 'fm', 'cm', 'hn', 'df',
        'jf', 'dp', 'bp', 'vg', 'fj', 'xs', 'mw', 'qj', 'qs', 'yl', 'uy', 'tq', 'yf', 'zp', 'qm', 'vn', 'ql', 'jy', 'rq', 'vb', 'mv',
        'xu', 'cp', 'gk', 'gf', 'tv', 'xg', 'uq', 'tf', 'jg', 'vq', 'bg', 'lx', 'hq', 'ix', 'rk', 'yb', 'vj', 'ys', 'fc', 'xb', 'vt',
        'fg', 'sx', 'ib', 'cz', 'fx', 'fk', 'pf', 'cv', 'vl', 'kr', 'gh', 'xp', 'pd', 'hc', 'yt', 'cf', 'cd', 'xw', 'tc', 'pj', 'fn',
        'vp', 'rv', 'cq', 'bt', 'ju', 'dx', 'xt', 'jb', 'sv', 'jk', 'kf', 'bv', 'cj', 'qt', 'zq', 'hj', 'nj', 'tk', 'wl', 'qi', 'zd',
        'jl', 'db', 'qk', 'px', 'hx', 'ud', 'ij', 'qn', 'pk', 'rw', 'dk', 'rj', 'qd', 'iq', 'vf', 'rx', 'fh', 'yd', 'sd', 'lj', 'wq',
        'xl', 'fd', 'jo', 'zj', 'kc', 'yk', 'jn', 'jp', 'bk', 'xq', 'qp', 'dm', 'cx', 'tp', 'xv', 'kd', 'vh', 'tz', 'zt', 'qo', 'ux',
        'yi', 'wb', 'hk', 'kj', 'wf', 'mf', 'fb', 'xd', 'wx', 'zw', 'zl', 'wm', 'yr', 'yc', 'fw', 'xc', 'dj', 'bh', 'iu', 'bs', 'bq',
        'vy', 'sj', 'vs', 'vr', 'pq', 'xh', 'yg', 'jc', 'cw', 'nq', 'vk', 'yw', 'jz', 'ji', 'pc', 'dg', 'ws', 'wp', 'tb', 'jv', 'vm',
        'tm', 'km', 'wg', 'ej', 'wz', 'pm', 'vc', 'hp', 'jq', 'md', 'wt', 'wd', 'gp', 'jr', 'dh', 'xm', 'zh', 'kw', 'bw', 'uo', 'vw',
        'yn', 'dw', 'tj', 'ts', 'zk', 'hf', 'vz', 'wk', 'hg', 'cb', 'cs', 'xf', 'mq', 'mj', 'fv', 'qf', 'kv', 'td', 'pz', 'gq', 'vd',
        'wc', 'jh', 'mx', 'dz', 'jt', 'qh', 'qv', 'jw', 'yj', 'kz', 'hl', 'gt', 'tg', 'hb', 'nf', 'eq', 'nv', 'zx', 'tn', 'gv', 'zs',
        'gc', 'pb', 'hv', 'fs', 'yx', 'lz', 'ks', 'nz', 'zm', 'kb'},
    'g': {
        'xk', 'bn', 'xj', 'wv', 'zg', 'fq', 'gz', 'zn', 'kh', 'qc', 'kq', 'cg', 'lc', 'jd', 'gj', 'zf', 'je', 'zc', 'ds', 'bf', 'fp',
        'xz', 'iy', 'ld', 'ct', 'qg', 'qr', 'kt', 'mz', 'zv', 'dq', 'pg', 'mr', 'yz', 'nx', 'tx', 'kp', 'yq', 'yh', 'pn', 'iw', 'gw',
        'qy', 'ku', 'bz', 'dl', 'sq', 'jx', 'qb', 'vi', 'wj', 'gx', 'mb', 'pv', 'qw', 'dv', 'bj', 'qz', 'tl', 'dc', 'pw', 'js', 'fz',
        'vx', 'zr', 'pt', 'qx', 'ft', 'bc', 'oj', 'xn', 'lf', 'lw', 'qe', 'kx', 'tw', 'ng', 'qa', 'ci', 'wn', 'ky', 'bx', 'uw', 'xr',
        'rl', 'rd', 'zb', 'jm', 'mp', 'dt', 'sr', 'fm', 'lr', 'cm', 'df', 'jf', 'dp', 'bp', 'vg', 'fj', 'xs', 'mw', 'qj', 'qs', 'tq',
        'yf', 'zp', 'qm', 'vn', 'ql', 'rn', 'jy', 'xa', 'rq', 'vb', 'mv', 'xu', 'cp', 'ze', 'gk', 'tv', 'xg', 'aq', 'uq', 'vu', 'tf',
        'jg', 'lt', 'rt', 'vq', 'rh', 'bg', 'lx', 'hq', 'ix', 'rk', 'vo', 'vj', 'fc', 'xb', 'vt', 'fg', 'sx', 'cz', 'fk', 'mn', 'cv',
        'vl', 'kr', 'xp', 'cf', 'cd', 'xw', 'tc', 'pj', 'fn', 'vp', 'rv', 'rf', 'cq', 'bt', 'ju', 'dx', 'xt', 'jb', 'sv', 'mg', 'jk',
        'kf', 'lq', 'bv', 'cj', 'qt', 'ck', 'zq', 'nj', 'py', 'nk', 'ls', 'wl', 'qi', 'zd', 'jl', 'db', 'qk', 'zo', 'cn', 'px', 'hx',
        'mt', 'qn', 'pk', 'lv', 'rw', 'rj', 'qd', 'iq', 'vf', 'rx', 'fh', 'lj', 'wq', 'sz', 'xl', 'rb', 'lp', 'fd', 'jo', 'zj', 'yk',
        'jn', 'xy', 'jp', 'bd', 'bk', 'xq', 'qp', 'dm', 'cx', 'ln', 'tp', 'xv', 'kd', 'vh', 'tz', 'zt', 'qo', 'ux', 'wb', 'lm', 'kj',
        'wf', 'mf', 'fb', 'ps', 'xd', 'ce', 'wx', 'zw', 'zl', 'wm', 'fw', 'xe', 'xc', 'dj', 'bh', 'bs', 'bq', 'zy', 'vy', 'sj', 'vs',
        'vr', 'pq', 'xh', 'jc', 'cw', 'nq', 'lk', 'rs', 'vk', 'jz', 'xo', 'mk', 'ji', 'pc', 'dg', 'ws', 'wp', 'tb', 'jv', 'vm', 'fy',
        'tm', 'km', 'mc', 'cy', 'wg', 'ej', 'wz', 'pm', 'vc', 'yu', 'jq', 'md', 'wt', 'wd', 'jr', 'dh', 'bm', 'ax', 'xm', 'zh', 'kw',
        'bw', 'rp', 'vw', 'tj', 'dw', 'ts', 'zk', 'vz', 'wk', 'lh', 'cb', 'cs', 'lg', 'xf', 'mq', 'mj', 'qu', 'gd', 'fv', 'rc', 'qf',
        'kv', 'td', 'pz', 'ty', 'gq', 'vd', 'wc', 'jh', 'mx', 'dz', 'jt', 'ke', 'qh', 'qv', 'jw', 'rm', 'yj', 'kz', 'gt', 'tg', 'zu',
        'eq', 'xi', 'nv', 'zx', 'tn', 'gv', 'kn', 'zs', 'pb', 'hv', 'fs', 'yx', 'lz', 'lb', 'ks', 'nz', 'zm', 'kb'},
    'f': {
        'xk', 'gb', 'bn', 'xj', 'wv', 'yv', 'zg', 'fq', 'gz', 'nr', 'zn', 'hw', 'kh', 'qc', 'kq', 'cg', 'lc', 'sw', 'jd', 'hz', 'bl',
        'nb', 'gj', 'zf', 'sf', 'hd', 'ko', 'zc', 'ds', 'bf', 'xz', 'nm', 'ld', 'nc', 'ct', 'qg', 'qr', 'gn', 'dn', 'kt', 'hs', 'mz',
        'zv', 'dq', 'pg', 'mr', 'yz', 'nw', 'nx', 'uk', 'tx', 'kp', 'yq', 'yh', 'pn', 'iw', 'gw', 'qy', 'ku', 'pu', 'bz', 'dl', 'gm',
        'sq', 'jx', 'qb', 'sg', 'vi', 'wj', 'gx', 'mb', 'pv', 'qw', 'dv', 'bj', 'qz', 'pw', 'js', 'fz', 'vx', 'zr', 'nd', 'pt', 'qx',
        'bc', 'ih', 'kg', 'oj', 'xn', 'lf', 'lw', 'qe', 'kx', 'yp', 'ng', 'qa', 'wn', 'bx', 'uw', 'gs', 'xr', 'rl', 'rd', 'zb', 'jm',
        'mp', 'nh', 'dt', 'sr', 'nt', 'lr', 'cm', 'hn', 'df', 'jf', 'dp', 'bp', 'vg', 'fj', 'xs', 'mw', 'qj', 'qs', 'tq', 'yf', 'zp',
        'qm', 'vn', 'ql', 'rn', 'jy', 'no', 'xa', 'mu', 'rq', 'vb', 'mv', 'xu', 'cp', 'gk', 'gf', 'pl', 'tv', 'xg', 'uq', 'vu', 'jg',
        'lt', 'rt', 'vq', 'hi', 'rh', 'bg', 'lx', 'hq', 'rk', 'yb', 'rg', 'vo', 'vj', 'po', 'ys', 'wy', 'xb', 'ph', 'vt', 'sx', 'sn',
        'su', 'cz', 'fx', 'wr', 'mn', 'pf', 'mi', 'cv', 'ht', 'vl', 'ms', 'kr', 'xp', 'pd', 'sl', 'hc', 'yt', 'cf', 'cd', 'xw', 'pj',
        'vp', 'rv', 'rf', 'cq', 'bt', 'ju', 'dx', 'xt', 'jb', 'sv', 'mg', 'bu', 'jk', 'kf', 'lq', 'up', 'bv', 'cj', 'qt', 'ck', 'zq',
        'hj', 'nj', 'py', 'nk', 'ls', 'tk', 'wl', 'qi', 'zd', 'jl', 'hu', 'db', 'qk', 'np', 'zo', 'cn', 'px', 'hx', 'mt', 'qn', 'pk',
        'lv', 'rw', 'dk', 'rj', 'gy', 'vf', 'rx', 'sd', 'lj', 'wq', 'sz', 'dy', 'xl', 'rb', 'lp', 'zj', 'kc', 'jn', 'sy', 'xy', 'jp',
        'bd', 'hm', 'bk', 'by', 'xq', 'qp', 'dm', 'uv', 'cx', 'xv', 'kd', 'za', 'vh', 'tz', 'zt', 'qo', 'ux', 'wb', 'hk', 'lm', 'kj',
        'rz', 'wf', 'mf', 'oq', 'ce', 'wx', 'zw', 'zl', 'wm', 'xe', 'xc', 'dj', 'bh', 'bs', 'bq', 'zy', 'vy', 'sj', 'vr', 'ns', 'kl',
        'pq', 'xh', 'yg', 'jc', 'cw', 'nq', 'lk', 'rs', 'vk', 'jz', 'wh', 'br', 'cl', 'xo', 'mk', 'ji', 'pc', 'dg', 'ws', 'wp', 'jv',
        'vm', 'hr', 'km', 'va', 'mc', 'cy', 'wg', 'ej', 'wz', 'pm', 'vc', 'hp', 'yu', 'jq', 'md', 'wt', 'gp', 'jr', 'dh', 'bm', 'xm',
        'ya', 'zh', 'kw', 'bw', 'rp', 'uo', 'vw', 'yn', 'dw', 'tj', 'zk', 'hf', 'vz', 'nl', 'wk', 'lh', 'hg', 'cb', 'cs', 'lg', 'xf',
        'mq', 'mj', 'gd', 'fv', 'rc', 'qf', 'kv', 'pz', 'gq', 'vd', 'wc', 'jh', 'mx', 'dz', 'ge', 'jt', 'ke', 'qh', 'qv', 'jw', 'rm',
        'yj', 'kz', 'hl', 'gt', 'hb', 'nf', 'zu', 'eq', 'xi', 'nv', 'mh', 'zx', 'ch', 'gv', 'kn', 'zs', 'gc', 'pb', 'hv', 'yx', 'lz',
        'lb', 'gl', 'ml', 'my', 'ks', 'nz', 'zm', 'kb'},
    'z': {
        'xk', 'gb', 'bn', 'xj', 'wv', 'yv', 'fq', 'gz', 'nr', 'sm', 'zn', 'hw', 'kh', 'qc', 'kq', 'cg', 'lc', 'sw', 'jd', 'hz', 'bl',
        'nb', 'gj', 'zf', 'sf', 'hd', 'je', 'zc', 'ds', 'bf', 'fp', 'xz', 'iy', 'nm', 'ld', 'nc', 'qg', 'qr', 'gn', 'dn', 'kt', 'ao',
        'ry', 'hs', 'mz', 'zv', 'dq', 'pg', 'mr', 'nw', 'nx', 'tx', 'kp', 'yq', 'pn', 'gw', 'qy', 'ku', 'pu', 'bz', 'ye', 'dl', 'gm',
        'sq', 'jx', 'qb', 'sg', 'vi', 'wj', 'gx', 'mb', 'pv', 'qw', 'dv', 'bj', 'gr', 'tu', 'qz', 'dc', 'fo', 'pw', 'js', 'ja', 'fi',
        'fz', 'fu', 'uj', 'vx', 'zr', 'nd', 'pt', 'qx', 'aj', 'ft', 'bc', 'kg', 'oj', 'xn', 'lf', 'ta', 'wu', 'lw', 'qe', 'kx', 'tw',
        'ng', 'qa', 'pe', 'ci', 'wn', 'bx', 'uw', 'gs', 'xr', 'rl', 'rd', 'ka', 'jm', 'mo', 'mp', 'so', 'nh', 'dt', 'sr', 'nt', 'gu',
        'fm', 'lr', 'cm', 'hn', 'df', 'jf', 'dp', 'bp', 'vg', 'fj', 'xs', 'mw', 'qj', 'qs', 'uy', 'tq', 'yf', 'zp', 'qm', 'vn', 'ql',
        'rn', 'jy', 'no', 'xa', 'rq', 'vb', 'mv', 'xu', 'cp', 'gk', 'gf', 'pl', 'tv', 'xg', 'uq', 'vu', 'tf', 'jg', 'lt', 'rt', 'vq',
        'rh', 'bg', 'lx', 'fr', 'hq', 'rk', 'rg', 'vj', 'wy', 'fc', 'xb', 'ph', 'vt', 'fg', 'sx', 'sn', 'su', 'cz', 'fx', 'wr', 'sh',
        'fk', 'mn', 'pf', 'cv', 'ht', 'vl', 'ms', 'nu', 'xp', 'pd', 'sl', 'hc', 'ni', 'co', 'cf', 'cd', 'xw', 'tc', 'pj', 'fn', 'vp',
        'rv', 'rf', 'cq', 'bt', 'ju', 'dx', 'xt', 'jb', 'sv', 'mg', 'jk', 'kf', 'lq', 'bv', 'cj', 'yo', 'qt', 'ck', 'zq', 'hj', 'nj',
        'py', 'nk', 'ls', 'tk', 'wl', 'qi', 'zd', 'jl', 'db', 'qk', 'np', 'cn', 'px', 'hx', 'mt', 'ua', 'sp', 'ij', 'qn', 'pk', 'lv',
        'rw', 'dk', 'rj', 'gy', 'qd', 'vf', 'rx', 'fh', 'yd', 'sd', 'lj', 'wq', 'sz', 'dy', 'xl', 'rb', 'lp', 'fd', 'jo', 'zj', 'kc',
        'jn', 'sy', 'xy', 'jp', 'bd', 'bk', 'by', 'xq', 'fl', 'qp', 'dm', 'uv', 'cx', 'ln', 'tp', 'xv', 'kd', 'vh', 'tz', 'zt', 'sk',
        'qo', 'ux', 'wb', 'hk', 'lm', 'kj', 'rz', 'wf', 'mf', 'fb', 'ps', 'ny', 'xd', 'fa', 'wx', 'si', 'pr', 'wm', 'ki', 'fw', 'xe',
        'xc', 'dj', 'sb', 'bh', 'bs', 'bq', 'vy', 'sj', 'vs', 'vr', 'ns', 'kl', 'pq', 'xh', 'jc', 'cw', 'nq', 'lk', 'rs', 'vk', 'jz',
        'wh', 'xo', 'mk', 'ji', 'pc', 'dg', 'ws', 'wp', 'tb', 'jv', 'vm', 'fy', 'hr', 'tm', 'km', 'mc', 'cy', 'wg', 'ej', 'wz', 'pm',
        'vc', 'hp', 'yu', 'jq', 'md', 'wt', 'wd', 'gp', 'jr', 'dh', 'bm', 'xm', 'ya', 'zh', 'kw', 'bw', 'rp', 'vw', 'dw', 'tj', 'ts',
        'zk', 'hf', 'uf', 'vz', 'nl', 'lh', 'hg', 'cb', 'cs', 'lg', 'oz', 'xf', 'st', 'mq', 'mj', 'qu', 'cr', 'gd', 'fv', 'rc', 'qf',
        'kv', 'td', 'pz', 'ty', 'gq', 'vd', 'wc', 'jh', 'mx', 'dz', 'jt', 'qh', 'qv', 'jw', 'yj', 'kz', 'hl', 'gt', 'do', 'tg', 'hb',
        'nf', 'xi', 'nv', 'mh', 'zx', 'tn', 'gv', 'kn', 'zs', 'gc', 'pb', 'hv', 'fs', 'yx', 'dr', 'lz', 'lb', 'ml', 'my', 'ks', 'nz',
        'kb'},
    'j': {
        'xk', 'gb', 'bn', 'xj', 'wv', 'yv', 'zg', 'fq', 'gz', 'sm', 'zn', 'hw', 'kh', 'qc', 'kq', 'cg', 'lc', 'sw', 'jd', 'hz', 'bl',
        'nb', 'gj', 'zf', 'sf', 'hd', 'ko', 'je', 'zc', 'ds', 'bf', 'fp', 'xz', 'iy', 'nm', 'ld', 'nc', 'ct', 'qg', 'qr', 'gn', 'dn',
        'kt', 'ry', 'hs', 'mz', 'zv', 'dq', 'mr', 'yz', 'nw', 'nx', 'tx', 'kp', 'la', 'yq', 'yh', 'pn', 'iw', 'gw', 'sa', 'qy', 'ku',
        'bz', 'ye', 'dl', 'ne', 'sq', 'of', 'gm', 'jx', 'qb', 'sg', 'vi', 'wj', 'gx', 'mb', 'pv', 'qw', 'dv', 'bj', 'gr', 'tu', 'qz',
        'tl', 'be', 'dc', 'fo', 'pw', 'js', 'fi', 'eg', 'fz', 'we', 'fu', 'vx', 'zr', 'nd', 'pt', 'qx', 'ey', 'ft', 'bc', 'kg', 'xn',
        'lf', 'wu', 'ga', 'lw', 'qe', 'kx', 'tw', 'yp', 'ng', 'qa', 'ci', 'wn', 'pa', 'ky', 'bx', 'uw', 'ru', 'gs', 'xr', 'to', 'rl',
        'rd', 'ka', 'zb', 'jm', 'mo', 'mp', 've', 'nh', 'dt', 'sr', 'nt', 'gu', 'fm', 'lr', 'go', 'cm', 'hn', 'df', 'jf', 'dp', 'bo',
        'bp', 'vg', 'fj', 'xs', 'mw', 'qj', 'qs', 'tq', 'gi', 'yf', 'zp', 'zi', 'vn', 'qm', 'de', 'ql', 'rn', 'jy', 'xa', 'fe', 'mu',
        'rq', 'vb', 'mv', 'xu', 'cp', 'ze', 'gk', 'om', 'gf', 'pl', 'tv', 'xg', 'uq', 'vu', 'tf', 'jg', 'lt', 'rt', 'vq', 'hi', 'le',
        'rh', 'bg', 'lx', 'fr', 'hq', 'rk', 'yb', 'rg', 'vo', 'vj', 'po', 'ys', 'wy', 'fc', 'xb', 'ph', 'vt', 'me', 'fg', 'sx', 'sn',
        'cz', 'fx', 'wr', 'sh', 'mn', 'pf', 'mi', 'cv', 'vl', 'ms', 'nu', 'tr', 'kr', 'xp', 'gh', 'pd', 'sl', 'hc', 'ni', 'yt', 'co',
        'cf', 'cd', 'xw', 'tc', 'pj', 'fn', 'vp', 'rv', 'rf', 'cq', 'bt', 'ju', 'th', 'dx', 'xt', 'jb', 'sv', 'mg', 'hy', 'jk', 'bu',
        'kf', 'lq', 'bv', 'cj', 'yo', 'qt', 'ck', 'zq', 'hj', 'nj', 'py', 'nk', 'pi', 'ls', 'tk', 'wl', 'qi', 'zd', 'jl', 'du', 'db',
        'qk', 'np', 'zo', 'cn', 'px', 'hx', 'mt', 'ti', 'ly', 'ij', 'qn', 'pk', 'lv', 'rw', 'dk', 'rj', 'gy', 'qd', 'vf', 'rx', 'fh',
        'yd', 'sd', 'lj', 'wq', 'sz', 'dy', 'xl', 'rb', 'lp', 'fd', 'jo', 'zj', 'kc', 'yk', 'jn', 'sy', 'xy', 'jp', 'bd', 'hm', 'bk',
        'by', 'xq', 'fl', 'qp', 'dm', 'io', 'cx', 'ln', 'tp', 'xv', 'kd', 'za', 'vh', 'tz', 'zt', 'sk', 'qo', 'yi', 'wb', 'hk', 'lm',
        'kj', 'rz', 'wf', 'mf', 'fb', 'ps', 'oq', 'ny', 'xd', 'ce', 'fa', 'wx', 'si', 'zw', 'zl', 'wm', 'yr', 'yc', 'ki', 'fw', 'xe',
        'xc', 'dj', 'sb', 'bh', 'bs', 'bq', 'zy', 'vy', 'sj', 'vs', 'vr', 'ns', 'kl', 'pq', 'xh', 'yg', 'jc', 'cw', 'nq', 'lk', 'rs',
        'vk', 'yw', 'jz', 'wh', 'br', 'cl', 'xo', 'mk', 'ji', 'pc', 'dg', 'ws', 'wp', 'tb', 'jv', 'fy', 'hr', 'tm', 'km', 'va', 'mc',
        'cy', 'wg', 'wz', 'pm', 'vc', 'hp', 'yu', 'jq', 'md', 'wt', 'wo', 'wd', 'gp', 'jr', 'ca', 'cu', 'dh', 'bm', 'ax', 'xm', 'ya',
        'zh', 'kw', 'bw', 'rp', 'uo', 'vw', 'dw', 'tj', 'ox', 'ts', 'zk', 'hf', 'vz', 'nl', 'wk', 'hg', 'cb', 'lh', 'cs', 'lg', 'xf',
        'ro', 'st', 'mq', 'lu', 'mj', 'qu', 'cr', 'gd', 'fv', 'rc', 'qf', 'kv', 'td', 'pz', 'ty', 'gq', 'vd', 'wc', 'jh', 'mx', 'dz',
        'ge', 'jt', 'ke', 'qh', 'qv', 'jw', 'rm', 'kz', 'hl', 'gt', 'do', 'tg', 'hb', 'nf', 'zu', 'xi', 'nv', 'mh', 'zx', 'ch', 'tn',
        'gv', 'kn', 'zs', 'gc', 'hv', 'fs', 'yx', 'wi', 'dr', 'lz', 'lb', 'gl', 'ml', 'my', 'ks', 'nz', 'zm', 'te', 'kb'},
    'k': {
        'xk', 'gb', 'bn', 'xj', 'wv', 'yv', 'zg', 'fq', 'gz', 'nr', 'zn', 'kh', 'qc', 'kq', 'cg', 'lc', 'jd', 'nb', 'gj', 'zf', 'hd',
        'zc', 'ds', 'bf', 'fp', 'xz', 'nm', 'ld', 'nc', 'ct', 'qg', 'qr', 'dn', 'kt', 'hs', 'mz', 'zv', 'dq', 'pg', 'mr', 'yz', 'nw',
        'nx', 'tx', 'kp', 'yq', 'pn', 'gw', 'qy', 'bz', 'dl', 'gm', 'sq', 'jx', 'qb', 'wj', 'gx', 'mb', 'pv', 'qw', 'dv', 'bj', 'qz',
        'tl', 'dc', 'pw', 'js', 'fz', 'uj', 'vx', 'zr', 'nd', 'pt', 'qx', 'ft', 'bc', 'kg', 'xn', 'lf', 'lw', 'kx', 'ng', 'qa', 'wn',
        'ky', 'bx', 'uw', 'gs', 'xr', 'rl', 'rd', 'zb', 'jm', 'mp', 'nh', 'dt', 'nt', 'fm', 'lr', 'cm', 'ig', 'df', 'jf', 'dp', 'bp',
        'vg', 'fj', 'xs', 'mw', 'qj', 'qs', 'tq', 'zp', 'zi', 'qm', 'vn', 'ql', 'rn', 'jy', 'xa', 'rq', 'vb', 'mv', 'xu', 'cp', 'ze',
        'gk', 'tv', 'xg', 'aq', 'uq', 'vu', 'tf', 'jg', 'lt', 'rt', 'vq', 'rh', 'bg', 'lx', 'hq', 'ix', 'rk', 'rg', 'vo', 'vj', 'wy',
        'xb', 'vt', 'fg', 'sx', 'cz', 'fx', 'fk', 'mn', 'pf', 'cv', 'vl', 'ms', 'kr', 'gh', 'xp', 'pd', 'hc', 'cf', 'cd', 'xw', 'tc',
        'pj', 'fn', 'vp', 'rv', 'rf', 'cq', 'bt', 'dx', 'xt', 'jb', 'sv', 'mg', 'jk', 'kf', 'lq', 'bv', 'cj', 'qt', 'ck', 'zq', 'hj',
        'nj', 'py', 'nk', 'ls', 'tk', 'wl', 'qi', 'zd', 'jl', 'du', 'db', 'qk', 'np', 'zo', 'cn', 'px', 'hx', 'mt', 'qn', 'pk', 'lv',
        'rw', 'dk', 'rj', 'gy', 'qd', 'iq', 'vf', 'rx', 'fh', 'sd', 'lj', 'wq', 'sz', 'dy', 'xl', 'rb', 'lp', 'fd', 'zj', 'kc', 'jn',
        'xy', 'jp', 'bd', 'bk', 'by', 'xq', 'qp', 'dm', 'cx', 'ln', 'tp', 'xv', 'kd', 'vh', 'zt', 'ux', 'wb', 'hk', 'kj', 'wf', 'mf',
        'fb', 'ps', 'oq', 'xd', 'ce', 'wx', 'zw', 'zl', 'wm', 'fw', 'xe', 'xc', 'dj', 'bh', 'bs', 'bq', 'zy', 'vy', 'sj', 'vs', 'vr',
        'ns', 'pq', 'xh', 'yg', 'jc', 'cw', 'nq', 'lk', 'rs', 'vk', 'jz', 'xo', 'mk', 'ji', 'pc', 'dg', 'ws', 'wp', 'tb', 'jv', 'vm',
        'fy', 'tm', 'km', 'mc', 'uz', 'cy', 'wg', 'wz', 'pm', 'vc', 'jq', 'md', 'wt', 'wd', 'gp', 'jr', 'dh', 'bm', 'xm', 'zh', 'kw',
        'bw', 'rp', 'vw', 'dw', 'tj', 'ts', 'zk', 'hf', 'vz', 'nl', 'wk', 'lh', 'hg', 'cb', 'lg', 'xf', 'mq', 'mj', 'qu', 'gd', 'fv',
        'rc', 'qf', 'kv', 'td', 'pz', 'gq', 'vd', 'wc', 'jh', 'mx', 'dz', 'jt', 'qh', 'qv', 'jw', 'rm', 'kz', 'gt', 'tg', 'hb', 'nf',
        'zu', 'eq', 'xi', 'nv', 'mh', 'zx', 'tn', 'gv', 'zs', 'gc', 'pb', 'fs', 'yx', 'lz', 'lb', 'gl', 'ml', 'my', 'ks', 'nz', 'zm',
        'kb'},
    'q': {
        'xk', 'gb', 'bn', 'xj', 'wv', 'yv', 'zg', 'ag', 'fq', 'im', 'gz', 'nr', 'sm', 'zn', 'hw', 'kh', 'qc', 'kq', 'cg', 'lc', 'sw',
        'jd', 'hz', 'bl', 'nb', 'ev', 'gj', 'zf', 'ma', 'sf', 'hd', 'ko', 'je', 'zc', 'ds', 'bf', 'fp', 'at', 'xz', 'iy', 'nm', 'ld',
        'nc', 'ct', 'qg', 'qr', 'gn', 'ap', 'kt', 'ao', 'ry', 'hs', 'mz', 'zv', 'dq', 'ha', 'pg', 'mr', 'yz', 'iv', 'nw', 'nx', 'uk',
        'if', 'tx', 'kp', 'yq', 'yh', 'en', 'pn', 'iw', 'gw', 'sa', 'qy', 'ku', 'pu', 'bz', 'da', 'ye', 'dl', 'ne', 'sq', 'of', 'gm',
        'jx', 'qb', 'sg', 'wj', 'gx', 'mb', 'pv', 'qw', 'na', 'dv', 'bj', 'gr', 'tu', 'qz', 'ov', 'tl', 'be', 'dc', 'fo', 'pw', 'js',
        'ae', 'ja', 'fi', 'eg', 'ym', 'fz', 'we', 'fu', 'uj', 'or', 'vx', 'zr', 'nd', 'pt', 'qx', 'ey', 'aj', 'ft', 'bc', 'ih', 'kg',
        'oj', 'xn', 'lf', 'ta', 'wu', 'ga', 'ba', 'lw', 'qe', 'kx', 'tw', 'yp', 'ng', 'qa', 'pe', 'ci', 'wn', 'pa', 'ky', 'bx', 'uw',
        'ru', 'gs', 'xr', 'to', 'os', 'rl', 'rd', 'iz', 'ka', 'zb', 'jm', 'mo', 'mp', 'so', 've', 'nh', 'ex', 'dt', 'sr', 'ec', 'nt',
        'gu', 'fm', 'lr', 'go', 'cm', 'ig', 'az', 'hn', 'df', 'jf', 'dp', 'ea', 'bo', 'bp', 'ah', 'vg', 'fj', 'xs', 'mw', 'qj', 'qs',
        'yl', 'tq', 'gi', 'yf', 'zp', 'zi', 'vn', 'qm', 'de', 'ql', 'rn', 'jy', 'no', 'xa', 'fe', 'el', 'mu', 'rq', 'vb', 'am', 'mv',
        'xu', 'ug', 'ef', 'ir', 'cp', 'ze', 'gk', 'om', 'gf', 'pl', 'tv', 'ar', 'xg', 'aq', 'uq', 'vu', 'tf', 'jg', 'lt', 'rt', 'vq',
        'oa', 'hi', 'ok', 'le', 'rh', 'bg', 'lx', 'fr', 'id', 'hq', 'an', 'ix', 'rk', 'yb', 'au', 'bi', 'rg', 'vo', 'vj', 'ay', 'po',
        'af', 'ys', 'wy', 'ei', 'ac', 'fc', 'uc', 'xb', 'ol', 'ph', 'vt', 'me', 'fg', 'sx', 'sn', 'ri', 'su', 'he', 'cz', 'fx', 'wr',
        'sh', 'fk', 'mn', 'pf', 'mi', 'cv', 'ht', 'vl', 'ms', 'nu', 'tr', 'kr', 'sc', 'xp', 'gh', 'pd', 'sl', 'hc', 'ni', 'yt', 'co',
        'se', 'cf', 'cd', 'xw', 'tc', 'pj', 'fn', 'vp', 'rv', 'rf', 'cq', 'bt', 'ju', 'th', 'dx', 'xt', 'eh', 'jb', 'sv', 'mg', 'hy',
        'jk', 'bu', 'kf', 'lq', 'et', 'up', 'bv', 'cj', 'yo', 'qt', 'ck', 'zq', 'hj', 'nj', 'py', 'nk', 'pi', 'ls', 'tk', 'wl', 'qi',
        'zd', 'jl', 'du', 'hu', 'db', 'qk', 'np', 'zo', 'cn', 'px', 'hx', 'mt', 'sp', 'ly', 'ij', 'qn', 'pk', 'lv', 'rw', 'dk', 'rj',
        'gy', 'qd', 'iq', 'vf', 'rx', 'ez', 'fh', 'yd', 'sd', 'ot', 'lj', 'wq', 'sz', 'it', 'dy', 'xl', 'rb', 'lp', 'fd', 'jo', 'zj',
        'kc', 'yk', 'jn', 'sy', 'xy', 'jp', 'bd', 'hm', 'bk', 'by', 'xq', 'fl', 'qp', 'dm', 'io', 'uv', 'cx', 'ln', 'tp', 'xv', 'kd',
        'za', 'vh', 'tz', 'zt', 'sk', 'qo', 'ux', 'yi', 'ow', 'wb', 'hk', 'lm', 'kj', 'rz', 'wf', 'mf', 'il', 'fb', 'ps', 're', 'oq',
        'ny', 'xd', 'ai', 'ce', 'fa', 'wx', 'si', 'av', 'od', 'ad', 'zw', 'zl', 'pr', 'wm', 'yr', 'yc', 'ki', 'fw', 'is', 'xe', 'xc',
        'dj', 'sb', 'bh', 'iu', 'bs', 'og', 'bq', 'zy', 'vy', 'sj', 'vs', 'vr', 'oi', 'kl', 'pq', 'xh', 'yg', 'jc', 'cw', 'nq', 'lk',
        'rs', 'vk', 'yw', 'on', 'jz', 'wh', 'br', 'cl', 'xo', 'lo', 'mk', 'ji', 'oc', 'pc', 'dg', 'ws', 'wp', 'tb', 'jv', 'vm', 'fy',
        'hr', 'tm', 'km', 'va', 'mc', 'uz', 'cy', 'oe', 'ak', 'ek', 'wg', 'ej', 'wz', 'pm', 'vc', 'hp', 'yu', 'ew', 'jq', 'md', 'wt',
        'aw', 'wo', 'wd', 'gp', 'ic', 'jr', 'ca', 'cu', 'dh', 'bm', 'ep', 'ax', 'xm', 'ya', 'ab', 'zh', 'kw', 'bw', 'rp', 'vw', 'yn',
        'dw', 'tj', 'ox', 'ts', 'zk', 'hf', 'es', 'ie', 'uf', 'vz', 'nl', 'ul', 'wk', 'hg', 'cb', 'lh', 'cs', 'lg', 'ik', 'oz', 'xf',
        'ro', 'st', 'mq', 'lu', 'mj', 'cr', 'gd', 'fv', 'rc', 'qf', 'di', 'li', 'kv', 'td', 'pz', 'ty', 'gq', 'vd', 'wc', 'jh', 'mx',
        'dz', 'ge', 'jt', 'al', 'ke', 'qh', 'qv', 'jw', 'ho', 'rm', 'yj', 'kz', 'hl', 'gt', 'do', 'tg', 'hb', 'nf', 'eo', 'zu', 'eq',
        'xi', 'nv', 'mh', 'em', 'eb', 'ip', 'zx', 'oy', 'ch', 'tn', 'gv', 'kn', 'zs', 'gc', 'pb', 'hv', 'fs', 'yx', 'wi', 'dr', 'wa',
        'lz', 'lb', 'gl', 'ml', 'my', 'ks', 'nz', 'zm', 'ob', 'te', 'kb'},
}


def is_valid_word_naive(text: str):
    if text is None:
        return False
    size = len(text)
    if strings.count_alpha(text) != size:
        return False
    if size <= 3:
        return True
    i_end = size - 3
    for i, c in enumerate(text):
        if i >= i_end:
            break
        c = c.lower()
        if c not in NAIVE_NEG_CHAR_TRANSITION:
            return False
        chunk = text[i + 1:i + 3].lower()
        if strings.count_alpha(chunk) != len(chunk) or chunk in NAIVE_NEG_CHAR_TRANSITION.get(c):
            return False
    return True
