"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const follow_mode_1 = require("./fs/follow-mode");
function toSymlinkFollow(follow) {
    if (!follow) {
        return undefined;
    }
    switch (follow) {
        case follow_mode_1.FollowMode.NEVER: return core_1.SymlinkFollowMode.NEVER;
        case follow_mode_1.FollowMode.ALWAYS: return core_1.SymlinkFollowMode.ALWAYS;
        case follow_mode_1.FollowMode.BLOCK_EXTERNAL: return core_1.SymlinkFollowMode.BLOCK_EXTERNAL;
        case follow_mode_1.FollowMode.EXTERNAL: return core_1.SymlinkFollowMode.EXTERNAL;
        default:
            throw new Error(`unknown follow mode: ${follow}`);
    }
}
exports.toSymlinkFollow = toSymlinkFollow;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tcGF0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29tcGF0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsd0NBQWtEO0FBQ2xELGtEQUE4QztBQUU5QyxTQUFnQixlQUFlLENBQUMsTUFBbUI7SUFDakQsSUFBSSxDQUFDLE1BQU0sRUFBRTtRQUNYLE9BQU8sU0FBUyxDQUFDO0tBQ2xCO0lBRUQsUUFBUSxNQUFNLEVBQUU7UUFDZCxLQUFLLHdCQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsT0FBTyx3QkFBaUIsQ0FBQyxLQUFLLENBQUM7UUFDdEQsS0FBSyx3QkFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLE9BQU8sd0JBQWlCLENBQUMsTUFBTSxDQUFDO1FBQ3hELEtBQUssd0JBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxPQUFPLHdCQUFpQixDQUFDLGNBQWMsQ0FBQztRQUN4RSxLQUFLLHdCQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsT0FBTyx3QkFBaUIsQ0FBQyxRQUFRLENBQUM7UUFDNUQ7WUFDRSxNQUFNLElBQUksS0FBSyxDQUFDLHdCQUF3QixNQUFNLEVBQUUsQ0FBQyxDQUFDO0tBQ3JEO0FBQ0gsQ0FBQztBQWJELDBDQWFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU3ltbGlua0ZvbGxvd01vZGUgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IEZvbGxvd01vZGUgfSBmcm9tICcuL2ZzL2ZvbGxvdy1tb2RlJztcblxuZXhwb3J0IGZ1bmN0aW9uIHRvU3ltbGlua0ZvbGxvdyhmb2xsb3c/OiBGb2xsb3dNb2RlKTogU3ltbGlua0ZvbGxvd01vZGUgfCB1bmRlZmluZWQge1xuICBpZiAoIWZvbGxvdykge1xuICAgIHJldHVybiB1bmRlZmluZWQ7XG4gIH1cblxuICBzd2l0Y2ggKGZvbGxvdykge1xuICAgIGNhc2UgRm9sbG93TW9kZS5ORVZFUjogcmV0dXJuIFN5bWxpbmtGb2xsb3dNb2RlLk5FVkVSO1xuICAgIGNhc2UgRm9sbG93TW9kZS5BTFdBWVM6IHJldHVybiBTeW1saW5rRm9sbG93TW9kZS5BTFdBWVM7XG4gICAgY2FzZSBGb2xsb3dNb2RlLkJMT0NLX0VYVEVSTkFMOiByZXR1cm4gU3ltbGlua0ZvbGxvd01vZGUuQkxPQ0tfRVhURVJOQUw7XG4gICAgY2FzZSBGb2xsb3dNb2RlLkVYVEVSTkFMOiByZXR1cm4gU3ltbGlua0ZvbGxvd01vZGUuRVhURVJOQUw7XG4gICAgZGVmYXVsdDpcbiAgICAgIHRocm93IG5ldyBFcnJvcihgdW5rbm93biBmb2xsb3cgbW9kZTogJHtmb2xsb3d9YCk7XG4gIH1cbn1cbiJdfQ==