"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Symlink follow mode.
 * @deprecated see `core.SymlinkFollowMode`
 */
var FollowMode;
(function (FollowMode) {
    /**
     * Never follow symlinks.
     */
    FollowMode["NEVER"] = "never";
    /**
     * Materialize all symlinks, whether they are internal or external to the source directory.
     */
    FollowMode["ALWAYS"] = "always";
    /**
     * Only follows symlinks that are external to the source directory.
     */
    FollowMode["EXTERNAL"] = "external";
    // ----------------- TODO::::::::::::::::::::::::::::::::::::::::::::
    /**
     * Forbids source from having any symlinks pointing outside of the source
     * tree.
     *
     * This is the safest mode of operation as it ensures that copy operations
     * won't materialize files from the user's file system. Internal symlinks are
     * not followed.
     *
     * If the copy operation runs into an external symlink, it will fail.
     */
    FollowMode["BLOCK_EXTERNAL"] = "internal-only";
})(FollowMode = exports.FollowMode || (exports.FollowMode = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZm9sbG93LW1vZGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJmb2xsb3ctbW9kZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7R0FHRztBQUNILElBQVksVUE0Qlg7QUE1QkQsV0FBWSxVQUFVO0lBQ3BCOztPQUVHO0lBQ0gsNkJBQWUsQ0FBQTtJQUVmOztPQUVHO0lBQ0gsK0JBQWlCLENBQUE7SUFFakI7O09BRUc7SUFDSCxtQ0FBcUIsQ0FBQTtJQUVyQixxRUFBcUU7SUFDckU7Ozs7Ozs7OztPQVNHO0lBQ0gsOENBQWdDLENBQUE7QUFDbEMsQ0FBQyxFQTVCVyxVQUFVLEdBQVYsa0JBQVUsS0FBVixrQkFBVSxRQTRCckIiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFN5bWxpbmsgZm9sbG93IG1vZGUuXG4gKiBAZGVwcmVjYXRlZCBzZWUgYGNvcmUuU3ltbGlua0ZvbGxvd01vZGVgXG4gKi9cbmV4cG9ydCBlbnVtIEZvbGxvd01vZGUge1xuICAvKipcbiAgICogTmV2ZXIgZm9sbG93IHN5bWxpbmtzLlxuICAgKi9cbiAgTkVWRVIgPSAnbmV2ZXInLFxuXG4gIC8qKlxuICAgKiBNYXRlcmlhbGl6ZSBhbGwgc3ltbGlua3MsIHdoZXRoZXIgdGhleSBhcmUgaW50ZXJuYWwgb3IgZXh0ZXJuYWwgdG8gdGhlIHNvdXJjZSBkaXJlY3RvcnkuXG4gICAqL1xuICBBTFdBWVMgPSAnYWx3YXlzJyxcblxuICAvKipcbiAgICogT25seSBmb2xsb3dzIHN5bWxpbmtzIHRoYXQgYXJlIGV4dGVybmFsIHRvIHRoZSBzb3VyY2UgZGlyZWN0b3J5LlxuICAgKi9cbiAgRVhURVJOQUwgPSAnZXh0ZXJuYWwnLFxuXG4gIC8vIC0tLS0tLS0tLS0tLS0tLS0tIFRPRE86Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6OlxuICAvKipcbiAgICogRm9yYmlkcyBzb3VyY2UgZnJvbSBoYXZpbmcgYW55IHN5bWxpbmtzIHBvaW50aW5nIG91dHNpZGUgb2YgdGhlIHNvdXJjZVxuICAgKiB0cmVlLlxuICAgKlxuICAgKiBUaGlzIGlzIHRoZSBzYWZlc3QgbW9kZSBvZiBvcGVyYXRpb24gYXMgaXQgZW5zdXJlcyB0aGF0IGNvcHkgb3BlcmF0aW9uc1xuICAgKiB3b24ndCBtYXRlcmlhbGl6ZSBmaWxlcyBmcm9tIHRoZSB1c2VyJ3MgZmlsZSBzeXN0ZW0uIEludGVybmFsIHN5bWxpbmtzIGFyZVxuICAgKiBub3QgZm9sbG93ZWQuXG4gICAqXG4gICAqIElmIHRoZSBjb3B5IG9wZXJhdGlvbiBydW5zIGludG8gYW4gZXh0ZXJuYWwgc3ltbGluaywgaXQgd2lsbCBmYWlsLlxuICAgKi9cbiAgQkxPQ0tfRVhURVJOQUwgPSAnaW50ZXJuYWwtb25seScsXG59XG4iXX0=