# coding: utf-8

"""
    Martlet Organization API

    Create/maintain organizations, access keys, addresses and permissions.   # noqa: E501

    OpenAPI spec version: 0.143.0
    Contact: apiteam@bmbix.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from bmb_martlet_organization_client.api_client import ApiClient


class OrganizationsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_address(self, body, organization_id, **kwargs):  # noqa: E501
        """Create an address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_address(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Address body: Address data (required)
        :param str organization_id: (required)
        :return: AddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_address_with_http_info(body, organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_address_with_http_info(body, organization_id, **kwargs)  # noqa: E501
            return data

    def create_address_with_http_info(self, body, organization_id, **kwargs):  # noqa: E501
        """Create an address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_address_with_http_info(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Address body: Address data (required)
        :param str organization_id: (required)
        :return: AddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_address`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `create_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/addresses', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_oauth2_client(self, body, organization_id, **kwargs):  # noqa: E501
        """Create an OAuth2 client  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_oauth2_client(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Oauth2ClientRequest body: Just name_from_user required (required)
        :param str organization_id: (required)
        :return: Oauth2ClientResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_oauth2_client_with_http_info(body, organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_oauth2_client_with_http_info(body, organization_id, **kwargs)  # noqa: E501
            return data

    def create_oauth2_client_with_http_info(self, body, organization_id, **kwargs):  # noqa: E501
        """Create an OAuth2 client  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_oauth2_client_with_http_info(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Oauth2ClientRequest body: Just name_from_user required (required)
        :param str organization_id: (required)
        :return: Oauth2ClientResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_oauth2_client" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_oauth2_client`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `create_oauth2_client`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/oauth2-clients', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Oauth2ClientResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_permission(self, body, organization_id, **kwargs):  # noqa: E501
        """Grant a permission.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_permission(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Permission body: Permission data (required)
        :param str organization_id: (required)
        :return: PermissionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_permission_with_http_info(body, organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_permission_with_http_info(body, organization_id, **kwargs)  # noqa: E501
            return data

    def create_permission_with_http_info(self, body, organization_id, **kwargs):  # noqa: E501
        """Grant a permission.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_permission_with_http_info(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Permission body: Permission data (required)
        :param str organization_id: (required)
        :return: PermissionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_permission" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_permission`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `create_permission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/permissions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermissionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_private_key(self, organization_id, **kwargs):  # noqa: E501
        """Rotate private key - create and store new key with life of 90 days.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_private_key(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: PrivateKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_private_key_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_private_key_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def create_private_key_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Rotate private key - create and store new key with life of 90 days.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_private_key_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: PrivateKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_private_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `create_private_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/private-keys', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PrivateKeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_proxy(self, body, organization_id, **kwargs):  # noqa: E501
        """[create] Create an organization proxy.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_proxy(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrganizationProxy body: Organization data (required)
        :param str organization_id: (required)
        :return: OrganizationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_proxy_with_http_info(body, organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_proxy_with_http_info(body, organization_id, **kwargs)  # noqa: E501
            return data

    def create_proxy_with_http_info(self, body, organization_id, **kwargs):  # noqa: E501
        """[create] Create an organization proxy.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_proxy_with_http_info(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrganizationProxy body: Organization data (required)
        :param str organization_id: (required)
        :return: OrganizationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_proxy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_proxy`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `create_proxy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/proxies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def define_message_content_type(self, body, organization_id, **kwargs):  # noqa: E501
        """Define a message content type for an organization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.define_message_content_type(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MessageContentType body: Message content type data (required)
        :param str organization_id: (required)
        :return: MessageContentTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.define_message_content_type_with_http_info(body, organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.define_message_content_type_with_http_info(body, organization_id, **kwargs)  # noqa: E501
            return data

    def define_message_content_type_with_http_info(self, body, organization_id, **kwargs):  # noqa: E501
        """Define a message content type for an organization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.define_message_content_type_with_http_info(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MessageContentType body: Message content type data (required)
        :param str organization_id: (required)
        :return: MessageContentTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method define_message_content_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `define_message_content_type`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `define_message_content_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/message-content-types', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageContentTypeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_oauth2_client(self, organization_id, oauth2_client_id, **kwargs):  # noqa: E501
        """Delete an individual Oauth2Client  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_oauth2_client(organization_id, oauth2_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str oauth2_client_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_oauth2_client_with_http_info(organization_id, oauth2_client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_oauth2_client_with_http_info(organization_id, oauth2_client_id, **kwargs)  # noqa: E501
            return data

    def delete_oauth2_client_with_http_info(self, organization_id, oauth2_client_id, **kwargs):  # noqa: E501
        """Delete an individual Oauth2Client  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_oauth2_client_with_http_info(organization_id, oauth2_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str oauth2_client_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'oauth2_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_oauth2_client" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `delete_oauth2_client`")  # noqa: E501
        # verify the required parameter 'oauth2_client_id' is set
        if ('oauth2_client_id' not in params or
                params['oauth2_client_id'] is None):
            raise ValueError("Missing the required parameter `oauth2_client_id` when calling `delete_oauth2_client`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501
        if 'oauth2_client_id' in params:
            path_params['oauth2_client_id'] = params['oauth2_client_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/oauth2-clients/{oauth2_client_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_permission(self, organization_id, permission_id, **kwargs):  # noqa: E501
        """Remove a permission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_permission(organization_id, permission_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str permission_id: (required)
        :return: PermissionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_permission_with_http_info(organization_id, permission_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_permission_with_http_info(organization_id, permission_id, **kwargs)  # noqa: E501
            return data

    def delete_permission_with_http_info(self, organization_id, permission_id, **kwargs):  # noqa: E501
        """Remove a permission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_permission_with_http_info(organization_id, permission_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str permission_id: (required)
        :return: PermissionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'permission_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_permission" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `delete_permission`")  # noqa: E501
        # verify the required parameter 'permission_id' is set
        if ('permission_id' not in params or
                params['permission_id'] is None):
            raise ValueError("Missing the required parameter `permission_id` when calling `delete_permission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501
        if 'permission_id' in params:
            path_params['permission_id'] = params['permission_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/permissions/{permission_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermissionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_proxy(self, organization_id, proxy_id, **kwargs):  # noqa: E501
        """[delete] Delete a proxy.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_proxy(organization_id, proxy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str proxy_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_proxy_with_http_info(organization_id, proxy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_proxy_with_http_info(organization_id, proxy_id, **kwargs)  # noqa: E501
            return data

    def delete_proxy_with_http_info(self, organization_id, proxy_id, **kwargs):  # noqa: E501
        """[delete] Delete a proxy.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_proxy_with_http_info(organization_id, proxy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str proxy_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'proxy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_proxy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `delete_proxy`")  # noqa: E501
        # verify the required parameter 'proxy_id' is set
        if ('proxy_id' not in params or
                params['proxy_id'] is None):
            raise ValueError("Missing the required parameter `proxy_id` when calling `delete_proxy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501
        if 'proxy_id' in params:
            path_params['proxy_id'] = params['proxy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/proxies/{proxy_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_billing_address_history(self, organization_id, **kwargs):  # noqa: E501
        """Gets the billing address history  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_billing_address_history(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: BillingAddressHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_billing_address_history_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_billing_address_history_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def get_billing_address_history_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Gets the billing address history  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_billing_address_history_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: BillingAddressHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_billing_address_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `get_billing_address_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/billing-addresses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BillingAddressHistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_current_billing_address(self, organization_id, **kwargs):  # noqa: E501
        """Gets the current billing address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_current_billing_address(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: BillingAddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_current_billing_address_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_current_billing_address_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def get_current_billing_address_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Gets the current billing address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_current_billing_address_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: BillingAddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_current_billing_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `get_current_billing_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/billing-addresses/current', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BillingAddressResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_message_content_type(self, organization_id, id, **kwargs):  # noqa: E501
        """get_message_content_type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_message_content_type(organization_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str id: (required)
        :return: MessageContentTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_message_content_type_with_http_info(organization_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_message_content_type_with_http_info(organization_id, id, **kwargs)  # noqa: E501
            return data

    def get_message_content_type_with_http_info(self, organization_id, id, **kwargs):  # noqa: E501
        """get_message_content_type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_message_content_type_with_http_info(organization_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str id: (required)
        :return: MessageContentTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_message_content_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `get_message_content_type`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_message_content_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/message-content-types/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageContentTypeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_organization_certificate(self, organization_id, **kwargs):  # noqa: E501
        """\"Get the certificate for an organization or a user.\"   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_certificate(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: CertificateObjResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_organization_certificate_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_organization_certificate_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def get_organization_certificate_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """\"Get the certificate for an organization or a user.\"   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_certificate_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: CertificateObjResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_certificate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `get_organization_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/certificate', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CertificateObjResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_proxy(self, organization_id, proxy_id, **kwargs):  # noqa: E501
        """[get_proxy] Get details of an individual proxy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_proxy(organization_id, proxy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str proxy_id: (required)
        :return: OrganizationProxyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_proxy_with_http_info(organization_id, proxy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_proxy_with_http_info(organization_id, proxy_id, **kwargs)  # noqa: E501
            return data

    def get_proxy_with_http_info(self, organization_id, proxy_id, **kwargs):  # noqa: E501
        """[get_proxy] Get details of an individual proxy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_proxy_with_http_info(organization_id, proxy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str proxy_id: (required)
        :return: OrganizationProxyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'proxy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_proxy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `get_proxy`")  # noqa: E501
        # verify the required parameter 'proxy_id' is set
        if ('proxy_id' not in params or
                params['proxy_id'] is None):
            raise ValueError("Missing the required parameter `proxy_id` when calling `get_proxy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501
        if 'proxy_id' in params:
            path_params['proxy_id'] = params['proxy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/proxies/{proxy_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationProxyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_public_key(self, organization_id, **kwargs):  # noqa: E501
        """Get the public key for a resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_public_key(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: PublicKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_public_key_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_public_key_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def get_public_key_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Get the public key for a resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_public_key_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: PublicKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `get_public_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/public-key', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PublicKeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_usage_report(self, organization_id, **kwargs):  # noqa: E501
        """Gets information to calculate current charges  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_usage_report(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: UsageReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_usage_report_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_usage_report_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def get_usage_report_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Gets information to calculate current charges  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_usage_report_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: UsageReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_usage_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `get_usage_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/usage-report', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UsageReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_addresses(self, organization_id, **kwargs):  # noqa: E501
        """list address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_addresses(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: AddressesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_addresses_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_addresses_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def list_addresses_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """list address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_addresses_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: AddressesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_addresses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `list_addresses`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/addresses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_message_content_types(self, organization_id, **kwargs):  # noqa: E501
        """list_message_content_types  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_message_content_types(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str query:
        :param float pointer:
        :param float limit:
        :return: MessageContentTypesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_message_content_types_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_message_content_types_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def list_message_content_types_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """list_message_content_types  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_message_content_types_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str query:
        :param float pointer:
        :param float limit:
        :return: MessageContentTypesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'query', 'pointer', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_message_content_types" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `list_message_content_types`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501
        if 'pointer' in params:
            query_params.append(('pointer', params['pointer']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/message-content-types', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageContentTypesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_oauth2_clients(self, organization_id, **kwargs):  # noqa: E501
        """Get the oauth2_clients for an organization.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_oauth2_clients(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: Oauth2ClientsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_oauth2_clients_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_oauth2_clients_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def list_oauth2_clients_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Get the oauth2_clients for an organization.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_oauth2_clients_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: Oauth2ClientsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_oauth2_clients" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `list_oauth2_clients`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/oauth2-clients', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Oauth2ClientsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_permissions(self, organization_id, **kwargs):  # noqa: E501
        """Get the permissions for an organization.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_permissions(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: PermissionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_permissions_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_permissions_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def list_permissions_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Get the permissions for an organization.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_permissions_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: PermissionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_permissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `list_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/permissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermissionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_private_keys(self, organization_id, **kwargs):  # noqa: E501
        """Get the private keys for a resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_private_keys(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: PrivateKeysResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_private_keys_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_private_keys_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def list_private_keys_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Get the private keys for a resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_private_keys_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: PrivateKeysResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_private_keys" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `list_private_keys`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/private-keys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PrivateKeysResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_proxies(self, organization_id, **kwargs):  # noqa: E501
        """[get_proxies ] Returns the proxies for this organization.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_proxies(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: OrganizationProxiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_proxies_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_proxies_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def list_proxies_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """[get_proxies ] Returns the proxies for this organization.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_proxies_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: OrganizationProxiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_proxies" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `list_proxies`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/proxies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationProxiesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch(self, body, organization_id, **kwargs):  # noqa: E501
        """Update organization object.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenericPatch body: Patch data (required)
        :param str organization_id: (required)
        :return: OrganizationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_with_http_info(body, organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_with_http_info(body, organization_id, **kwargs)  # noqa: E501
            return data

    def patch_with_http_info(self, body, organization_id, **kwargs):  # noqa: E501
        """Update organization object.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_with_http_info(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenericPatch body: Patch data (required)
        :param str organization_id: (required)
        :return: OrganizationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def select(self, organization_id, **kwargs):  # noqa: E501
        """Get details of an individual organization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.select(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: OrganizationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.select_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.select_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def select_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Get details of an individual organization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.select_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: OrganizationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method select" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `select`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_billing_address(self, body, organization_id, **kwargs):  # noqa: E501
        """Sets a new billing address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_billing_address(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillingAddressRequest body: Billing Address body (required)
        :param str organization_id: (required)
        :return: BillingAddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_billing_address_with_http_info(body, organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_billing_address_with_http_info(body, organization_id, **kwargs)  # noqa: E501
            return data

    def set_billing_address_with_http_info(self, body, organization_id, **kwargs):  # noqa: E501
        """Sets a new billing address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_billing_address_with_http_info(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillingAddressRequest body: Billing Address body (required)
        :param str organization_id: (required)
        :return: BillingAddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_billing_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_billing_address`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `set_billing_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/billing-addresses', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BillingAddressResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_icon(self, body, organization_id, **kwargs):  # noqa: E501
        """Set an icon for the organization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_icon(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Image body: Organization icon data (required)
        :param str organization_id: (required)
        :return: ImageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_icon_with_http_info(body, organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_icon_with_http_info(body, organization_id, **kwargs)  # noqa: E501
            return data

    def set_icon_with_http_info(self, body, organization_id, **kwargs):  # noqa: E501
        """Set an icon for the organization  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_icon_with_http_info(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Image body: Organization icon data (required)
        :param str organization_id: (required)
        :return: ImageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_icon" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_icon`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `set_icon`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/icon', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_organization_certificate(self, body, organization_id, **kwargs):  # noqa: E501
        """Upload a new X.509 identity certificate   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_organization_certificate(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Certificate body: Certificate data (required)
        :param str organization_id: (required)
        :return: CertificateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_organization_certificate_with_http_info(body, organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_organization_certificate_with_http_info(body, organization_id, **kwargs)  # noqa: E501
            return data

    def set_organization_certificate_with_http_info(self, body, organization_id, **kwargs):  # noqa: E501
        """Upload a new X.509 identity certificate   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_organization_certificate_with_http_info(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Certificate body: Certificate data (required)
        :param str organization_id: (required)
        :return: CertificateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_organization_certificate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_organization_certificate`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `set_organization_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/certificate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CertificateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_private_key(self, body, organization_id, private_key_id, **kwargs):  # noqa: E501
        """Update a private key.  set_rescinded ============= {   \"op\": \"replace\",   \"path\": \"/rescinded\",   \"value\": true }   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_private_key(body, organization_id, private_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenericPatch body: Private Key Patch (required)
        :param str organization_id: (required)
        :param str private_key_id: (required)
        :return: PrivateKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_private_key_with_http_info(body, organization_id, private_key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_private_key_with_http_info(body, organization_id, private_key_id, **kwargs)  # noqa: E501
            return data

    def update_private_key_with_http_info(self, body, organization_id, private_key_id, **kwargs):  # noqa: E501
        """Update a private key.  set_rescinded ============= {   \"op\": \"replace\",   \"path\": \"/rescinded\",   \"value\": true }   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_private_key_with_http_info(body, organization_id, private_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenericPatch body: Private Key Patch (required)
        :param str organization_id: (required)
        :param str private_key_id: (required)
        :return: PrivateKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_id', 'private_key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_private_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_private_key`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `update_private_key`")  # noqa: E501
        # verify the required parameter 'private_key_id' is set
        if ('private_key_id' not in params or
                params['private_key_id'] is None):
            raise ValueError("Missing the required parameter `private_key_id` when calling `update_private_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501
        if 'private_key_id' in params:
            path_params['private_key_id'] = params['private_key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/private-keys/{private_key_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PrivateKeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
