"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CertManager = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class CertManager extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const cluster_issuer_namespace_manifest = {
            apiVersion: 'v1',
            kind: 'Namespace',
            metadata: { name: 'aws-pca-issuer' },
        };
        const cert_issuer_namespace = props.cluster.addManifest('ClusterIssuerNamespaceManifest', cluster_issuer_namespace_manifest);
        const service_account = props.cluster.addServiceAccount('PrivateCASA');
        service_account.addToPrincipalPolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            resources: [props.privateCaArn],
            actions: [
                'acm-pca:Get*',
                'acm-pca:Issue*',
                'acm-pca:Describe*',
            ],
        }));
        // TODO : Dont know why, but pod SA still wants node to lookup Describe* calls on PCA
        props.nodegroup.role.addToPrincipalPolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            resources: [props.privateCaArn],
            actions: [
                'acm-pca:Get*',
                'acm-pca:Issue*',
                'acm-pca:Describe*',
            ],
        }));
        service_account.node.addDependency(cert_issuer_namespace);
        const deploy_cert_manager = props.cluster.addHelmChart('CertManager', {
            repository: 'https://charts.jetstack.io',
            chart: 'cert-manager',
            namespace: 'cert-manager',
            release: 'cert-manager',
            wait: true,
            version: 'v1.5.0',
            values: {
                installCRDs: true,
                webhook: {
                    timeoutSeconds: 30,
                },
            },
        });
        const priv_ca_issuer_helm = props.cluster.addHelmChart('PrivateCaIssuer', {
            repository: 'https://cert-manager.github.io/aws-privateca-issuer',
            chart: 'aws-pca-issuer',
            namespace: 'aws-pca-issuer',
            release: 'aws-pca-issuer',
            wait: true,
            values: {
                serviceAccount: {
                    create: 'false',
                    name: service_account.serviceAccountName,
                },
            },
        });
        priv_ca_issuer_helm.node.addDependency(deploy_cert_manager);
        const deploy_waiter = props.cluster.addHelmChart('DummyWaiterPostCertManager', {
            repository: 'https://anshrma.github.io/helm-charts',
            chart: 'helm-waiter',
            // namespace: 'default',
            release: 'helm-waiter',
            wait: true,
        });
        deploy_waiter.node.addDependency(priv_ca_issuer_helm);
        const cluster_issuer_manifest = {
            apiVersion: 'awspca.cert-manager.io/v1beta1',
            kind: 'AWSPCAClusterIssuer',
            metadata: { name: props.clusterIssuerName },
            spec: {
                arn: props.privateCaArn,
                // arn: cfnCertificateAuthority.attrArn,
                region: aws_cdk_lib_1.Stack.of(this).region,
            },
        };
        const cluster_issuer = props.cluster.addManifest('ClusterIssuerManifest', cluster_issuer_manifest);
        cluster_issuer.node.addDependency(deploy_waiter);
        const namespace_manifest = {
            apiVersion: 'v1',
            kind: 'Namespace',
            metadata: { name: props.namespace },
        };
        const ns = props.cluster.addManifest('NSManifests', namespace_manifest);
        const cert_manifest = {
            apiVersion: 'cert-manager.io/v1',
            kind: 'Certificate',
            metadata: {
                name: props.cacertname,
                namespace: props.namespace,
            },
            spec: {
                commonName: props.hostedZoneName,
                dnsNames: props.dnsNames,
                duration: '2160h0m0s',
                issuerRef: {
                    group: 'awspca.cert-manager.io',
                    kind: 'AWSPCAClusterIssuer',
                    name: props.clusterIssuerName,
                },
                renewBefore: '360h0m0s',
                secretName: `${props.clusterIssuerName}-secret`,
                usages: [
                    'server auth',
                    'client auth',
                ],
                privateKey: {
                    algorithm: 'RSA',
                    size: 2048,
                },
            },
        };
        const cert = props.cluster.addManifest('CertManifests', cert_manifest);
        cert.node.addDependency(ns, cluster_issuer);
    }
}
exports.CertManager = CertManager;
_a = JSII_RTTI_SYMBOL_1;
CertManager[_a] = { fqn: "kong-core.CertManager", version: "2.0.6" };
//# sourceMappingURL=data:application/json;base64,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