"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElastiCacheStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class ElastiCacheStack extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const logGroup = new aws_cdk_lib_1.aws_logs.LogGroup(this, 'LogGroup', {
            retention: Infinity,
        });
        let privatesubnets = [];
        props.vpc.privateSubnets.forEach(function (value) {
            privatesubnets.push(value.subnetId);
        });
        const redisSubnetGroup = new aws_cdk_lib_1.aws_elasticache.CfnSubnetGroup(this, 'RedisClusterPrivateSubnetGroup', {
            subnetIds: privatesubnets,
            description: 'private subnet group for kong cache',
        });
        // redisSubnetGroup.cacheSubnetGroupName = redisSubnetGroup.ref;
        const redisReplication = new aws_cdk_lib_1.aws_elasticache.CfnReplicationGroup(this, 'RedisReplicaGroup', {
            engine: 'redis',
            cacheNodeType: 'cache.m6g.large',
            replicasPerNodeGroup: 1,
            numNodeGroups: props.numberofnodegroups,
            automaticFailoverEnabled: true,
            autoMinorVersionUpgrade: true,
            replicationGroupDescription: 'kong redis cluster group',
            cacheSubnetGroupName: redisSubnetGroup.ref,
            atRestEncryptionEnabled: true,
            multiAzEnabled: true,
            logDeliveryConfigurations: [{
                    destinationDetails: {
                        cloudWatchLogsDetails: {
                            logGroup: logGroup.logGroupName,
                        },
                    },
                    destinationType: 'cloudwatch-logs',
                    logFormat: 'json',
                    logType: 'slow-log',
                }],
        });
        redisReplication.addDependsOn(redisSubnetGroup);
        new aws_cdk_lib_1.CfnOutput(this, 'CacheConfigEndpointOutput', { value: redisReplication.attrConfigurationEndPointAddress });
    }
}
exports.ElastiCacheStack = ElastiCacheStack;
_a = JSII_RTTI_SYMBOL_1;
ElastiCacheStack[_a] = { fqn: "kong-core.ElastiCacheStack", version: "2.0.6" };
//# sourceMappingURL=data:application/json;base64,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