"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExternalDns = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class ExternalDns extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const service_account_external_dns = props.cluster.addServiceAccount('ExternalDns');
        service_account_external_dns.addToPrincipalPolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            resources: ['*'],
            actions: [
                'route53:*',
            ],
        }));
        props.cluster.addHelmChart('ExternalDnsHelm', {
            repository: 'https://kubernetes-sigs.github.io/external-dns/',
            chart: 'external-dns',
            // namespace: 'external-dns',
            release: 'external-dns',
            wait: true,
            values: {
                provider: 'aws',
                policy: 'sync',
                aws: {
                    region: aws_cdk_lib_1.Stack.of(this).region,
                    zoneType: 'private',
                },
                triggerLoopOnEvent: true,
                interval: '5m',
                // domainFilters: [
                //   hosted_zone.zoneName,
                // ],
                serviceAccount: {
                    create: false,
                    name: service_account_external_dns.serviceAccountName,
                },
            },
        });
    }
}
exports.ExternalDns = ExternalDns;
_a = JSII_RTTI_SYMBOL_1;
ExternalDns[_a] = { fqn: "kong-core.ExternalDns", version: "2.0.6" };
//# sourceMappingURL=data:application/json;base64,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