import { aws_rds, aws_eks } from 'aws-cdk-lib';
export interface KongEksControlPlaneProps {
    /**
      * @summary Name of the hosted zone
      */
    readonly hostedZoneName: string;
    /**
   * @summary Kubernetes Namespace to install Kong Control Plane
   */
    readonly namespace: string;
    /**
      * @summary Name of the Secret in AWS Secrets Manager
      */
    readonly licenseSecretsName: string;
    /**
       * @summary Control Plane EKS Cluster properties
       * @see https://docs.aws.amazon.com/cdk/api/latest/docs/@aws-cdk_aws-eks.ClusterProps.html
       */
    readonly controlPlaneClusterProps: aws_eks.ClusterProps;
    /**
       * @summary Data Plane EKS Cluster properties
       * @see https://docs.aws.amazon.com/cdk/api/latest/docs/@aws-cdk_aws-eks.ClusterProps.html
       */
    /**
       * @summary RDS Database properties
       */
    readonly rdsProps: RdsDatabaseProps;
    /**
       * @summary Kong Control Plane EKS Nodes properties
       * @see https://docs.aws.amazon.com/cdk/api/latest/docs/@aws-cdk_aws-eks.AutoScalingGroupCapacityOptions.html
       */
    readonly controlPlaneNodeProps: aws_eks.NodegroupOptions;
}
export interface RdsDatabaseProps {
    /**
       * @summary RDS PostGres Engine Version
       * @see https://docs.aws.amazon.com/cdk/api/latest/docs/@aws-cdk_aws-rds.PostgresEngineVersion.html
       */
    readonly postgresversion: aws_rds.PostgresEngineVersion;
    /**
       * @summary Master username to be used for RDS
       */
    readonly username: string;
    /**
       * @summary Database name to be used for Artifactory
       */
    readonly databasename: string;
}
