import { aws_eks } from 'aws-cdk-lib';
export interface KongEksDataPlaneProps {
    /**
       * @summary Control Plane EKS Cluster properties
       * @see https://docs.aws.amazon.com/cdk/api/latest/docs/@aws-cdk_aws-eks.ClusterProps.html
       */
    readonly dataPlaneClusterProps: aws_eks.ClusterProps;
    /**
       * @summary Data Plane EKS Cluster properties
       * @see https://docs.aws.amazon.com/cdk/api/latest/docs/@aws-cdk_aws-eks.ClusterProps.html
       */
    /**
       * @summary Kong Data Plane EKS Nodes properties
       * @see https://docs.aws.amazon.com/cdk/api/latest/docs/@aws-cdk_aws-eks.AutoScalingGroupCapacityOptions.html
       */
    /**
      * @summary Name of the Secret in AWS Secrets Manager
      */
    readonly licenseSecretsName: string;
    readonly dataPlaneNodeProps: aws_eks.NodegroupOptions;
    readonly clusterDns: String;
    readonly telemetryDns: String;
    readonly privateCaArn: string;
}
