"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RdsStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class RdsStack extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.kongPostgresSql = new aws_cdk_lib_1.aws_rds.DatabaseInstance(this, 'PGInstance', {
            engine: aws_cdk_lib_1.aws_rds.DatabaseInstanceEngine.postgres({
                version: props.postgresversion,
            }),
            deletionProtection: false,
            instanceType: aws_cdk_lib_1.aws_ec2.InstanceType.of(aws_cdk_lib_1.aws_ec2.InstanceClass.M4, aws_cdk_lib_1.aws_ec2.InstanceSize.LARGE),
            vpc: props.vpc,
            databaseName: props.databasename,
            // maxAllocatedStorage : 10,
            multiAz: true,
            credentials: {
                username: props.username,
            },
        });
        this.kongPostgresSql.connections.allowDefaultPortFrom(aws_cdk_lib_1.aws_ec2.Peer.ipv4(props.vpc.vpcCidrBlock));
        // new CfnOutput(this, 'SMArnOutput', { value: this.kong_postgres_sql.secret?.secretArn! });
        // new CfnOutput(this, 'PGOutput', { value: this.kong_postgres_sql.dbInstanceEndpointAddress });
    }
}
exports.RdsStack = RdsStack;
_a = JSII_RTTI_SYMBOL_1;
RdsStack[_a] = { fqn: "kong-core.RdsStack", version: "2.0.6" };
//# sourceMappingURL=data:application/json;base64,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