"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretsManager = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class SecretsManager extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // TODO : Dont know why, but pod SA still wants node to lookup Describe* calls on PCA
        props.nodegroup.role.addToPrincipalPolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            resources: ['*'],
            actions: [
                'secretsmanager:GetResourcePolicy',
                'secretsmanager:GetSecretValue',
                'secretsmanager:DescribeSecret',
                'secretsmanager:ListSecretVersionIds',
            ],
        }));
        props.cluster.addHelmChart('ExternalSecretsHandler', {
            repository: 'https://external-secrets.github.io/kubernetes-external-secrets/',
            chart: 'kubernetes-external-secrets',
            release: 'kubernetes-external-secrets',
            namespace: props.namespace,
            wait: true,
            values: {
                securityContext: {
                    fsGroup: 65534,
                },
                env: {
                    AWS_REGION: aws_cdk_lib_1.Stack.of(this).region,
                },
            },
        });
    }
}
exports.SecretsManager = SecretsManager;
_a = JSII_RTTI_SYMBOL_1;
SecretsManager[_a] = { fqn: "kong-core.SecretsManager", version: "2.0.6" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2VjcmV0cy1tYW5hZ2VyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3NlY3JldHMtbWFuYWdlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZDQUFzRDtBQUN0RCwyQ0FBdUM7QUFTdkMsTUFBYSxjQUFlLFNBQVEsc0JBQVM7SUFFM0MsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEwQjtRQUNsRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLHFGQUFxRjtRQUVyRixLQUFLLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLHFCQUFPLENBQUMsZUFBZSxDQUFDO1lBQ3BFLFNBQVMsRUFBRSxDQUFDLEdBQUcsQ0FBQztZQUNoQixPQUFPLEVBQUU7Z0JBQ1Asa0NBQWtDO2dCQUNsQywrQkFBK0I7Z0JBQy9CLCtCQUErQjtnQkFDL0IscUNBQXFDO2FBQ3RDO1NBQ0YsQ0FBQyxDQUFDLENBQUM7UUFFSixLQUFLLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQyx3QkFBd0IsRUFBRTtZQUNuRCxVQUFVLEVBQUUsaUVBQWlFO1lBQzdFLEtBQUssRUFBRSw2QkFBNkI7WUFDcEMsT0FBTyxFQUFFLDZCQUE2QjtZQUN0QyxTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7WUFDMUIsSUFBSSxFQUFFLElBQUk7WUFDVixNQUFNLEVBQUU7Z0JBQ04sZUFBZSxFQUFFO29CQUNmLE9BQU8sRUFBRSxLQUFLO2lCQUNmO2dCQUNELEdBQUcsRUFBRTtvQkFDSCxVQUFVLEVBQUUsbUJBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBTTtpQkFFbEM7YUFNRjtTQUNGLENBQUMsQ0FBQztJQUdMLENBQUM7O0FBeENILHdDQXlDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFN0YWNrLCBhd3NfaWFtLCBhd3NfZWtzIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cblxuZXhwb3J0IGludGVyZmFjZSBTZWNyZXRzTWFuYWdlclByb3BzIHtcbiAgcmVhZG9ubHkgY2x1c3RlciA6IGF3c19la3MuQ2x1c3RlcjtcbiAgcmVhZG9ubHkgbm9kZWdyb3VwIDogYXdzX2Vrcy5Ob2RlZ3JvdXA7XG4gIHJlYWRvbmx5IG5hbWVzcGFjZTogc3RyaW5nO1xufVxuXG5leHBvcnQgY2xhc3MgU2VjcmV0c01hbmFnZXIgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBTZWNyZXRzTWFuYWdlclByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIC8vIFRPRE8gOiBEb250IGtub3cgd2h5LCBidXQgcG9kIFNBIHN0aWxsIHdhbnRzIG5vZGUgdG8gbG9va3VwIERlc2NyaWJlKiBjYWxscyBvbiBQQ0FcblxuICAgIHByb3BzLm5vZGVncm91cC5yb2xlLmFkZFRvUHJpbmNpcGFsUG9saWN5KG5ldyBhd3NfaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICByZXNvdXJjZXM6IFsnKiddLFxuICAgICAgYWN0aW9uczogW1xuICAgICAgICAnc2VjcmV0c21hbmFnZXI6R2V0UmVzb3VyY2VQb2xpY3knLFxuICAgICAgICAnc2VjcmV0c21hbmFnZXI6R2V0U2VjcmV0VmFsdWUnLFxuICAgICAgICAnc2VjcmV0c21hbmFnZXI6RGVzY3JpYmVTZWNyZXQnLFxuICAgICAgICAnc2VjcmV0c21hbmFnZXI6TGlzdFNlY3JldFZlcnNpb25JZHMnLFxuICAgICAgXSxcbiAgICB9KSk7XG5cbiAgICBwcm9wcy5jbHVzdGVyLmFkZEhlbG1DaGFydCgnRXh0ZXJuYWxTZWNyZXRzSGFuZGxlcicsIHtcbiAgICAgIHJlcG9zaXRvcnk6ICdodHRwczovL2V4dGVybmFsLXNlY3JldHMuZ2l0aHViLmlvL2t1YmVybmV0ZXMtZXh0ZXJuYWwtc2VjcmV0cy8nLFxuICAgICAgY2hhcnQ6ICdrdWJlcm5ldGVzLWV4dGVybmFsLXNlY3JldHMnLFxuICAgICAgcmVsZWFzZTogJ2t1YmVybmV0ZXMtZXh0ZXJuYWwtc2VjcmV0cycsXG4gICAgICBuYW1lc3BhY2U6IHByb3BzLm5hbWVzcGFjZSxcbiAgICAgIHdhaXQ6IHRydWUsXG4gICAgICB2YWx1ZXM6IHtcbiAgICAgICAgc2VjdXJpdHlDb250ZXh0OiB7XG4gICAgICAgICAgZnNHcm91cDogNjU1MzQsXG4gICAgICAgIH0sXG4gICAgICAgIGVudjoge1xuICAgICAgICAgIEFXU19SRUdJT046IFN0YWNrLm9mKHRoaXMpLnJlZ2lvbixcbiAgICAgICAgICAvLyBESVNBQkxFX1BPTExJTkc6IHRydWUsXG4gICAgICAgIH0sXG4gICAgICAgIC8vIHNlcnZpY2VBY2NvdW50OiB7XG4gICAgICAgIC8vICAgYW5ub3RhdGlvbnM6IHtcbiAgICAgICAgLy8gICAgICdla3MuYW1hem9uYXdzLmNvbS9yb2xlLWFybic6IHNlcnZpY2VfYWNjb3VudC5yb2xlLnJvbGVBcm4sXG4gICAgICAgIC8vICAgfSxcbiAgICAgICAgLy8gfSxcbiAgICAgIH0sXG4gICAgfSk7XG5cblxuICB9XG59Il19