# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EnabledProtocols(Model):
    """Class to specify which protocols are enabled.

    All required parameters must be populated in order to send to Azure.

    :param download: Required. Enable Download protocol or not
    :type download: bool
    :param dash: Required. Enable Dash protocol or not
    :type dash: bool
    :param hls: Required. Enable Hls protocol or not
    :type hls: bool
    :param smooth_streaming: Required. Enable SmoothStreaming protocol or not
    :type smooth_streaming: bool
    """

    _validation = {
        'download': {'required': True},
        'dash': {'required': True},
        'hls': {'required': True},
        'smooth_streaming': {'required': True},
    }

    _attribute_map = {
        'download': {'key': 'download', 'type': 'bool'},
        'dash': {'key': 'dash', 'type': 'bool'},
        'hls': {'key': 'hls', 'type': 'bool'},
        'smooth_streaming': {'key': 'smoothStreaming', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(EnabledProtocols, self).__init__(**kwargs)
        self.download = kwargs.get('download', None)
        self.dash = kwargs.get('dash', None)
        self.hls = kwargs.get('hls', None)
        self.smooth_streaming = kwargs.get('smooth_streaming', None)
