# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class StreamingLocatorContentKey(Model):
    """Class for content key in Streaming Locator.

    All required parameters must be populated in order to send to Azure.

    :param label: Label of Content Key
    :type label: str
    :param type: Required. Encryption type of Content Key. Possible values
     include: 'CommonEncryptionCenc', 'CommonEncryptionCbcs',
     'EnvelopeEncryption'
    :type type: str or ~azure.mgmt.media.models.StreamingLocatorContentKeyType
    :param id: Required. ID of Content Key
    :type id: str
    :param value: Value of  of Content Key
    :type value: str
    :param policy_name: ContentKeyPolicy used by Content Key
    :type policy_name: str
    :param tracks: Tracks which use this Content Key
    :type tracks: list[~azure.mgmt.media.models.TrackSelection]
    """

    _validation = {
        'type': {'required': True},
        'id': {'required': True},
    }

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'type': {'key': 'type', 'type': 'StreamingLocatorContentKeyType'},
        'id': {'key': 'id', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'tracks': {'key': 'tracks', 'type': '[TrackSelection]'},
    }

    def __init__(self, **kwargs):
        super(StreamingLocatorContentKey, self).__init__(**kwargs)
        self.label = kwargs.get('label', None)
        self.type = kwargs.get('type', None)
        self.id = kwargs.get('id', None)
        self.value = kwargs.get('value', None)
        self.policy_name = kwargs.get('policy_name', None)
        self.tracks = kwargs.get('tracks', None)
