# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlbVirtualHostArgs', 'AlbVirtualHost']

@pulumi.input_type
class AlbVirtualHostArgs:
    def __init__(__self__, *,
                 http_router_id: pulumi.Input[str],
                 authorities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 modify_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostModifyRequestHeaderArgs']]]] = None,
                 modify_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostModifyResponseHeaderArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rate_limit: Optional[pulumi.Input['AlbVirtualHostRateLimitArgs']] = None,
                 route_options: Optional[pulumi.Input['AlbVirtualHostRouteOptionsArgs']] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostRouteArgs']]]] = None):
        """
        The set of arguments for constructing a AlbVirtualHost resource.
        :param pulumi.Input[str] http_router_id: The ID of the HTTP router to which the virtual host belongs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorities: A list of domains (host/authority header) that will be matched to this virtual host. Wildcard hosts are supported in the form of '*.foo.com' or '*-bar.foo.com'. If not specified, all domains will be matched.
        :param pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostModifyRequestHeaderArgs']]] modify_request_headers: Apply the following modifications to the request headers. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostModifyResponseHeaderArgs']]] modify_response_headers: Apply the following modifications to the response headers. The structure is documented below.
        :param pulumi.Input[str] name: name of the header to modify.
        :param pulumi.Input['AlbVirtualHostRateLimitArgs'] rate_limit: Rate limit configuration applied for a whole virtual host
        :param pulumi.Input['AlbVirtualHostRouteOptionsArgs'] route_options: Route options for the virtual host. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostRouteArgs']]] routes: A Route resource. Routes are matched *in-order*. Be careful when adding them to the end. For instance, having http '/' match first makes all other routes unused. The structure is documented below.
        """
        pulumi.set(__self__, "http_router_id", http_router_id)
        if authorities is not None:
            pulumi.set(__self__, "authorities", authorities)
        if modify_request_headers is not None:
            pulumi.set(__self__, "modify_request_headers", modify_request_headers)
        if modify_response_headers is not None:
            pulumi.set(__self__, "modify_response_headers", modify_response_headers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)
        if route_options is not None:
            pulumi.set(__self__, "route_options", route_options)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter(name="httpRouterId")
    def http_router_id(self) -> pulumi.Input[str]:
        """
        The ID of the HTTP router to which the virtual host belongs.
        """
        return pulumi.get(self, "http_router_id")

    @http_router_id.setter
    def http_router_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "http_router_id", value)

    @property
    @pulumi.getter
    def authorities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of domains (host/authority header) that will be matched to this virtual host. Wildcard hosts are supported in the form of '*.foo.com' or '*-bar.foo.com'. If not specified, all domains will be matched.
        """
        return pulumi.get(self, "authorities")

    @authorities.setter
    def authorities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "authorities", value)

    @property
    @pulumi.getter(name="modifyRequestHeaders")
    def modify_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostModifyRequestHeaderArgs']]]]:
        """
        Apply the following modifications to the request headers. The structure is documented below.
        """
        return pulumi.get(self, "modify_request_headers")

    @modify_request_headers.setter
    def modify_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostModifyRequestHeaderArgs']]]]):
        pulumi.set(self, "modify_request_headers", value)

    @property
    @pulumi.getter(name="modifyResponseHeaders")
    def modify_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostModifyResponseHeaderArgs']]]]:
        """
        Apply the following modifications to the response headers. The structure is documented below.
        """
        return pulumi.get(self, "modify_response_headers")

    @modify_response_headers.setter
    def modify_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostModifyResponseHeaderArgs']]]]):
        pulumi.set(self, "modify_response_headers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the header to modify.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional[pulumi.Input['AlbVirtualHostRateLimitArgs']]:
        """
        Rate limit configuration applied for a whole virtual host
        """
        return pulumi.get(self, "rate_limit")

    @rate_limit.setter
    def rate_limit(self, value: Optional[pulumi.Input['AlbVirtualHostRateLimitArgs']]):
        pulumi.set(self, "rate_limit", value)

    @property
    @pulumi.getter(name="routeOptions")
    def route_options(self) -> Optional[pulumi.Input['AlbVirtualHostRouteOptionsArgs']]:
        """
        Route options for the virtual host. The structure is documented below.
        """
        return pulumi.get(self, "route_options")

    @route_options.setter
    def route_options(self, value: Optional[pulumi.Input['AlbVirtualHostRouteOptionsArgs']]):
        pulumi.set(self, "route_options", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostRouteArgs']]]]:
        """
        A Route resource. Routes are matched *in-order*. Be careful when adding them to the end. For instance, having http '/' match first makes all other routes unused. The structure is documented below.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostRouteArgs']]]]):
        pulumi.set(self, "routes", value)


@pulumi.input_type
class _AlbVirtualHostState:
    def __init__(__self__, *,
                 authorities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 http_router_id: Optional[pulumi.Input[str]] = None,
                 modify_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostModifyRequestHeaderArgs']]]] = None,
                 modify_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostModifyResponseHeaderArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rate_limit: Optional[pulumi.Input['AlbVirtualHostRateLimitArgs']] = None,
                 route_options: Optional[pulumi.Input['AlbVirtualHostRouteOptionsArgs']] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostRouteArgs']]]] = None):
        """
        Input properties used for looking up and filtering AlbVirtualHost resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorities: A list of domains (host/authority header) that will be matched to this virtual host. Wildcard hosts are supported in the form of '*.foo.com' or '*-bar.foo.com'. If not specified, all domains will be matched.
        :param pulumi.Input[str] http_router_id: The ID of the HTTP router to which the virtual host belongs.
        :param pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostModifyRequestHeaderArgs']]] modify_request_headers: Apply the following modifications to the request headers. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostModifyResponseHeaderArgs']]] modify_response_headers: Apply the following modifications to the response headers. The structure is documented below.
        :param pulumi.Input[str] name: name of the header to modify.
        :param pulumi.Input['AlbVirtualHostRateLimitArgs'] rate_limit: Rate limit configuration applied for a whole virtual host
        :param pulumi.Input['AlbVirtualHostRouteOptionsArgs'] route_options: Route options for the virtual host. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostRouteArgs']]] routes: A Route resource. Routes are matched *in-order*. Be careful when adding them to the end. For instance, having http '/' match first makes all other routes unused. The structure is documented below.
        """
        if authorities is not None:
            pulumi.set(__self__, "authorities", authorities)
        if http_router_id is not None:
            pulumi.set(__self__, "http_router_id", http_router_id)
        if modify_request_headers is not None:
            pulumi.set(__self__, "modify_request_headers", modify_request_headers)
        if modify_response_headers is not None:
            pulumi.set(__self__, "modify_response_headers", modify_response_headers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)
        if route_options is not None:
            pulumi.set(__self__, "route_options", route_options)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter
    def authorities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of domains (host/authority header) that will be matched to this virtual host. Wildcard hosts are supported in the form of '*.foo.com' or '*-bar.foo.com'. If not specified, all domains will be matched.
        """
        return pulumi.get(self, "authorities")

    @authorities.setter
    def authorities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "authorities", value)

    @property
    @pulumi.getter(name="httpRouterId")
    def http_router_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the HTTP router to which the virtual host belongs.
        """
        return pulumi.get(self, "http_router_id")

    @http_router_id.setter
    def http_router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_router_id", value)

    @property
    @pulumi.getter(name="modifyRequestHeaders")
    def modify_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostModifyRequestHeaderArgs']]]]:
        """
        Apply the following modifications to the request headers. The structure is documented below.
        """
        return pulumi.get(self, "modify_request_headers")

    @modify_request_headers.setter
    def modify_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostModifyRequestHeaderArgs']]]]):
        pulumi.set(self, "modify_request_headers", value)

    @property
    @pulumi.getter(name="modifyResponseHeaders")
    def modify_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostModifyResponseHeaderArgs']]]]:
        """
        Apply the following modifications to the response headers. The structure is documented below.
        """
        return pulumi.get(self, "modify_response_headers")

    @modify_response_headers.setter
    def modify_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostModifyResponseHeaderArgs']]]]):
        pulumi.set(self, "modify_response_headers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the header to modify.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional[pulumi.Input['AlbVirtualHostRateLimitArgs']]:
        """
        Rate limit configuration applied for a whole virtual host
        """
        return pulumi.get(self, "rate_limit")

    @rate_limit.setter
    def rate_limit(self, value: Optional[pulumi.Input['AlbVirtualHostRateLimitArgs']]):
        pulumi.set(self, "rate_limit", value)

    @property
    @pulumi.getter(name="routeOptions")
    def route_options(self) -> Optional[pulumi.Input['AlbVirtualHostRouteOptionsArgs']]:
        """
        Route options for the virtual host. The structure is documented below.
        """
        return pulumi.get(self, "route_options")

    @route_options.setter
    def route_options(self, value: Optional[pulumi.Input['AlbVirtualHostRouteOptionsArgs']]):
        pulumi.set(self, "route_options", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostRouteArgs']]]]:
        """
        A Route resource. Routes are matched *in-order*. Be careful when adding them to the end. For instance, having http '/' match first makes all other routes unused. The structure is documented below.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlbVirtualHostRouteArgs']]]]):
        pulumi.set(self, "routes", value)


class AlbVirtualHost(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 http_router_id: Optional[pulumi.Input[str]] = None,
                 modify_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlbVirtualHostModifyRequestHeaderArgs', 'AlbVirtualHostModifyRequestHeaderArgsDict']]]]] = None,
                 modify_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlbVirtualHostModifyResponseHeaderArgs', 'AlbVirtualHostModifyResponseHeaderArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rate_limit: Optional[pulumi.Input[Union['AlbVirtualHostRateLimitArgs', 'AlbVirtualHostRateLimitArgsDict']]] = None,
                 route_options: Optional[pulumi.Input[Union['AlbVirtualHostRouteOptionsArgs', 'AlbVirtualHostRouteOptionsArgsDict']]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlbVirtualHostRouteArgs', 'AlbVirtualHostRouteArgsDict']]]]] = None,
                 __props__=None):
        """
        Creates a virtual host that belongs to specified HTTP router and adds the specified routes to it. For more information, see [the official documentation](https://yandex.cloud/docs/application-load-balancer/concepts/http-router).

        ## Example Usage

        {{ tffile "examples/alb_virtual_host/r_alb_virtual_host_1.tf" }}

        ## Import

        A virtual host can be imported using the `id` of the resource, which for a virtual host is defined as its http router id separated by `/` from the virtual host's name, e.g.:

        ```sh
        $ pulumi import yandex:index/albVirtualHost:AlbVirtualHost default http_router_id/vhost_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorities: A list of domains (host/authority header) that will be matched to this virtual host. Wildcard hosts are supported in the form of '*.foo.com' or '*-bar.foo.com'. If not specified, all domains will be matched.
        :param pulumi.Input[str] http_router_id: The ID of the HTTP router to which the virtual host belongs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlbVirtualHostModifyRequestHeaderArgs', 'AlbVirtualHostModifyRequestHeaderArgsDict']]]] modify_request_headers: Apply the following modifications to the request headers. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlbVirtualHostModifyResponseHeaderArgs', 'AlbVirtualHostModifyResponseHeaderArgsDict']]]] modify_response_headers: Apply the following modifications to the response headers. The structure is documented below.
        :param pulumi.Input[str] name: name of the header to modify.
        :param pulumi.Input[Union['AlbVirtualHostRateLimitArgs', 'AlbVirtualHostRateLimitArgsDict']] rate_limit: Rate limit configuration applied for a whole virtual host
        :param pulumi.Input[Union['AlbVirtualHostRouteOptionsArgs', 'AlbVirtualHostRouteOptionsArgsDict']] route_options: Route options for the virtual host. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlbVirtualHostRouteArgs', 'AlbVirtualHostRouteArgsDict']]]] routes: A Route resource. Routes are matched *in-order*. Be careful when adding them to the end. For instance, having http '/' match first makes all other routes unused. The structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlbVirtualHostArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a virtual host that belongs to specified HTTP router and adds the specified routes to it. For more information, see [the official documentation](https://yandex.cloud/docs/application-load-balancer/concepts/http-router).

        ## Example Usage

        {{ tffile "examples/alb_virtual_host/r_alb_virtual_host_1.tf" }}

        ## Import

        A virtual host can be imported using the `id` of the resource, which for a virtual host is defined as its http router id separated by `/` from the virtual host's name, e.g.:

        ```sh
        $ pulumi import yandex:index/albVirtualHost:AlbVirtualHost default http_router_id/vhost_name
        ```

        :param str resource_name: The name of the resource.
        :param AlbVirtualHostArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlbVirtualHostArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 http_router_id: Optional[pulumi.Input[str]] = None,
                 modify_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlbVirtualHostModifyRequestHeaderArgs', 'AlbVirtualHostModifyRequestHeaderArgsDict']]]]] = None,
                 modify_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlbVirtualHostModifyResponseHeaderArgs', 'AlbVirtualHostModifyResponseHeaderArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rate_limit: Optional[pulumi.Input[Union['AlbVirtualHostRateLimitArgs', 'AlbVirtualHostRateLimitArgsDict']]] = None,
                 route_options: Optional[pulumi.Input[Union['AlbVirtualHostRouteOptionsArgs', 'AlbVirtualHostRouteOptionsArgsDict']]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlbVirtualHostRouteArgs', 'AlbVirtualHostRouteArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlbVirtualHostArgs.__new__(AlbVirtualHostArgs)

            __props__.__dict__["authorities"] = authorities
            if http_router_id is None and not opts.urn:
                raise TypeError("Missing required property 'http_router_id'")
            __props__.__dict__["http_router_id"] = http_router_id
            __props__.__dict__["modify_request_headers"] = modify_request_headers
            __props__.__dict__["modify_response_headers"] = modify_response_headers
            __props__.__dict__["name"] = name
            __props__.__dict__["rate_limit"] = rate_limit
            __props__.__dict__["route_options"] = route_options
            __props__.__dict__["routes"] = routes
        super(AlbVirtualHost, __self__).__init__(
            'yandex:index/albVirtualHost:AlbVirtualHost',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            http_router_id: Optional[pulumi.Input[str]] = None,
            modify_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlbVirtualHostModifyRequestHeaderArgs', 'AlbVirtualHostModifyRequestHeaderArgsDict']]]]] = None,
            modify_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlbVirtualHostModifyResponseHeaderArgs', 'AlbVirtualHostModifyResponseHeaderArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            rate_limit: Optional[pulumi.Input[Union['AlbVirtualHostRateLimitArgs', 'AlbVirtualHostRateLimitArgsDict']]] = None,
            route_options: Optional[pulumi.Input[Union['AlbVirtualHostRouteOptionsArgs', 'AlbVirtualHostRouteOptionsArgsDict']]] = None,
            routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlbVirtualHostRouteArgs', 'AlbVirtualHostRouteArgsDict']]]]] = None) -> 'AlbVirtualHost':
        """
        Get an existing AlbVirtualHost resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorities: A list of domains (host/authority header) that will be matched to this virtual host. Wildcard hosts are supported in the form of '*.foo.com' or '*-bar.foo.com'. If not specified, all domains will be matched.
        :param pulumi.Input[str] http_router_id: The ID of the HTTP router to which the virtual host belongs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlbVirtualHostModifyRequestHeaderArgs', 'AlbVirtualHostModifyRequestHeaderArgsDict']]]] modify_request_headers: Apply the following modifications to the request headers. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlbVirtualHostModifyResponseHeaderArgs', 'AlbVirtualHostModifyResponseHeaderArgsDict']]]] modify_response_headers: Apply the following modifications to the response headers. The structure is documented below.
        :param pulumi.Input[str] name: name of the header to modify.
        :param pulumi.Input[Union['AlbVirtualHostRateLimitArgs', 'AlbVirtualHostRateLimitArgsDict']] rate_limit: Rate limit configuration applied for a whole virtual host
        :param pulumi.Input[Union['AlbVirtualHostRouteOptionsArgs', 'AlbVirtualHostRouteOptionsArgsDict']] route_options: Route options for the virtual host. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlbVirtualHostRouteArgs', 'AlbVirtualHostRouteArgsDict']]]] routes: A Route resource. Routes are matched *in-order*. Be careful when adding them to the end. For instance, having http '/' match first makes all other routes unused. The structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlbVirtualHostState.__new__(_AlbVirtualHostState)

        __props__.__dict__["authorities"] = authorities
        __props__.__dict__["http_router_id"] = http_router_id
        __props__.__dict__["modify_request_headers"] = modify_request_headers
        __props__.__dict__["modify_response_headers"] = modify_response_headers
        __props__.__dict__["name"] = name
        __props__.__dict__["rate_limit"] = rate_limit
        __props__.__dict__["route_options"] = route_options
        __props__.__dict__["routes"] = routes
        return AlbVirtualHost(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def authorities(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of domains (host/authority header) that will be matched to this virtual host. Wildcard hosts are supported in the form of '*.foo.com' or '*-bar.foo.com'. If not specified, all domains will be matched.
        """
        return pulumi.get(self, "authorities")

    @property
    @pulumi.getter(name="httpRouterId")
    def http_router_id(self) -> pulumi.Output[str]:
        """
        The ID of the HTTP router to which the virtual host belongs.
        """
        return pulumi.get(self, "http_router_id")

    @property
    @pulumi.getter(name="modifyRequestHeaders")
    def modify_request_headers(self) -> pulumi.Output[Optional[Sequence['outputs.AlbVirtualHostModifyRequestHeader']]]:
        """
        Apply the following modifications to the request headers. The structure is documented below.
        """
        return pulumi.get(self, "modify_request_headers")

    @property
    @pulumi.getter(name="modifyResponseHeaders")
    def modify_response_headers(self) -> pulumi.Output[Optional[Sequence['outputs.AlbVirtualHostModifyResponseHeader']]]:
        """
        Apply the following modifications to the response headers. The structure is documented below.
        """
        return pulumi.get(self, "modify_response_headers")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        name of the header to modify.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> pulumi.Output[Optional['outputs.AlbVirtualHostRateLimit']]:
        """
        Rate limit configuration applied for a whole virtual host
        """
        return pulumi.get(self, "rate_limit")

    @property
    @pulumi.getter(name="routeOptions")
    def route_options(self) -> pulumi.Output[Optional['outputs.AlbVirtualHostRouteOptions']]:
        """
        Route options for the virtual host. The structure is documented below.
        """
        return pulumi.get(self, "route_options")

    @property
    @pulumi.getter
    def routes(self) -> pulumi.Output[Optional[Sequence['outputs.AlbVirtualHostRoute']]]:
        """
        A Route resource. Routes are matched *in-order*. Be careful when adding them to the end. For instance, having http '/' match first makes all other routes unused. The structure is documented below.
        """
        return pulumi.get(self, "routes")

