# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiGatewayArgs', 'ApiGateway']

@pulumi.input_type
class ApiGatewayArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input[str],
                 canary: Optional[pulumi.Input['ApiGatewayCanaryArgs']] = None,
                 connectivity: Optional[pulumi.Input['ApiGatewayConnectivityArgs']] = None,
                 custom_domains: Optional[pulumi.Input[Sequence[pulumi.Input['ApiGatewayCustomDomainArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_timeout: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 log_options: Optional[pulumi.Input['ApiGatewayLogOptionsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ApiGateway resource.
        :param pulumi.Input[str] spec: OpenAPI specification for Yandex API Gateway.
        :param pulumi.Input['ApiGatewayCanaryArgs'] canary: Canary release settings of gateway.
               * `canary.0.weight` - Percentage of requests, which will be processed by canary release.
               * `canary.0.variables` - A list of values for variables in gateway specification of canary release.
        :param pulumi.Input['ApiGatewayConnectivityArgs'] connectivity: Gateway connectivity. If specified the gateway will be attached to specified network.
               * `connectivity.0.network_id` - Network the gateway will have access to. It's essential to specify network with subnets in all availability zones.
        :param pulumi.Input[Sequence[pulumi.Input['ApiGatewayCustomDomainArgs']]] custom_domains: Set of custom domains to be attached to Yandex API Gateway.
        :param pulumi.Input[str] description: Description of the Yandex Cloud API Gateway.
        :param pulumi.Input[str] execution_timeout: Execution timeout in seconds for the Yandex Cloud API Gateway.
        :param pulumi.Input[str] folder_id: Folder ID for the Yandex Cloud API Gateway. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Yandex Cloud API Gateway.
        :param pulumi.Input['ApiGatewayLogOptionsArgs'] log_options: Options for logging from Yandex Cloud API Gateway.
        :param pulumi.Input[str] name: Yandex Cloud API Gateway name used to define API Gateway.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] variables: A set of values for variables in gateway specification.
        """
        pulumi.set(__self__, "spec", spec)
        if canary is not None:
            pulumi.set(__self__, "canary", canary)
        if connectivity is not None:
            pulumi.set(__self__, "connectivity", connectivity)
        if custom_domains is not None:
            pulumi.set(__self__, "custom_domains", custom_domains)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_timeout is not None:
            pulumi.set(__self__, "execution_timeout", execution_timeout)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_options is not None:
            pulumi.set(__self__, "log_options", log_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input[str]:
        """
        OpenAPI specification for Yandex API Gateway.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input[str]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def canary(self) -> Optional[pulumi.Input['ApiGatewayCanaryArgs']]:
        """
        Canary release settings of gateway.
        * `canary.0.weight` - Percentage of requests, which will be processed by canary release.
        * `canary.0.variables` - A list of values for variables in gateway specification of canary release.
        """
        return pulumi.get(self, "canary")

    @canary.setter
    def canary(self, value: Optional[pulumi.Input['ApiGatewayCanaryArgs']]):
        pulumi.set(self, "canary", value)

    @property
    @pulumi.getter
    def connectivity(self) -> Optional[pulumi.Input['ApiGatewayConnectivityArgs']]:
        """
        Gateway connectivity. If specified the gateway will be attached to specified network.
        * `connectivity.0.network_id` - Network the gateway will have access to. It's essential to specify network with subnets in all availability zones.
        """
        return pulumi.get(self, "connectivity")

    @connectivity.setter
    def connectivity(self, value: Optional[pulumi.Input['ApiGatewayConnectivityArgs']]):
        pulumi.set(self, "connectivity", value)

    @property
    @pulumi.getter(name="customDomains")
    def custom_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiGatewayCustomDomainArgs']]]]:
        """
        Set of custom domains to be attached to Yandex API Gateway.
        """
        return pulumi.get(self, "custom_domains")

    @custom_domains.setter
    def custom_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiGatewayCustomDomainArgs']]]]):
        pulumi.set(self, "custom_domains", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Execution timeout in seconds for the Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "execution_timeout")

    @execution_timeout.setter
    def execution_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_timeout", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        Folder ID for the Yandex Cloud API Gateway. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="logOptions")
    def log_options(self) -> Optional[pulumi.Input['ApiGatewayLogOptionsArgs']]:
        """
        Options for logging from Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "log_options")

    @log_options.setter
    def log_options(self, value: Optional[pulumi.Input['ApiGatewayLogOptionsArgs']]):
        pulumi.set(self, "log_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Yandex Cloud API Gateway name used to define API Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of values for variables in gateway specification.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "variables", value)


@pulumi.input_type
class _ApiGatewayState:
    def __init__(__self__, *,
                 canary: Optional[pulumi.Input['ApiGatewayCanaryArgs']] = None,
                 connectivity: Optional[pulumi.Input['ApiGatewayConnectivityArgs']] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 custom_domains: Optional[pulumi.Input[Sequence[pulumi.Input['ApiGatewayCustomDomainArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 execution_timeout: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 log_group_id: Optional[pulumi.Input[str]] = None,
                 log_options: Optional[pulumi.Input['ApiGatewayLogOptionsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 user_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering ApiGateway resources.
        :param pulumi.Input['ApiGatewayCanaryArgs'] canary: Canary release settings of gateway.
               * `canary.0.weight` - Percentage of requests, which will be processed by canary release.
               * `canary.0.variables` - A list of values for variables in gateway specification of canary release.
        :param pulumi.Input['ApiGatewayConnectivityArgs'] connectivity: Gateway connectivity. If specified the gateway will be attached to specified network.
               * `connectivity.0.network_id` - Network the gateway will have access to. It's essential to specify network with subnets in all availability zones.
        :param pulumi.Input[str] created_at: Creation timestamp of the Yandex Cloud API Gateway.
        :param pulumi.Input[Sequence[pulumi.Input['ApiGatewayCustomDomainArgs']]] custom_domains: Set of custom domains to be attached to Yandex API Gateway.
        :param pulumi.Input[str] description: Description of the Yandex Cloud API Gateway.
        :param pulumi.Input[str] domain: Default domain for the Yandex API Gateway. Generated at creation time.
        :param pulumi.Input[str] execution_timeout: Execution timeout in seconds for the Yandex Cloud API Gateway.
        :param pulumi.Input[str] folder_id: Folder ID for the Yandex Cloud API Gateway. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Yandex Cloud API Gateway.
        :param pulumi.Input[str] log_group_id: Log entries are written to specified log group
        :param pulumi.Input['ApiGatewayLogOptionsArgs'] log_options: Options for logging from Yandex Cloud API Gateway.
        :param pulumi.Input[str] name: Yandex Cloud API Gateway name used to define API Gateway.
        :param pulumi.Input[str] spec: OpenAPI specification for Yandex API Gateway.
        :param pulumi.Input[str] status: Status of the Yandex API Gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_domains: (**DEPRECATED**, use `custom_domains` instead) Set of user domains attached to Yandex API Gateway.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] variables: A set of values for variables in gateway specification.
        """
        if canary is not None:
            pulumi.set(__self__, "canary", canary)
        if connectivity is not None:
            pulumi.set(__self__, "connectivity", connectivity)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if custom_domains is not None:
            pulumi.set(__self__, "custom_domains", custom_domains)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if execution_timeout is not None:
            pulumi.set(__self__, "execution_timeout", execution_timeout)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_group_id is not None:
            pulumi.set(__self__, "log_group_id", log_group_id)
        if log_options is not None:
            pulumi.set(__self__, "log_options", log_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_domains is not None:
            warnings.warn("""The 'user_domains' field has been deprecated. Please use 'custom_domains' instead.""", DeprecationWarning)
            pulumi.log.warn("""user_domains is deprecated: The 'user_domains' field has been deprecated. Please use 'custom_domains' instead.""")
        if user_domains is not None:
            pulumi.set(__self__, "user_domains", user_domains)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def canary(self) -> Optional[pulumi.Input['ApiGatewayCanaryArgs']]:
        """
        Canary release settings of gateway.
        * `canary.0.weight` - Percentage of requests, which will be processed by canary release.
        * `canary.0.variables` - A list of values for variables in gateway specification of canary release.
        """
        return pulumi.get(self, "canary")

    @canary.setter
    def canary(self, value: Optional[pulumi.Input['ApiGatewayCanaryArgs']]):
        pulumi.set(self, "canary", value)

    @property
    @pulumi.getter
    def connectivity(self) -> Optional[pulumi.Input['ApiGatewayConnectivityArgs']]:
        """
        Gateway connectivity. If specified the gateway will be attached to specified network.
        * `connectivity.0.network_id` - Network the gateway will have access to. It's essential to specify network with subnets in all availability zones.
        """
        return pulumi.get(self, "connectivity")

    @connectivity.setter
    def connectivity(self, value: Optional[pulumi.Input['ApiGatewayConnectivityArgs']]):
        pulumi.set(self, "connectivity", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp of the Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="customDomains")
    def custom_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiGatewayCustomDomainArgs']]]]:
        """
        Set of custom domains to be attached to Yandex API Gateway.
        """
        return pulumi.get(self, "custom_domains")

    @custom_domains.setter
    def custom_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiGatewayCustomDomainArgs']]]]):
        pulumi.set(self, "custom_domains", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        Default domain for the Yandex API Gateway. Generated at creation time.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Execution timeout in seconds for the Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "execution_timeout")

    @execution_timeout.setter
    def execution_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_timeout", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        Folder ID for the Yandex Cloud API Gateway. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Log entries are written to specified log group
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_group_id", value)

    @property
    @pulumi.getter(name="logOptions")
    def log_options(self) -> Optional[pulumi.Input['ApiGatewayLogOptionsArgs']]:
        """
        Options for logging from Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "log_options")

    @log_options.setter
    def log_options(self, value: Optional[pulumi.Input['ApiGatewayLogOptionsArgs']]):
        pulumi.set(self, "log_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Yandex Cloud API Gateway name used to define API Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input[str]]:
        """
        OpenAPI specification for Yandex API Gateway.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the Yandex API Gateway.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="userDomains")
    @_utilities.deprecated("""The 'user_domains' field has been deprecated. Please use 'custom_domains' instead.""")
    def user_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (**DEPRECATED**, use `custom_domains` instead) Set of user domains attached to Yandex API Gateway.
        """
        return pulumi.get(self, "user_domains")

    @user_domains.setter
    def user_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_domains", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of values for variables in gateway specification.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "variables", value)


class ApiGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 canary: Optional[pulumi.Input[Union['ApiGatewayCanaryArgs', 'ApiGatewayCanaryArgsDict']]] = None,
                 connectivity: Optional[pulumi.Input[Union['ApiGatewayConnectivityArgs', 'ApiGatewayConnectivityArgsDict']]] = None,
                 custom_domains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiGatewayCustomDomainArgs', 'ApiGatewayCustomDomainArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_timeout: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 log_options: Optional[pulumi.Input[Union['ApiGatewayLogOptionsArgs', 'ApiGatewayLogOptionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[str]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Allows management of [Yandex Cloud API Gateway](https://cloud.yandex.com/docs/api-gateway/).

        ## Example Usage

        {{ tffile "examples/api_gateway/r_api_gateway_1.tf" }}

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ApiGatewayCanaryArgs', 'ApiGatewayCanaryArgsDict']] canary: Canary release settings of gateway.
               * `canary.0.weight` - Percentage of requests, which will be processed by canary release.
               * `canary.0.variables` - A list of values for variables in gateway specification of canary release.
        :param pulumi.Input[Union['ApiGatewayConnectivityArgs', 'ApiGatewayConnectivityArgsDict']] connectivity: Gateway connectivity. If specified the gateway will be attached to specified network.
               * `connectivity.0.network_id` - Network the gateway will have access to. It's essential to specify network with subnets in all availability zones.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiGatewayCustomDomainArgs', 'ApiGatewayCustomDomainArgsDict']]]] custom_domains: Set of custom domains to be attached to Yandex API Gateway.
        :param pulumi.Input[str] description: Description of the Yandex Cloud API Gateway.
        :param pulumi.Input[str] execution_timeout: Execution timeout in seconds for the Yandex Cloud API Gateway.
        :param pulumi.Input[str] folder_id: Folder ID for the Yandex Cloud API Gateway. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Yandex Cloud API Gateway.
        :param pulumi.Input[Union['ApiGatewayLogOptionsArgs', 'ApiGatewayLogOptionsArgsDict']] log_options: Options for logging from Yandex Cloud API Gateway.
        :param pulumi.Input[str] name: Yandex Cloud API Gateway name used to define API Gateway.
        :param pulumi.Input[str] spec: OpenAPI specification for Yandex API Gateway.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] variables: A set of values for variables in gateway specification.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [Yandex Cloud API Gateway](https://cloud.yandex.com/docs/api-gateway/).

        ## Example Usage

        {{ tffile "examples/api_gateway/r_api_gateway_1.tf" }}

        :param str resource_name: The name of the resource.
        :param ApiGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 canary: Optional[pulumi.Input[Union['ApiGatewayCanaryArgs', 'ApiGatewayCanaryArgsDict']]] = None,
                 connectivity: Optional[pulumi.Input[Union['ApiGatewayConnectivityArgs', 'ApiGatewayConnectivityArgsDict']]] = None,
                 custom_domains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiGatewayCustomDomainArgs', 'ApiGatewayCustomDomainArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_timeout: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 log_options: Optional[pulumi.Input[Union['ApiGatewayLogOptionsArgs', 'ApiGatewayLogOptionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[str]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiGatewayArgs.__new__(ApiGatewayArgs)

            __props__.__dict__["canary"] = canary
            __props__.__dict__["connectivity"] = connectivity
            __props__.__dict__["custom_domains"] = custom_domains
            __props__.__dict__["description"] = description
            __props__.__dict__["execution_timeout"] = execution_timeout
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["log_options"] = log_options
            __props__.__dict__["name"] = name
            if spec is None and not opts.urn:
                raise TypeError("Missing required property 'spec'")
            __props__.__dict__["spec"] = spec
            __props__.__dict__["variables"] = variables
            __props__.__dict__["created_at"] = None
            __props__.__dict__["domain"] = None
            __props__.__dict__["log_group_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["user_domains"] = None
        super(ApiGateway, __self__).__init__(
            'yandex:index/apiGateway:ApiGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            canary: Optional[pulumi.Input[Union['ApiGatewayCanaryArgs', 'ApiGatewayCanaryArgsDict']]] = None,
            connectivity: Optional[pulumi.Input[Union['ApiGatewayConnectivityArgs', 'ApiGatewayConnectivityArgsDict']]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            custom_domains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiGatewayCustomDomainArgs', 'ApiGatewayCustomDomainArgsDict']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            execution_timeout: Optional[pulumi.Input[str]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            log_group_id: Optional[pulumi.Input[str]] = None,
            log_options: Optional[pulumi.Input[Union['ApiGatewayLogOptionsArgs', 'ApiGatewayLogOptionsArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            spec: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            user_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'ApiGateway':
        """
        Get an existing ApiGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ApiGatewayCanaryArgs', 'ApiGatewayCanaryArgsDict']] canary: Canary release settings of gateway.
               * `canary.0.weight` - Percentage of requests, which will be processed by canary release.
               * `canary.0.variables` - A list of values for variables in gateway specification of canary release.
        :param pulumi.Input[Union['ApiGatewayConnectivityArgs', 'ApiGatewayConnectivityArgsDict']] connectivity: Gateway connectivity. If specified the gateway will be attached to specified network.
               * `connectivity.0.network_id` - Network the gateway will have access to. It's essential to specify network with subnets in all availability zones.
        :param pulumi.Input[str] created_at: Creation timestamp of the Yandex Cloud API Gateway.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiGatewayCustomDomainArgs', 'ApiGatewayCustomDomainArgsDict']]]] custom_domains: Set of custom domains to be attached to Yandex API Gateway.
        :param pulumi.Input[str] description: Description of the Yandex Cloud API Gateway.
        :param pulumi.Input[str] domain: Default domain for the Yandex API Gateway. Generated at creation time.
        :param pulumi.Input[str] execution_timeout: Execution timeout in seconds for the Yandex Cloud API Gateway.
        :param pulumi.Input[str] folder_id: Folder ID for the Yandex Cloud API Gateway. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Yandex Cloud API Gateway.
        :param pulumi.Input[str] log_group_id: Log entries are written to specified log group
        :param pulumi.Input[Union['ApiGatewayLogOptionsArgs', 'ApiGatewayLogOptionsArgsDict']] log_options: Options for logging from Yandex Cloud API Gateway.
        :param pulumi.Input[str] name: Yandex Cloud API Gateway name used to define API Gateway.
        :param pulumi.Input[str] spec: OpenAPI specification for Yandex API Gateway.
        :param pulumi.Input[str] status: Status of the Yandex API Gateway.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_domains: (**DEPRECATED**, use `custom_domains` instead) Set of user domains attached to Yandex API Gateway.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] variables: A set of values for variables in gateway specification.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiGatewayState.__new__(_ApiGatewayState)

        __props__.__dict__["canary"] = canary
        __props__.__dict__["connectivity"] = connectivity
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["custom_domains"] = custom_domains
        __props__.__dict__["description"] = description
        __props__.__dict__["domain"] = domain
        __props__.__dict__["execution_timeout"] = execution_timeout
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["log_group_id"] = log_group_id
        __props__.__dict__["log_options"] = log_options
        __props__.__dict__["name"] = name
        __props__.__dict__["spec"] = spec
        __props__.__dict__["status"] = status
        __props__.__dict__["user_domains"] = user_domains
        __props__.__dict__["variables"] = variables
        return ApiGateway(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def canary(self) -> pulumi.Output[Optional['outputs.ApiGatewayCanary']]:
        """
        Canary release settings of gateway.
        * `canary.0.weight` - Percentage of requests, which will be processed by canary release.
        * `canary.0.variables` - A list of values for variables in gateway specification of canary release.
        """
        return pulumi.get(self, "canary")

    @property
    @pulumi.getter
    def connectivity(self) -> pulumi.Output[Optional['outputs.ApiGatewayConnectivity']]:
        """
        Gateway connectivity. If specified the gateway will be attached to specified network.
        * `connectivity.0.network_id` - Network the gateway will have access to. It's essential to specify network with subnets in all availability zones.
        """
        return pulumi.get(self, "connectivity")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Creation timestamp of the Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customDomains")
    def custom_domains(self) -> pulumi.Output[Optional[Sequence['outputs.ApiGatewayCustomDomain']]]:
        """
        Set of custom domains to be attached to Yandex API Gateway.
        """
        return pulumi.get(self, "custom_domains")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        Default domain for the Yandex API Gateway. Generated at creation time.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> pulumi.Output[str]:
        """
        Execution timeout in seconds for the Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "execution_timeout")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        Folder ID for the Yandex Cloud API Gateway. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A set of key/value label pairs to assign to the Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> pulumi.Output[str]:
        """
        Log entries are written to specified log group
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logOptions")
    def log_options(self) -> pulumi.Output[Optional['outputs.ApiGatewayLogOptions']]:
        """
        Options for logging from Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "log_options")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Yandex Cloud API Gateway name used to define API Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Output[str]:
        """
        OpenAPI specification for Yandex API Gateway.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the Yandex API Gateway.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="userDomains")
    @_utilities.deprecated("""The 'user_domains' field has been deprecated. Please use 'custom_domains' instead.""")
    def user_domains(self) -> pulumi.Output[Sequence[str]]:
        """
        (**DEPRECATED**, use `custom_domains` instead) Set of user domains attached to Yandex API Gateway.
        """
        return pulumi.get(self, "user_domains")

    @property
    @pulumi.getter
    def variables(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A set of values for variables in gateway specification.
        """
        return pulumi.get(self, "variables")

