# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuditTrailsTrailArgs', 'AuditTrailsTrail']

@pulumi.input_type
class AuditTrailsTrailArgs:
    def __init__(__self__, *,
                 folder_id: pulumi.Input[str],
                 service_account_id: pulumi.Input[str],
                 data_stream_destination: Optional[pulumi.Input['AuditTrailsTrailDataStreamDestinationArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input['AuditTrailsTrailFilterArgs']] = None,
                 filtering_policy: Optional[pulumi.Input['AuditTrailsTrailFilteringPolicyArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 logging_destination: Optional[pulumi.Input['AuditTrailsTrailLoggingDestinationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 storage_destination: Optional[pulumi.Input['AuditTrailsTrailStorageDestinationArgs']] = None):
        """
        The set of arguments for constructing a AuditTrailsTrail resource.
        :param pulumi.Input[str] folder_id: ID of the folder to which the trail belongs.
        :param pulumi.Input[str] service_account_id: ID of the [IAM service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) that is used by the trail.
        :param pulumi.Input['AuditTrailsTrailDataStreamDestinationArgs'] data_stream_destination: Structure describing destination data stream of the trail. Mutually exclusive with `logging_destination` and `storage_destination`.
        :param pulumi.Input[str] description: Description of the trail.
        :param pulumi.Input['AuditTrailsTrailFilterArgs'] filter: Structure describing event filtering process for the trail.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels defined by the user.
        :param pulumi.Input['AuditTrailsTrailLoggingDestinationArgs'] logging_destination: Structure describing destination log group of the trail. Mutually exclusive with `storage_destination` and `data_stream_destination`.
        :param pulumi.Input[str] name: Name of the trail.
        :param pulumi.Input['AuditTrailsTrailStorageDestinationArgs'] storage_destination: Structure describing destination bucket of the trail. Mutually exclusive with `logging_destination` and `data_stream_destination`.
        """
        pulumi.set(__self__, "folder_id", folder_id)
        pulumi.set(__self__, "service_account_id", service_account_id)
        if data_stream_destination is not None:
            pulumi.set(__self__, "data_stream_destination", data_stream_destination)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filter is not None:
            warnings.warn("""Configure filtering_policy instead. This attribute will be removed""", DeprecationWarning)
            pulumi.log.warn("""filter is deprecated: Configure filtering_policy instead. This attribute will be removed""")
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if filtering_policy is not None:
            pulumi.set(__self__, "filtering_policy", filtering_policy)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if logging_destination is not None:
            pulumi.set(__self__, "logging_destination", logging_destination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_destination is not None:
            pulumi.set(__self__, "storage_destination", storage_destination)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Input[str]:
        """
        ID of the folder to which the trail belongs.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Input[str]:
        """
        ID of the [IAM service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) that is used by the trail.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_account_id", value)

    @property
    @pulumi.getter(name="dataStreamDestination")
    def data_stream_destination(self) -> Optional[pulumi.Input['AuditTrailsTrailDataStreamDestinationArgs']]:
        """
        Structure describing destination data stream of the trail. Mutually exclusive with `logging_destination` and `storage_destination`.
        """
        return pulumi.get(self, "data_stream_destination")

    @data_stream_destination.setter
    def data_stream_destination(self, value: Optional[pulumi.Input['AuditTrailsTrailDataStreamDestinationArgs']]):
        pulumi.set(self, "data_stream_destination", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the trail.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Configure filtering_policy instead. This attribute will be removed""")
    def filter(self) -> Optional[pulumi.Input['AuditTrailsTrailFilterArgs']]:
        """
        Structure describing event filtering process for the trail.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['AuditTrailsTrailFilterArgs']]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="filteringPolicy")
    def filtering_policy(self) -> Optional[pulumi.Input['AuditTrailsTrailFilteringPolicyArgs']]:
        return pulumi.get(self, "filtering_policy")

    @filtering_policy.setter
    def filtering_policy(self, value: Optional[pulumi.Input['AuditTrailsTrailFilteringPolicyArgs']]):
        pulumi.set(self, "filtering_policy", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels defined by the user.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="loggingDestination")
    def logging_destination(self) -> Optional[pulumi.Input['AuditTrailsTrailLoggingDestinationArgs']]:
        """
        Structure describing destination log group of the trail. Mutually exclusive with `storage_destination` and `data_stream_destination`.
        """
        return pulumi.get(self, "logging_destination")

    @logging_destination.setter
    def logging_destination(self, value: Optional[pulumi.Input['AuditTrailsTrailLoggingDestinationArgs']]):
        pulumi.set(self, "logging_destination", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the trail.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="storageDestination")
    def storage_destination(self) -> Optional[pulumi.Input['AuditTrailsTrailStorageDestinationArgs']]:
        """
        Structure describing destination bucket of the trail. Mutually exclusive with `logging_destination` and `data_stream_destination`.
        """
        return pulumi.get(self, "storage_destination")

    @storage_destination.setter
    def storage_destination(self, value: Optional[pulumi.Input['AuditTrailsTrailStorageDestinationArgs']]):
        pulumi.set(self, "storage_destination", value)


@pulumi.input_type
class _AuditTrailsTrailState:
    def __init__(__self__, *,
                 data_stream_destination: Optional[pulumi.Input['AuditTrailsTrailDataStreamDestinationArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input['AuditTrailsTrailFilterArgs']] = None,
                 filtering_policy: Optional[pulumi.Input['AuditTrailsTrailFilteringPolicyArgs']] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 logging_destination: Optional[pulumi.Input['AuditTrailsTrailLoggingDestinationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_account_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_destination: Optional[pulumi.Input['AuditTrailsTrailStorageDestinationArgs']] = None,
                 trail_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AuditTrailsTrail resources.
        :param pulumi.Input['AuditTrailsTrailDataStreamDestinationArgs'] data_stream_destination: Structure describing destination data stream of the trail. Mutually exclusive with `logging_destination` and `storage_destination`.
        :param pulumi.Input[str] description: Description of the trail.
        :param pulumi.Input['AuditTrailsTrailFilterArgs'] filter: Structure describing event filtering process for the trail.
        :param pulumi.Input[str] folder_id: ID of the folder to which the trail belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels defined by the user.
        :param pulumi.Input['AuditTrailsTrailLoggingDestinationArgs'] logging_destination: Structure describing destination log group of the trail. Mutually exclusive with `storage_destination` and `data_stream_destination`.
        :param pulumi.Input[str] name: Name of the trail.
        :param pulumi.Input[str] service_account_id: ID of the [IAM service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) that is used by the trail.
        :param pulumi.Input[str] status: Status of this trail.
        :param pulumi.Input['AuditTrailsTrailStorageDestinationArgs'] storage_destination: Structure describing destination bucket of the trail. Mutually exclusive with `logging_destination` and `data_stream_destination`.
        :param pulumi.Input[str] trail_id: ID of the trail resource.
        """
        if data_stream_destination is not None:
            pulumi.set(__self__, "data_stream_destination", data_stream_destination)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filter is not None:
            warnings.warn("""Configure filtering_policy instead. This attribute will be removed""", DeprecationWarning)
            pulumi.log.warn("""filter is deprecated: Configure filtering_policy instead. This attribute will be removed""")
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if filtering_policy is not None:
            pulumi.set(__self__, "filtering_policy", filtering_policy)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if logging_destination is not None:
            pulumi.set(__self__, "logging_destination", logging_destination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_destination is not None:
            pulumi.set(__self__, "storage_destination", storage_destination)
        if trail_id is not None:
            pulumi.set(__self__, "trail_id", trail_id)

    @property
    @pulumi.getter(name="dataStreamDestination")
    def data_stream_destination(self) -> Optional[pulumi.Input['AuditTrailsTrailDataStreamDestinationArgs']]:
        """
        Structure describing destination data stream of the trail. Mutually exclusive with `logging_destination` and `storage_destination`.
        """
        return pulumi.get(self, "data_stream_destination")

    @data_stream_destination.setter
    def data_stream_destination(self, value: Optional[pulumi.Input['AuditTrailsTrailDataStreamDestinationArgs']]):
        pulumi.set(self, "data_stream_destination", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the trail.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Configure filtering_policy instead. This attribute will be removed""")
    def filter(self) -> Optional[pulumi.Input['AuditTrailsTrailFilterArgs']]:
        """
        Structure describing event filtering process for the trail.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['AuditTrailsTrailFilterArgs']]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="filteringPolicy")
    def filtering_policy(self) -> Optional[pulumi.Input['AuditTrailsTrailFilteringPolicyArgs']]:
        return pulumi.get(self, "filtering_policy")

    @filtering_policy.setter
    def filtering_policy(self, value: Optional[pulumi.Input['AuditTrailsTrailFilteringPolicyArgs']]):
        pulumi.set(self, "filtering_policy", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the folder to which the trail belongs.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels defined by the user.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="loggingDestination")
    def logging_destination(self) -> Optional[pulumi.Input['AuditTrailsTrailLoggingDestinationArgs']]:
        """
        Structure describing destination log group of the trail. Mutually exclusive with `storage_destination` and `data_stream_destination`.
        """
        return pulumi.get(self, "logging_destination")

    @logging_destination.setter
    def logging_destination(self, value: Optional[pulumi.Input['AuditTrailsTrailLoggingDestinationArgs']]):
        pulumi.set(self, "logging_destination", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the trail.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the [IAM service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) that is used by the trail.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of this trail.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storageDestination")
    def storage_destination(self) -> Optional[pulumi.Input['AuditTrailsTrailStorageDestinationArgs']]:
        """
        Structure describing destination bucket of the trail. Mutually exclusive with `logging_destination` and `data_stream_destination`.
        """
        return pulumi.get(self, "storage_destination")

    @storage_destination.setter
    def storage_destination(self, value: Optional[pulumi.Input['AuditTrailsTrailStorageDestinationArgs']]):
        pulumi.set(self, "storage_destination", value)

    @property
    @pulumi.getter(name="trailId")
    def trail_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the trail resource.
        """
        return pulumi.get(self, "trail_id")

    @trail_id.setter
    def trail_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trail_id", value)


class AuditTrailsTrail(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_stream_destination: Optional[pulumi.Input[Union['AuditTrailsTrailDataStreamDestinationArgs', 'AuditTrailsTrailDataStreamDestinationArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input[Union['AuditTrailsTrailFilterArgs', 'AuditTrailsTrailFilterArgsDict']]] = None,
                 filtering_policy: Optional[pulumi.Input[Union['AuditTrailsTrailFilteringPolicyArgs', 'AuditTrailsTrailFilteringPolicyArgsDict']]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 logging_destination: Optional[pulumi.Input[Union['AuditTrailsTrailLoggingDestinationArgs', 'AuditTrailsTrailLoggingDestinationArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_account_id: Optional[pulumi.Input[str]] = None,
                 storage_destination: Optional[pulumi.Input[Union['AuditTrailsTrailStorageDestinationArgs', 'AuditTrailsTrailStorageDestinationArgsDict']]] = None,
                 __props__=None):
        """
        Allows management of [trail](https://yandex.cloud/docs/audit-trails/concepts/trail)

        ## Example Usage

        {{ tffile "examples/audit_trails_trail/r_audit_trails_trail_1.tf" }}

        Trail delivering events to YDS and gathering such events:

        * Management events from the 'some-organization' organization
        * DNS data events from the 'some-organization' organization
        * Object Storage data events from the 'some-organization' organization

        {{ tffile "examples/audit_trails_trail/r_audit_trails_trail_2.tf" }}

        Trail delivering events to Object Storage and gathering such events:

        * Management events from the 'home-folder' folder
        * Managed PostgreSQL data events from the 'home-folder' folder

        {{ tffile "examples/audit_trails_trail/r_audit_trails_trail_3.tf" }}

        ## Migration from deprecated filter field

        In order to migrate from unsing `filter` to the `filtering_policy`, you will have to:

        * Remove the `filter.event_filters.categories` blocks. With the introduction of `included_events`/`excluded_events` you can configure filtering per each event type.

        * Replace the `filter.event_filters.path_filter` with the appropriate `resource_scope` blocks. You have to account that `resource_scope` does not support specifying relations between resources, so your configuration will simplify to only the actual resources, that will be monitored.

        Before

        {{ tffile "examples/audit_trails_trail/r_audit_trails_trail_4.tf" }}

        After

        {{ tffile "examples/audit_trails_trail/r_audit_trails_trail_5.tf" }}

        * Replace the `filter.path_filter` block with the `filtering_policy.management_events_filter`. New API states management events filtration in a more clear way. The resources, that were specified, must migrate into the `filtering_policy.management_events_filter.resource_scope`

        Before

        {{ tffile "examples/audit_trails_trail/r_audit_trails_trail_6.tf" }}

        After

        {{ tffile "examples/audit_trails_trail/r_audit_trails_trail_7.tf" }}

        ## Import

        A trail can be imported using the `id` of the resource, e.g.

        bash

        ```sh
        $ pulumi import yandex:index/auditTrailsTrail:AuditTrailsTrail infosec-trail trail_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AuditTrailsTrailDataStreamDestinationArgs', 'AuditTrailsTrailDataStreamDestinationArgsDict']] data_stream_destination: Structure describing destination data stream of the trail. Mutually exclusive with `logging_destination` and `storage_destination`.
        :param pulumi.Input[str] description: Description of the trail.
        :param pulumi.Input[Union['AuditTrailsTrailFilterArgs', 'AuditTrailsTrailFilterArgsDict']] filter: Structure describing event filtering process for the trail.
        :param pulumi.Input[str] folder_id: ID of the folder to which the trail belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels defined by the user.
        :param pulumi.Input[Union['AuditTrailsTrailLoggingDestinationArgs', 'AuditTrailsTrailLoggingDestinationArgsDict']] logging_destination: Structure describing destination log group of the trail. Mutually exclusive with `storage_destination` and `data_stream_destination`.
        :param pulumi.Input[str] name: Name of the trail.
        :param pulumi.Input[str] service_account_id: ID of the [IAM service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) that is used by the trail.
        :param pulumi.Input[Union['AuditTrailsTrailStorageDestinationArgs', 'AuditTrailsTrailStorageDestinationArgsDict']] storage_destination: Structure describing destination bucket of the trail. Mutually exclusive with `logging_destination` and `data_stream_destination`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuditTrailsTrailArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [trail](https://yandex.cloud/docs/audit-trails/concepts/trail)

        ## Example Usage

        {{ tffile "examples/audit_trails_trail/r_audit_trails_trail_1.tf" }}

        Trail delivering events to YDS and gathering such events:

        * Management events from the 'some-organization' organization
        * DNS data events from the 'some-organization' organization
        * Object Storage data events from the 'some-organization' organization

        {{ tffile "examples/audit_trails_trail/r_audit_trails_trail_2.tf" }}

        Trail delivering events to Object Storage and gathering such events:

        * Management events from the 'home-folder' folder
        * Managed PostgreSQL data events from the 'home-folder' folder

        {{ tffile "examples/audit_trails_trail/r_audit_trails_trail_3.tf" }}

        ## Migration from deprecated filter field

        In order to migrate from unsing `filter` to the `filtering_policy`, you will have to:

        * Remove the `filter.event_filters.categories` blocks. With the introduction of `included_events`/`excluded_events` you can configure filtering per each event type.

        * Replace the `filter.event_filters.path_filter` with the appropriate `resource_scope` blocks. You have to account that `resource_scope` does not support specifying relations between resources, so your configuration will simplify to only the actual resources, that will be monitored.

        Before

        {{ tffile "examples/audit_trails_trail/r_audit_trails_trail_4.tf" }}

        After

        {{ tffile "examples/audit_trails_trail/r_audit_trails_trail_5.tf" }}

        * Replace the `filter.path_filter` block with the `filtering_policy.management_events_filter`. New API states management events filtration in a more clear way. The resources, that were specified, must migrate into the `filtering_policy.management_events_filter.resource_scope`

        Before

        {{ tffile "examples/audit_trails_trail/r_audit_trails_trail_6.tf" }}

        After

        {{ tffile "examples/audit_trails_trail/r_audit_trails_trail_7.tf" }}

        ## Import

        A trail can be imported using the `id` of the resource, e.g.

        bash

        ```sh
        $ pulumi import yandex:index/auditTrailsTrail:AuditTrailsTrail infosec-trail trail_id
        ```

        :param str resource_name: The name of the resource.
        :param AuditTrailsTrailArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuditTrailsTrailArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_stream_destination: Optional[pulumi.Input[Union['AuditTrailsTrailDataStreamDestinationArgs', 'AuditTrailsTrailDataStreamDestinationArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input[Union['AuditTrailsTrailFilterArgs', 'AuditTrailsTrailFilterArgsDict']]] = None,
                 filtering_policy: Optional[pulumi.Input[Union['AuditTrailsTrailFilteringPolicyArgs', 'AuditTrailsTrailFilteringPolicyArgsDict']]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 logging_destination: Optional[pulumi.Input[Union['AuditTrailsTrailLoggingDestinationArgs', 'AuditTrailsTrailLoggingDestinationArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_account_id: Optional[pulumi.Input[str]] = None,
                 storage_destination: Optional[pulumi.Input[Union['AuditTrailsTrailStorageDestinationArgs', 'AuditTrailsTrailStorageDestinationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuditTrailsTrailArgs.__new__(AuditTrailsTrailArgs)

            __props__.__dict__["data_stream_destination"] = data_stream_destination
            __props__.__dict__["description"] = description
            __props__.__dict__["filter"] = filter
            __props__.__dict__["filtering_policy"] = filtering_policy
            if folder_id is None and not opts.urn:
                raise TypeError("Missing required property 'folder_id'")
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["logging_destination"] = logging_destination
            __props__.__dict__["name"] = name
            if service_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_id'")
            __props__.__dict__["service_account_id"] = service_account_id
            __props__.__dict__["storage_destination"] = storage_destination
            __props__.__dict__["status"] = None
            __props__.__dict__["trail_id"] = None
        super(AuditTrailsTrail, __self__).__init__(
            'yandex:index/auditTrailsTrail:AuditTrailsTrail',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_stream_destination: Optional[pulumi.Input[Union['AuditTrailsTrailDataStreamDestinationArgs', 'AuditTrailsTrailDataStreamDestinationArgsDict']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            filter: Optional[pulumi.Input[Union['AuditTrailsTrailFilterArgs', 'AuditTrailsTrailFilterArgsDict']]] = None,
            filtering_policy: Optional[pulumi.Input[Union['AuditTrailsTrailFilteringPolicyArgs', 'AuditTrailsTrailFilteringPolicyArgsDict']]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            logging_destination: Optional[pulumi.Input[Union['AuditTrailsTrailLoggingDestinationArgs', 'AuditTrailsTrailLoggingDestinationArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            service_account_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            storage_destination: Optional[pulumi.Input[Union['AuditTrailsTrailStorageDestinationArgs', 'AuditTrailsTrailStorageDestinationArgsDict']]] = None,
            trail_id: Optional[pulumi.Input[str]] = None) -> 'AuditTrailsTrail':
        """
        Get an existing AuditTrailsTrail resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AuditTrailsTrailDataStreamDestinationArgs', 'AuditTrailsTrailDataStreamDestinationArgsDict']] data_stream_destination: Structure describing destination data stream of the trail. Mutually exclusive with `logging_destination` and `storage_destination`.
        :param pulumi.Input[str] description: Description of the trail.
        :param pulumi.Input[Union['AuditTrailsTrailFilterArgs', 'AuditTrailsTrailFilterArgsDict']] filter: Structure describing event filtering process for the trail.
        :param pulumi.Input[str] folder_id: ID of the folder to which the trail belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels defined by the user.
        :param pulumi.Input[Union['AuditTrailsTrailLoggingDestinationArgs', 'AuditTrailsTrailLoggingDestinationArgsDict']] logging_destination: Structure describing destination log group of the trail. Mutually exclusive with `storage_destination` and `data_stream_destination`.
        :param pulumi.Input[str] name: Name of the trail.
        :param pulumi.Input[str] service_account_id: ID of the [IAM service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) that is used by the trail.
        :param pulumi.Input[str] status: Status of this trail.
        :param pulumi.Input[Union['AuditTrailsTrailStorageDestinationArgs', 'AuditTrailsTrailStorageDestinationArgsDict']] storage_destination: Structure describing destination bucket of the trail. Mutually exclusive with `logging_destination` and `data_stream_destination`.
        :param pulumi.Input[str] trail_id: ID of the trail resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuditTrailsTrailState.__new__(_AuditTrailsTrailState)

        __props__.__dict__["data_stream_destination"] = data_stream_destination
        __props__.__dict__["description"] = description
        __props__.__dict__["filter"] = filter
        __props__.__dict__["filtering_policy"] = filtering_policy
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["logging_destination"] = logging_destination
        __props__.__dict__["name"] = name
        __props__.__dict__["service_account_id"] = service_account_id
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_destination"] = storage_destination
        __props__.__dict__["trail_id"] = trail_id
        return AuditTrailsTrail(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dataStreamDestination")
    def data_stream_destination(self) -> pulumi.Output[Optional['outputs.AuditTrailsTrailDataStreamDestination']]:
        """
        Structure describing destination data stream of the trail. Mutually exclusive with `logging_destination` and `storage_destination`.
        """
        return pulumi.get(self, "data_stream_destination")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the trail.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Configure filtering_policy instead. This attribute will be removed""")
    def filter(self) -> pulumi.Output[Optional['outputs.AuditTrailsTrailFilter']]:
        """
        Structure describing event filtering process for the trail.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="filteringPolicy")
    def filtering_policy(self) -> pulumi.Output[Optional['outputs.AuditTrailsTrailFilteringPolicy']]:
        return pulumi.get(self, "filtering_policy")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        ID of the folder to which the trail belongs.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels defined by the user.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="loggingDestination")
    def logging_destination(self) -> pulumi.Output[Optional['outputs.AuditTrailsTrailLoggingDestination']]:
        """
        Structure describing destination log group of the trail. Mutually exclusive with `storage_destination` and `data_stream_destination`.
        """
        return pulumi.get(self, "logging_destination")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the trail.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[str]:
        """
        ID of the [IAM service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) that is used by the trail.
        """
        return pulumi.get(self, "service_account_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of this trail.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageDestination")
    def storage_destination(self) -> pulumi.Output[Optional['outputs.AuditTrailsTrailStorageDestination']]:
        """
        Structure describing destination bucket of the trail. Mutually exclusive with `logging_destination` and `data_stream_destination`.
        """
        return pulumi.get(self, "storage_destination")

    @property
    @pulumi.getter(name="trailId")
    def trail_id(self) -> pulumi.Output[str]:
        """
        ID of the trail resource.
        """
        return pulumi.get(self, "trail_id")

