# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupPolicyArgs', 'BackupPolicy']

@pulumi.input_type
class BackupPolicyArgs:
    def __init__(__self__, *,
                 reattempts: pulumi.Input['BackupPolicyReattemptsArgs'],
                 retention: pulumi.Input['BackupPolicyRetentionArgs'],
                 scheduling: pulumi.Input['BackupPolicySchedulingArgs'],
                 vm_snapshot_reattempts: pulumi.Input['BackupPolicyVmSnapshotReattemptsArgs'],
                 archive_name: Optional[pulumi.Input[str]] = None,
                 cbt: Optional[pulumi.Input[str]] = None,
                 compression: Optional[pulumi.Input[str]] = None,
                 fast_backup_enabled: Optional[pulumi.Input[bool]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 multi_volume_snapshotting_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 performance_window_enabled: Optional[pulumi.Input[bool]] = None,
                 preserve_file_security_settings: Optional[pulumi.Input[bool]] = None,
                 quiesce_snapshotting_enabled: Optional[pulumi.Input[bool]] = None,
                 silent_mode_enabled: Optional[pulumi.Input[bool]] = None,
                 splitting_bytes: Optional[pulumi.Input[str]] = None,
                 vss_provider: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BackupPolicy resource.
        :param pulumi.Input['BackupPolicyReattemptsArgs'] reattempts: — Amount of reattempts that should be performed while trying to make backup at the host. This attribute consists of the following parameters:
        :param pulumi.Input['BackupPolicyRetentionArgs'] retention: — Retention policy for backups. Allows to setup backups lifecycle. This attribute consists of the following parameters:
        :param pulumi.Input['BackupPolicySchedulingArgs'] scheduling: — Schedule settings for creating backups on the host.
        :param pulumi.Input['BackupPolicyVmSnapshotReattemptsArgs'] vm_snapshot_reattempts: — Amount of reattempts that should be performed while trying to make snapshot. This attribute consists of the following parameters:
        :param pulumi.Input[str] archive_name: — The name of generated archives.
        :param pulumi.Input[str] cbt: — Configuration of Changed Block Tracking. Available values are: `"USE_IF_ENABLED"`, `"ENABLED_AND_USE"`, `"DO_NOT_USE"`.
        :param pulumi.Input[str] compression: — Archive compression level. Affects CPU. Available values: `"NORMAL"`, `"HIGH"`, `"MAX"`, `"OFF"`.
        :param pulumi.Input[str] format: — Format of the backup. It's strongly recommend to leave this option empty or `"AUTO"`. Available values: `"AUTO"`, `"VERSION_11"`, `"VERSION_12"`.
        :param pulumi.Input[bool] multi_volume_snapshotting_enabled: — If true, snapshots of multiple volumes will be taken simultaneously.
        :param pulumi.Input[str] name: — Name of the policy
        :param pulumi.Input[bool] performance_window_enabled: — Time windows for performance limitations of backup.
        :param pulumi.Input[bool] preserve_file_security_settings: — Preserves file security settings. It's better to set this option to true.
        :param pulumi.Input[bool] quiesce_snapshotting_enabled: — If true, a quiesced snapshot of the virtual machine will be taken.
        :param pulumi.Input[bool] silent_mode_enabled: — if true, a user interaction will be avoided when possible.
        :param pulumi.Input[str] splitting_bytes: — determines the size to split backups. It's better to leave this option unchanged.
        :param pulumi.Input[str] vss_provider: — Settings for the volume shadow copy service. Available values are: "`NATIVE`", `"TARGET_SYSTEM_DEFINED"`
        """
        pulumi.set(__self__, "reattempts", reattempts)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "scheduling", scheduling)
        pulumi.set(__self__, "vm_snapshot_reattempts", vm_snapshot_reattempts)
        if archive_name is not None:
            pulumi.set(__self__, "archive_name", archive_name)
        if cbt is not None:
            pulumi.set(__self__, "cbt", cbt)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if fast_backup_enabled is not None:
            pulumi.set(__self__, "fast_backup_enabled", fast_backup_enabled)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if multi_volume_snapshotting_enabled is not None:
            pulumi.set(__self__, "multi_volume_snapshotting_enabled", multi_volume_snapshotting_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_window_enabled is not None:
            pulumi.set(__self__, "performance_window_enabled", performance_window_enabled)
        if preserve_file_security_settings is not None:
            pulumi.set(__self__, "preserve_file_security_settings", preserve_file_security_settings)
        if quiesce_snapshotting_enabled is not None:
            pulumi.set(__self__, "quiesce_snapshotting_enabled", quiesce_snapshotting_enabled)
        if silent_mode_enabled is not None:
            pulumi.set(__self__, "silent_mode_enabled", silent_mode_enabled)
        if splitting_bytes is not None:
            pulumi.set(__self__, "splitting_bytes", splitting_bytes)
        if vss_provider is not None:
            pulumi.set(__self__, "vss_provider", vss_provider)

    @property
    @pulumi.getter
    def reattempts(self) -> pulumi.Input['BackupPolicyReattemptsArgs']:
        """
        — Amount of reattempts that should be performed while trying to make backup at the host. This attribute consists of the following parameters:
        """
        return pulumi.get(self, "reattempts")

    @reattempts.setter
    def reattempts(self, value: pulumi.Input['BackupPolicyReattemptsArgs']):
        pulumi.set(self, "reattempts", value)

    @property
    @pulumi.getter
    def retention(self) -> pulumi.Input['BackupPolicyRetentionArgs']:
        """
        — Retention policy for backups. Allows to setup backups lifecycle. This attribute consists of the following parameters:
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: pulumi.Input['BackupPolicyRetentionArgs']):
        pulumi.set(self, "retention", value)

    @property
    @pulumi.getter
    def scheduling(self) -> pulumi.Input['BackupPolicySchedulingArgs']:
        """
        — Schedule settings for creating backups on the host.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: pulumi.Input['BackupPolicySchedulingArgs']):
        pulumi.set(self, "scheduling", value)

    @property
    @pulumi.getter(name="vmSnapshotReattempts")
    def vm_snapshot_reattempts(self) -> pulumi.Input['BackupPolicyVmSnapshotReattemptsArgs']:
        """
        — Amount of reattempts that should be performed while trying to make snapshot. This attribute consists of the following parameters:
        """
        return pulumi.get(self, "vm_snapshot_reattempts")

    @vm_snapshot_reattempts.setter
    def vm_snapshot_reattempts(self, value: pulumi.Input['BackupPolicyVmSnapshotReattemptsArgs']):
        pulumi.set(self, "vm_snapshot_reattempts", value)

    @property
    @pulumi.getter(name="archiveName")
    def archive_name(self) -> Optional[pulumi.Input[str]]:
        """
        — The name of generated archives.
        """
        return pulumi.get(self, "archive_name")

    @archive_name.setter
    def archive_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "archive_name", value)

    @property
    @pulumi.getter
    def cbt(self) -> Optional[pulumi.Input[str]]:
        """
        — Configuration of Changed Block Tracking. Available values are: `"USE_IF_ENABLED"`, `"ENABLED_AND_USE"`, `"DO_NOT_USE"`.
        """
        return pulumi.get(self, "cbt")

    @cbt.setter
    def cbt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cbt", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[str]]:
        """
        — Archive compression level. Affects CPU. Available values: `"NORMAL"`, `"HIGH"`, `"MAX"`, `"OFF"`.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter(name="fastBackupEnabled")
    def fast_backup_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "fast_backup_enabled")

    @fast_backup_enabled.setter
    def fast_backup_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fast_backup_enabled", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        — Format of the backup. It's strongly recommend to leave this option empty or `"AUTO"`. Available values: `"AUTO"`, `"VERSION_11"`, `"VERSION_12"`.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="multiVolumeSnapshottingEnabled")
    def multi_volume_snapshotting_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        — If true, snapshots of multiple volumes will be taken simultaneously.
        """
        return pulumi.get(self, "multi_volume_snapshotting_enabled")

    @multi_volume_snapshotting_enabled.setter
    def multi_volume_snapshotting_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_volume_snapshotting_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        — Name of the policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="performanceWindowEnabled")
    def performance_window_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        — Time windows for performance limitations of backup.
        """
        return pulumi.get(self, "performance_window_enabled")

    @performance_window_enabled.setter
    def performance_window_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "performance_window_enabled", value)

    @property
    @pulumi.getter(name="preserveFileSecuritySettings")
    def preserve_file_security_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        — Preserves file security settings. It's better to set this option to true.
        """
        return pulumi.get(self, "preserve_file_security_settings")

    @preserve_file_security_settings.setter
    def preserve_file_security_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_file_security_settings", value)

    @property
    @pulumi.getter(name="quiesceSnapshottingEnabled")
    def quiesce_snapshotting_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        — If true, a quiesced snapshot of the virtual machine will be taken.
        """
        return pulumi.get(self, "quiesce_snapshotting_enabled")

    @quiesce_snapshotting_enabled.setter
    def quiesce_snapshotting_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "quiesce_snapshotting_enabled", value)

    @property
    @pulumi.getter(name="silentModeEnabled")
    def silent_mode_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        — if true, a user interaction will be avoided when possible.
        """
        return pulumi.get(self, "silent_mode_enabled")

    @silent_mode_enabled.setter
    def silent_mode_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "silent_mode_enabled", value)

    @property
    @pulumi.getter(name="splittingBytes")
    def splitting_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        — determines the size to split backups. It's better to leave this option unchanged.
        """
        return pulumi.get(self, "splitting_bytes")

    @splitting_bytes.setter
    def splitting_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "splitting_bytes", value)

    @property
    @pulumi.getter(name="vssProvider")
    def vss_provider(self) -> Optional[pulumi.Input[str]]:
        """
        — Settings for the volume shadow copy service. Available values are: "`NATIVE`", `"TARGET_SYSTEM_DEFINED"`
        """
        return pulumi.get(self, "vss_provider")

    @vss_provider.setter
    def vss_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vss_provider", value)


@pulumi.input_type
class _BackupPolicyState:
    def __init__(__self__, *,
                 archive_name: Optional[pulumi.Input[str]] = None,
                 cbt: Optional[pulumi.Input[str]] = None,
                 compression: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 fast_backup_enabled: Optional[pulumi.Input[bool]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 multi_volume_snapshotting_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 performance_window_enabled: Optional[pulumi.Input[bool]] = None,
                 preserve_file_security_settings: Optional[pulumi.Input[bool]] = None,
                 quiesce_snapshotting_enabled: Optional[pulumi.Input[bool]] = None,
                 reattempts: Optional[pulumi.Input['BackupPolicyReattemptsArgs']] = None,
                 retention: Optional[pulumi.Input['BackupPolicyRetentionArgs']] = None,
                 scheduling: Optional[pulumi.Input['BackupPolicySchedulingArgs']] = None,
                 silent_mode_enabled: Optional[pulumi.Input[bool]] = None,
                 splitting_bytes: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 vm_snapshot_reattempts: Optional[pulumi.Input['BackupPolicyVmSnapshotReattemptsArgs']] = None,
                 vss_provider: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BackupPolicy resources.
        :param pulumi.Input[str] archive_name: — The name of generated archives.
        :param pulumi.Input[str] cbt: — Configuration of Changed Block Tracking. Available values are: `"USE_IF_ENABLED"`, `"ENABLED_AND_USE"`, `"DO_NOT_USE"`.
        :param pulumi.Input[str] compression: — Archive compression level. Affects CPU. Available values: `"NORMAL"`, `"HIGH"`, `"MAX"`, `"OFF"`.
        :param pulumi.Input[str] format: — Format of the backup. It's strongly recommend to leave this option empty or `"AUTO"`. Available values: `"AUTO"`, `"VERSION_11"`, `"VERSION_12"`.
        :param pulumi.Input[bool] multi_volume_snapshotting_enabled: — If true, snapshots of multiple volumes will be taken simultaneously.
        :param pulumi.Input[str] name: — Name of the policy
        :param pulumi.Input[bool] performance_window_enabled: — Time windows for performance limitations of backup.
        :param pulumi.Input[bool] preserve_file_security_settings: — Preserves file security settings. It's better to set this option to true.
        :param pulumi.Input[bool] quiesce_snapshotting_enabled: — If true, a quiesced snapshot of the virtual machine will be taken.
        :param pulumi.Input['BackupPolicyReattemptsArgs'] reattempts: — Amount of reattempts that should be performed while trying to make backup at the host. This attribute consists of the following parameters:
        :param pulumi.Input['BackupPolicyRetentionArgs'] retention: — Retention policy for backups. Allows to setup backups lifecycle. This attribute consists of the following parameters:
        :param pulumi.Input['BackupPolicySchedulingArgs'] scheduling: — Schedule settings for creating backups on the host.
        :param pulumi.Input[bool] silent_mode_enabled: — if true, a user interaction will be avoided when possible.
        :param pulumi.Input[str] splitting_bytes: — determines the size to split backups. It's better to leave this option unchanged.
        :param pulumi.Input['BackupPolicyVmSnapshotReattemptsArgs'] vm_snapshot_reattempts: — Amount of reattempts that should be performed while trying to make snapshot. This attribute consists of the following parameters:
        :param pulumi.Input[str] vss_provider: — Settings for the volume shadow copy service. Available values are: "`NATIVE`", `"TARGET_SYSTEM_DEFINED"`
        """
        if archive_name is not None:
            pulumi.set(__self__, "archive_name", archive_name)
        if cbt is not None:
            pulumi.set(__self__, "cbt", cbt)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if fast_backup_enabled is not None:
            pulumi.set(__self__, "fast_backup_enabled", fast_backup_enabled)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if multi_volume_snapshotting_enabled is not None:
            pulumi.set(__self__, "multi_volume_snapshotting_enabled", multi_volume_snapshotting_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_window_enabled is not None:
            pulumi.set(__self__, "performance_window_enabled", performance_window_enabled)
        if preserve_file_security_settings is not None:
            pulumi.set(__self__, "preserve_file_security_settings", preserve_file_security_settings)
        if quiesce_snapshotting_enabled is not None:
            pulumi.set(__self__, "quiesce_snapshotting_enabled", quiesce_snapshotting_enabled)
        if reattempts is not None:
            pulumi.set(__self__, "reattempts", reattempts)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if silent_mode_enabled is not None:
            pulumi.set(__self__, "silent_mode_enabled", silent_mode_enabled)
        if splitting_bytes is not None:
            pulumi.set(__self__, "splitting_bytes", splitting_bytes)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vm_snapshot_reattempts is not None:
            pulumi.set(__self__, "vm_snapshot_reattempts", vm_snapshot_reattempts)
        if vss_provider is not None:
            pulumi.set(__self__, "vss_provider", vss_provider)

    @property
    @pulumi.getter(name="archiveName")
    def archive_name(self) -> Optional[pulumi.Input[str]]:
        """
        — The name of generated archives.
        """
        return pulumi.get(self, "archive_name")

    @archive_name.setter
    def archive_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "archive_name", value)

    @property
    @pulumi.getter
    def cbt(self) -> Optional[pulumi.Input[str]]:
        """
        — Configuration of Changed Block Tracking. Available values are: `"USE_IF_ENABLED"`, `"ENABLED_AND_USE"`, `"DO_NOT_USE"`.
        """
        return pulumi.get(self, "cbt")

    @cbt.setter
    def cbt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cbt", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[str]]:
        """
        — Archive compression level. Affects CPU. Available values: `"NORMAL"`, `"HIGH"`, `"MAX"`, `"OFF"`.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="fastBackupEnabled")
    def fast_backup_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "fast_backup_enabled")

    @fast_backup_enabled.setter
    def fast_backup_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fast_backup_enabled", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        — Format of the backup. It's strongly recommend to leave this option empty or `"AUTO"`. Available values: `"AUTO"`, `"VERSION_11"`, `"VERSION_12"`.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="multiVolumeSnapshottingEnabled")
    def multi_volume_snapshotting_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        — If true, snapshots of multiple volumes will be taken simultaneously.
        """
        return pulumi.get(self, "multi_volume_snapshotting_enabled")

    @multi_volume_snapshotting_enabled.setter
    def multi_volume_snapshotting_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_volume_snapshotting_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        — Name of the policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="performanceWindowEnabled")
    def performance_window_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        — Time windows for performance limitations of backup.
        """
        return pulumi.get(self, "performance_window_enabled")

    @performance_window_enabled.setter
    def performance_window_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "performance_window_enabled", value)

    @property
    @pulumi.getter(name="preserveFileSecuritySettings")
    def preserve_file_security_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        — Preserves file security settings. It's better to set this option to true.
        """
        return pulumi.get(self, "preserve_file_security_settings")

    @preserve_file_security_settings.setter
    def preserve_file_security_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_file_security_settings", value)

    @property
    @pulumi.getter(name="quiesceSnapshottingEnabled")
    def quiesce_snapshotting_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        — If true, a quiesced snapshot of the virtual machine will be taken.
        """
        return pulumi.get(self, "quiesce_snapshotting_enabled")

    @quiesce_snapshotting_enabled.setter
    def quiesce_snapshotting_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "quiesce_snapshotting_enabled", value)

    @property
    @pulumi.getter
    def reattempts(self) -> Optional[pulumi.Input['BackupPolicyReattemptsArgs']]:
        """
        — Amount of reattempts that should be performed while trying to make backup at the host. This attribute consists of the following parameters:
        """
        return pulumi.get(self, "reattempts")

    @reattempts.setter
    def reattempts(self, value: Optional[pulumi.Input['BackupPolicyReattemptsArgs']]):
        pulumi.set(self, "reattempts", value)

    @property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input['BackupPolicyRetentionArgs']]:
        """
        — Retention policy for backups. Allows to setup backups lifecycle. This attribute consists of the following parameters:
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input['BackupPolicyRetentionArgs']]):
        pulumi.set(self, "retention", value)

    @property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['BackupPolicySchedulingArgs']]:
        """
        — Schedule settings for creating backups on the host.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['BackupPolicySchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @property
    @pulumi.getter(name="silentModeEnabled")
    def silent_mode_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        — if true, a user interaction will be avoided when possible.
        """
        return pulumi.get(self, "silent_mode_enabled")

    @silent_mode_enabled.setter
    def silent_mode_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "silent_mode_enabled", value)

    @property
    @pulumi.getter(name="splittingBytes")
    def splitting_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        — determines the size to split backups. It's better to leave this option unchanged.
        """
        return pulumi.get(self, "splitting_bytes")

    @splitting_bytes.setter
    def splitting_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "splitting_bytes", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="vmSnapshotReattempts")
    def vm_snapshot_reattempts(self) -> Optional[pulumi.Input['BackupPolicyVmSnapshotReattemptsArgs']]:
        """
        — Amount of reattempts that should be performed while trying to make snapshot. This attribute consists of the following parameters:
        """
        return pulumi.get(self, "vm_snapshot_reattempts")

    @vm_snapshot_reattempts.setter
    def vm_snapshot_reattempts(self, value: Optional[pulumi.Input['BackupPolicyVmSnapshotReattemptsArgs']]):
        pulumi.set(self, "vm_snapshot_reattempts", value)

    @property
    @pulumi.getter(name="vssProvider")
    def vss_provider(self) -> Optional[pulumi.Input[str]]:
        """
        — Settings for the volume shadow copy service. Available values are: "`NATIVE`", `"TARGET_SYSTEM_DEFINED"`
        """
        return pulumi.get(self, "vss_provider")

    @vss_provider.setter
    def vss_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vss_provider", value)


class BackupPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 archive_name: Optional[pulumi.Input[str]] = None,
                 cbt: Optional[pulumi.Input[str]] = None,
                 compression: Optional[pulumi.Input[str]] = None,
                 fast_backup_enabled: Optional[pulumi.Input[bool]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 multi_volume_snapshotting_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 performance_window_enabled: Optional[pulumi.Input[bool]] = None,
                 preserve_file_security_settings: Optional[pulumi.Input[bool]] = None,
                 quiesce_snapshotting_enabled: Optional[pulumi.Input[bool]] = None,
                 reattempts: Optional[pulumi.Input[Union['BackupPolicyReattemptsArgs', 'BackupPolicyReattemptsArgsDict']]] = None,
                 retention: Optional[pulumi.Input[Union['BackupPolicyRetentionArgs', 'BackupPolicyRetentionArgsDict']]] = None,
                 scheduling: Optional[pulumi.Input[Union['BackupPolicySchedulingArgs', 'BackupPolicySchedulingArgsDict']]] = None,
                 silent_mode_enabled: Optional[pulumi.Input[bool]] = None,
                 splitting_bytes: Optional[pulumi.Input[str]] = None,
                 vm_snapshot_reattempts: Optional[pulumi.Input[Union['BackupPolicyVmSnapshotReattemptsArgs', 'BackupPolicyVmSnapshotReattemptsArgsDict']]] = None,
                 vss_provider: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Allows management of [Yandex Cloud Backup Policy](https://yandex.cloud/docs/backup/concepts/policy).

        > Cloud Backup Provider must be activated in order to manipulate with policies. Active it either by UI Console or by `yc` command.

        ## Example Usage

        {{ tffile "examples/backup_policy/r_backup_policy_1.tf" }}

        For the full policy attributes, take a look at the following example:

        {{ tffile "examples/backup_policy/r_backup_policy_2.tf" }}

        ## Defined types

        ### interval_type 

        A string type, that accepts values in the format of: `number` + `time type`, where `time type` might be:

        - `s` — seconds
        - `m` — minutes
        - `h` — hours
        - `d` — days
        - `w` — weekdays
        - `M` — months

        Example of interval value: `"5m", "10d", "2M", "5w"`

        ### day_type

        A string type, that accepts the following values: `"ALWAYS_INCREMENTAL"`, `"ALWAYS_FULL"`, `"WEEKLY_FULL_DAILY_INCREMENTAL"`, `'WEEKLY_INCREMENTAL"`.

        ### backup_set_type

        `"TYPE_AUTO"`, `"TYPE_FULL"`, `"TYPE_INCREMENTAL"`, `'TYPE_DIFFERENTIAL"`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] archive_name: — The name of generated archives.
        :param pulumi.Input[str] cbt: — Configuration of Changed Block Tracking. Available values are: `"USE_IF_ENABLED"`, `"ENABLED_AND_USE"`, `"DO_NOT_USE"`.
        :param pulumi.Input[str] compression: — Archive compression level. Affects CPU. Available values: `"NORMAL"`, `"HIGH"`, `"MAX"`, `"OFF"`.
        :param pulumi.Input[str] format: — Format of the backup. It's strongly recommend to leave this option empty or `"AUTO"`. Available values: `"AUTO"`, `"VERSION_11"`, `"VERSION_12"`.
        :param pulumi.Input[bool] multi_volume_snapshotting_enabled: — If true, snapshots of multiple volumes will be taken simultaneously.
        :param pulumi.Input[str] name: — Name of the policy
        :param pulumi.Input[bool] performance_window_enabled: — Time windows for performance limitations of backup.
        :param pulumi.Input[bool] preserve_file_security_settings: — Preserves file security settings. It's better to set this option to true.
        :param pulumi.Input[bool] quiesce_snapshotting_enabled: — If true, a quiesced snapshot of the virtual machine will be taken.
        :param pulumi.Input[Union['BackupPolicyReattemptsArgs', 'BackupPolicyReattemptsArgsDict']] reattempts: — Amount of reattempts that should be performed while trying to make backup at the host. This attribute consists of the following parameters:
        :param pulumi.Input[Union['BackupPolicyRetentionArgs', 'BackupPolicyRetentionArgsDict']] retention: — Retention policy for backups. Allows to setup backups lifecycle. This attribute consists of the following parameters:
        :param pulumi.Input[Union['BackupPolicySchedulingArgs', 'BackupPolicySchedulingArgsDict']] scheduling: — Schedule settings for creating backups on the host.
        :param pulumi.Input[bool] silent_mode_enabled: — if true, a user interaction will be avoided when possible.
        :param pulumi.Input[str] splitting_bytes: — determines the size to split backups. It's better to leave this option unchanged.
        :param pulumi.Input[Union['BackupPolicyVmSnapshotReattemptsArgs', 'BackupPolicyVmSnapshotReattemptsArgsDict']] vm_snapshot_reattempts: — Amount of reattempts that should be performed while trying to make snapshot. This attribute consists of the following parameters:
        :param pulumi.Input[str] vss_provider: — Settings for the volume shadow copy service. Available values are: "`NATIVE`", `"TARGET_SYSTEM_DEFINED"`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [Yandex Cloud Backup Policy](https://yandex.cloud/docs/backup/concepts/policy).

        > Cloud Backup Provider must be activated in order to manipulate with policies. Active it either by UI Console or by `yc` command.

        ## Example Usage

        {{ tffile "examples/backup_policy/r_backup_policy_1.tf" }}

        For the full policy attributes, take a look at the following example:

        {{ tffile "examples/backup_policy/r_backup_policy_2.tf" }}

        ## Defined types

        ### interval_type 

        A string type, that accepts values in the format of: `number` + `time type`, where `time type` might be:

        - `s` — seconds
        - `m` — minutes
        - `h` — hours
        - `d` — days
        - `w` — weekdays
        - `M` — months

        Example of interval value: `"5m", "10d", "2M", "5w"`

        ### day_type

        A string type, that accepts the following values: `"ALWAYS_INCREMENTAL"`, `"ALWAYS_FULL"`, `"WEEKLY_FULL_DAILY_INCREMENTAL"`, `'WEEKLY_INCREMENTAL"`.

        ### backup_set_type

        `"TYPE_AUTO"`, `"TYPE_FULL"`, `"TYPE_INCREMENTAL"`, `'TYPE_DIFFERENTIAL"`.

        :param str resource_name: The name of the resource.
        :param BackupPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 archive_name: Optional[pulumi.Input[str]] = None,
                 cbt: Optional[pulumi.Input[str]] = None,
                 compression: Optional[pulumi.Input[str]] = None,
                 fast_backup_enabled: Optional[pulumi.Input[bool]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 multi_volume_snapshotting_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 performance_window_enabled: Optional[pulumi.Input[bool]] = None,
                 preserve_file_security_settings: Optional[pulumi.Input[bool]] = None,
                 quiesce_snapshotting_enabled: Optional[pulumi.Input[bool]] = None,
                 reattempts: Optional[pulumi.Input[Union['BackupPolicyReattemptsArgs', 'BackupPolicyReattemptsArgsDict']]] = None,
                 retention: Optional[pulumi.Input[Union['BackupPolicyRetentionArgs', 'BackupPolicyRetentionArgsDict']]] = None,
                 scheduling: Optional[pulumi.Input[Union['BackupPolicySchedulingArgs', 'BackupPolicySchedulingArgsDict']]] = None,
                 silent_mode_enabled: Optional[pulumi.Input[bool]] = None,
                 splitting_bytes: Optional[pulumi.Input[str]] = None,
                 vm_snapshot_reattempts: Optional[pulumi.Input[Union['BackupPolicyVmSnapshotReattemptsArgs', 'BackupPolicyVmSnapshotReattemptsArgsDict']]] = None,
                 vss_provider: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupPolicyArgs.__new__(BackupPolicyArgs)

            __props__.__dict__["archive_name"] = archive_name
            __props__.__dict__["cbt"] = cbt
            __props__.__dict__["compression"] = compression
            __props__.__dict__["fast_backup_enabled"] = fast_backup_enabled
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["format"] = format
            __props__.__dict__["multi_volume_snapshotting_enabled"] = multi_volume_snapshotting_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["performance_window_enabled"] = performance_window_enabled
            __props__.__dict__["preserve_file_security_settings"] = preserve_file_security_settings
            __props__.__dict__["quiesce_snapshotting_enabled"] = quiesce_snapshotting_enabled
            if reattempts is None and not opts.urn:
                raise TypeError("Missing required property 'reattempts'")
            __props__.__dict__["reattempts"] = reattempts
            if retention is None and not opts.urn:
                raise TypeError("Missing required property 'retention'")
            __props__.__dict__["retention"] = retention
            if scheduling is None and not opts.urn:
                raise TypeError("Missing required property 'scheduling'")
            __props__.__dict__["scheduling"] = scheduling
            __props__.__dict__["silent_mode_enabled"] = silent_mode_enabled
            __props__.__dict__["splitting_bytes"] = splitting_bytes
            if vm_snapshot_reattempts is None and not opts.urn:
                raise TypeError("Missing required property 'vm_snapshot_reattempts'")
            __props__.__dict__["vm_snapshot_reattempts"] = vm_snapshot_reattempts
            __props__.__dict__["vss_provider"] = vss_provider
            __props__.__dict__["created_at"] = None
            __props__.__dict__["enabled"] = None
            __props__.__dict__["updated_at"] = None
        super(BackupPolicy, __self__).__init__(
            'yandex:index/backupPolicy:BackupPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            archive_name: Optional[pulumi.Input[str]] = None,
            cbt: Optional[pulumi.Input[str]] = None,
            compression: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            fast_backup_enabled: Optional[pulumi.Input[bool]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            format: Optional[pulumi.Input[str]] = None,
            multi_volume_snapshotting_enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            performance_window_enabled: Optional[pulumi.Input[bool]] = None,
            preserve_file_security_settings: Optional[pulumi.Input[bool]] = None,
            quiesce_snapshotting_enabled: Optional[pulumi.Input[bool]] = None,
            reattempts: Optional[pulumi.Input[Union['BackupPolicyReattemptsArgs', 'BackupPolicyReattemptsArgsDict']]] = None,
            retention: Optional[pulumi.Input[Union['BackupPolicyRetentionArgs', 'BackupPolicyRetentionArgsDict']]] = None,
            scheduling: Optional[pulumi.Input[Union['BackupPolicySchedulingArgs', 'BackupPolicySchedulingArgsDict']]] = None,
            silent_mode_enabled: Optional[pulumi.Input[bool]] = None,
            splitting_bytes: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            vm_snapshot_reattempts: Optional[pulumi.Input[Union['BackupPolicyVmSnapshotReattemptsArgs', 'BackupPolicyVmSnapshotReattemptsArgsDict']]] = None,
            vss_provider: Optional[pulumi.Input[str]] = None) -> 'BackupPolicy':
        """
        Get an existing BackupPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] archive_name: — The name of generated archives.
        :param pulumi.Input[str] cbt: — Configuration of Changed Block Tracking. Available values are: `"USE_IF_ENABLED"`, `"ENABLED_AND_USE"`, `"DO_NOT_USE"`.
        :param pulumi.Input[str] compression: — Archive compression level. Affects CPU. Available values: `"NORMAL"`, `"HIGH"`, `"MAX"`, `"OFF"`.
        :param pulumi.Input[str] format: — Format of the backup. It's strongly recommend to leave this option empty or `"AUTO"`. Available values: `"AUTO"`, `"VERSION_11"`, `"VERSION_12"`.
        :param pulumi.Input[bool] multi_volume_snapshotting_enabled: — If true, snapshots of multiple volumes will be taken simultaneously.
        :param pulumi.Input[str] name: — Name of the policy
        :param pulumi.Input[bool] performance_window_enabled: — Time windows for performance limitations of backup.
        :param pulumi.Input[bool] preserve_file_security_settings: — Preserves file security settings. It's better to set this option to true.
        :param pulumi.Input[bool] quiesce_snapshotting_enabled: — If true, a quiesced snapshot of the virtual machine will be taken.
        :param pulumi.Input[Union['BackupPolicyReattemptsArgs', 'BackupPolicyReattemptsArgsDict']] reattempts: — Amount of reattempts that should be performed while trying to make backup at the host. This attribute consists of the following parameters:
        :param pulumi.Input[Union['BackupPolicyRetentionArgs', 'BackupPolicyRetentionArgsDict']] retention: — Retention policy for backups. Allows to setup backups lifecycle. This attribute consists of the following parameters:
        :param pulumi.Input[Union['BackupPolicySchedulingArgs', 'BackupPolicySchedulingArgsDict']] scheduling: — Schedule settings for creating backups on the host.
        :param pulumi.Input[bool] silent_mode_enabled: — if true, a user interaction will be avoided when possible.
        :param pulumi.Input[str] splitting_bytes: — determines the size to split backups. It's better to leave this option unchanged.
        :param pulumi.Input[Union['BackupPolicyVmSnapshotReattemptsArgs', 'BackupPolicyVmSnapshotReattemptsArgsDict']] vm_snapshot_reattempts: — Amount of reattempts that should be performed while trying to make snapshot. This attribute consists of the following parameters:
        :param pulumi.Input[str] vss_provider: — Settings for the volume shadow copy service. Available values are: "`NATIVE`", `"TARGET_SYSTEM_DEFINED"`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupPolicyState.__new__(_BackupPolicyState)

        __props__.__dict__["archive_name"] = archive_name
        __props__.__dict__["cbt"] = cbt
        __props__.__dict__["compression"] = compression
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["fast_backup_enabled"] = fast_backup_enabled
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["format"] = format
        __props__.__dict__["multi_volume_snapshotting_enabled"] = multi_volume_snapshotting_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["performance_window_enabled"] = performance_window_enabled
        __props__.__dict__["preserve_file_security_settings"] = preserve_file_security_settings
        __props__.__dict__["quiesce_snapshotting_enabled"] = quiesce_snapshotting_enabled
        __props__.__dict__["reattempts"] = reattempts
        __props__.__dict__["retention"] = retention
        __props__.__dict__["scheduling"] = scheduling
        __props__.__dict__["silent_mode_enabled"] = silent_mode_enabled
        __props__.__dict__["splitting_bytes"] = splitting_bytes
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["vm_snapshot_reattempts"] = vm_snapshot_reattempts
        __props__.__dict__["vss_provider"] = vss_provider
        return BackupPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="archiveName")
    def archive_name(self) -> pulumi.Output[Optional[str]]:
        """
        — The name of generated archives.
        """
        return pulumi.get(self, "archive_name")

    @property
    @pulumi.getter
    def cbt(self) -> pulumi.Output[Optional[str]]:
        """
        — Configuration of Changed Block Tracking. Available values are: `"USE_IF_ENABLED"`, `"ENABLED_AND_USE"`, `"DO_NOT_USE"`.
        """
        return pulumi.get(self, "cbt")

    @property
    @pulumi.getter
    def compression(self) -> pulumi.Output[Optional[str]]:
        """
        — Archive compression level. Affects CPU. Available values: `"NORMAL"`, `"HIGH"`, `"MAX"`, `"OFF"`.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="fastBackupEnabled")
    def fast_backup_enabled(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "fast_backup_enabled")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def format(self) -> pulumi.Output[Optional[str]]:
        """
        — Format of the backup. It's strongly recommend to leave this option empty or `"AUTO"`. Available values: `"AUTO"`, `"VERSION_11"`, `"VERSION_12"`.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="multiVolumeSnapshottingEnabled")
    def multi_volume_snapshotting_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        — If true, snapshots of multiple volumes will be taken simultaneously.
        """
        return pulumi.get(self, "multi_volume_snapshotting_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        — Name of the policy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="performanceWindowEnabled")
    def performance_window_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        — Time windows for performance limitations of backup.
        """
        return pulumi.get(self, "performance_window_enabled")

    @property
    @pulumi.getter(name="preserveFileSecuritySettings")
    def preserve_file_security_settings(self) -> pulumi.Output[Optional[bool]]:
        """
        — Preserves file security settings. It's better to set this option to true.
        """
        return pulumi.get(self, "preserve_file_security_settings")

    @property
    @pulumi.getter(name="quiesceSnapshottingEnabled")
    def quiesce_snapshotting_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        — If true, a quiesced snapshot of the virtual machine will be taken.
        """
        return pulumi.get(self, "quiesce_snapshotting_enabled")

    @property
    @pulumi.getter
    def reattempts(self) -> pulumi.Output['outputs.BackupPolicyReattempts']:
        """
        — Amount of reattempts that should be performed while trying to make backup at the host. This attribute consists of the following parameters:
        """
        return pulumi.get(self, "reattempts")

    @property
    @pulumi.getter
    def retention(self) -> pulumi.Output['outputs.BackupPolicyRetention']:
        """
        — Retention policy for backups. Allows to setup backups lifecycle. This attribute consists of the following parameters:
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter
    def scheduling(self) -> pulumi.Output['outputs.BackupPolicyScheduling']:
        """
        — Schedule settings for creating backups on the host.
        """
        return pulumi.get(self, "scheduling")

    @property
    @pulumi.getter(name="silentModeEnabled")
    def silent_mode_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        — if true, a user interaction will be avoided when possible.
        """
        return pulumi.get(self, "silent_mode_enabled")

    @property
    @pulumi.getter(name="splittingBytes")
    def splitting_bytes(self) -> pulumi.Output[Optional[str]]:
        """
        — determines the size to split backups. It's better to leave this option unchanged.
        """
        return pulumi.get(self, "splitting_bytes")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="vmSnapshotReattempts")
    def vm_snapshot_reattempts(self) -> pulumi.Output['outputs.BackupPolicyVmSnapshotReattempts']:
        """
        — Amount of reattempts that should be performed while trying to make snapshot. This attribute consists of the following parameters:
        """
        return pulumi.get(self, "vm_snapshot_reattempts")

    @property
    @pulumi.getter(name="vssProvider")
    def vss_provider(self) -> pulumi.Output[Optional[str]]:
        """
        — Settings for the volume shadow copy service. Available values are: "`NATIVE`", `"TARGET_SYSTEM_DEFINED"`
        """
        return pulumi.get(self, "vss_provider")

