# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['BackupPolicyBindingsArgs', 'BackupPolicyBindings']

@pulumi.input_type
class BackupPolicyBindingsArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 policy_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a BackupPolicyBindings resource.
        :param pulumi.Input[str] instance_id: — Compute Cloud instance ID.
        :param pulumi.Input[str] policy_id: — Backup Policy ID.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "policy_id", policy_id)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        — Compute Cloud instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[str]:
        """
        — Backup Policy ID.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_id", value)


@pulumi.input_type
class _BackupPolicyBindingsState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 processing: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering BackupPolicyBindings resources.
        :param pulumi.Input[str] created_at: (Computed) - Creation timestamp of the Yandex Cloud Policy Bindings.
        :param pulumi.Input[bool] enabled: (Computed) - Boolean flag that specifies whether the policy application is enabled. May be `false` if `processing` flag is `true`.
        :param pulumi.Input[str] instance_id: — Compute Cloud instance ID.
        :param pulumi.Input[str] policy_id: — Backup Policy ID.
        :param pulumi.Input[bool] processing: (Computed) - Boolean flag that specifies whether the policy is in the process of binding to an instance.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if processing is not None:
            pulumi.set(__self__, "processing", processing)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        (Computed) - Creation timestamp of the Yandex Cloud Policy Bindings.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Computed) - Boolean flag that specifies whether the policy application is enabled. May be `false` if `processing` flag is `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        — Compute Cloud instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        — Backup Policy ID.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def processing(self) -> Optional[pulumi.Input[bool]]:
        """
        (Computed) - Boolean flag that specifies whether the policy is in the process of binding to an instance.
        """
        return pulumi.get(self, "processing")

    @processing.setter
    def processing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "processing", value)


class BackupPolicyBindings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Allows management of [Yandex Cloud Attach and Detach VM](https://yandex.cloud/docs/backup/operations/policy-vm/attach-and-detach-vm).

        > Cloud Backup Provider must be activated in order to manipulate with policies. Active it either by UI Console or by `yc` command.

        ## Example Usage

        {{ tffile "examples/backup_policy_bindings/r_backup_policy_bindings_1.tf" }}

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_id: — Compute Cloud instance ID.
        :param pulumi.Input[str] policy_id: — Backup Policy ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupPolicyBindingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [Yandex Cloud Attach and Detach VM](https://yandex.cloud/docs/backup/operations/policy-vm/attach-and-detach-vm).

        > Cloud Backup Provider must be activated in order to manipulate with policies. Active it either by UI Console or by `yc` command.

        ## Example Usage

        {{ tffile "examples/backup_policy_bindings/r_backup_policy_bindings_1.tf" }}

        :param str resource_name: The name of the resource.
        :param BackupPolicyBindingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupPolicyBindingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupPolicyBindingsArgs.__new__(BackupPolicyBindingsArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["enabled"] = None
            __props__.__dict__["processing"] = None
        super(BackupPolicyBindings, __self__).__init__(
            'yandex:index/backupPolicyBindings:BackupPolicyBindings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            processing: Optional[pulumi.Input[bool]] = None) -> 'BackupPolicyBindings':
        """
        Get an existing BackupPolicyBindings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: (Computed) - Creation timestamp of the Yandex Cloud Policy Bindings.
        :param pulumi.Input[bool] enabled: (Computed) - Boolean flag that specifies whether the policy application is enabled. May be `false` if `processing` flag is `true`.
        :param pulumi.Input[str] instance_id: — Compute Cloud instance ID.
        :param pulumi.Input[str] policy_id: — Backup Policy ID.
        :param pulumi.Input[bool] processing: (Computed) - Boolean flag that specifies whether the policy is in the process of binding to an instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupPolicyBindingsState.__new__(_BackupPolicyBindingsState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["processing"] = processing
        return BackupPolicyBindings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        (Computed) - Creation timestamp of the Yandex Cloud Policy Bindings.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        (Computed) - Boolean flag that specifies whether the policy application is enabled. May be `false` if `processing` flag is `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        — Compute Cloud instance ID.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[str]:
        """
        — Backup Policy ID.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def processing(self) -> pulumi.Output[bool]:
        """
        (Computed) - Boolean flag that specifies whether the policy is in the process of binding to an instance.
        """
        return pulumi.get(self, "processing")

