# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComputeDiskArgs', 'ComputeDisk']

@pulumi.input_type
class ComputeDiskArgs:
    def __init__(__self__, *,
                 allow_recreate: Optional[pulumi.Input[bool]] = None,
                 block_size: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_placement_policy: Optional[pulumi.Input['ComputeDiskDiskPlacementPolicyArgs']] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 hardware_generation: Optional[pulumi.Input['ComputeDiskHardwareGenerationArgs']] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ComputeDisk resource.
        :param pulumi.Input[int] block_size: Block size of the disk, specified in bytes.
        :param pulumi.Input[str] description: Description of the disk. Provide this property when you create a resource.
        :param pulumi.Input['ComputeDiskDiskPlacementPolicyArgs'] disk_placement_policy: Disk placement policy configuration. The structure is documented below.
        :param pulumi.Input[str] folder_id: The ID of the folder that the disk belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input['ComputeDiskHardwareGenerationArgs'] hardware_generation: Hardware generation and its features,
               which will be applied to the instance when this disk is used as a boot
               disk. Provide this property if you wish to override this value, which
               otherwise is inherited from the source. The structure is documented below.
        :param pulumi.Input[str] image_id: The source image to use for disk creation.
        :param pulumi.Input[str] kms_key_id: ID of KMS symmetric key used to encrypt disk.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to assign to this disk. A list of key/value pairs.
        :param pulumi.Input[str] name: Name of the disk. Provide this property when you create a resource.
        :param pulumi.Input[int] size: Size of the persistent disk, specified in GB. You can specify this field when creating a persistent disk using the `image_id` or `snapshot_id` parameter, or specify it alone to create an empty persistent disk. If you specify this field along with `image_id` or `snapshot_id`, the size value must not be less than the size of the source image or the size of the snapshot.
        :param pulumi.Input[str] snapshot_id: The source snapshot to use for disk creation.
        :param pulumi.Input[str] type: Type of disk to create. Provide this when creating a disk.
        :param pulumi.Input[str] zone: Availability zone where the disk will reside.
        """
        if allow_recreate is not None:
            pulumi.set(__self__, "allow_recreate", allow_recreate)
        if block_size is not None:
            pulumi.set(__self__, "block_size", block_size)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_placement_policy is not None:
            pulumi.set(__self__, "disk_placement_policy", disk_placement_policy)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if hardware_generation is not None:
            pulumi.set(__self__, "hardware_generation", hardware_generation)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="allowRecreate")
    def allow_recreate(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_recreate")

    @allow_recreate.setter
    def allow_recreate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_recreate", value)

    @property
    @pulumi.getter(name="blockSize")
    def block_size(self) -> Optional[pulumi.Input[int]]:
        """
        Block size of the disk, specified in bytes.
        """
        return pulumi.get(self, "block_size")

    @block_size.setter
    def block_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "block_size", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the disk. Provide this property when you create a resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskPlacementPolicy")
    def disk_placement_policy(self) -> Optional[pulumi.Input['ComputeDiskDiskPlacementPolicyArgs']]:
        """
        Disk placement policy configuration. The structure is documented below.
        """
        return pulumi.get(self, "disk_placement_policy")

    @disk_placement_policy.setter
    def disk_placement_policy(self, value: Optional[pulumi.Input['ComputeDiskDiskPlacementPolicyArgs']]):
        pulumi.set(self, "disk_placement_policy", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the folder that the disk belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="hardwareGeneration")
    def hardware_generation(self) -> Optional[pulumi.Input['ComputeDiskHardwareGenerationArgs']]:
        """
        Hardware generation and its features,
        which will be applied to the instance when this disk is used as a boot
        disk. Provide this property if you wish to override this value, which
        otherwise is inherited from the source. The structure is documented below.
        """
        return pulumi.get(self, "hardware_generation")

    @hardware_generation.setter
    def hardware_generation(self, value: Optional[pulumi.Input['ComputeDiskHardwareGenerationArgs']]):
        pulumi.set(self, "hardware_generation", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The source image to use for disk creation.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of KMS symmetric key used to encrypt disk.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to assign to this disk. A list of key/value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the disk. Provide this property when you create a resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the persistent disk, specified in GB. You can specify this field when creating a persistent disk using the `image_id` or `snapshot_id` parameter, or specify it alone to create an empty persistent disk. If you specify this field along with `image_id` or `snapshot_id`, the size value must not be less than the size of the source image or the size of the snapshot.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        The source snapshot to use for disk creation.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of disk to create. Provide this when creating a disk.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Availability zone where the disk will reside.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _ComputeDiskState:
    def __init__(__self__, *,
                 allow_recreate: Optional[pulumi.Input[bool]] = None,
                 block_size: Optional[pulumi.Input[int]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_placement_policy: Optional[pulumi.Input['ComputeDiskDiskPlacementPolicyArgs']] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 hardware_generation: Optional[pulumi.Input['ComputeDiskHardwareGenerationArgs']] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ComputeDisk resources.
        :param pulumi.Input[int] block_size: Block size of the disk, specified in bytes.
        :param pulumi.Input[str] created_at: Creation timestamp of the disk.
        :param pulumi.Input[str] description: Description of the disk. Provide this property when you create a resource.
        :param pulumi.Input['ComputeDiskDiskPlacementPolicyArgs'] disk_placement_policy: Disk placement policy configuration. The structure is documented below.
        :param pulumi.Input[str] folder_id: The ID of the folder that the disk belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input['ComputeDiskHardwareGenerationArgs'] hardware_generation: Hardware generation and its features,
               which will be applied to the instance when this disk is used as a boot
               disk. Provide this property if you wish to override this value, which
               otherwise is inherited from the source. The structure is documented below.
        :param pulumi.Input[str] image_id: The source image to use for disk creation.
        :param pulumi.Input[str] kms_key_id: ID of KMS symmetric key used to encrypt disk.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to assign to this disk. A list of key/value pairs.
        :param pulumi.Input[str] name: Name of the disk. Provide this property when you create a resource.
        :param pulumi.Input[int] size: Size of the persistent disk, specified in GB. You can specify this field when creating a persistent disk using the `image_id` or `snapshot_id` parameter, or specify it alone to create an empty persistent disk. If you specify this field along with `image_id` or `snapshot_id`, the size value must not be less than the size of the source image or the size of the snapshot.
        :param pulumi.Input[str] snapshot_id: The source snapshot to use for disk creation.
        :param pulumi.Input[str] status: The status of the disk.
        :param pulumi.Input[str] type: Type of disk to create. Provide this when creating a disk.
        :param pulumi.Input[str] zone: Availability zone where the disk will reside.
        """
        if allow_recreate is not None:
            pulumi.set(__self__, "allow_recreate", allow_recreate)
        if block_size is not None:
            pulumi.set(__self__, "block_size", block_size)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_placement_policy is not None:
            pulumi.set(__self__, "disk_placement_policy", disk_placement_policy)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if hardware_generation is not None:
            pulumi.set(__self__, "hardware_generation", hardware_generation)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_ids is not None:
            pulumi.set(__self__, "product_ids", product_ids)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="allowRecreate")
    def allow_recreate(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_recreate")

    @allow_recreate.setter
    def allow_recreate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_recreate", value)

    @property
    @pulumi.getter(name="blockSize")
    def block_size(self) -> Optional[pulumi.Input[int]]:
        """
        Block size of the disk, specified in bytes.
        """
        return pulumi.get(self, "block_size")

    @block_size.setter
    def block_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "block_size", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp of the disk.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the disk. Provide this property when you create a resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskPlacementPolicy")
    def disk_placement_policy(self) -> Optional[pulumi.Input['ComputeDiskDiskPlacementPolicyArgs']]:
        """
        Disk placement policy configuration. The structure is documented below.
        """
        return pulumi.get(self, "disk_placement_policy")

    @disk_placement_policy.setter
    def disk_placement_policy(self, value: Optional[pulumi.Input['ComputeDiskDiskPlacementPolicyArgs']]):
        pulumi.set(self, "disk_placement_policy", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the folder that the disk belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="hardwareGeneration")
    def hardware_generation(self) -> Optional[pulumi.Input['ComputeDiskHardwareGenerationArgs']]:
        """
        Hardware generation and its features,
        which will be applied to the instance when this disk is used as a boot
        disk. Provide this property if you wish to override this value, which
        otherwise is inherited from the source. The structure is documented below.
        """
        return pulumi.get(self, "hardware_generation")

    @hardware_generation.setter
    def hardware_generation(self, value: Optional[pulumi.Input['ComputeDiskHardwareGenerationArgs']]):
        pulumi.set(self, "hardware_generation", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The source image to use for disk creation.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of KMS symmetric key used to encrypt disk.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to assign to this disk. A list of key/value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the disk. Provide this property when you create a resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="productIds")
    def product_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "product_ids")

    @product_ids.setter
    def product_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "product_ids", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the persistent disk, specified in GB. You can specify this field when creating a persistent disk using the `image_id` or `snapshot_id` parameter, or specify it alone to create an empty persistent disk. If you specify this field along with `image_id` or `snapshot_id`, the size value must not be less than the size of the source image or the size of the snapshot.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        The source snapshot to use for disk creation.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the disk.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of disk to create. Provide this when creating a disk.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Availability zone where the disk will reside.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class ComputeDisk(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_recreate: Optional[pulumi.Input[bool]] = None,
                 block_size: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_placement_policy: Optional[pulumi.Input[Union['ComputeDiskDiskPlacementPolicyArgs', 'ComputeDiskDiskPlacementPolicyArgsDict']]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 hardware_generation: Optional[pulumi.Input[Union['ComputeDiskHardwareGenerationArgs', 'ComputeDiskHardwareGenerationArgsDict']]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Persistent disks are used for data storage and function similarly to physical hard and solid state drives.

        A disk can be attached or detached from the virtual machine and can be located locally. A disk can be moved between virtual machines within the same availability zone. Each disk can be attached to only one virtual machine at a time.

        For more information about disks in Yandex Cloud, see:

        * [Documentation](https://cloud.yandex.com/docs/compute/concepts/disk)
        * How-to Guides
          * [Attach and detach a disk](https://cloud.yandex.com/docs/compute/concepts/disk#attach-detach)
          * [Backup operation](https://cloud.yandex.com/docs/compute/concepts/disk#backup)

        ## Example Usage

        {{ tffile "examples/compute_disk/r_compute_disk_1.tf" }}

        {{ tffile "examples/compute_disk/r_compute_disk_2.tf" }}

        ## Import

        A disk can be imported using any of these accepted formats:

        ```sh
        $ pulumi import yandex:index/computeDisk:ComputeDisk default disk_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] block_size: Block size of the disk, specified in bytes.
        :param pulumi.Input[str] description: Description of the disk. Provide this property when you create a resource.
        :param pulumi.Input[Union['ComputeDiskDiskPlacementPolicyArgs', 'ComputeDiskDiskPlacementPolicyArgsDict']] disk_placement_policy: Disk placement policy configuration. The structure is documented below.
        :param pulumi.Input[str] folder_id: The ID of the folder that the disk belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Union['ComputeDiskHardwareGenerationArgs', 'ComputeDiskHardwareGenerationArgsDict']] hardware_generation: Hardware generation and its features,
               which will be applied to the instance when this disk is used as a boot
               disk. Provide this property if you wish to override this value, which
               otherwise is inherited from the source. The structure is documented below.
        :param pulumi.Input[str] image_id: The source image to use for disk creation.
        :param pulumi.Input[str] kms_key_id: ID of KMS symmetric key used to encrypt disk.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to assign to this disk. A list of key/value pairs.
        :param pulumi.Input[str] name: Name of the disk. Provide this property when you create a resource.
        :param pulumi.Input[int] size: Size of the persistent disk, specified in GB. You can specify this field when creating a persistent disk using the `image_id` or `snapshot_id` parameter, or specify it alone to create an empty persistent disk. If you specify this field along with `image_id` or `snapshot_id`, the size value must not be less than the size of the source image or the size of the snapshot.
        :param pulumi.Input[str] snapshot_id: The source snapshot to use for disk creation.
        :param pulumi.Input[str] type: Type of disk to create. Provide this when creating a disk.
        :param pulumi.Input[str] zone: Availability zone where the disk will reside.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ComputeDiskArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Persistent disks are used for data storage and function similarly to physical hard and solid state drives.

        A disk can be attached or detached from the virtual machine and can be located locally. A disk can be moved between virtual machines within the same availability zone. Each disk can be attached to only one virtual machine at a time.

        For more information about disks in Yandex Cloud, see:

        * [Documentation](https://cloud.yandex.com/docs/compute/concepts/disk)
        * How-to Guides
          * [Attach and detach a disk](https://cloud.yandex.com/docs/compute/concepts/disk#attach-detach)
          * [Backup operation](https://cloud.yandex.com/docs/compute/concepts/disk#backup)

        ## Example Usage

        {{ tffile "examples/compute_disk/r_compute_disk_1.tf" }}

        {{ tffile "examples/compute_disk/r_compute_disk_2.tf" }}

        ## Import

        A disk can be imported using any of these accepted formats:

        ```sh
        $ pulumi import yandex:index/computeDisk:ComputeDisk default disk_id
        ```

        :param str resource_name: The name of the resource.
        :param ComputeDiskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeDiskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_recreate: Optional[pulumi.Input[bool]] = None,
                 block_size: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_placement_policy: Optional[pulumi.Input[Union['ComputeDiskDiskPlacementPolicyArgs', 'ComputeDiskDiskPlacementPolicyArgsDict']]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 hardware_generation: Optional[pulumi.Input[Union['ComputeDiskHardwareGenerationArgs', 'ComputeDiskHardwareGenerationArgsDict']]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeDiskArgs.__new__(ComputeDiskArgs)

            __props__.__dict__["allow_recreate"] = allow_recreate
            __props__.__dict__["block_size"] = block_size
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_placement_policy"] = disk_placement_policy
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["hardware_generation"] = hardware_generation
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["size"] = size
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["type"] = type
            __props__.__dict__["zone"] = zone
            __props__.__dict__["created_at"] = None
            __props__.__dict__["product_ids"] = None
            __props__.__dict__["status"] = None
        super(ComputeDisk, __self__).__init__(
            'yandex:index/computeDisk:ComputeDisk',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_recreate: Optional[pulumi.Input[bool]] = None,
            block_size: Optional[pulumi.Input[int]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disk_placement_policy: Optional[pulumi.Input[Union['ComputeDiskDiskPlacementPolicyArgs', 'ComputeDiskDiskPlacementPolicyArgsDict']]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            hardware_generation: Optional[pulumi.Input[Union['ComputeDiskHardwareGenerationArgs', 'ComputeDiskHardwareGenerationArgsDict']]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            product_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            size: Optional[pulumi.Input[int]] = None,
            snapshot_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'ComputeDisk':
        """
        Get an existing ComputeDisk resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] block_size: Block size of the disk, specified in bytes.
        :param pulumi.Input[str] created_at: Creation timestamp of the disk.
        :param pulumi.Input[str] description: Description of the disk. Provide this property when you create a resource.
        :param pulumi.Input[Union['ComputeDiskDiskPlacementPolicyArgs', 'ComputeDiskDiskPlacementPolicyArgsDict']] disk_placement_policy: Disk placement policy configuration. The structure is documented below.
        :param pulumi.Input[str] folder_id: The ID of the folder that the disk belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Union['ComputeDiskHardwareGenerationArgs', 'ComputeDiskHardwareGenerationArgsDict']] hardware_generation: Hardware generation and its features,
               which will be applied to the instance when this disk is used as a boot
               disk. Provide this property if you wish to override this value, which
               otherwise is inherited from the source. The structure is documented below.
        :param pulumi.Input[str] image_id: The source image to use for disk creation.
        :param pulumi.Input[str] kms_key_id: ID of KMS symmetric key used to encrypt disk.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to assign to this disk. A list of key/value pairs.
        :param pulumi.Input[str] name: Name of the disk. Provide this property when you create a resource.
        :param pulumi.Input[int] size: Size of the persistent disk, specified in GB. You can specify this field when creating a persistent disk using the `image_id` or `snapshot_id` parameter, or specify it alone to create an empty persistent disk. If you specify this field along with `image_id` or `snapshot_id`, the size value must not be less than the size of the source image or the size of the snapshot.
        :param pulumi.Input[str] snapshot_id: The source snapshot to use for disk creation.
        :param pulumi.Input[str] status: The status of the disk.
        :param pulumi.Input[str] type: Type of disk to create. Provide this when creating a disk.
        :param pulumi.Input[str] zone: Availability zone where the disk will reside.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeDiskState.__new__(_ComputeDiskState)

        __props__.__dict__["allow_recreate"] = allow_recreate
        __props__.__dict__["block_size"] = block_size
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_placement_policy"] = disk_placement_policy
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["hardware_generation"] = hardware_generation
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["product_ids"] = product_ids
        __props__.__dict__["size"] = size
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        __props__.__dict__["zone"] = zone
        return ComputeDisk(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowRecreate")
    def allow_recreate(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "allow_recreate")

    @property
    @pulumi.getter(name="blockSize")
    def block_size(self) -> pulumi.Output[Optional[int]]:
        """
        Block size of the disk, specified in bytes.
        """
        return pulumi.get(self, "block_size")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Creation timestamp of the disk.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the disk. Provide this property when you create a resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskPlacementPolicy")
    def disk_placement_policy(self) -> pulumi.Output['outputs.ComputeDiskDiskPlacementPolicy']:
        """
        Disk placement policy configuration. The structure is documented below.
        """
        return pulumi.get(self, "disk_placement_policy")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        The ID of the folder that the disk belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter(name="hardwareGeneration")
    def hardware_generation(self) -> pulumi.Output['outputs.ComputeDiskHardwareGeneration']:
        """
        Hardware generation and its features,
        which will be applied to the instance when this disk is used as a boot
        disk. Provide this property if you wish to override this value, which
        otherwise is inherited from the source. The structure is documented below.
        """
        return pulumi.get(self, "hardware_generation")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[str]]:
        """
        The source image to use for disk creation.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of KMS symmetric key used to encrypt disk.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels to assign to this disk. A list of key/value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the disk. Provide this property when you create a resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productIds")
    def product_ids(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "product_ids")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[Optional[int]]:
        """
        Size of the persistent disk, specified in GB. You can specify this field when creating a persistent disk using the `image_id` or `snapshot_id` parameter, or specify it alone to create an empty persistent disk. If you specify this field along with `image_id` or `snapshot_id`, the size value must not be less than the size of the source image or the size of the snapshot.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[str]]:
        """
        The source snapshot to use for disk creation.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the disk.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of disk to create. Provide this when creating a disk.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        Availability zone where the disk will reside.
        """
        return pulumi.get(self, "zone")

