# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComputeImageArgs', 'ComputeImage']

@pulumi.input_type
class ComputeImageArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 hardware_generation: Optional[pulumi.Input['ComputeImageHardwareGenerationArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 min_disk_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 pooled: Optional[pulumi.Input[bool]] = None,
                 product_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_disk: Optional[pulumi.Input[str]] = None,
                 source_family: Optional[pulumi.Input[str]] = None,
                 source_image: Optional[pulumi.Input[str]] = None,
                 source_snapshot: Optional[pulumi.Input[str]] = None,
                 source_url: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ComputeImage resource.
        :param pulumi.Input[str] description: An optional description of the image. Provide this property when you create a resource.
        :param pulumi.Input[str] family: The name of the image family to which this image belongs.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the image.
        :param pulumi.Input[int] min_disk_size: Minimum size in GB of the disk that will be created from this image.
        :param pulumi.Input[str] name: Name of the disk.
        :param pulumi.Input[str] os_type: Operating system type that is contained in the image. Possible values: "LINUX", "WINDOWS".
        :param pulumi.Input[bool] pooled: Optimize the image to create a disk.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] product_ids: License IDs that indicate which licenses are attached to this image.
               
               > One of `source_family`, `source_image`, `source_snapshot`, `source_disk` or `source_url` must be specified.
        :param pulumi.Input[str] source_disk: The ID of a disk to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[str] source_family: The name of the family to use as the source of the new image. The ID of the latest image is taken from the "standard-images" folder. Changing the family forces a new resource to be created.
        :param pulumi.Input[str] source_image: The ID of an existing image to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[str] source_snapshot: The ID of a snapshot to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[str] source_url: The URL to use as the source of the image. Changing this URL forces a new resource to be created.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if hardware_generation is not None:
            pulumi.set(__self__, "hardware_generation", hardware_generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if min_disk_size is not None:
            pulumi.set(__self__, "min_disk_size", min_disk_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if pooled is not None:
            pulumi.set(__self__, "pooled", pooled)
        if product_ids is not None:
            pulumi.set(__self__, "product_ids", product_ids)
        if source_disk is not None:
            pulumi.set(__self__, "source_disk", source_disk)
        if source_family is not None:
            pulumi.set(__self__, "source_family", source_family)
        if source_image is not None:
            pulumi.set(__self__, "source_image", source_image)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)
        if source_url is not None:
            pulumi.set(__self__, "source_url", source_url)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of the image. Provide this property when you create a resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the image family to which this image belongs.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="hardwareGeneration")
    def hardware_generation(self) -> Optional[pulumi.Input['ComputeImageHardwareGenerationArgs']]:
        return pulumi.get(self, "hardware_generation")

    @hardware_generation.setter
    def hardware_generation(self, value: Optional[pulumi.Input['ComputeImageHardwareGenerationArgs']]):
        pulumi.set(self, "hardware_generation", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the image.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="minDiskSize")
    def min_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum size in GB of the disk that will be created from this image.
        """
        return pulumi.get(self, "min_disk_size")

    @min_disk_size.setter
    def min_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_disk_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the disk.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[str]]:
        """
        Operating system type that is contained in the image. Possible values: "LINUX", "WINDOWS".
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter
    def pooled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optimize the image to create a disk.
        """
        return pulumi.get(self, "pooled")

    @pooled.setter
    def pooled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pooled", value)

    @property
    @pulumi.getter(name="productIds")
    def product_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        License IDs that indicate which licenses are attached to this image.

        > One of `source_family`, `source_image`, `source_snapshot`, `source_disk` or `source_url` must be specified.
        """
        return pulumi.get(self, "product_ids")

    @product_ids.setter
    def product_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "product_ids", value)

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of a disk to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_disk")

    @source_disk.setter
    def source_disk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_disk", value)

    @property
    @pulumi.getter(name="sourceFamily")
    def source_family(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the family to use as the source of the new image. The ID of the latest image is taken from the "standard-images" folder. Changing the family forces a new resource to be created.
        """
        return pulumi.get(self, "source_family")

    @source_family.setter
    def source_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_family", value)

    @property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an existing image to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_image")

    @source_image.setter
    def source_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_image", value)

    @property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of a snapshot to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_snapshot")

    @source_snapshot.setter
    def source_snapshot(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_snapshot", value)

    @property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL to use as the source of the image. Changing this URL forces a new resource to be created.
        """
        return pulumi.get(self, "source_url")

    @source_url.setter
    def source_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_url", value)


@pulumi.input_type
class _ComputeImageState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 hardware_generation: Optional[pulumi.Input['ComputeImageHardwareGenerationArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 min_disk_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 pooled: Optional[pulumi.Input[bool]] = None,
                 product_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 source_disk: Optional[pulumi.Input[str]] = None,
                 source_family: Optional[pulumi.Input[str]] = None,
                 source_image: Optional[pulumi.Input[str]] = None,
                 source_snapshot: Optional[pulumi.Input[str]] = None,
                 source_url: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ComputeImage resources.
        :param pulumi.Input[str] created_at: Creation timestamp of the image.
        :param pulumi.Input[str] description: An optional description of the image. Provide this property when you create a resource.
        :param pulumi.Input[str] family: The name of the image family to which this image belongs.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the image.
        :param pulumi.Input[int] min_disk_size: Minimum size in GB of the disk that will be created from this image.
        :param pulumi.Input[str] name: Name of the disk.
        :param pulumi.Input[str] os_type: Operating system type that is contained in the image. Possible values: "LINUX", "WINDOWS".
        :param pulumi.Input[bool] pooled: Optimize the image to create a disk.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] product_ids: License IDs that indicate which licenses are attached to this image.
               
               > One of `source_family`, `source_image`, `source_snapshot`, `source_disk` or `source_url` must be specified.
        :param pulumi.Input[int] size: The size of the image, specified in GB.
        :param pulumi.Input[str] source_disk: The ID of a disk to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[str] source_family: The name of the family to use as the source of the new image. The ID of the latest image is taken from the "standard-images" folder. Changing the family forces a new resource to be created.
        :param pulumi.Input[str] source_image: The ID of an existing image to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[str] source_snapshot: The ID of a snapshot to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[str] source_url: The URL to use as the source of the image. Changing this URL forces a new resource to be created.
        :param pulumi.Input[str] status: The status of the image.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if hardware_generation is not None:
            pulumi.set(__self__, "hardware_generation", hardware_generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if min_disk_size is not None:
            pulumi.set(__self__, "min_disk_size", min_disk_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if pooled is not None:
            pulumi.set(__self__, "pooled", pooled)
        if product_ids is not None:
            pulumi.set(__self__, "product_ids", product_ids)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if source_disk is not None:
            pulumi.set(__self__, "source_disk", source_disk)
        if source_family is not None:
            pulumi.set(__self__, "source_family", source_family)
        if source_image is not None:
            pulumi.set(__self__, "source_image", source_image)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)
        if source_url is not None:
            pulumi.set(__self__, "source_url", source_url)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp of the image.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of the image. Provide this property when you create a resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the image family to which this image belongs.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="hardwareGeneration")
    def hardware_generation(self) -> Optional[pulumi.Input['ComputeImageHardwareGenerationArgs']]:
        return pulumi.get(self, "hardware_generation")

    @hardware_generation.setter
    def hardware_generation(self, value: Optional[pulumi.Input['ComputeImageHardwareGenerationArgs']]):
        pulumi.set(self, "hardware_generation", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the image.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="minDiskSize")
    def min_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum size in GB of the disk that will be created from this image.
        """
        return pulumi.get(self, "min_disk_size")

    @min_disk_size.setter
    def min_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_disk_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the disk.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[str]]:
        """
        Operating system type that is contained in the image. Possible values: "LINUX", "WINDOWS".
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter
    def pooled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optimize the image to create a disk.
        """
        return pulumi.get(self, "pooled")

    @pooled.setter
    def pooled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pooled", value)

    @property
    @pulumi.getter(name="productIds")
    def product_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        License IDs that indicate which licenses are attached to this image.

        > One of `source_family`, `source_image`, `source_snapshot`, `source_disk` or `source_url` must be specified.
        """
        return pulumi.get(self, "product_ids")

    @product_ids.setter
    def product_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "product_ids", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the image, specified in GB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of a disk to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_disk")

    @source_disk.setter
    def source_disk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_disk", value)

    @property
    @pulumi.getter(name="sourceFamily")
    def source_family(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the family to use as the source of the new image. The ID of the latest image is taken from the "standard-images" folder. Changing the family forces a new resource to be created.
        """
        return pulumi.get(self, "source_family")

    @source_family.setter
    def source_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_family", value)

    @property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an existing image to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_image")

    @source_image.setter
    def source_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_image", value)

    @property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of a snapshot to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_snapshot")

    @source_snapshot.setter
    def source_snapshot(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_snapshot", value)

    @property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL to use as the source of the image. Changing this URL forces a new resource to be created.
        """
        return pulumi.get(self, "source_url")

    @source_url.setter
    def source_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_url", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the image.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class ComputeImage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 hardware_generation: Optional[pulumi.Input[Union['ComputeImageHardwareGenerationArgs', 'ComputeImageHardwareGenerationArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 min_disk_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 pooled: Optional[pulumi.Input[bool]] = None,
                 product_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_disk: Optional[pulumi.Input[str]] = None,
                 source_family: Optional[pulumi.Input[str]] = None,
                 source_image: Optional[pulumi.Input[str]] = None,
                 source_snapshot: Optional[pulumi.Input[str]] = None,
                 source_url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a virtual machine image resource for the Yandex Compute Cloud service from an existing tarball. For more information, see [the official documentation](https://cloud.yandex.com/docs/compute/concepts/image).

        ## Example Usage

        {{ tffile "examples/compute_image/r_compute_image_1.tf" }}

        ## Import

        A VM image can be imported using the `id` of the resource, e.g.

        ```sh
        $ pulumi import yandex:index/computeImage:ComputeImage web-image image_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description of the image. Provide this property when you create a resource.
        :param pulumi.Input[str] family: The name of the image family to which this image belongs.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the image.
        :param pulumi.Input[int] min_disk_size: Minimum size in GB of the disk that will be created from this image.
        :param pulumi.Input[str] name: Name of the disk.
        :param pulumi.Input[str] os_type: Operating system type that is contained in the image. Possible values: "LINUX", "WINDOWS".
        :param pulumi.Input[bool] pooled: Optimize the image to create a disk.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] product_ids: License IDs that indicate which licenses are attached to this image.
               
               > One of `source_family`, `source_image`, `source_snapshot`, `source_disk` or `source_url` must be specified.
        :param pulumi.Input[str] source_disk: The ID of a disk to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[str] source_family: The name of the family to use as the source of the new image. The ID of the latest image is taken from the "standard-images" folder. Changing the family forces a new resource to be created.
        :param pulumi.Input[str] source_image: The ID of an existing image to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[str] source_snapshot: The ID of a snapshot to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[str] source_url: The URL to use as the source of the image. Changing this URL forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ComputeImageArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a virtual machine image resource for the Yandex Compute Cloud service from an existing tarball. For more information, see [the official documentation](https://cloud.yandex.com/docs/compute/concepts/image).

        ## Example Usage

        {{ tffile "examples/compute_image/r_compute_image_1.tf" }}

        ## Import

        A VM image can be imported using the `id` of the resource, e.g.

        ```sh
        $ pulumi import yandex:index/computeImage:ComputeImage web-image image_id
        ```

        :param str resource_name: The name of the resource.
        :param ComputeImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 hardware_generation: Optional[pulumi.Input[Union['ComputeImageHardwareGenerationArgs', 'ComputeImageHardwareGenerationArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 min_disk_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 pooled: Optional[pulumi.Input[bool]] = None,
                 product_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_disk: Optional[pulumi.Input[str]] = None,
                 source_family: Optional[pulumi.Input[str]] = None,
                 source_image: Optional[pulumi.Input[str]] = None,
                 source_snapshot: Optional[pulumi.Input[str]] = None,
                 source_url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeImageArgs.__new__(ComputeImageArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["family"] = family
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["hardware_generation"] = hardware_generation
            __props__.__dict__["labels"] = labels
            __props__.__dict__["min_disk_size"] = min_disk_size
            __props__.__dict__["name"] = name
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["pooled"] = pooled
            __props__.__dict__["product_ids"] = product_ids
            __props__.__dict__["source_disk"] = source_disk
            __props__.__dict__["source_family"] = source_family
            __props__.__dict__["source_image"] = source_image
            __props__.__dict__["source_snapshot"] = source_snapshot
            __props__.__dict__["source_url"] = source_url
            __props__.__dict__["created_at"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["status"] = None
        super(ComputeImage, __self__).__init__(
            'yandex:index/computeImage:ComputeImage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            family: Optional[pulumi.Input[str]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            hardware_generation: Optional[pulumi.Input[Union['ComputeImageHardwareGenerationArgs', 'ComputeImageHardwareGenerationArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            min_disk_size: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            os_type: Optional[pulumi.Input[str]] = None,
            pooled: Optional[pulumi.Input[bool]] = None,
            product_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            size: Optional[pulumi.Input[int]] = None,
            source_disk: Optional[pulumi.Input[str]] = None,
            source_family: Optional[pulumi.Input[str]] = None,
            source_image: Optional[pulumi.Input[str]] = None,
            source_snapshot: Optional[pulumi.Input[str]] = None,
            source_url: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'ComputeImage':
        """
        Get an existing ComputeImage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: Creation timestamp of the image.
        :param pulumi.Input[str] description: An optional description of the image. Provide this property when you create a resource.
        :param pulumi.Input[str] family: The name of the image family to which this image belongs.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the image.
        :param pulumi.Input[int] min_disk_size: Minimum size in GB of the disk that will be created from this image.
        :param pulumi.Input[str] name: Name of the disk.
        :param pulumi.Input[str] os_type: Operating system type that is contained in the image. Possible values: "LINUX", "WINDOWS".
        :param pulumi.Input[bool] pooled: Optimize the image to create a disk.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] product_ids: License IDs that indicate which licenses are attached to this image.
               
               > One of `source_family`, `source_image`, `source_snapshot`, `source_disk` or `source_url` must be specified.
        :param pulumi.Input[int] size: The size of the image, specified in GB.
        :param pulumi.Input[str] source_disk: The ID of a disk to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[str] source_family: The name of the family to use as the source of the new image. The ID of the latest image is taken from the "standard-images" folder. Changing the family forces a new resource to be created.
        :param pulumi.Input[str] source_image: The ID of an existing image to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[str] source_snapshot: The ID of a snapshot to use as the source of the image. Changing this ID forces a new resource to be created.
        :param pulumi.Input[str] source_url: The URL to use as the source of the image. Changing this URL forces a new resource to be created.
        :param pulumi.Input[str] status: The status of the image.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeImageState.__new__(_ComputeImageState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["family"] = family
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["hardware_generation"] = hardware_generation
        __props__.__dict__["labels"] = labels
        __props__.__dict__["min_disk_size"] = min_disk_size
        __props__.__dict__["name"] = name
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["pooled"] = pooled
        __props__.__dict__["product_ids"] = product_ids
        __props__.__dict__["size"] = size
        __props__.__dict__["source_disk"] = source_disk
        __props__.__dict__["source_family"] = source_family
        __props__.__dict__["source_image"] = source_image
        __props__.__dict__["source_snapshot"] = source_snapshot
        __props__.__dict__["source_url"] = source_url
        __props__.__dict__["status"] = status
        return ComputeImage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Creation timestamp of the image.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of the image. Provide this property when you create a resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def family(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the image family to which this image belongs.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter(name="hardwareGeneration")
    def hardware_generation(self) -> pulumi.Output['outputs.ComputeImageHardwareGeneration']:
        return pulumi.get(self, "hardware_generation")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A set of key/value label pairs to assign to the image.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="minDiskSize")
    def min_disk_size(self) -> pulumi.Output[int]:
        """
        Minimum size in GB of the disk that will be created from this image.
        """
        return pulumi.get(self, "min_disk_size")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the disk.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[str]:
        """
        Operating system type that is contained in the image. Possible values: "LINUX", "WINDOWS".
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def pooled(self) -> pulumi.Output[bool]:
        """
        Optimize the image to create a disk.
        """
        return pulumi.get(self, "pooled")

    @property
    @pulumi.getter(name="productIds")
    def product_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        License IDs that indicate which licenses are attached to this image.

        > One of `source_family`, `source_image`, `source_snapshot`, `source_disk` or `source_url` must be specified.
        """
        return pulumi.get(self, "product_ids")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        The size of the image, specified in GB.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> pulumi.Output[str]:
        """
        The ID of a disk to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_disk")

    @property
    @pulumi.getter(name="sourceFamily")
    def source_family(self) -> pulumi.Output[str]:
        """
        The name of the family to use as the source of the new image. The ID of the latest image is taken from the "standard-images" folder. Changing the family forces a new resource to be created.
        """
        return pulumi.get(self, "source_family")

    @property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> pulumi.Output[str]:
        """
        The ID of an existing image to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_image")

    @property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> pulumi.Output[str]:
        """
        The ID of a snapshot to use as the source of the image. Changing this ID forces a new resource to be created.
        """
        return pulumi.get(self, "source_snapshot")

    @property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> pulumi.Output[str]:
        """
        The URL to use as the source of the image. Changing this URL forces a new resource to be created.
        """
        return pulumi.get(self, "source_url")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the image.
        """
        return pulumi.get(self, "status")

