# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ComputePlacementGroupArgs', 'ComputePlacementGroup']

@pulumi.input_type
class ComputePlacementGroupArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 placement_strategy_partitions: Optional[pulumi.Input[int]] = None,
                 placement_strategy_spread: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ComputePlacementGroup resource.
        :param pulumi.Input[str] description: A description of the Placement Group.
        :param pulumi.Input[str] folder_id: Folder that the resource belongs to. If value is omitted, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Placement Group.
        :param pulumi.Input[str] name: The name of the Placement Group.
        :param pulumi.Input[int] placement_strategy_partitions: A number of partitions in the placement strategy with partitions policy of the Placement Group (conflicts with placement_strategy_spread).
        :param pulumi.Input[bool] placement_strategy_spread: A placement strategy with spread policy of the Placement Group. Should be true or unset (conflicts with placement_strategy_partitions).
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if placement_strategy_partitions is not None:
            pulumi.set(__self__, "placement_strategy_partitions", placement_strategy_partitions)
        if placement_strategy_spread is not None:
            pulumi.set(__self__, "placement_strategy_spread", placement_strategy_spread)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the Placement Group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        Folder that the resource belongs to. If value is omitted, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the Placement Group.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Placement Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="placementStrategyPartitions")
    def placement_strategy_partitions(self) -> Optional[pulumi.Input[int]]:
        """
        A number of partitions in the placement strategy with partitions policy of the Placement Group (conflicts with placement_strategy_spread).
        """
        return pulumi.get(self, "placement_strategy_partitions")

    @placement_strategy_partitions.setter
    def placement_strategy_partitions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "placement_strategy_partitions", value)

    @property
    @pulumi.getter(name="placementStrategySpread")
    def placement_strategy_spread(self) -> Optional[pulumi.Input[bool]]:
        """
        A placement strategy with spread policy of the Placement Group. Should be true or unset (conflicts with placement_strategy_partitions).
        """
        return pulumi.get(self, "placement_strategy_spread")

    @placement_strategy_spread.setter
    def placement_strategy_spread(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "placement_strategy_spread", value)


@pulumi.input_type
class _ComputePlacementGroupState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 placement_strategy_partitions: Optional[pulumi.Input[int]] = None,
                 placement_strategy_spread: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering ComputePlacementGroup resources.
        :param pulumi.Input[str] description: A description of the Placement Group.
        :param pulumi.Input[str] folder_id: Folder that the resource belongs to. If value is omitted, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Placement Group.
        :param pulumi.Input[str] name: The name of the Placement Group.
        :param pulumi.Input[int] placement_strategy_partitions: A number of partitions in the placement strategy with partitions policy of the Placement Group (conflicts with placement_strategy_spread).
        :param pulumi.Input[bool] placement_strategy_spread: A placement strategy with spread policy of the Placement Group. Should be true or unset (conflicts with placement_strategy_partitions).
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if placement_strategy_partitions is not None:
            pulumi.set(__self__, "placement_strategy_partitions", placement_strategy_partitions)
        if placement_strategy_spread is not None:
            pulumi.set(__self__, "placement_strategy_spread", placement_strategy_spread)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the Placement Group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        Folder that the resource belongs to. If value is omitted, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the Placement Group.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Placement Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="placementStrategyPartitions")
    def placement_strategy_partitions(self) -> Optional[pulumi.Input[int]]:
        """
        A number of partitions in the placement strategy with partitions policy of the Placement Group (conflicts with placement_strategy_spread).
        """
        return pulumi.get(self, "placement_strategy_partitions")

    @placement_strategy_partitions.setter
    def placement_strategy_partitions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "placement_strategy_partitions", value)

    @property
    @pulumi.getter(name="placementStrategySpread")
    def placement_strategy_spread(self) -> Optional[pulumi.Input[bool]]:
        """
        A placement strategy with spread policy of the Placement Group. Should be true or unset (conflicts with placement_strategy_partitions).
        """
        return pulumi.get(self, "placement_strategy_spread")

    @placement_strategy_spread.setter
    def placement_strategy_spread(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "placement_strategy_spread", value)


class ComputePlacementGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 placement_strategy_partitions: Optional[pulumi.Input[int]] = None,
                 placement_strategy_spread: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        A Placement group resource. For more information, see [the official documentation](https://cloud.yandex.com/docs/compute/concepts/placement-groups).

        ## Example Usage

        {{ tffile "examples/compute_placement_group/r_compute_placement_group_1.tf" }}

        ## Import

        A Placement Group can be imported using any of these accepted formats:

        ```sh
        $ pulumi import yandex:index/computePlacementGroup:ComputePlacementGroup default placement_group_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of the Placement Group.
        :param pulumi.Input[str] folder_id: Folder that the resource belongs to. If value is omitted, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Placement Group.
        :param pulumi.Input[str] name: The name of the Placement Group.
        :param pulumi.Input[int] placement_strategy_partitions: A number of partitions in the placement strategy with partitions policy of the Placement Group (conflicts with placement_strategy_spread).
        :param pulumi.Input[bool] placement_strategy_spread: A placement strategy with spread policy of the Placement Group. Should be true or unset (conflicts with placement_strategy_partitions).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ComputePlacementGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Placement group resource. For more information, see [the official documentation](https://cloud.yandex.com/docs/compute/concepts/placement-groups).

        ## Example Usage

        {{ tffile "examples/compute_placement_group/r_compute_placement_group_1.tf" }}

        ## Import

        A Placement Group can be imported using any of these accepted formats:

        ```sh
        $ pulumi import yandex:index/computePlacementGroup:ComputePlacementGroup default placement_group_id
        ```

        :param str resource_name: The name of the resource.
        :param ComputePlacementGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputePlacementGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 placement_strategy_partitions: Optional[pulumi.Input[int]] = None,
                 placement_strategy_spread: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputePlacementGroupArgs.__new__(ComputePlacementGroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["placement_strategy_partitions"] = placement_strategy_partitions
            __props__.__dict__["placement_strategy_spread"] = placement_strategy_spread
            __props__.__dict__["created_at"] = None
        super(ComputePlacementGroup, __self__).__init__(
            'yandex:index/computePlacementGroup:ComputePlacementGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            placement_strategy_partitions: Optional[pulumi.Input[int]] = None,
            placement_strategy_spread: Optional[pulumi.Input[bool]] = None) -> 'ComputePlacementGroup':
        """
        Get an existing ComputePlacementGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of the Placement Group.
        :param pulumi.Input[str] folder_id: Folder that the resource belongs to. If value is omitted, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Placement Group.
        :param pulumi.Input[str] name: The name of the Placement Group.
        :param pulumi.Input[int] placement_strategy_partitions: A number of partitions in the placement strategy with partitions policy of the Placement Group (conflicts with placement_strategy_spread).
        :param pulumi.Input[bool] placement_strategy_spread: A placement strategy with spread policy of the Placement Group. Should be true or unset (conflicts with placement_strategy_partitions).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputePlacementGroupState.__new__(_ComputePlacementGroupState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["placement_strategy_partitions"] = placement_strategy_partitions
        __props__.__dict__["placement_strategy_spread"] = placement_strategy_spread
        return ComputePlacementGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the Placement Group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        Folder that the resource belongs to. If value is omitted, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A set of key/value label pairs to assign to the Placement Group.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Placement Group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="placementStrategyPartitions")
    def placement_strategy_partitions(self) -> pulumi.Output[Optional[int]]:
        """
        A number of partitions in the placement strategy with partitions policy of the Placement Group (conflicts with placement_strategy_spread).
        """
        return pulumi.get(self, "placement_strategy_partitions")

    @property
    @pulumi.getter(name="placementStrategySpread")
    def placement_strategy_spread(self) -> pulumi.Output[Optional[bool]]:
        """
        A placement strategy with spread policy of the Placement Group. Should be true or unset (conflicts with placement_strategy_partitions).
        """
        return pulumi.get(self, "placement_strategy_spread")

