# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComputeSnapshotArgs', 'ComputeSnapshot']

@pulumi.input_type
class ComputeSnapshotArgs:
    def __init__(__self__, *,
                 source_disk_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 hardware_generation: Optional[pulumi.Input['ComputeSnapshotHardwareGenerationArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ComputeSnapshot resource.
        :param pulumi.Input[str] source_disk_id: ID of the disk to create a snapshot from.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input['ComputeSnapshotHardwareGenerationArgs'] hardware_generation: Hardware generation and its features,
               which will be applied to the instance when this snapshot is used as a boot
               disk source. Provide this property if you wish to override this value, which
               otherwise is inherited from the source. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the snapshot.
        :param pulumi.Input[str] name: A name for the resource.
        """
        pulumi.set(__self__, "source_disk_id", source_disk_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if hardware_generation is not None:
            pulumi.set(__self__, "hardware_generation", hardware_generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="sourceDiskId")
    def source_disk_id(self) -> pulumi.Input[str]:
        """
        ID of the disk to create a snapshot from.
        """
        return pulumi.get(self, "source_disk_id")

    @source_disk_id.setter
    def source_disk_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_disk_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="hardwareGeneration")
    def hardware_generation(self) -> Optional[pulumi.Input['ComputeSnapshotHardwareGenerationArgs']]:
        """
        Hardware generation and its features,
        which will be applied to the instance when this snapshot is used as a boot
        disk source. Provide this property if you wish to override this value, which
        otherwise is inherited from the source. The structure is documented below.
        """
        return pulumi.get(self, "hardware_generation")

    @hardware_generation.setter
    def hardware_generation(self, value: Optional[pulumi.Input['ComputeSnapshotHardwareGenerationArgs']]):
        pulumi.set(self, "hardware_generation", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the snapshot.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ComputeSnapshotState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_size: Optional[pulumi.Input[int]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 hardware_generation: Optional[pulumi.Input['ComputeSnapshotHardwareGenerationArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_disk_id: Optional[pulumi.Input[str]] = None,
                 storage_size: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ComputeSnapshot resources.
        :param pulumi.Input[str] created_at: Creation timestamp of the snapshot.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[int] disk_size: Size of the disk when the snapshot was created, specified in GB.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input['ComputeSnapshotHardwareGenerationArgs'] hardware_generation: Hardware generation and its features,
               which will be applied to the instance when this snapshot is used as a boot
               disk source. Provide this property if you wish to override this value, which
               otherwise is inherited from the source. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the snapshot.
        :param pulumi.Input[str] name: A name for the resource.
        :param pulumi.Input[str] source_disk_id: ID of the disk to create a snapshot from.
        :param pulumi.Input[int] storage_size: Size of the snapshot, specified in GB.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if hardware_generation is not None:
            pulumi.set(__self__, "hardware_generation", hardware_generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_disk_id is not None:
            pulumi.set(__self__, "source_disk_id", source_disk_id)
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp of the snapshot.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the disk when the snapshot was created, specified in GB.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="hardwareGeneration")
    def hardware_generation(self) -> Optional[pulumi.Input['ComputeSnapshotHardwareGenerationArgs']]:
        """
        Hardware generation and its features,
        which will be applied to the instance when this snapshot is used as a boot
        disk source. Provide this property if you wish to override this value, which
        otherwise is inherited from the source. The structure is documented below.
        """
        return pulumi.get(self, "hardware_generation")

    @hardware_generation.setter
    def hardware_generation(self, value: Optional[pulumi.Input['ComputeSnapshotHardwareGenerationArgs']]):
        pulumi.set(self, "hardware_generation", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the snapshot.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceDiskId")
    def source_disk_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the disk to create a snapshot from.
        """
        return pulumi.get(self, "source_disk_id")

    @source_disk_id.setter
    def source_disk_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_disk_id", value)

    @property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the snapshot, specified in GB.
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_size", value)


class ComputeSnapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 hardware_generation: Optional[pulumi.Input[Union['ComputeSnapshotHardwareGenerationArgs', 'ComputeSnapshotHardwareGenerationArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_disk_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new snapshot of a disk. For more information, see [the official documentation](https://cloud.yandex.com/docs/compute/concepts/snapshot).

        ## Example Usage

        {{ tffile "examples/compute_snapshot/r_compute_snapshot_1.tf" }}

        ## Import

        A snapshot can be imported using the `id` of the resource, e.g.

        ```sh
        $ pulumi import yandex:index/computeSnapshot:ComputeSnapshot disk-snapshot shapshot_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Union['ComputeSnapshotHardwareGenerationArgs', 'ComputeSnapshotHardwareGenerationArgsDict']] hardware_generation: Hardware generation and its features,
               which will be applied to the instance when this snapshot is used as a boot
               disk source. Provide this property if you wish to override this value, which
               otherwise is inherited from the source. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the snapshot.
        :param pulumi.Input[str] name: A name for the resource.
        :param pulumi.Input[str] source_disk_id: ID of the disk to create a snapshot from.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputeSnapshotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new snapshot of a disk. For more information, see [the official documentation](https://cloud.yandex.com/docs/compute/concepts/snapshot).

        ## Example Usage

        {{ tffile "examples/compute_snapshot/r_compute_snapshot_1.tf" }}

        ## Import

        A snapshot can be imported using the `id` of the resource, e.g.

        ```sh
        $ pulumi import yandex:index/computeSnapshot:ComputeSnapshot disk-snapshot shapshot_id
        ```

        :param str resource_name: The name of the resource.
        :param ComputeSnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeSnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 hardware_generation: Optional[pulumi.Input[Union['ComputeSnapshotHardwareGenerationArgs', 'ComputeSnapshotHardwareGenerationArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_disk_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeSnapshotArgs.__new__(ComputeSnapshotArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["hardware_generation"] = hardware_generation
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            if source_disk_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_disk_id'")
            __props__.__dict__["source_disk_id"] = source_disk_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["disk_size"] = None
            __props__.__dict__["storage_size"] = None
        super(ComputeSnapshot, __self__).__init__(
            'yandex:index/computeSnapshot:ComputeSnapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disk_size: Optional[pulumi.Input[int]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            hardware_generation: Optional[pulumi.Input[Union['ComputeSnapshotHardwareGenerationArgs', 'ComputeSnapshotHardwareGenerationArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            source_disk_id: Optional[pulumi.Input[str]] = None,
            storage_size: Optional[pulumi.Input[int]] = None) -> 'ComputeSnapshot':
        """
        Get an existing ComputeSnapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: Creation timestamp of the snapshot.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[int] disk_size: Size of the disk when the snapshot was created, specified in GB.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Union['ComputeSnapshotHardwareGenerationArgs', 'ComputeSnapshotHardwareGenerationArgsDict']] hardware_generation: Hardware generation and its features,
               which will be applied to the instance when this snapshot is used as a boot
               disk source. Provide this property if you wish to override this value, which
               otherwise is inherited from the source. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the snapshot.
        :param pulumi.Input[str] name: A name for the resource.
        :param pulumi.Input[str] source_disk_id: ID of the disk to create a snapshot from.
        :param pulumi.Input[int] storage_size: Size of the snapshot, specified in GB.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeSnapshotState.__new__(_ComputeSnapshotState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_size"] = disk_size
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["hardware_generation"] = hardware_generation
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["source_disk_id"] = source_disk_id
        __props__.__dict__["storage_size"] = storage_size
        return ComputeSnapshot(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Creation timestamp of the snapshot.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> pulumi.Output[int]:
        """
        Size of the disk when the snapshot was created, specified in GB.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter(name="hardwareGeneration")
    def hardware_generation(self) -> pulumi.Output['outputs.ComputeSnapshotHardwareGeneration']:
        """
        Hardware generation and its features,
        which will be applied to the instance when this snapshot is used as a boot
        disk source. Provide this property if you wish to override this value, which
        otherwise is inherited from the source. The structure is documented below.
        """
        return pulumi.get(self, "hardware_generation")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A set of key/value label pairs to assign to the snapshot.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A name for the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceDiskId")
    def source_disk_id(self) -> pulumi.Output[str]:
        """
        ID of the disk to create a snapshot from.
        """
        return pulumi.get(self, "source_disk_id")

    @property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> pulumi.Output[int]:
        """
        Size of the snapshot, specified in GB.
        """
        return pulumi.get(self, "storage_size")

