# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComputeSnapshotScheduleArgs', 'ComputeSnapshotSchedule']

@pulumi.input_type
class ComputeSnapshotScheduleArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_period: Optional[pulumi.Input[str]] = None,
                 schedule_policy: Optional[pulumi.Input['ComputeSnapshotScheduleSchedulePolicyArgs']] = None,
                 snapshot_count: Optional[pulumi.Input[int]] = None,
                 snapshot_spec: Optional[pulumi.Input['ComputeSnapshotScheduleSnapshotSpecArgs']] = None):
        """
        The set of arguments for constructing a ComputeSnapshotSchedule resource.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disk_ids: IDs of the disk for snapshot schedule.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the snapshot schedule.
        :param pulumi.Input[str] name: A name for the resource.
        :param pulumi.Input[str] retention_period: Time duration applied to snapshots created by this snapshot schedule. This is a signed sequence of decimal numbers, each with optional fraction and a unit suffix. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h". Examples: "300ms", "1.5h" or "2h45m".
        :param pulumi.Input['ComputeSnapshotScheduleSchedulePolicyArgs'] schedule_policy: Schedule policy of the snapshot schedule.
        :param pulumi.Input[int] snapshot_count: Maximum number of snapshots for every disk of the snapshot schedule.
        :param pulumi.Input['ComputeSnapshotScheduleSnapshotSpecArgs'] snapshot_spec: Additional attributes for snapshots created by this snapshot schedule.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_ids is not None:
            pulumi.set(__self__, "disk_ids", disk_ids)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if schedule_policy is not None:
            pulumi.set(__self__, "schedule_policy", schedule_policy)
        if snapshot_count is not None:
            pulumi.set(__self__, "snapshot_count", snapshot_count)
        if snapshot_spec is not None:
            pulumi.set(__self__, "snapshot_spec", snapshot_spec)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskIds")
    def disk_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IDs of the disk for snapshot schedule.
        """
        return pulumi.get(self, "disk_ids")

    @disk_ids.setter
    def disk_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "disk_ids", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the snapshot schedule.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[str]]:
        """
        Time duration applied to snapshots created by this snapshot schedule. This is a signed sequence of decimal numbers, each with optional fraction and a unit suffix. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h". Examples: "300ms", "1.5h" or "2h45m".
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_period", value)

    @property
    @pulumi.getter(name="schedulePolicy")
    def schedule_policy(self) -> Optional[pulumi.Input['ComputeSnapshotScheduleSchedulePolicyArgs']]:
        """
        Schedule policy of the snapshot schedule.
        """
        return pulumi.get(self, "schedule_policy")

    @schedule_policy.setter
    def schedule_policy(self, value: Optional[pulumi.Input['ComputeSnapshotScheduleSchedulePolicyArgs']]):
        pulumi.set(self, "schedule_policy", value)

    @property
    @pulumi.getter(name="snapshotCount")
    def snapshot_count(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of snapshots for every disk of the snapshot schedule.
        """
        return pulumi.get(self, "snapshot_count")

    @snapshot_count.setter
    def snapshot_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "snapshot_count", value)

    @property
    @pulumi.getter(name="snapshotSpec")
    def snapshot_spec(self) -> Optional[pulumi.Input['ComputeSnapshotScheduleSnapshotSpecArgs']]:
        """
        Additional attributes for snapshots created by this snapshot schedule.
        """
        return pulumi.get(self, "snapshot_spec")

    @snapshot_spec.setter
    def snapshot_spec(self, value: Optional[pulumi.Input['ComputeSnapshotScheduleSnapshotSpecArgs']]):
        pulumi.set(self, "snapshot_spec", value)


@pulumi.input_type
class _ComputeSnapshotScheduleState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_period: Optional[pulumi.Input[str]] = None,
                 schedule_policy: Optional[pulumi.Input['ComputeSnapshotScheduleSchedulePolicyArgs']] = None,
                 snapshot_count: Optional[pulumi.Input[int]] = None,
                 snapshot_spec: Optional[pulumi.Input['ComputeSnapshotScheduleSnapshotSpecArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ComputeSnapshotSchedule resources.
        :param pulumi.Input[str] created_at: Creation timestamp of the snapshot schedule.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disk_ids: IDs of the disk for snapshot schedule.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the snapshot schedule.
        :param pulumi.Input[str] name: A name for the resource.
        :param pulumi.Input[str] retention_period: Time duration applied to snapshots created by this snapshot schedule. This is a signed sequence of decimal numbers, each with optional fraction and a unit suffix. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h". Examples: "300ms", "1.5h" or "2h45m".
        :param pulumi.Input['ComputeSnapshotScheduleSchedulePolicyArgs'] schedule_policy: Schedule policy of the snapshot schedule.
        :param pulumi.Input[int] snapshot_count: Maximum number of snapshots for every disk of the snapshot schedule.
        :param pulumi.Input['ComputeSnapshotScheduleSnapshotSpecArgs'] snapshot_spec: Additional attributes for snapshots created by this snapshot schedule.
        :param pulumi.Input[str] status: The status of the snapshot schedule.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_ids is not None:
            pulumi.set(__self__, "disk_ids", disk_ids)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if schedule_policy is not None:
            pulumi.set(__self__, "schedule_policy", schedule_policy)
        if snapshot_count is not None:
            pulumi.set(__self__, "snapshot_count", snapshot_count)
        if snapshot_spec is not None:
            pulumi.set(__self__, "snapshot_spec", snapshot_spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp of the snapshot schedule.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskIds")
    def disk_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IDs of the disk for snapshot schedule.
        """
        return pulumi.get(self, "disk_ids")

    @disk_ids.setter
    def disk_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "disk_ids", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the snapshot schedule.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[str]]:
        """
        Time duration applied to snapshots created by this snapshot schedule. This is a signed sequence of decimal numbers, each with optional fraction and a unit suffix. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h". Examples: "300ms", "1.5h" or "2h45m".
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_period", value)

    @property
    @pulumi.getter(name="schedulePolicy")
    def schedule_policy(self) -> Optional[pulumi.Input['ComputeSnapshotScheduleSchedulePolicyArgs']]:
        """
        Schedule policy of the snapshot schedule.
        """
        return pulumi.get(self, "schedule_policy")

    @schedule_policy.setter
    def schedule_policy(self, value: Optional[pulumi.Input['ComputeSnapshotScheduleSchedulePolicyArgs']]):
        pulumi.set(self, "schedule_policy", value)

    @property
    @pulumi.getter(name="snapshotCount")
    def snapshot_count(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of snapshots for every disk of the snapshot schedule.
        """
        return pulumi.get(self, "snapshot_count")

    @snapshot_count.setter
    def snapshot_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "snapshot_count", value)

    @property
    @pulumi.getter(name="snapshotSpec")
    def snapshot_spec(self) -> Optional[pulumi.Input['ComputeSnapshotScheduleSnapshotSpecArgs']]:
        """
        Additional attributes for snapshots created by this snapshot schedule.
        """
        return pulumi.get(self, "snapshot_spec")

    @snapshot_spec.setter
    def snapshot_spec(self, value: Optional[pulumi.Input['ComputeSnapshotScheduleSnapshotSpecArgs']]):
        pulumi.set(self, "snapshot_spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the snapshot schedule.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class ComputeSnapshotSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_period: Optional[pulumi.Input[str]] = None,
                 schedule_policy: Optional[pulumi.Input[Union['ComputeSnapshotScheduleSchedulePolicyArgs', 'ComputeSnapshotScheduleSchedulePolicyArgsDict']]] = None,
                 snapshot_count: Optional[pulumi.Input[int]] = None,
                 snapshot_spec: Optional[pulumi.Input[Union['ComputeSnapshotScheduleSnapshotSpecArgs', 'ComputeSnapshotScheduleSnapshotSpecArgsDict']]] = None,
                 __props__=None):
        """
        Creates a new snapshot schedule. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/snapshot-schedule).

        ## Example Usage

        {{ tffile "examples/compute_snapshot_schedule/r_compute_snapshot_schedule_1.tf" }}

        ## Import

        A snapshot schedule can be imported using the `id` of the resource, e.g.

        ```sh
        $ pulumi import yandex:index/computeSnapshotSchedule:ComputeSnapshotSchedule my-schedule snapshot_schedule_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disk_ids: IDs of the disk for snapshot schedule.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the snapshot schedule.
        :param pulumi.Input[str] name: A name for the resource.
        :param pulumi.Input[str] retention_period: Time duration applied to snapshots created by this snapshot schedule. This is a signed sequence of decimal numbers, each with optional fraction and a unit suffix. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h". Examples: "300ms", "1.5h" or "2h45m".
        :param pulumi.Input[Union['ComputeSnapshotScheduleSchedulePolicyArgs', 'ComputeSnapshotScheduleSchedulePolicyArgsDict']] schedule_policy: Schedule policy of the snapshot schedule.
        :param pulumi.Input[int] snapshot_count: Maximum number of snapshots for every disk of the snapshot schedule.
        :param pulumi.Input[Union['ComputeSnapshotScheduleSnapshotSpecArgs', 'ComputeSnapshotScheduleSnapshotSpecArgsDict']] snapshot_spec: Additional attributes for snapshots created by this snapshot schedule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ComputeSnapshotScheduleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new snapshot schedule. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/snapshot-schedule).

        ## Example Usage

        {{ tffile "examples/compute_snapshot_schedule/r_compute_snapshot_schedule_1.tf" }}

        ## Import

        A snapshot schedule can be imported using the `id` of the resource, e.g.

        ```sh
        $ pulumi import yandex:index/computeSnapshotSchedule:ComputeSnapshotSchedule my-schedule snapshot_schedule_id
        ```

        :param str resource_name: The name of the resource.
        :param ComputeSnapshotScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeSnapshotScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_period: Optional[pulumi.Input[str]] = None,
                 schedule_policy: Optional[pulumi.Input[Union['ComputeSnapshotScheduleSchedulePolicyArgs', 'ComputeSnapshotScheduleSchedulePolicyArgsDict']]] = None,
                 snapshot_count: Optional[pulumi.Input[int]] = None,
                 snapshot_spec: Optional[pulumi.Input[Union['ComputeSnapshotScheduleSnapshotSpecArgs', 'ComputeSnapshotScheduleSnapshotSpecArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeSnapshotScheduleArgs.__new__(ComputeSnapshotScheduleArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["disk_ids"] = disk_ids
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["retention_period"] = retention_period
            __props__.__dict__["schedule_policy"] = schedule_policy
            __props__.__dict__["snapshot_count"] = snapshot_count
            __props__.__dict__["snapshot_spec"] = snapshot_spec
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
        super(ComputeSnapshotSchedule, __self__).__init__(
            'yandex:index/computeSnapshotSchedule:ComputeSnapshotSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            retention_period: Optional[pulumi.Input[str]] = None,
            schedule_policy: Optional[pulumi.Input[Union['ComputeSnapshotScheduleSchedulePolicyArgs', 'ComputeSnapshotScheduleSchedulePolicyArgsDict']]] = None,
            snapshot_count: Optional[pulumi.Input[int]] = None,
            snapshot_spec: Optional[pulumi.Input[Union['ComputeSnapshotScheduleSnapshotSpecArgs', 'ComputeSnapshotScheduleSnapshotSpecArgsDict']]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'ComputeSnapshotSchedule':
        """
        Get an existing ComputeSnapshotSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: Creation timestamp of the snapshot schedule.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disk_ids: IDs of the disk for snapshot schedule.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the snapshot schedule.
        :param pulumi.Input[str] name: A name for the resource.
        :param pulumi.Input[str] retention_period: Time duration applied to snapshots created by this snapshot schedule. This is a signed sequence of decimal numbers, each with optional fraction and a unit suffix. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h". Examples: "300ms", "1.5h" or "2h45m".
        :param pulumi.Input[Union['ComputeSnapshotScheduleSchedulePolicyArgs', 'ComputeSnapshotScheduleSchedulePolicyArgsDict']] schedule_policy: Schedule policy of the snapshot schedule.
        :param pulumi.Input[int] snapshot_count: Maximum number of snapshots for every disk of the snapshot schedule.
        :param pulumi.Input[Union['ComputeSnapshotScheduleSnapshotSpecArgs', 'ComputeSnapshotScheduleSnapshotSpecArgsDict']] snapshot_spec: Additional attributes for snapshots created by this snapshot schedule.
        :param pulumi.Input[str] status: The status of the snapshot schedule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeSnapshotScheduleState.__new__(_ComputeSnapshotScheduleState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_ids"] = disk_ids
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["retention_period"] = retention_period
        __props__.__dict__["schedule_policy"] = schedule_policy
        __props__.__dict__["snapshot_count"] = snapshot_count
        __props__.__dict__["snapshot_spec"] = snapshot_spec
        __props__.__dict__["status"] = status
        return ComputeSnapshotSchedule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Creation timestamp of the snapshot schedule.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskIds")
    def disk_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        IDs of the disk for snapshot schedule.
        """
        return pulumi.get(self, "disk_ids")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A set of key/value label pairs to assign to the snapshot schedule.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A name for the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> pulumi.Output[Optional[str]]:
        """
        Time duration applied to snapshots created by this snapshot schedule. This is a signed sequence of decimal numbers, each with optional fraction and a unit suffix. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h". Examples: "300ms", "1.5h" or "2h45m".
        """
        return pulumi.get(self, "retention_period")

    @property
    @pulumi.getter(name="schedulePolicy")
    def schedule_policy(self) -> pulumi.Output['outputs.ComputeSnapshotScheduleSchedulePolicy']:
        """
        Schedule policy of the snapshot schedule.
        """
        return pulumi.get(self, "schedule_policy")

    @property
    @pulumi.getter(name="snapshotCount")
    def snapshot_count(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum number of snapshots for every disk of the snapshot schedule.
        """
        return pulumi.get(self, "snapshot_count")

    @property
    @pulumi.getter(name="snapshotSpec")
    def snapshot_spec(self) -> pulumi.Output['outputs.ComputeSnapshotScheduleSnapshotSpec']:
        """
        Additional attributes for snapshots created by this snapshot schedule.
        """
        return pulumi.get(self, "snapshot_spec")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the snapshot schedule.
        """
        return pulumi.get(self, "status")

