# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ContainerRegistryIpPermissionArgs', 'ContainerRegistryIpPermission']

@pulumi.input_type
class ContainerRegistryIpPermissionArgs:
    def __init__(__self__, *,
                 registry_id: pulumi.Input[str],
                 pulls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pushes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ContainerRegistryIpPermission resource.
        :param pulumi.Input[str] registry_id: The ID of the registry that ip restrictions applied to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pulls: List of configured CIDRs, from which pull is allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pushes: List of configured CIDRs, from which push is allowed.
        """
        pulumi.set(__self__, "registry_id", registry_id)
        if pulls is not None:
            pulumi.set(__self__, "pulls", pulls)
        if pushes is not None:
            pulumi.set(__self__, "pushes", pushes)

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> pulumi.Input[str]:
        """
        The ID of the registry that ip restrictions applied to.
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "registry_id", value)

    @property
    @pulumi.getter
    def pulls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of configured CIDRs, from which pull is allowed.
        """
        return pulumi.get(self, "pulls")

    @pulls.setter
    def pulls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pulls", value)

    @property
    @pulumi.getter
    def pushes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of configured CIDRs, from which push is allowed.
        """
        return pulumi.get(self, "pushes")

    @pushes.setter
    def pushes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pushes", value)


@pulumi.input_type
class _ContainerRegistryIpPermissionState:
    def __init__(__self__, *,
                 pulls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pushes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 registry_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ContainerRegistryIpPermission resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pulls: List of configured CIDRs, from which pull is allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pushes: List of configured CIDRs, from which push is allowed.
        :param pulumi.Input[str] registry_id: The ID of the registry that ip restrictions applied to.
        """
        if pulls is not None:
            pulumi.set(__self__, "pulls", pulls)
        if pushes is not None:
            pulumi.set(__self__, "pushes", pushes)
        if registry_id is not None:
            pulumi.set(__self__, "registry_id", registry_id)

    @property
    @pulumi.getter
    def pulls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of configured CIDRs, from which pull is allowed.
        """
        return pulumi.get(self, "pulls")

    @pulls.setter
    def pulls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pulls", value)

    @property
    @pulumi.getter
    def pushes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of configured CIDRs, from which push is allowed.
        """
        return pulumi.get(self, "pushes")

    @pushes.setter
    def pushes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pushes", value)

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the registry that ip restrictions applied to.
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_id", value)


class ContainerRegistryIpPermission(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 pulls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pushes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 registry_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new Container Registry IP Permission. For more information, see [the official documentation](https://yandex.cloud/docs/container-registry/operations/registry/registry-access)

        ## Example Usage

        {{ tffile "examples/container_registry_ip_permission/r_container_registry_ip_permission_1.tf" }}

        ## Import

        An ip premission can be imported using the `id` of the Container Registry it is applied to, e.g.

        bash

        ```sh
        $ pulumi import yandex:index/containerRegistryIpPermission:ContainerRegistryIpPermission my_ip_permission registry_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pulls: List of configured CIDRs, from which pull is allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pushes: List of configured CIDRs, from which push is allowed.
        :param pulumi.Input[str] registry_id: The ID of the registry that ip restrictions applied to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerRegistryIpPermissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Container Registry IP Permission. For more information, see [the official documentation](https://yandex.cloud/docs/container-registry/operations/registry/registry-access)

        ## Example Usage

        {{ tffile "examples/container_registry_ip_permission/r_container_registry_ip_permission_1.tf" }}

        ## Import

        An ip premission can be imported using the `id` of the Container Registry it is applied to, e.g.

        bash

        ```sh
        $ pulumi import yandex:index/containerRegistryIpPermission:ContainerRegistryIpPermission my_ip_permission registry_id
        ```

        :param str resource_name: The name of the resource.
        :param ContainerRegistryIpPermissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerRegistryIpPermissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 pulls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pushes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 registry_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerRegistryIpPermissionArgs.__new__(ContainerRegistryIpPermissionArgs)

            __props__.__dict__["pulls"] = pulls
            __props__.__dict__["pushes"] = pushes
            if registry_id is None and not opts.urn:
                raise TypeError("Missing required property 'registry_id'")
            __props__.__dict__["registry_id"] = registry_id
        super(ContainerRegistryIpPermission, __self__).__init__(
            'yandex:index/containerRegistryIpPermission:ContainerRegistryIpPermission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            pulls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            pushes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            registry_id: Optional[pulumi.Input[str]] = None) -> 'ContainerRegistryIpPermission':
        """
        Get an existing ContainerRegistryIpPermission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pulls: List of configured CIDRs, from which pull is allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pushes: List of configured CIDRs, from which push is allowed.
        :param pulumi.Input[str] registry_id: The ID of the registry that ip restrictions applied to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerRegistryIpPermissionState.__new__(_ContainerRegistryIpPermissionState)

        __props__.__dict__["pulls"] = pulls
        __props__.__dict__["pushes"] = pushes
        __props__.__dict__["registry_id"] = registry_id
        return ContainerRegistryIpPermission(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def pulls(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of configured CIDRs, from which pull is allowed.
        """
        return pulumi.get(self, "pulls")

    @property
    @pulumi.getter
    def pushes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of configured CIDRs, from which push is allowed.
        """
        return pulumi.get(self, "pushes")

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> pulumi.Output[str]:
        """
        The ID of the registry that ip restrictions applied to.
        """
        return pulumi.get(self, "registry_id")

