# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContainerRepositoryLifecyclePolicyArgs', 'ContainerRepositoryLifecyclePolicy']

@pulumi.input_type
class ContainerRepositoryLifecyclePolicyArgs:
    def __init__(__self__, *,
                 repository_id: pulumi.Input[str],
                 status: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRepositoryLifecyclePolicyRuleArgs']]]] = None):
        """
        The set of arguments for constructing a ContainerRepositoryLifecyclePolicy resource.
        :param pulumi.Input[str] repository_id: The ID of the repository that the resource belongs to.
        :param pulumi.Input[str] status: The status of lifecycle policy. Must be `active` or `disabled`.
        :param pulumi.Input[str] description: Description of the lifecycle policy.
        :param pulumi.Input[str] name: Lifecycle policy name.
        """
        pulumi.set(__self__, "repository_id", repository_id)
        pulumi.set(__self__, "status", status)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[str]:
        """
        The ID of the repository that the resource belongs to.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_id", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        The status of lifecycle policy. Must be `active` or `disabled`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the lifecycle policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Lifecycle policy name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRepositoryLifecyclePolicyRuleArgs']]]]:
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRepositoryLifecyclePolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _ContainerRepositoryLifecyclePolicyState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 repository_id: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRepositoryLifecyclePolicyRuleArgs']]]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ContainerRepositoryLifecyclePolicy resources.
        :param pulumi.Input[str] created_at: Creation timestamp of the instance.
        :param pulumi.Input[str] description: Description of the lifecycle policy.
        :param pulumi.Input[str] name: Lifecycle policy name.
        :param pulumi.Input[str] repository_id: The ID of the repository that the resource belongs to.
        :param pulumi.Input[str] status: The status of lifecycle policy. Must be `active` or `disabled`.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp of the instance.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the lifecycle policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Lifecycle policy name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the repository that the resource belongs to.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_id", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRepositoryLifecyclePolicyRuleArgs']]]]:
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRepositoryLifecyclePolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of lifecycle policy. Must be `active` or `disabled`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class ContainerRepositoryLifecyclePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 repository_id: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerRepositoryLifecyclePolicyRuleArgs', 'ContainerRepositoryLifecyclePolicyRuleArgsDict']]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new container repository lifecycle policy. For more information, see [the official documentation](https://yandex.cloud/docs/container-registry/concepts/lifecycle-policy).

        ## Example Usage

        {{ tffile "examples/container_repository_lifecycle_policy/r_container_repository_lifecycle_policy_1.tf" }}

        ## Import

        A lifecycle policy can be imported using the `id` of the resource, e.g.

        bash

        ```sh
        $ pulumi import yandex:index/containerRepositoryLifecyclePolicy:ContainerRepositoryLifecyclePolicy my_lifecycle_policy lifecycle_policy_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the lifecycle policy.
        :param pulumi.Input[str] name: Lifecycle policy name.
        :param pulumi.Input[str] repository_id: The ID of the repository that the resource belongs to.
        :param pulumi.Input[str] status: The status of lifecycle policy. Must be `active` or `disabled`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerRepositoryLifecyclePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new container repository lifecycle policy. For more information, see [the official documentation](https://yandex.cloud/docs/container-registry/concepts/lifecycle-policy).

        ## Example Usage

        {{ tffile "examples/container_repository_lifecycle_policy/r_container_repository_lifecycle_policy_1.tf" }}

        ## Import

        A lifecycle policy can be imported using the `id` of the resource, e.g.

        bash

        ```sh
        $ pulumi import yandex:index/containerRepositoryLifecyclePolicy:ContainerRepositoryLifecyclePolicy my_lifecycle_policy lifecycle_policy_id
        ```

        :param str resource_name: The name of the resource.
        :param ContainerRepositoryLifecyclePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerRepositoryLifecyclePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 repository_id: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerRepositoryLifecyclePolicyRuleArgs', 'ContainerRepositoryLifecyclePolicyRuleArgsDict']]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerRepositoryLifecyclePolicyArgs.__new__(ContainerRepositoryLifecyclePolicyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
            __props__.__dict__["rules"] = rules
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["created_at"] = None
        super(ContainerRepositoryLifecyclePolicy, __self__).__init__(
            'yandex:index/containerRepositoryLifecyclePolicy:ContainerRepositoryLifecyclePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            repository_id: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerRepositoryLifecyclePolicyRuleArgs', 'ContainerRepositoryLifecyclePolicyRuleArgsDict']]]]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'ContainerRepositoryLifecyclePolicy':
        """
        Get an existing ContainerRepositoryLifecyclePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: Creation timestamp of the instance.
        :param pulumi.Input[str] description: Description of the lifecycle policy.
        :param pulumi.Input[str] name: Lifecycle policy name.
        :param pulumi.Input[str] repository_id: The ID of the repository that the resource belongs to.
        :param pulumi.Input[str] status: The status of lifecycle policy. Must be `active` or `disabled`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerRepositoryLifecyclePolicyState.__new__(_ContainerRepositoryLifecyclePolicyState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["repository_id"] = repository_id
        __props__.__dict__["rules"] = rules
        __props__.__dict__["status"] = status
        return ContainerRepositoryLifecyclePolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Creation timestamp of the instance.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the lifecycle policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Lifecycle policy name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[str]:
        """
        The ID of the repository that the resource belongs to.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.ContainerRepositoryLifecyclePolicyRule']]:
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of lifecycle policy. Must be `active` or `disabled`.
        """
        return pulumi.get(self, "status")

