# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionTriggerArgs', 'FunctionTrigger']

@pulumi.input_type
class FunctionTriggerArgs:
    def __init__(__self__, *,
                 container: Optional[pulumi.Input['FunctionTriggerContainerArgs']] = None,
                 container_registry: Optional[pulumi.Input['FunctionTriggerContainerRegistryArgs']] = None,
                 data_streams: Optional[pulumi.Input['FunctionTriggerDataStreamsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dlq: Optional[pulumi.Input['FunctionTriggerDlqArgs']] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 function: Optional[pulumi.Input['FunctionTriggerFunctionArgs']] = None,
                 iot: Optional[pulumi.Input['FunctionTriggerIotArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 log_group: Optional[pulumi.Input['FunctionTriggerLogGroupArgs']] = None,
                 logging: Optional[pulumi.Input['FunctionTriggerLoggingArgs']] = None,
                 mail: Optional[pulumi.Input['FunctionTriggerMailArgs']] = None,
                 message_queue: Optional[pulumi.Input['FunctionTriggerMessageQueueArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_storage: Optional[pulumi.Input['FunctionTriggerObjectStorageArgs']] = None,
                 timer: Optional[pulumi.Input['FunctionTriggerTimerArgs']] = None):
        """
        The set of arguments for constructing a FunctionTrigger resource.
        :param pulumi.Input['FunctionTriggerContainerArgs'] container: [Yandex Cloud Serverless Container](https://yandex.cloud/docs/serverless-containers/concepts/container) settings definition for Yandex Cloud Functions Trigger
               * `container.0.id` - Yandex Cloud Serverless Container ID for Yandex Cloud Functions Trigger
               * `container.0.service_account_id` - Service account ID for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
               * `container.0.path` - Path for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
               * `container.0.retry_attempts` - Retry attempts for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
               * `container.0.retry_interval` - Retry interval in seconds for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerContainerRegistryArgs'] container_registry: [Container Registry](https://yandex.cloud/docs/functions/concepts/trigger/cr-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `container_registry.0.registry_id` - Container Registry ID for Yandex Cloud Functions Trigger
               * `container_registry.0.image_name` - Image name filter setting for Yandex Cloud Functions Trigger
               * `container_registry.0.tag` - Image tag filter setting for Yandex Cloud Functions Trigger
               * `container_registry.0.create_image` - Boolean flag for setting create image event for Yandex Cloud Functions Trigger
               * `container_registry.0.delete_image` - Boolean flag for setting delete image event for Yandex Cloud Functions Trigger
               * `container_registry.0.create_image_tag` - Boolean flag for setting create image tag event for Yandex Cloud Functions Trigger
               * `container_registry.0.delete_image_tag` - Boolean flag for setting delete image tag event for Yandex Cloud Functions Trigger
               * `container_registry.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `container_registry.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerDataStreamsArgs'] data_streams: [Data Streams](https://yandex.cloud/docs/functions/concepts/trigger/data-streams-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `data_streams.0.stream_name` - Stream name for Yandex Cloud Functions Trigger
               * `data_streams.0.database` - Stream database for Yandex Cloud Functions Trigger
               * `data_streams.0.service_account_id` - Service account ID to access data stream for Yandex Cloud Functions Trigger
               * `data_streams.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `data_streams.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[str] description: Description of the Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerDlqArgs'] dlq: Dead Letter Queue settings definition for Yandex Cloud Functions Trigger
               * `dlq.0.queue_id` - ID of Dead Letter Queue for Trigger (Queue ARN)
               * `dlq.0.service_account_id` - Service Account ID for Dead Letter Queue for Yandex Cloud Functions Trigger
        :param pulumi.Input[str] folder_id: Folder ID for the Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerFunctionArgs'] function: [Yandex Cloud Function](https://cloud.yandex.com/docs/functions/concepts/function) settings definition for Yandex Cloud Functions Trigger
               * `function.0.id` - Yandex Cloud Function ID for Yandex Cloud Functions Trigger
               * `function.0.service_account_id` - Service account ID for Yandex Cloud Function for Yandex Cloud Functions Trigger
               * `function.0.tag` - Tag for Yandex Cloud Function for Yandex Cloud Functions Trigger
               * `function.0.retry_attempts` - Retry attempts for Yandex Cloud Function for Yandex Cloud Functions Trigger
               * `function.0.retry_interval` - Retry interval in seconds for Yandex Cloud Function for Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerIotArgs'] iot: [IoT](https://cloud.yandex.com/docs/functions/concepts/trigger/iot-core-trigger) settings definition for Yandex Cloud Functions Trigger, if present. Only one section `iot` or `message_queue` or `object_storage` or `timer` can be defined.
               * `iot.0.registry_id` - IoT Registry ID for Yandex Cloud Functions Trigger
               * `iot.0.device_id` - IoT Device ID for Yandex Cloud Functions Trigger
               * `iot.0.topic` - IoT Topic for Yandex Cloud Functions Trigger
               * `iot.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `iot.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerLoggingArgs'] logging: [Logging](https://cloud.yandex.com/docs/functions/concepts/trigger/cloud-logging-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `logging.0.group_id` - Logging group ID for Yandex Cloud Functions Trigger
               * `logging.0.resource_ids` - Resource ID filter setting for Yandex Cloud Functions Trigger
               * `logging.0.resource_types` - Resource type filter setting for Yandex Cloud Functions Trigger
               * `logging.0.levels` - Logging level filter setting for Yandex Cloud Functions Trigger
               * `logging.0.stream_names` - Logging stream name filter setting for Yandex Cloud Functions Trigger
               * `logging.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `logging.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerMailArgs'] mail: [Mail](https://yandex.cloud/docs/functions/concepts/trigger/mail-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `mail.0.attachments_bucket_id` - Object Storage Bucket ID for Yandex Cloud Functions Trigger
               * `mail.0.service_account_id` - Service account ID to access object storage for Yandex Cloud Functions Trigger
               * `mail.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `mail.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerMessageQueueArgs'] message_queue: [Message Queue](https://cloud.yandex.com/docs/functions/concepts/trigger/ymq-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `message_queue.0.queue_id` - Message Queue ID for Yandex Cloud Functions Trigger
               * `message_queue.0.service_account_id` - Message Queue Service Account ID for Yandex Cloud Functions Trigger
               * `message_queue.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `message_queue.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
               * `message_queue.0.visibility_timeout` - Visibility timeout for Yandex Cloud Functions Trigger
        :param pulumi.Input[str] name: Yandex Cloud Functions Trigger name used to define trigger
        :param pulumi.Input['FunctionTriggerObjectStorageArgs'] object_storage: [Object Storage](https://cloud.yandex.com/docs/functions/concepts/trigger/os-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `object_storage.0.bucket_id` - Object Storage Bucket ID for Yandex Cloud Functions Trigger
               * `object_storage.0.prefix` - Prefix for Object Storage for Yandex Cloud Functions Trigger
               * `object_storage.0.suffix` - Suffix for Object Storage for Yandex Cloud Functions Trigger
               * `object_storage.0.create` - Boolean flag for setting create event for Yandex Cloud Functions Trigger
               * `object_storage.0.update` - Boolean flag for setting update event for Yandex Cloud Functions Trigger
               * `object_storage.0.delete` - Boolean flag for setting delete event for Yandex Cloud Functions Trigger
               * `object_storage.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `object_storage.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerTimerArgs'] timer: [Timer](https://cloud.yandex.com/docs/functions/concepts/trigger/timer) settings definition for Yandex Cloud Functions Trigger, if present
               * `timer.0.cron_expression` - Cron expression for timer for Yandex Cloud Functions Trigger
               * `timer.0.payload` - Payload to be passed to function
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if container_registry is not None:
            pulumi.set(__self__, "container_registry", container_registry)
        if data_streams is not None:
            pulumi.set(__self__, "data_streams", data_streams)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dlq is not None:
            pulumi.set(__self__, "dlq", dlq)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if iot is not None:
            pulumi.set(__self__, "iot", iot)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if mail is not None:
            pulumi.set(__self__, "mail", mail)
        if message_queue is not None:
            pulumi.set(__self__, "message_queue", message_queue)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_storage is not None:
            pulumi.set(__self__, "object_storage", object_storage)
        if timer is not None:
            pulumi.set(__self__, "timer", timer)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input['FunctionTriggerContainerArgs']]:
        """
        [Yandex Cloud Serverless Container](https://yandex.cloud/docs/serverless-containers/concepts/container) settings definition for Yandex Cloud Functions Trigger
        * `container.0.id` - Yandex Cloud Serverless Container ID for Yandex Cloud Functions Trigger
        * `container.0.service_account_id` - Service account ID for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
        * `container.0.path` - Path for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
        * `container.0.retry_attempts` - Retry attempts for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
        * `container.0.retry_interval` - Retry interval in seconds for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input['FunctionTriggerContainerArgs']]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="containerRegistry")
    def container_registry(self) -> Optional[pulumi.Input['FunctionTriggerContainerRegistryArgs']]:
        """
        [Container Registry](https://yandex.cloud/docs/functions/concepts/trigger/cr-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `container_registry.0.registry_id` - Container Registry ID for Yandex Cloud Functions Trigger
        * `container_registry.0.image_name` - Image name filter setting for Yandex Cloud Functions Trigger
        * `container_registry.0.tag` - Image tag filter setting for Yandex Cloud Functions Trigger
        * `container_registry.0.create_image` - Boolean flag for setting create image event for Yandex Cloud Functions Trigger
        * `container_registry.0.delete_image` - Boolean flag for setting delete image event for Yandex Cloud Functions Trigger
        * `container_registry.0.create_image_tag` - Boolean flag for setting create image tag event for Yandex Cloud Functions Trigger
        * `container_registry.0.delete_image_tag` - Boolean flag for setting delete image tag event for Yandex Cloud Functions Trigger
        * `container_registry.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `container_registry.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "container_registry")

    @container_registry.setter
    def container_registry(self, value: Optional[pulumi.Input['FunctionTriggerContainerRegistryArgs']]):
        pulumi.set(self, "container_registry", value)

    @property
    @pulumi.getter(name="dataStreams")
    def data_streams(self) -> Optional[pulumi.Input['FunctionTriggerDataStreamsArgs']]:
        """
        [Data Streams](https://yandex.cloud/docs/functions/concepts/trigger/data-streams-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `data_streams.0.stream_name` - Stream name for Yandex Cloud Functions Trigger
        * `data_streams.0.database` - Stream database for Yandex Cloud Functions Trigger
        * `data_streams.0.service_account_id` - Service account ID to access data stream for Yandex Cloud Functions Trigger
        * `data_streams.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `data_streams.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "data_streams")

    @data_streams.setter
    def data_streams(self, value: Optional[pulumi.Input['FunctionTriggerDataStreamsArgs']]):
        pulumi.set(self, "data_streams", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dlq(self) -> Optional[pulumi.Input['FunctionTriggerDlqArgs']]:
        """
        Dead Letter Queue settings definition for Yandex Cloud Functions Trigger
        * `dlq.0.queue_id` - ID of Dead Letter Queue for Trigger (Queue ARN)
        * `dlq.0.service_account_id` - Service Account ID for Dead Letter Queue for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "dlq")

    @dlq.setter
    def dlq(self, value: Optional[pulumi.Input['FunctionTriggerDlqArgs']]):
        pulumi.set(self, "dlq", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        Folder ID for the Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input['FunctionTriggerFunctionArgs']]:
        """
        [Yandex Cloud Function](https://cloud.yandex.com/docs/functions/concepts/function) settings definition for Yandex Cloud Functions Trigger
        * `function.0.id` - Yandex Cloud Function ID for Yandex Cloud Functions Trigger
        * `function.0.service_account_id` - Service account ID for Yandex Cloud Function for Yandex Cloud Functions Trigger
        * `function.0.tag` - Tag for Yandex Cloud Function for Yandex Cloud Functions Trigger
        * `function.0.retry_attempts` - Retry attempts for Yandex Cloud Function for Yandex Cloud Functions Trigger
        * `function.0.retry_interval` - Retry interval in seconds for Yandex Cloud Function for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input['FunctionTriggerFunctionArgs']]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter
    def iot(self) -> Optional[pulumi.Input['FunctionTriggerIotArgs']]:
        """
        [IoT](https://cloud.yandex.com/docs/functions/concepts/trigger/iot-core-trigger) settings definition for Yandex Cloud Functions Trigger, if present. Only one section `iot` or `message_queue` or `object_storage` or `timer` can be defined.
        * `iot.0.registry_id` - IoT Registry ID for Yandex Cloud Functions Trigger
        * `iot.0.device_id` - IoT Device ID for Yandex Cloud Functions Trigger
        * `iot.0.topic` - IoT Topic for Yandex Cloud Functions Trigger
        * `iot.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `iot.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "iot")

    @iot.setter
    def iot(self, value: Optional[pulumi.Input['FunctionTriggerIotArgs']]):
        pulumi.set(self, "iot", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional[pulumi.Input['FunctionTriggerLogGroupArgs']]:
        return pulumi.get(self, "log_group")

    @log_group.setter
    def log_group(self, value: Optional[pulumi.Input['FunctionTriggerLogGroupArgs']]):
        pulumi.set(self, "log_group", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['FunctionTriggerLoggingArgs']]:
        """
        [Logging](https://cloud.yandex.com/docs/functions/concepts/trigger/cloud-logging-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `logging.0.group_id` - Logging group ID for Yandex Cloud Functions Trigger
        * `logging.0.resource_ids` - Resource ID filter setting for Yandex Cloud Functions Trigger
        * `logging.0.resource_types` - Resource type filter setting for Yandex Cloud Functions Trigger
        * `logging.0.levels` - Logging level filter setting for Yandex Cloud Functions Trigger
        * `logging.0.stream_names` - Logging stream name filter setting for Yandex Cloud Functions Trigger
        * `logging.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `logging.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['FunctionTriggerLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter
    def mail(self) -> Optional[pulumi.Input['FunctionTriggerMailArgs']]:
        """
        [Mail](https://yandex.cloud/docs/functions/concepts/trigger/mail-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `mail.0.attachments_bucket_id` - Object Storage Bucket ID for Yandex Cloud Functions Trigger
        * `mail.0.service_account_id` - Service account ID to access object storage for Yandex Cloud Functions Trigger
        * `mail.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `mail.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "mail")

    @mail.setter
    def mail(self, value: Optional[pulumi.Input['FunctionTriggerMailArgs']]):
        pulumi.set(self, "mail", value)

    @property
    @pulumi.getter(name="messageQueue")
    def message_queue(self) -> Optional[pulumi.Input['FunctionTriggerMessageQueueArgs']]:
        """
        [Message Queue](https://cloud.yandex.com/docs/functions/concepts/trigger/ymq-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `message_queue.0.queue_id` - Message Queue ID for Yandex Cloud Functions Trigger
        * `message_queue.0.service_account_id` - Message Queue Service Account ID for Yandex Cloud Functions Trigger
        * `message_queue.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `message_queue.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        * `message_queue.0.visibility_timeout` - Visibility timeout for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "message_queue")

    @message_queue.setter
    def message_queue(self, value: Optional[pulumi.Input['FunctionTriggerMessageQueueArgs']]):
        pulumi.set(self, "message_queue", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Yandex Cloud Functions Trigger name used to define trigger
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectStorage")
    def object_storage(self) -> Optional[pulumi.Input['FunctionTriggerObjectStorageArgs']]:
        """
        [Object Storage](https://cloud.yandex.com/docs/functions/concepts/trigger/os-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `object_storage.0.bucket_id` - Object Storage Bucket ID for Yandex Cloud Functions Trigger
        * `object_storage.0.prefix` - Prefix for Object Storage for Yandex Cloud Functions Trigger
        * `object_storage.0.suffix` - Suffix for Object Storage for Yandex Cloud Functions Trigger
        * `object_storage.0.create` - Boolean flag for setting create event for Yandex Cloud Functions Trigger
        * `object_storage.0.update` - Boolean flag for setting update event for Yandex Cloud Functions Trigger
        * `object_storage.0.delete` - Boolean flag for setting delete event for Yandex Cloud Functions Trigger
        * `object_storage.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `object_storage.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "object_storage")

    @object_storage.setter
    def object_storage(self, value: Optional[pulumi.Input['FunctionTriggerObjectStorageArgs']]):
        pulumi.set(self, "object_storage", value)

    @property
    @pulumi.getter
    def timer(self) -> Optional[pulumi.Input['FunctionTriggerTimerArgs']]:
        """
        [Timer](https://cloud.yandex.com/docs/functions/concepts/trigger/timer) settings definition for Yandex Cloud Functions Trigger, if present
        * `timer.0.cron_expression` - Cron expression for timer for Yandex Cloud Functions Trigger
        * `timer.0.payload` - Payload to be passed to function
        """
        return pulumi.get(self, "timer")

    @timer.setter
    def timer(self, value: Optional[pulumi.Input['FunctionTriggerTimerArgs']]):
        pulumi.set(self, "timer", value)


@pulumi.input_type
class _FunctionTriggerState:
    def __init__(__self__, *,
                 container: Optional[pulumi.Input['FunctionTriggerContainerArgs']] = None,
                 container_registry: Optional[pulumi.Input['FunctionTriggerContainerRegistryArgs']] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 data_streams: Optional[pulumi.Input['FunctionTriggerDataStreamsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dlq: Optional[pulumi.Input['FunctionTriggerDlqArgs']] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 function: Optional[pulumi.Input['FunctionTriggerFunctionArgs']] = None,
                 iot: Optional[pulumi.Input['FunctionTriggerIotArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 log_group: Optional[pulumi.Input['FunctionTriggerLogGroupArgs']] = None,
                 logging: Optional[pulumi.Input['FunctionTriggerLoggingArgs']] = None,
                 mail: Optional[pulumi.Input['FunctionTriggerMailArgs']] = None,
                 message_queue: Optional[pulumi.Input['FunctionTriggerMessageQueueArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_storage: Optional[pulumi.Input['FunctionTriggerObjectStorageArgs']] = None,
                 timer: Optional[pulumi.Input['FunctionTriggerTimerArgs']] = None):
        """
        Input properties used for looking up and filtering FunctionTrigger resources.
        :param pulumi.Input['FunctionTriggerContainerArgs'] container: [Yandex Cloud Serverless Container](https://yandex.cloud/docs/serverless-containers/concepts/container) settings definition for Yandex Cloud Functions Trigger
               * `container.0.id` - Yandex Cloud Serverless Container ID for Yandex Cloud Functions Trigger
               * `container.0.service_account_id` - Service account ID for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
               * `container.0.path` - Path for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
               * `container.0.retry_attempts` - Retry attempts for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
               * `container.0.retry_interval` - Retry interval in seconds for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerContainerRegistryArgs'] container_registry: [Container Registry](https://yandex.cloud/docs/functions/concepts/trigger/cr-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `container_registry.0.registry_id` - Container Registry ID for Yandex Cloud Functions Trigger
               * `container_registry.0.image_name` - Image name filter setting for Yandex Cloud Functions Trigger
               * `container_registry.0.tag` - Image tag filter setting for Yandex Cloud Functions Trigger
               * `container_registry.0.create_image` - Boolean flag for setting create image event for Yandex Cloud Functions Trigger
               * `container_registry.0.delete_image` - Boolean flag for setting delete image event for Yandex Cloud Functions Trigger
               * `container_registry.0.create_image_tag` - Boolean flag for setting create image tag event for Yandex Cloud Functions Trigger
               * `container_registry.0.delete_image_tag` - Boolean flag for setting delete image tag event for Yandex Cloud Functions Trigger
               * `container_registry.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `container_registry.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[str] created_at: Creation timestamp of the Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerDataStreamsArgs'] data_streams: [Data Streams](https://yandex.cloud/docs/functions/concepts/trigger/data-streams-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `data_streams.0.stream_name` - Stream name for Yandex Cloud Functions Trigger
               * `data_streams.0.database` - Stream database for Yandex Cloud Functions Trigger
               * `data_streams.0.service_account_id` - Service account ID to access data stream for Yandex Cloud Functions Trigger
               * `data_streams.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `data_streams.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[str] description: Description of the Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerDlqArgs'] dlq: Dead Letter Queue settings definition for Yandex Cloud Functions Trigger
               * `dlq.0.queue_id` - ID of Dead Letter Queue for Trigger (Queue ARN)
               * `dlq.0.service_account_id` - Service Account ID for Dead Letter Queue for Yandex Cloud Functions Trigger
        :param pulumi.Input[str] folder_id: Folder ID for the Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerFunctionArgs'] function: [Yandex Cloud Function](https://cloud.yandex.com/docs/functions/concepts/function) settings definition for Yandex Cloud Functions Trigger
               * `function.0.id` - Yandex Cloud Function ID for Yandex Cloud Functions Trigger
               * `function.0.service_account_id` - Service account ID for Yandex Cloud Function for Yandex Cloud Functions Trigger
               * `function.0.tag` - Tag for Yandex Cloud Function for Yandex Cloud Functions Trigger
               * `function.0.retry_attempts` - Retry attempts for Yandex Cloud Function for Yandex Cloud Functions Trigger
               * `function.0.retry_interval` - Retry interval in seconds for Yandex Cloud Function for Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerIotArgs'] iot: [IoT](https://cloud.yandex.com/docs/functions/concepts/trigger/iot-core-trigger) settings definition for Yandex Cloud Functions Trigger, if present. Only one section `iot` or `message_queue` or `object_storage` or `timer` can be defined.
               * `iot.0.registry_id` - IoT Registry ID for Yandex Cloud Functions Trigger
               * `iot.0.device_id` - IoT Device ID for Yandex Cloud Functions Trigger
               * `iot.0.topic` - IoT Topic for Yandex Cloud Functions Trigger
               * `iot.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `iot.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerLoggingArgs'] logging: [Logging](https://cloud.yandex.com/docs/functions/concepts/trigger/cloud-logging-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `logging.0.group_id` - Logging group ID for Yandex Cloud Functions Trigger
               * `logging.0.resource_ids` - Resource ID filter setting for Yandex Cloud Functions Trigger
               * `logging.0.resource_types` - Resource type filter setting for Yandex Cloud Functions Trigger
               * `logging.0.levels` - Logging level filter setting for Yandex Cloud Functions Trigger
               * `logging.0.stream_names` - Logging stream name filter setting for Yandex Cloud Functions Trigger
               * `logging.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `logging.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerMailArgs'] mail: [Mail](https://yandex.cloud/docs/functions/concepts/trigger/mail-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `mail.0.attachments_bucket_id` - Object Storage Bucket ID for Yandex Cloud Functions Trigger
               * `mail.0.service_account_id` - Service account ID to access object storage for Yandex Cloud Functions Trigger
               * `mail.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `mail.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerMessageQueueArgs'] message_queue: [Message Queue](https://cloud.yandex.com/docs/functions/concepts/trigger/ymq-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `message_queue.0.queue_id` - Message Queue ID for Yandex Cloud Functions Trigger
               * `message_queue.0.service_account_id` - Message Queue Service Account ID for Yandex Cloud Functions Trigger
               * `message_queue.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `message_queue.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
               * `message_queue.0.visibility_timeout` - Visibility timeout for Yandex Cloud Functions Trigger
        :param pulumi.Input[str] name: Yandex Cloud Functions Trigger name used to define trigger
        :param pulumi.Input['FunctionTriggerObjectStorageArgs'] object_storage: [Object Storage](https://cloud.yandex.com/docs/functions/concepts/trigger/os-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `object_storage.0.bucket_id` - Object Storage Bucket ID for Yandex Cloud Functions Trigger
               * `object_storage.0.prefix` - Prefix for Object Storage for Yandex Cloud Functions Trigger
               * `object_storage.0.suffix` - Suffix for Object Storage for Yandex Cloud Functions Trigger
               * `object_storage.0.create` - Boolean flag for setting create event for Yandex Cloud Functions Trigger
               * `object_storage.0.update` - Boolean flag for setting update event for Yandex Cloud Functions Trigger
               * `object_storage.0.delete` - Boolean flag for setting delete event for Yandex Cloud Functions Trigger
               * `object_storage.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `object_storage.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input['FunctionTriggerTimerArgs'] timer: [Timer](https://cloud.yandex.com/docs/functions/concepts/trigger/timer) settings definition for Yandex Cloud Functions Trigger, if present
               * `timer.0.cron_expression` - Cron expression for timer for Yandex Cloud Functions Trigger
               * `timer.0.payload` - Payload to be passed to function
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if container_registry is not None:
            pulumi.set(__self__, "container_registry", container_registry)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if data_streams is not None:
            pulumi.set(__self__, "data_streams", data_streams)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dlq is not None:
            pulumi.set(__self__, "dlq", dlq)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if iot is not None:
            pulumi.set(__self__, "iot", iot)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if mail is not None:
            pulumi.set(__self__, "mail", mail)
        if message_queue is not None:
            pulumi.set(__self__, "message_queue", message_queue)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_storage is not None:
            pulumi.set(__self__, "object_storage", object_storage)
        if timer is not None:
            pulumi.set(__self__, "timer", timer)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input['FunctionTriggerContainerArgs']]:
        """
        [Yandex Cloud Serverless Container](https://yandex.cloud/docs/serverless-containers/concepts/container) settings definition for Yandex Cloud Functions Trigger
        * `container.0.id` - Yandex Cloud Serverless Container ID for Yandex Cloud Functions Trigger
        * `container.0.service_account_id` - Service account ID for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
        * `container.0.path` - Path for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
        * `container.0.retry_attempts` - Retry attempts for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
        * `container.0.retry_interval` - Retry interval in seconds for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input['FunctionTriggerContainerArgs']]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="containerRegistry")
    def container_registry(self) -> Optional[pulumi.Input['FunctionTriggerContainerRegistryArgs']]:
        """
        [Container Registry](https://yandex.cloud/docs/functions/concepts/trigger/cr-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `container_registry.0.registry_id` - Container Registry ID for Yandex Cloud Functions Trigger
        * `container_registry.0.image_name` - Image name filter setting for Yandex Cloud Functions Trigger
        * `container_registry.0.tag` - Image tag filter setting for Yandex Cloud Functions Trigger
        * `container_registry.0.create_image` - Boolean flag for setting create image event for Yandex Cloud Functions Trigger
        * `container_registry.0.delete_image` - Boolean flag for setting delete image event for Yandex Cloud Functions Trigger
        * `container_registry.0.create_image_tag` - Boolean flag for setting create image tag event for Yandex Cloud Functions Trigger
        * `container_registry.0.delete_image_tag` - Boolean flag for setting delete image tag event for Yandex Cloud Functions Trigger
        * `container_registry.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `container_registry.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "container_registry")

    @container_registry.setter
    def container_registry(self, value: Optional[pulumi.Input['FunctionTriggerContainerRegistryArgs']]):
        pulumi.set(self, "container_registry", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp of the Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="dataStreams")
    def data_streams(self) -> Optional[pulumi.Input['FunctionTriggerDataStreamsArgs']]:
        """
        [Data Streams](https://yandex.cloud/docs/functions/concepts/trigger/data-streams-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `data_streams.0.stream_name` - Stream name for Yandex Cloud Functions Trigger
        * `data_streams.0.database` - Stream database for Yandex Cloud Functions Trigger
        * `data_streams.0.service_account_id` - Service account ID to access data stream for Yandex Cloud Functions Trigger
        * `data_streams.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `data_streams.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "data_streams")

    @data_streams.setter
    def data_streams(self, value: Optional[pulumi.Input['FunctionTriggerDataStreamsArgs']]):
        pulumi.set(self, "data_streams", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dlq(self) -> Optional[pulumi.Input['FunctionTriggerDlqArgs']]:
        """
        Dead Letter Queue settings definition for Yandex Cloud Functions Trigger
        * `dlq.0.queue_id` - ID of Dead Letter Queue for Trigger (Queue ARN)
        * `dlq.0.service_account_id` - Service Account ID for Dead Letter Queue for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "dlq")

    @dlq.setter
    def dlq(self, value: Optional[pulumi.Input['FunctionTriggerDlqArgs']]):
        pulumi.set(self, "dlq", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        Folder ID for the Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input['FunctionTriggerFunctionArgs']]:
        """
        [Yandex Cloud Function](https://cloud.yandex.com/docs/functions/concepts/function) settings definition for Yandex Cloud Functions Trigger
        * `function.0.id` - Yandex Cloud Function ID for Yandex Cloud Functions Trigger
        * `function.0.service_account_id` - Service account ID for Yandex Cloud Function for Yandex Cloud Functions Trigger
        * `function.0.tag` - Tag for Yandex Cloud Function for Yandex Cloud Functions Trigger
        * `function.0.retry_attempts` - Retry attempts for Yandex Cloud Function for Yandex Cloud Functions Trigger
        * `function.0.retry_interval` - Retry interval in seconds for Yandex Cloud Function for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input['FunctionTriggerFunctionArgs']]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter
    def iot(self) -> Optional[pulumi.Input['FunctionTriggerIotArgs']]:
        """
        [IoT](https://cloud.yandex.com/docs/functions/concepts/trigger/iot-core-trigger) settings definition for Yandex Cloud Functions Trigger, if present. Only one section `iot` or `message_queue` or `object_storage` or `timer` can be defined.
        * `iot.0.registry_id` - IoT Registry ID for Yandex Cloud Functions Trigger
        * `iot.0.device_id` - IoT Device ID for Yandex Cloud Functions Trigger
        * `iot.0.topic` - IoT Topic for Yandex Cloud Functions Trigger
        * `iot.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `iot.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "iot")

    @iot.setter
    def iot(self, value: Optional[pulumi.Input['FunctionTriggerIotArgs']]):
        pulumi.set(self, "iot", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional[pulumi.Input['FunctionTriggerLogGroupArgs']]:
        return pulumi.get(self, "log_group")

    @log_group.setter
    def log_group(self, value: Optional[pulumi.Input['FunctionTriggerLogGroupArgs']]):
        pulumi.set(self, "log_group", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['FunctionTriggerLoggingArgs']]:
        """
        [Logging](https://cloud.yandex.com/docs/functions/concepts/trigger/cloud-logging-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `logging.0.group_id` - Logging group ID for Yandex Cloud Functions Trigger
        * `logging.0.resource_ids` - Resource ID filter setting for Yandex Cloud Functions Trigger
        * `logging.0.resource_types` - Resource type filter setting for Yandex Cloud Functions Trigger
        * `logging.0.levels` - Logging level filter setting for Yandex Cloud Functions Trigger
        * `logging.0.stream_names` - Logging stream name filter setting for Yandex Cloud Functions Trigger
        * `logging.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `logging.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['FunctionTriggerLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter
    def mail(self) -> Optional[pulumi.Input['FunctionTriggerMailArgs']]:
        """
        [Mail](https://yandex.cloud/docs/functions/concepts/trigger/mail-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `mail.0.attachments_bucket_id` - Object Storage Bucket ID for Yandex Cloud Functions Trigger
        * `mail.0.service_account_id` - Service account ID to access object storage for Yandex Cloud Functions Trigger
        * `mail.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `mail.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "mail")

    @mail.setter
    def mail(self, value: Optional[pulumi.Input['FunctionTriggerMailArgs']]):
        pulumi.set(self, "mail", value)

    @property
    @pulumi.getter(name="messageQueue")
    def message_queue(self) -> Optional[pulumi.Input['FunctionTriggerMessageQueueArgs']]:
        """
        [Message Queue](https://cloud.yandex.com/docs/functions/concepts/trigger/ymq-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `message_queue.0.queue_id` - Message Queue ID for Yandex Cloud Functions Trigger
        * `message_queue.0.service_account_id` - Message Queue Service Account ID for Yandex Cloud Functions Trigger
        * `message_queue.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `message_queue.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        * `message_queue.0.visibility_timeout` - Visibility timeout for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "message_queue")

    @message_queue.setter
    def message_queue(self, value: Optional[pulumi.Input['FunctionTriggerMessageQueueArgs']]):
        pulumi.set(self, "message_queue", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Yandex Cloud Functions Trigger name used to define trigger
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectStorage")
    def object_storage(self) -> Optional[pulumi.Input['FunctionTriggerObjectStorageArgs']]:
        """
        [Object Storage](https://cloud.yandex.com/docs/functions/concepts/trigger/os-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `object_storage.0.bucket_id` - Object Storage Bucket ID for Yandex Cloud Functions Trigger
        * `object_storage.0.prefix` - Prefix for Object Storage for Yandex Cloud Functions Trigger
        * `object_storage.0.suffix` - Suffix for Object Storage for Yandex Cloud Functions Trigger
        * `object_storage.0.create` - Boolean flag for setting create event for Yandex Cloud Functions Trigger
        * `object_storage.0.update` - Boolean flag for setting update event for Yandex Cloud Functions Trigger
        * `object_storage.0.delete` - Boolean flag for setting delete event for Yandex Cloud Functions Trigger
        * `object_storage.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `object_storage.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "object_storage")

    @object_storage.setter
    def object_storage(self, value: Optional[pulumi.Input['FunctionTriggerObjectStorageArgs']]):
        pulumi.set(self, "object_storage", value)

    @property
    @pulumi.getter
    def timer(self) -> Optional[pulumi.Input['FunctionTriggerTimerArgs']]:
        """
        [Timer](https://cloud.yandex.com/docs/functions/concepts/trigger/timer) settings definition for Yandex Cloud Functions Trigger, if present
        * `timer.0.cron_expression` - Cron expression for timer for Yandex Cloud Functions Trigger
        * `timer.0.payload` - Payload to be passed to function
        """
        return pulumi.get(self, "timer")

    @timer.setter
    def timer(self, value: Optional[pulumi.Input['FunctionTriggerTimerArgs']]):
        pulumi.set(self, "timer", value)


class FunctionTrigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container: Optional[pulumi.Input[Union['FunctionTriggerContainerArgs', 'FunctionTriggerContainerArgsDict']]] = None,
                 container_registry: Optional[pulumi.Input[Union['FunctionTriggerContainerRegistryArgs', 'FunctionTriggerContainerRegistryArgsDict']]] = None,
                 data_streams: Optional[pulumi.Input[Union['FunctionTriggerDataStreamsArgs', 'FunctionTriggerDataStreamsArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dlq: Optional[pulumi.Input[Union['FunctionTriggerDlqArgs', 'FunctionTriggerDlqArgsDict']]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 function: Optional[pulumi.Input[Union['FunctionTriggerFunctionArgs', 'FunctionTriggerFunctionArgsDict']]] = None,
                 iot: Optional[pulumi.Input[Union['FunctionTriggerIotArgs', 'FunctionTriggerIotArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 log_group: Optional[pulumi.Input[Union['FunctionTriggerLogGroupArgs', 'FunctionTriggerLogGroupArgsDict']]] = None,
                 logging: Optional[pulumi.Input[Union['FunctionTriggerLoggingArgs', 'FunctionTriggerLoggingArgsDict']]] = None,
                 mail: Optional[pulumi.Input[Union['FunctionTriggerMailArgs', 'FunctionTriggerMailArgsDict']]] = None,
                 message_queue: Optional[pulumi.Input[Union['FunctionTriggerMessageQueueArgs', 'FunctionTriggerMessageQueueArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_storage: Optional[pulumi.Input[Union['FunctionTriggerObjectStorageArgs', 'FunctionTriggerObjectStorageArgsDict']]] = None,
                 timer: Optional[pulumi.Input[Union['FunctionTriggerTimerArgs', 'FunctionTriggerTimerArgsDict']]] = None,
                 __props__=None):
        """
        Allows management of [Yandex Cloud Functions Trigger](https://cloud.yandex.com/docs/functions/)

        ## Example Usage

        {{ tffile "examples/function_trigger/r_function_trigger_1.tf" }}

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FunctionTriggerContainerArgs', 'FunctionTriggerContainerArgsDict']] container: [Yandex Cloud Serverless Container](https://yandex.cloud/docs/serverless-containers/concepts/container) settings definition for Yandex Cloud Functions Trigger
               * `container.0.id` - Yandex Cloud Serverless Container ID for Yandex Cloud Functions Trigger
               * `container.0.service_account_id` - Service account ID for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
               * `container.0.path` - Path for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
               * `container.0.retry_attempts` - Retry attempts for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
               * `container.0.retry_interval` - Retry interval in seconds for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerContainerRegistryArgs', 'FunctionTriggerContainerRegistryArgsDict']] container_registry: [Container Registry](https://yandex.cloud/docs/functions/concepts/trigger/cr-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `container_registry.0.registry_id` - Container Registry ID for Yandex Cloud Functions Trigger
               * `container_registry.0.image_name` - Image name filter setting for Yandex Cloud Functions Trigger
               * `container_registry.0.tag` - Image tag filter setting for Yandex Cloud Functions Trigger
               * `container_registry.0.create_image` - Boolean flag for setting create image event for Yandex Cloud Functions Trigger
               * `container_registry.0.delete_image` - Boolean flag for setting delete image event for Yandex Cloud Functions Trigger
               * `container_registry.0.create_image_tag` - Boolean flag for setting create image tag event for Yandex Cloud Functions Trigger
               * `container_registry.0.delete_image_tag` - Boolean flag for setting delete image tag event for Yandex Cloud Functions Trigger
               * `container_registry.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `container_registry.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerDataStreamsArgs', 'FunctionTriggerDataStreamsArgsDict']] data_streams: [Data Streams](https://yandex.cloud/docs/functions/concepts/trigger/data-streams-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `data_streams.0.stream_name` - Stream name for Yandex Cloud Functions Trigger
               * `data_streams.0.database` - Stream database for Yandex Cloud Functions Trigger
               * `data_streams.0.service_account_id` - Service account ID to access data stream for Yandex Cloud Functions Trigger
               * `data_streams.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `data_streams.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[str] description: Description of the Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerDlqArgs', 'FunctionTriggerDlqArgsDict']] dlq: Dead Letter Queue settings definition for Yandex Cloud Functions Trigger
               * `dlq.0.queue_id` - ID of Dead Letter Queue for Trigger (Queue ARN)
               * `dlq.0.service_account_id` - Service Account ID for Dead Letter Queue for Yandex Cloud Functions Trigger
        :param pulumi.Input[str] folder_id: Folder ID for the Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerFunctionArgs', 'FunctionTriggerFunctionArgsDict']] function: [Yandex Cloud Function](https://cloud.yandex.com/docs/functions/concepts/function) settings definition for Yandex Cloud Functions Trigger
               * `function.0.id` - Yandex Cloud Function ID for Yandex Cloud Functions Trigger
               * `function.0.service_account_id` - Service account ID for Yandex Cloud Function for Yandex Cloud Functions Trigger
               * `function.0.tag` - Tag for Yandex Cloud Function for Yandex Cloud Functions Trigger
               * `function.0.retry_attempts` - Retry attempts for Yandex Cloud Function for Yandex Cloud Functions Trigger
               * `function.0.retry_interval` - Retry interval in seconds for Yandex Cloud Function for Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerIotArgs', 'FunctionTriggerIotArgsDict']] iot: [IoT](https://cloud.yandex.com/docs/functions/concepts/trigger/iot-core-trigger) settings definition for Yandex Cloud Functions Trigger, if present. Only one section `iot` or `message_queue` or `object_storage` or `timer` can be defined.
               * `iot.0.registry_id` - IoT Registry ID for Yandex Cloud Functions Trigger
               * `iot.0.device_id` - IoT Device ID for Yandex Cloud Functions Trigger
               * `iot.0.topic` - IoT Topic for Yandex Cloud Functions Trigger
               * `iot.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `iot.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerLoggingArgs', 'FunctionTriggerLoggingArgsDict']] logging: [Logging](https://cloud.yandex.com/docs/functions/concepts/trigger/cloud-logging-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `logging.0.group_id` - Logging group ID for Yandex Cloud Functions Trigger
               * `logging.0.resource_ids` - Resource ID filter setting for Yandex Cloud Functions Trigger
               * `logging.0.resource_types` - Resource type filter setting for Yandex Cloud Functions Trigger
               * `logging.0.levels` - Logging level filter setting for Yandex Cloud Functions Trigger
               * `logging.0.stream_names` - Logging stream name filter setting for Yandex Cloud Functions Trigger
               * `logging.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `logging.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerMailArgs', 'FunctionTriggerMailArgsDict']] mail: [Mail](https://yandex.cloud/docs/functions/concepts/trigger/mail-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `mail.0.attachments_bucket_id` - Object Storage Bucket ID for Yandex Cloud Functions Trigger
               * `mail.0.service_account_id` - Service account ID to access object storage for Yandex Cloud Functions Trigger
               * `mail.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `mail.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerMessageQueueArgs', 'FunctionTriggerMessageQueueArgsDict']] message_queue: [Message Queue](https://cloud.yandex.com/docs/functions/concepts/trigger/ymq-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `message_queue.0.queue_id` - Message Queue ID for Yandex Cloud Functions Trigger
               * `message_queue.0.service_account_id` - Message Queue Service Account ID for Yandex Cloud Functions Trigger
               * `message_queue.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `message_queue.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
               * `message_queue.0.visibility_timeout` - Visibility timeout for Yandex Cloud Functions Trigger
        :param pulumi.Input[str] name: Yandex Cloud Functions Trigger name used to define trigger
        :param pulumi.Input[Union['FunctionTriggerObjectStorageArgs', 'FunctionTriggerObjectStorageArgsDict']] object_storage: [Object Storage](https://cloud.yandex.com/docs/functions/concepts/trigger/os-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `object_storage.0.bucket_id` - Object Storage Bucket ID for Yandex Cloud Functions Trigger
               * `object_storage.0.prefix` - Prefix for Object Storage for Yandex Cloud Functions Trigger
               * `object_storage.0.suffix` - Suffix for Object Storage for Yandex Cloud Functions Trigger
               * `object_storage.0.create` - Boolean flag for setting create event for Yandex Cloud Functions Trigger
               * `object_storage.0.update` - Boolean flag for setting update event for Yandex Cloud Functions Trigger
               * `object_storage.0.delete` - Boolean flag for setting delete event for Yandex Cloud Functions Trigger
               * `object_storage.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `object_storage.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerTimerArgs', 'FunctionTriggerTimerArgsDict']] timer: [Timer](https://cloud.yandex.com/docs/functions/concepts/trigger/timer) settings definition for Yandex Cloud Functions Trigger, if present
               * `timer.0.cron_expression` - Cron expression for timer for Yandex Cloud Functions Trigger
               * `timer.0.payload` - Payload to be passed to function
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FunctionTriggerArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [Yandex Cloud Functions Trigger](https://cloud.yandex.com/docs/functions/)

        ## Example Usage

        {{ tffile "examples/function_trigger/r_function_trigger_1.tf" }}

        :param str resource_name: The name of the resource.
        :param FunctionTriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionTriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container: Optional[pulumi.Input[Union['FunctionTriggerContainerArgs', 'FunctionTriggerContainerArgsDict']]] = None,
                 container_registry: Optional[pulumi.Input[Union['FunctionTriggerContainerRegistryArgs', 'FunctionTriggerContainerRegistryArgsDict']]] = None,
                 data_streams: Optional[pulumi.Input[Union['FunctionTriggerDataStreamsArgs', 'FunctionTriggerDataStreamsArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dlq: Optional[pulumi.Input[Union['FunctionTriggerDlqArgs', 'FunctionTriggerDlqArgsDict']]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 function: Optional[pulumi.Input[Union['FunctionTriggerFunctionArgs', 'FunctionTriggerFunctionArgsDict']]] = None,
                 iot: Optional[pulumi.Input[Union['FunctionTriggerIotArgs', 'FunctionTriggerIotArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 log_group: Optional[pulumi.Input[Union['FunctionTriggerLogGroupArgs', 'FunctionTriggerLogGroupArgsDict']]] = None,
                 logging: Optional[pulumi.Input[Union['FunctionTriggerLoggingArgs', 'FunctionTriggerLoggingArgsDict']]] = None,
                 mail: Optional[pulumi.Input[Union['FunctionTriggerMailArgs', 'FunctionTriggerMailArgsDict']]] = None,
                 message_queue: Optional[pulumi.Input[Union['FunctionTriggerMessageQueueArgs', 'FunctionTriggerMessageQueueArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_storage: Optional[pulumi.Input[Union['FunctionTriggerObjectStorageArgs', 'FunctionTriggerObjectStorageArgsDict']]] = None,
                 timer: Optional[pulumi.Input[Union['FunctionTriggerTimerArgs', 'FunctionTriggerTimerArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionTriggerArgs.__new__(FunctionTriggerArgs)

            __props__.__dict__["container"] = container
            __props__.__dict__["container_registry"] = container_registry
            __props__.__dict__["data_streams"] = data_streams
            __props__.__dict__["description"] = description
            __props__.__dict__["dlq"] = dlq
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["function"] = function
            __props__.__dict__["iot"] = iot
            __props__.__dict__["labels"] = labels
            __props__.__dict__["log_group"] = log_group
            __props__.__dict__["logging"] = logging
            __props__.__dict__["mail"] = mail
            __props__.__dict__["message_queue"] = message_queue
            __props__.__dict__["name"] = name
            __props__.__dict__["object_storage"] = object_storage
            __props__.__dict__["timer"] = timer
            __props__.__dict__["created_at"] = None
        super(FunctionTrigger, __self__).__init__(
            'yandex:index/functionTrigger:FunctionTrigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            container: Optional[pulumi.Input[Union['FunctionTriggerContainerArgs', 'FunctionTriggerContainerArgsDict']]] = None,
            container_registry: Optional[pulumi.Input[Union['FunctionTriggerContainerRegistryArgs', 'FunctionTriggerContainerRegistryArgsDict']]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            data_streams: Optional[pulumi.Input[Union['FunctionTriggerDataStreamsArgs', 'FunctionTriggerDataStreamsArgsDict']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dlq: Optional[pulumi.Input[Union['FunctionTriggerDlqArgs', 'FunctionTriggerDlqArgsDict']]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            function: Optional[pulumi.Input[Union['FunctionTriggerFunctionArgs', 'FunctionTriggerFunctionArgsDict']]] = None,
            iot: Optional[pulumi.Input[Union['FunctionTriggerIotArgs', 'FunctionTriggerIotArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            log_group: Optional[pulumi.Input[Union['FunctionTriggerLogGroupArgs', 'FunctionTriggerLogGroupArgsDict']]] = None,
            logging: Optional[pulumi.Input[Union['FunctionTriggerLoggingArgs', 'FunctionTriggerLoggingArgsDict']]] = None,
            mail: Optional[pulumi.Input[Union['FunctionTriggerMailArgs', 'FunctionTriggerMailArgsDict']]] = None,
            message_queue: Optional[pulumi.Input[Union['FunctionTriggerMessageQueueArgs', 'FunctionTriggerMessageQueueArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            object_storage: Optional[pulumi.Input[Union['FunctionTriggerObjectStorageArgs', 'FunctionTriggerObjectStorageArgsDict']]] = None,
            timer: Optional[pulumi.Input[Union['FunctionTriggerTimerArgs', 'FunctionTriggerTimerArgsDict']]] = None) -> 'FunctionTrigger':
        """
        Get an existing FunctionTrigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FunctionTriggerContainerArgs', 'FunctionTriggerContainerArgsDict']] container: [Yandex Cloud Serverless Container](https://yandex.cloud/docs/serverless-containers/concepts/container) settings definition for Yandex Cloud Functions Trigger
               * `container.0.id` - Yandex Cloud Serverless Container ID for Yandex Cloud Functions Trigger
               * `container.0.service_account_id` - Service account ID for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
               * `container.0.path` - Path for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
               * `container.0.retry_attempts` - Retry attempts for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
               * `container.0.retry_interval` - Retry interval in seconds for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerContainerRegistryArgs', 'FunctionTriggerContainerRegistryArgsDict']] container_registry: [Container Registry](https://yandex.cloud/docs/functions/concepts/trigger/cr-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `container_registry.0.registry_id` - Container Registry ID for Yandex Cloud Functions Trigger
               * `container_registry.0.image_name` - Image name filter setting for Yandex Cloud Functions Trigger
               * `container_registry.0.tag` - Image tag filter setting for Yandex Cloud Functions Trigger
               * `container_registry.0.create_image` - Boolean flag for setting create image event for Yandex Cloud Functions Trigger
               * `container_registry.0.delete_image` - Boolean flag for setting delete image event for Yandex Cloud Functions Trigger
               * `container_registry.0.create_image_tag` - Boolean flag for setting create image tag event for Yandex Cloud Functions Trigger
               * `container_registry.0.delete_image_tag` - Boolean flag for setting delete image tag event for Yandex Cloud Functions Trigger
               * `container_registry.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `container_registry.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[str] created_at: Creation timestamp of the Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerDataStreamsArgs', 'FunctionTriggerDataStreamsArgsDict']] data_streams: [Data Streams](https://yandex.cloud/docs/functions/concepts/trigger/data-streams-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `data_streams.0.stream_name` - Stream name for Yandex Cloud Functions Trigger
               * `data_streams.0.database` - Stream database for Yandex Cloud Functions Trigger
               * `data_streams.0.service_account_id` - Service account ID to access data stream for Yandex Cloud Functions Trigger
               * `data_streams.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `data_streams.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[str] description: Description of the Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerDlqArgs', 'FunctionTriggerDlqArgsDict']] dlq: Dead Letter Queue settings definition for Yandex Cloud Functions Trigger
               * `dlq.0.queue_id` - ID of Dead Letter Queue for Trigger (Queue ARN)
               * `dlq.0.service_account_id` - Service Account ID for Dead Letter Queue for Yandex Cloud Functions Trigger
        :param pulumi.Input[str] folder_id: Folder ID for the Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerFunctionArgs', 'FunctionTriggerFunctionArgsDict']] function: [Yandex Cloud Function](https://cloud.yandex.com/docs/functions/concepts/function) settings definition for Yandex Cloud Functions Trigger
               * `function.0.id` - Yandex Cloud Function ID for Yandex Cloud Functions Trigger
               * `function.0.service_account_id` - Service account ID for Yandex Cloud Function for Yandex Cloud Functions Trigger
               * `function.0.tag` - Tag for Yandex Cloud Function for Yandex Cloud Functions Trigger
               * `function.0.retry_attempts` - Retry attempts for Yandex Cloud Function for Yandex Cloud Functions Trigger
               * `function.0.retry_interval` - Retry interval in seconds for Yandex Cloud Function for Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerIotArgs', 'FunctionTriggerIotArgsDict']] iot: [IoT](https://cloud.yandex.com/docs/functions/concepts/trigger/iot-core-trigger) settings definition for Yandex Cloud Functions Trigger, if present. Only one section `iot` or `message_queue` or `object_storage` or `timer` can be defined.
               * `iot.0.registry_id` - IoT Registry ID for Yandex Cloud Functions Trigger
               * `iot.0.device_id` - IoT Device ID for Yandex Cloud Functions Trigger
               * `iot.0.topic` - IoT Topic for Yandex Cloud Functions Trigger
               * `iot.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `iot.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerLoggingArgs', 'FunctionTriggerLoggingArgsDict']] logging: [Logging](https://cloud.yandex.com/docs/functions/concepts/trigger/cloud-logging-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `logging.0.group_id` - Logging group ID for Yandex Cloud Functions Trigger
               * `logging.0.resource_ids` - Resource ID filter setting for Yandex Cloud Functions Trigger
               * `logging.0.resource_types` - Resource type filter setting for Yandex Cloud Functions Trigger
               * `logging.0.levels` - Logging level filter setting for Yandex Cloud Functions Trigger
               * `logging.0.stream_names` - Logging stream name filter setting for Yandex Cloud Functions Trigger
               * `logging.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `logging.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerMailArgs', 'FunctionTriggerMailArgsDict']] mail: [Mail](https://yandex.cloud/docs/functions/concepts/trigger/mail-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `mail.0.attachments_bucket_id` - Object Storage Bucket ID for Yandex Cloud Functions Trigger
               * `mail.0.service_account_id` - Service account ID to access object storage for Yandex Cloud Functions Trigger
               * `mail.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `mail.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerMessageQueueArgs', 'FunctionTriggerMessageQueueArgsDict']] message_queue: [Message Queue](https://cloud.yandex.com/docs/functions/concepts/trigger/ymq-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `message_queue.0.queue_id` - Message Queue ID for Yandex Cloud Functions Trigger
               * `message_queue.0.service_account_id` - Message Queue Service Account ID for Yandex Cloud Functions Trigger
               * `message_queue.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `message_queue.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
               * `message_queue.0.visibility_timeout` - Visibility timeout for Yandex Cloud Functions Trigger
        :param pulumi.Input[str] name: Yandex Cloud Functions Trigger name used to define trigger
        :param pulumi.Input[Union['FunctionTriggerObjectStorageArgs', 'FunctionTriggerObjectStorageArgsDict']] object_storage: [Object Storage](https://cloud.yandex.com/docs/functions/concepts/trigger/os-trigger) settings definition for Yandex Cloud Functions Trigger, if present
               * `object_storage.0.bucket_id` - Object Storage Bucket ID for Yandex Cloud Functions Trigger
               * `object_storage.0.prefix` - Prefix for Object Storage for Yandex Cloud Functions Trigger
               * `object_storage.0.suffix` - Suffix for Object Storage for Yandex Cloud Functions Trigger
               * `object_storage.0.create` - Boolean flag for setting create event for Yandex Cloud Functions Trigger
               * `object_storage.0.update` - Boolean flag for setting update event for Yandex Cloud Functions Trigger
               * `object_storage.0.delete` - Boolean flag for setting delete event for Yandex Cloud Functions Trigger
               * `object_storage.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
               * `object_storage.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        :param pulumi.Input[Union['FunctionTriggerTimerArgs', 'FunctionTriggerTimerArgsDict']] timer: [Timer](https://cloud.yandex.com/docs/functions/concepts/trigger/timer) settings definition for Yandex Cloud Functions Trigger, if present
               * `timer.0.cron_expression` - Cron expression for timer for Yandex Cloud Functions Trigger
               * `timer.0.payload` - Payload to be passed to function
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionTriggerState.__new__(_FunctionTriggerState)

        __props__.__dict__["container"] = container
        __props__.__dict__["container_registry"] = container_registry
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["data_streams"] = data_streams
        __props__.__dict__["description"] = description
        __props__.__dict__["dlq"] = dlq
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["function"] = function
        __props__.__dict__["iot"] = iot
        __props__.__dict__["labels"] = labels
        __props__.__dict__["log_group"] = log_group
        __props__.__dict__["logging"] = logging
        __props__.__dict__["mail"] = mail
        __props__.__dict__["message_queue"] = message_queue
        __props__.__dict__["name"] = name
        __props__.__dict__["object_storage"] = object_storage
        __props__.__dict__["timer"] = timer
        return FunctionTrigger(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def container(self) -> pulumi.Output[Optional['outputs.FunctionTriggerContainer']]:
        """
        [Yandex Cloud Serverless Container](https://yandex.cloud/docs/serverless-containers/concepts/container) settings definition for Yandex Cloud Functions Trigger
        * `container.0.id` - Yandex Cloud Serverless Container ID for Yandex Cloud Functions Trigger
        * `container.0.service_account_id` - Service account ID for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
        * `container.0.path` - Path for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
        * `container.0.retry_attempts` - Retry attempts for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
        * `container.0.retry_interval` - Retry interval in seconds for Yandex Cloud Serverless Container for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="containerRegistry")
    def container_registry(self) -> pulumi.Output[Optional['outputs.FunctionTriggerContainerRegistry']]:
        """
        [Container Registry](https://yandex.cloud/docs/functions/concepts/trigger/cr-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `container_registry.0.registry_id` - Container Registry ID for Yandex Cloud Functions Trigger
        * `container_registry.0.image_name` - Image name filter setting for Yandex Cloud Functions Trigger
        * `container_registry.0.tag` - Image tag filter setting for Yandex Cloud Functions Trigger
        * `container_registry.0.create_image` - Boolean flag for setting create image event for Yandex Cloud Functions Trigger
        * `container_registry.0.delete_image` - Boolean flag for setting delete image event for Yandex Cloud Functions Trigger
        * `container_registry.0.create_image_tag` - Boolean flag for setting create image tag event for Yandex Cloud Functions Trigger
        * `container_registry.0.delete_image_tag` - Boolean flag for setting delete image tag event for Yandex Cloud Functions Trigger
        * `container_registry.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `container_registry.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "container_registry")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Creation timestamp of the Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dataStreams")
    def data_streams(self) -> pulumi.Output[Optional['outputs.FunctionTriggerDataStreams']]:
        """
        [Data Streams](https://yandex.cloud/docs/functions/concepts/trigger/data-streams-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `data_streams.0.stream_name` - Stream name for Yandex Cloud Functions Trigger
        * `data_streams.0.database` - Stream database for Yandex Cloud Functions Trigger
        * `data_streams.0.service_account_id` - Service account ID to access data stream for Yandex Cloud Functions Trigger
        * `data_streams.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `data_streams.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "data_streams")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dlq(self) -> pulumi.Output[Optional['outputs.FunctionTriggerDlq']]:
        """
        Dead Letter Queue settings definition for Yandex Cloud Functions Trigger
        * `dlq.0.queue_id` - ID of Dead Letter Queue for Trigger (Queue ARN)
        * `dlq.0.service_account_id` - Service Account ID for Dead Letter Queue for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "dlq")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        Folder ID for the Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def function(self) -> pulumi.Output[Optional['outputs.FunctionTriggerFunction']]:
        """
        [Yandex Cloud Function](https://cloud.yandex.com/docs/functions/concepts/function) settings definition for Yandex Cloud Functions Trigger
        * `function.0.id` - Yandex Cloud Function ID for Yandex Cloud Functions Trigger
        * `function.0.service_account_id` - Service account ID for Yandex Cloud Function for Yandex Cloud Functions Trigger
        * `function.0.tag` - Tag for Yandex Cloud Function for Yandex Cloud Functions Trigger
        * `function.0.retry_attempts` - Retry attempts for Yandex Cloud Function for Yandex Cloud Functions Trigger
        * `function.0.retry_interval` - Retry interval in seconds for Yandex Cloud Function for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter
    def iot(self) -> pulumi.Output[Optional['outputs.FunctionTriggerIot']]:
        """
        [IoT](https://cloud.yandex.com/docs/functions/concepts/trigger/iot-core-trigger) settings definition for Yandex Cloud Functions Trigger, if present. Only one section `iot` or `message_queue` or `object_storage` or `timer` can be defined.
        * `iot.0.registry_id` - IoT Registry ID for Yandex Cloud Functions Trigger
        * `iot.0.device_id` - IoT Device ID for Yandex Cloud Functions Trigger
        * `iot.0.topic` - IoT Topic for Yandex Cloud Functions Trigger
        * `iot.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `iot.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "iot")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A set of key/value label pairs to assign to the Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> pulumi.Output[Optional['outputs.FunctionTriggerLogGroup']]:
        return pulumi.get(self, "log_group")

    @property
    @pulumi.getter
    def logging(self) -> pulumi.Output[Optional['outputs.FunctionTriggerLogging']]:
        """
        [Logging](https://cloud.yandex.com/docs/functions/concepts/trigger/cloud-logging-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `logging.0.group_id` - Logging group ID for Yandex Cloud Functions Trigger
        * `logging.0.resource_ids` - Resource ID filter setting for Yandex Cloud Functions Trigger
        * `logging.0.resource_types` - Resource type filter setting for Yandex Cloud Functions Trigger
        * `logging.0.levels` - Logging level filter setting for Yandex Cloud Functions Trigger
        * `logging.0.stream_names` - Logging stream name filter setting for Yandex Cloud Functions Trigger
        * `logging.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `logging.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter
    def mail(self) -> pulumi.Output[Optional['outputs.FunctionTriggerMail']]:
        """
        [Mail](https://yandex.cloud/docs/functions/concepts/trigger/mail-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `mail.0.attachments_bucket_id` - Object Storage Bucket ID for Yandex Cloud Functions Trigger
        * `mail.0.service_account_id` - Service account ID to access object storage for Yandex Cloud Functions Trigger
        * `mail.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `mail.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "mail")

    @property
    @pulumi.getter(name="messageQueue")
    def message_queue(self) -> pulumi.Output[Optional['outputs.FunctionTriggerMessageQueue']]:
        """
        [Message Queue](https://cloud.yandex.com/docs/functions/concepts/trigger/ymq-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `message_queue.0.queue_id` - Message Queue ID for Yandex Cloud Functions Trigger
        * `message_queue.0.service_account_id` - Message Queue Service Account ID for Yandex Cloud Functions Trigger
        * `message_queue.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `message_queue.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        * `message_queue.0.visibility_timeout` - Visibility timeout for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "message_queue")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Yandex Cloud Functions Trigger name used to define trigger
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectStorage")
    def object_storage(self) -> pulumi.Output[Optional['outputs.FunctionTriggerObjectStorage']]:
        """
        [Object Storage](https://cloud.yandex.com/docs/functions/concepts/trigger/os-trigger) settings definition for Yandex Cloud Functions Trigger, if present
        * `object_storage.0.bucket_id` - Object Storage Bucket ID for Yandex Cloud Functions Trigger
        * `object_storage.0.prefix` - Prefix for Object Storage for Yandex Cloud Functions Trigger
        * `object_storage.0.suffix` - Suffix for Object Storage for Yandex Cloud Functions Trigger
        * `object_storage.0.create` - Boolean flag for setting create event for Yandex Cloud Functions Trigger
        * `object_storage.0.update` - Boolean flag for setting update event for Yandex Cloud Functions Trigger
        * `object_storage.0.delete` - Boolean flag for setting delete event for Yandex Cloud Functions Trigger
        * `object_storage.0.batch_cutoff` - Batch Duration in seconds for Yandex Cloud Functions Trigger
        * `object_storage.0.batch_size` - Batch Size for Yandex Cloud Functions Trigger
        """
        return pulumi.get(self, "object_storage")

    @property
    @pulumi.getter
    def timer(self) -> pulumi.Output[Optional['outputs.FunctionTriggerTimer']]:
        """
        [Timer](https://cloud.yandex.com/docs/functions/concepts/trigger/timer) settings definition for Yandex Cloud Functions Trigger, if present
        * `timer.0.cron_expression` - Cron expression for timer for Yandex Cloud Functions Trigger
        * `timer.0.payload` - Payload to be passed to function
        """
        return pulumi.get(self, "timer")

