# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAlbBackendGroupResult',
    'AwaitableGetAlbBackendGroupResult',
    'get_alb_backend_group',
    'get_alb_backend_group_output',
]

@pulumi.output_type
class GetAlbBackendGroupResult:
    """
    A collection of values returned by getAlbBackendGroup.
    """
    def __init__(__self__, backend_group_id=None, created_at=None, description=None, folder_id=None, grpc_backends=None, http_backends=None, id=None, labels=None, name=None, session_affinity=None, stream_backends=None):
        if backend_group_id and not isinstance(backend_group_id, str):
            raise TypeError("Expected argument 'backend_group_id' to be a str")
        pulumi.set(__self__, "backend_group_id", backend_group_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if grpc_backends and not isinstance(grpc_backends, list):
            raise TypeError("Expected argument 'grpc_backends' to be a list")
        pulumi.set(__self__, "grpc_backends", grpc_backends)
        if http_backends and not isinstance(http_backends, list):
            raise TypeError("Expected argument 'http_backends' to be a list")
        pulumi.set(__self__, "http_backends", http_backends)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if session_affinity and not isinstance(session_affinity, dict):
            raise TypeError("Expected argument 'session_affinity' to be a dict")
        pulumi.set(__self__, "session_affinity", session_affinity)
        if stream_backends and not isinstance(stream_backends, list):
            raise TypeError("Expected argument 'stream_backends' to be a list")
        pulumi.set(__self__, "stream_backends", stream_backends)

    @property
    @pulumi.getter(name="backendGroupId")
    def backend_group_id(self) -> str:
        return pulumi.get(self, "backend_group_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Creation timestamp of this backend group.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the backend group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> str:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter(name="grpcBackends")
    def grpc_backends(self) -> Sequence['outputs.GetAlbBackendGroupGrpcBackendResult']:
        """
        Grpc backend specification that will be used by the ALB Backend Group. Structure is documented below.
        """
        return pulumi.get(self, "grpc_backends")

    @property
    @pulumi.getter(name="httpBackends")
    def http_backends(self) -> Sequence['outputs.GetAlbBackendGroupHttpBackendResult']:
        """
        Http backend specification that will be used by the ALB Backend Group. Structure is documented below.
        """
        return pulumi.get(self, "http_backends")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels to assign to this backend group.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the backend.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> 'outputs.GetAlbBackendGroupSessionAffinityResult':
        """
        Session affinity mode determines how incoming requests are grouped into one session. Structure is documented below.
        """
        return pulumi.get(self, "session_affinity")

    @property
    @pulumi.getter(name="streamBackends")
    def stream_backends(self) -> Sequence['outputs.GetAlbBackendGroupStreamBackendResult']:
        """
        Stream backend specification that will be used by the ALB Backend Group. Structure is documented below.
        """
        return pulumi.get(self, "stream_backends")


class AwaitableGetAlbBackendGroupResult(GetAlbBackendGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlbBackendGroupResult(
            backend_group_id=self.backend_group_id,
            created_at=self.created_at,
            description=self.description,
            folder_id=self.folder_id,
            grpc_backends=self.grpc_backends,
            http_backends=self.http_backends,
            id=self.id,
            labels=self.labels,
            name=self.name,
            session_affinity=self.session_affinity,
            stream_backends=self.stream_backends)


def get_alb_backend_group(backend_group_id: Optional[str] = None,
                          description: Optional[str] = None,
                          folder_id: Optional[str] = None,
                          grpc_backends: Optional[Sequence[Union['GetAlbBackendGroupGrpcBackendArgs', 'GetAlbBackendGroupGrpcBackendArgsDict']]] = None,
                          http_backends: Optional[Sequence[Union['GetAlbBackendGroupHttpBackendArgs', 'GetAlbBackendGroupHttpBackendArgsDict']]] = None,
                          labels: Optional[Mapping[str, str]] = None,
                          name: Optional[str] = None,
                          session_affinity: Optional[Union['GetAlbBackendGroupSessionAffinityArgs', 'GetAlbBackendGroupSessionAffinityArgsDict']] = None,
                          stream_backends: Optional[Sequence[Union['GetAlbBackendGroupStreamBackendArgs', 'GetAlbBackendGroupStreamBackendArgsDict']]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlbBackendGroupResult:
    """
    Get information about a Yandex Application Load Balancer Backend Group. For more information, see [official documentation](https://yandex.cloud/docs/application-load-balancer/quickstart).

    ## Example Usage

    {{ tffile "examples/alb_backend_group/d_alb_backend_group_1.tf" }}

    This data source is used to define [Application Load Balancer Backend Groups](https://yandex.cloud/docs/application-load-balancer/concepts/backend-group) that can be used by other resources.


    :param str backend_group_id: Backend Group ID.
    :param str description: Description of the backend group.
    :param str folder_id: Folder that the resource belongs to. If value is omitted, the default provider folder is used.
    :param Sequence[Union['GetAlbBackendGroupGrpcBackendArgs', 'GetAlbBackendGroupGrpcBackendArgsDict']] grpc_backends: Grpc backend specification that will be used by the ALB Backend Group. Structure is documented below.
    :param Sequence[Union['GetAlbBackendGroupHttpBackendArgs', 'GetAlbBackendGroupHttpBackendArgsDict']] http_backends: Http backend specification that will be used by the ALB Backend Group. Structure is documented below.
    :param Mapping[str, str] labels: Labels to assign to this backend group.
    :param str name: Name of the Backend Group.
           
           > One of `backend_group_id` or `name` should be specified.
    :param Union['GetAlbBackendGroupSessionAffinityArgs', 'GetAlbBackendGroupSessionAffinityArgsDict'] session_affinity: Session affinity mode determines how incoming requests are grouped into one session. Structure is documented below.
    :param Sequence[Union['GetAlbBackendGroupStreamBackendArgs', 'GetAlbBackendGroupStreamBackendArgsDict']] stream_backends: Stream backend specification that will be used by the ALB Backend Group. Structure is documented below.
    """
    __args__ = dict()
    __args__['backendGroupId'] = backend_group_id
    __args__['description'] = description
    __args__['folderId'] = folder_id
    __args__['grpcBackends'] = grpc_backends
    __args__['httpBackends'] = http_backends
    __args__['labels'] = labels
    __args__['name'] = name
    __args__['sessionAffinity'] = session_affinity
    __args__['streamBackends'] = stream_backends
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getAlbBackendGroup:getAlbBackendGroup', __args__, opts=opts, typ=GetAlbBackendGroupResult).value

    return AwaitableGetAlbBackendGroupResult(
        backend_group_id=pulumi.get(__ret__, 'backend_group_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        grpc_backends=pulumi.get(__ret__, 'grpc_backends'),
        http_backends=pulumi.get(__ret__, 'http_backends'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        session_affinity=pulumi.get(__ret__, 'session_affinity'),
        stream_backends=pulumi.get(__ret__, 'stream_backends'))
def get_alb_backend_group_output(backend_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 description: Optional[pulumi.Input[Optional[str]]] = None,
                                 folder_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 grpc_backends: Optional[pulumi.Input[Optional[Sequence[Union['GetAlbBackendGroupGrpcBackendArgs', 'GetAlbBackendGroupGrpcBackendArgsDict']]]]] = None,
                                 http_backends: Optional[pulumi.Input[Optional[Sequence[Union['GetAlbBackendGroupHttpBackendArgs', 'GetAlbBackendGroupHttpBackendArgsDict']]]]] = None,
                                 labels: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                                 name: Optional[pulumi.Input[Optional[str]]] = None,
                                 session_affinity: Optional[pulumi.Input[Optional[Union['GetAlbBackendGroupSessionAffinityArgs', 'GetAlbBackendGroupSessionAffinityArgsDict']]]] = None,
                                 stream_backends: Optional[pulumi.Input[Optional[Sequence[Union['GetAlbBackendGroupStreamBackendArgs', 'GetAlbBackendGroupStreamBackendArgsDict']]]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlbBackendGroupResult]:
    """
    Get information about a Yandex Application Load Balancer Backend Group. For more information, see [official documentation](https://yandex.cloud/docs/application-load-balancer/quickstart).

    ## Example Usage

    {{ tffile "examples/alb_backend_group/d_alb_backend_group_1.tf" }}

    This data source is used to define [Application Load Balancer Backend Groups](https://yandex.cloud/docs/application-load-balancer/concepts/backend-group) that can be used by other resources.


    :param str backend_group_id: Backend Group ID.
    :param str description: Description of the backend group.
    :param str folder_id: Folder that the resource belongs to. If value is omitted, the default provider folder is used.
    :param Sequence[Union['GetAlbBackendGroupGrpcBackendArgs', 'GetAlbBackendGroupGrpcBackendArgsDict']] grpc_backends: Grpc backend specification that will be used by the ALB Backend Group. Structure is documented below.
    :param Sequence[Union['GetAlbBackendGroupHttpBackendArgs', 'GetAlbBackendGroupHttpBackendArgsDict']] http_backends: Http backend specification that will be used by the ALB Backend Group. Structure is documented below.
    :param Mapping[str, str] labels: Labels to assign to this backend group.
    :param str name: Name of the Backend Group.
           
           > One of `backend_group_id` or `name` should be specified.
    :param Union['GetAlbBackendGroupSessionAffinityArgs', 'GetAlbBackendGroupSessionAffinityArgsDict'] session_affinity: Session affinity mode determines how incoming requests are grouped into one session. Structure is documented below.
    :param Sequence[Union['GetAlbBackendGroupStreamBackendArgs', 'GetAlbBackendGroupStreamBackendArgsDict']] stream_backends: Stream backend specification that will be used by the ALB Backend Group. Structure is documented below.
    """
    __args__ = dict()
    __args__['backendGroupId'] = backend_group_id
    __args__['description'] = description
    __args__['folderId'] = folder_id
    __args__['grpcBackends'] = grpc_backends
    __args__['httpBackends'] = http_backends
    __args__['labels'] = labels
    __args__['name'] = name
    __args__['sessionAffinity'] = session_affinity
    __args__['streamBackends'] = stream_backends
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getAlbBackendGroup:getAlbBackendGroup', __args__, opts=opts, typ=GetAlbBackendGroupResult)
    return __ret__.apply(lambda __response__: GetAlbBackendGroupResult(
        backend_group_id=pulumi.get(__response__, 'backend_group_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        grpc_backends=pulumi.get(__response__, 'grpc_backends'),
        http_backends=pulumi.get(__response__, 'http_backends'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        session_affinity=pulumi.get(__response__, 'session_affinity'),
        stream_backends=pulumi.get(__response__, 'stream_backends')))
