# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAlbVirtualHostResult',
    'AwaitableGetAlbVirtualHostResult',
    'get_alb_virtual_host',
    'get_alb_virtual_host_output',
]

@pulumi.output_type
class GetAlbVirtualHostResult:
    """
    A collection of values returned by getAlbVirtualHost.
    """
    def __init__(__self__, authorities=None, http_router_id=None, id=None, modify_request_headers=None, modify_response_headers=None, name=None, rate_limits=None, route_options=None, routes=None, virtual_host_id=None):
        if authorities and not isinstance(authorities, list):
            raise TypeError("Expected argument 'authorities' to be a list")
        pulumi.set(__self__, "authorities", authorities)
        if http_router_id and not isinstance(http_router_id, str):
            raise TypeError("Expected argument 'http_router_id' to be a str")
        pulumi.set(__self__, "http_router_id", http_router_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if modify_request_headers and not isinstance(modify_request_headers, list):
            raise TypeError("Expected argument 'modify_request_headers' to be a list")
        pulumi.set(__self__, "modify_request_headers", modify_request_headers)
        if modify_response_headers and not isinstance(modify_response_headers, list):
            raise TypeError("Expected argument 'modify_response_headers' to be a list")
        pulumi.set(__self__, "modify_response_headers", modify_response_headers)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if rate_limits and not isinstance(rate_limits, list):
            raise TypeError("Expected argument 'rate_limits' to be a list")
        pulumi.set(__self__, "rate_limits", rate_limits)
        if route_options and not isinstance(route_options, list):
            raise TypeError("Expected argument 'route_options' to be a list")
        pulumi.set(__self__, "route_options", route_options)
        if routes and not isinstance(routes, list):
            raise TypeError("Expected argument 'routes' to be a list")
        pulumi.set(__self__, "routes", routes)
        if virtual_host_id and not isinstance(virtual_host_id, str):
            raise TypeError("Expected argument 'virtual_host_id' to be a str")
        pulumi.set(__self__, "virtual_host_id", virtual_host_id)

    @property
    @pulumi.getter
    def authorities(self) -> Sequence[str]:
        """
        A list of domains (host/authority header) that will be matched to this virtual host. Wildcard hosts are supported in the form of '*.foo.com' or '*-bar.foo.com'. If not specified, all domains will be matched.
        """
        return pulumi.get(self, "authorities")

    @property
    @pulumi.getter(name="httpRouterId")
    def http_router_id(self) -> str:
        return pulumi.get(self, "http_router_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modifyRequestHeaders")
    def modify_request_headers(self) -> Sequence['outputs.GetAlbVirtualHostModifyRequestHeaderResult']:
        """
        Apply the following modifications to the request headers. The structure is documented below.
        """
        return pulumi.get(self, "modify_request_headers")

    @property
    @pulumi.getter(name="modifyResponseHeaders")
    def modify_response_headers(self) -> Sequence['outputs.GetAlbVirtualHostModifyResponseHeaderResult']:
        """
        Apply the following modifications to the response headers. The structure is documented below.
        """
        return pulumi.get(self, "modify_response_headers")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name of the route.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rateLimits")
    def rate_limits(self) -> Sequence['outputs.GetAlbVirtualHostRateLimitResult']:
        return pulumi.get(self, "rate_limits")

    @property
    @pulumi.getter(name="routeOptions")
    def route_options(self) -> Sequence['outputs.GetAlbVirtualHostRouteOptionResult']:
        return pulumi.get(self, "route_options")

    @property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetAlbVirtualHostRouteResult']:
        """
        A Route resource. Routes are matched *in-order*. Be careful when adding them to the end. For instance, having http '/' match first makes all other routes unused. The structure is documented below.
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter(name="virtualHostId")
    def virtual_host_id(self) -> str:
        return pulumi.get(self, "virtual_host_id")


class AwaitableGetAlbVirtualHostResult(GetAlbVirtualHostResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlbVirtualHostResult(
            authorities=self.authorities,
            http_router_id=self.http_router_id,
            id=self.id,
            modify_request_headers=self.modify_request_headers,
            modify_response_headers=self.modify_response_headers,
            name=self.name,
            rate_limits=self.rate_limits,
            route_options=self.route_options,
            routes=self.routes,
            virtual_host_id=self.virtual_host_id)


def get_alb_virtual_host(http_router_id: Optional[str] = None,
                         name: Optional[str] = None,
                         virtual_host_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlbVirtualHostResult:
    """
    Get information about a Yandex ALB Virtual Host. For more information, see [Yandex Cloud Application Load Balancer](https://yandex.cloud/docs/application-load-balancer/quickstart).

    ## Example Usage

    {{ tffile "examples/alb_virtual_host/d_alb_virtual_host_1.tf" }}

    This data source is used to define [Application Load Balancer Virtual Host](https://yandex.cloud/docs/application-load-balancer/concepts/http-router) that can be used by other resources.


    :param str http_router_id: HTTP Router that the resource belongs to.
           
           > One of `virtual_host_id` or `name` with `http_router_id` should be specified.
    :param str name: Name of the Virtual Host.
    :param str virtual_host_id: The ID of a specific Virtual Host. Virtual Host ID is concatenation of HTTP Router ID and Virtual Host name with `/` symbol between them. For Example, "http_router_id/vhost_name".
    """
    __args__ = dict()
    __args__['httpRouterId'] = http_router_id
    __args__['name'] = name
    __args__['virtualHostId'] = virtual_host_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getAlbVirtualHost:getAlbVirtualHost', __args__, opts=opts, typ=GetAlbVirtualHostResult).value

    return AwaitableGetAlbVirtualHostResult(
        authorities=pulumi.get(__ret__, 'authorities'),
        http_router_id=pulumi.get(__ret__, 'http_router_id'),
        id=pulumi.get(__ret__, 'id'),
        modify_request_headers=pulumi.get(__ret__, 'modify_request_headers'),
        modify_response_headers=pulumi.get(__ret__, 'modify_response_headers'),
        name=pulumi.get(__ret__, 'name'),
        rate_limits=pulumi.get(__ret__, 'rate_limits'),
        route_options=pulumi.get(__ret__, 'route_options'),
        routes=pulumi.get(__ret__, 'routes'),
        virtual_host_id=pulumi.get(__ret__, 'virtual_host_id'))
def get_alb_virtual_host_output(http_router_id: Optional[pulumi.Input[Optional[str]]] = None,
                                name: Optional[pulumi.Input[Optional[str]]] = None,
                                virtual_host_id: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlbVirtualHostResult]:
    """
    Get information about a Yandex ALB Virtual Host. For more information, see [Yandex Cloud Application Load Balancer](https://yandex.cloud/docs/application-load-balancer/quickstart).

    ## Example Usage

    {{ tffile "examples/alb_virtual_host/d_alb_virtual_host_1.tf" }}

    This data source is used to define [Application Load Balancer Virtual Host](https://yandex.cloud/docs/application-load-balancer/concepts/http-router) that can be used by other resources.


    :param str http_router_id: HTTP Router that the resource belongs to.
           
           > One of `virtual_host_id` or `name` with `http_router_id` should be specified.
    :param str name: Name of the Virtual Host.
    :param str virtual_host_id: The ID of a specific Virtual Host. Virtual Host ID is concatenation of HTTP Router ID and Virtual Host name with `/` symbol between them. For Example, "http_router_id/vhost_name".
    """
    __args__ = dict()
    __args__['httpRouterId'] = http_router_id
    __args__['name'] = name
    __args__['virtualHostId'] = virtual_host_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getAlbVirtualHost:getAlbVirtualHost', __args__, opts=opts, typ=GetAlbVirtualHostResult)
    return __ret__.apply(lambda __response__: GetAlbVirtualHostResult(
        authorities=pulumi.get(__response__, 'authorities'),
        http_router_id=pulumi.get(__response__, 'http_router_id'),
        id=pulumi.get(__response__, 'id'),
        modify_request_headers=pulumi.get(__response__, 'modify_request_headers'),
        modify_response_headers=pulumi.get(__response__, 'modify_response_headers'),
        name=pulumi.get(__response__, 'name'),
        rate_limits=pulumi.get(__response__, 'rate_limits'),
        route_options=pulumi.get(__response__, 'route_options'),
        routes=pulumi.get(__response__, 'routes'),
        virtual_host_id=pulumi.get(__response__, 'virtual_host_id')))
