# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetApiGatewayResult',
    'AwaitableGetApiGatewayResult',
    'get_api_gateway',
    'get_api_gateway_output',
]

@pulumi.output_type
class GetApiGatewayResult:
    """
    A collection of values returned by getApiGateway.
    """
    def __init__(__self__, api_gateway_id=None, canary=None, connectivity=None, created_at=None, custom_domains=None, description=None, domain=None, execution_timeout=None, folder_id=None, id=None, labels=None, log_group_id=None, log_options=None, name=None, status=None, user_domains=None, variables=None):
        if api_gateway_id and not isinstance(api_gateway_id, str):
            raise TypeError("Expected argument 'api_gateway_id' to be a str")
        pulumi.set(__self__, "api_gateway_id", api_gateway_id)
        if canary and not isinstance(canary, dict):
            raise TypeError("Expected argument 'canary' to be a dict")
        pulumi.set(__self__, "canary", canary)
        if connectivity and not isinstance(connectivity, dict):
            raise TypeError("Expected argument 'connectivity' to be a dict")
        pulumi.set(__self__, "connectivity", connectivity)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if custom_domains and not isinstance(custom_domains, list):
            raise TypeError("Expected argument 'custom_domains' to be a list")
        pulumi.set(__self__, "custom_domains", custom_domains)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if execution_timeout and not isinstance(execution_timeout, str):
            raise TypeError("Expected argument 'execution_timeout' to be a str")
        pulumi.set(__self__, "execution_timeout", execution_timeout)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if log_group_id and not isinstance(log_group_id, str):
            raise TypeError("Expected argument 'log_group_id' to be a str")
        pulumi.set(__self__, "log_group_id", log_group_id)
        if log_options and not isinstance(log_options, list):
            raise TypeError("Expected argument 'log_options' to be a list")
        pulumi.set(__self__, "log_options", log_options)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if user_domains and not isinstance(user_domains, list):
            raise TypeError("Expected argument 'user_domains' to be a list")
        pulumi.set(__self__, "user_domains", user_domains)
        if variables and not isinstance(variables, dict):
            raise TypeError("Expected argument 'variables' to be a dict")
        pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter(name="apiGatewayId")
    def api_gateway_id(self) -> Optional[str]:
        return pulumi.get(self, "api_gateway_id")

    @property
    @pulumi.getter
    def canary(self) -> Optional['outputs.GetApiGatewayCanaryResult']:
        """
        Canary release settings of gateway.
        """
        return pulumi.get(self, "canary")

    @property
    @pulumi.getter
    def connectivity(self) -> Optional['outputs.GetApiGatewayConnectivityResult']:
        """
        Gateway connectivity. If specified the gateway will be attached to specified network.
        """
        return pulumi.get(self, "connectivity")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Creation timestamp of the Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customDomains")
    def custom_domains(self) -> Optional[Sequence['outputs.GetApiGatewayCustomDomainResult']]:
        """
        Set of custom domains attached to Yandex API Gateway. Each set item has the following properties: `domain_id`, `fqdn`, `certificate_id`.
        """
        return pulumi.get(self, "custom_domains")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        Default domain for the Yandex API Gateway.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> str:
        """
        Execution timeout in seconds for the Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "execution_timeout")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[str]:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        A set of key/value label pairs to assign to the Yandex Cloud API Gateway.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> str:
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logOptions")
    def log_options(self) -> Sequence['outputs.GetApiGatewayLogOptionResult']:
        """
        Options for logging from Yandex Cloud Function.
        """
        return pulumi.get(self, "log_options")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the Yandex API Gateway.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="userDomains")
    @_utilities.deprecated("""The 'user_domains' field has been deprecated. Please use 'custom_domains' instead.""")
    def user_domains(self) -> Sequence[str]:
        """
        (**DEPRECATED**, use `custom_domains` instead) Set of user domains attached to Yandex API Gateway.
        """
        return pulumi.get(self, "user_domains")

    @property
    @pulumi.getter
    def variables(self) -> Optional[Mapping[str, str]]:
        """
        A set of values for variables in gateway specification.
        """
        return pulumi.get(self, "variables")


class AwaitableGetApiGatewayResult(GetApiGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiGatewayResult(
            api_gateway_id=self.api_gateway_id,
            canary=self.canary,
            connectivity=self.connectivity,
            created_at=self.created_at,
            custom_domains=self.custom_domains,
            description=self.description,
            domain=self.domain,
            execution_timeout=self.execution_timeout,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            log_group_id=self.log_group_id,
            log_options=self.log_options,
            name=self.name,
            status=self.status,
            user_domains=self.user_domains,
            variables=self.variables)


def get_api_gateway(api_gateway_id: Optional[str] = None,
                    canary: Optional[Union['GetApiGatewayCanaryArgs', 'GetApiGatewayCanaryArgsDict']] = None,
                    connectivity: Optional[Union['GetApiGatewayConnectivityArgs', 'GetApiGatewayConnectivityArgsDict']] = None,
                    custom_domains: Optional[Sequence[Union['GetApiGatewayCustomDomainArgs', 'GetApiGatewayCustomDomainArgsDict']]] = None,
                    execution_timeout: Optional[str] = None,
                    folder_id: Optional[str] = None,
                    name: Optional[str] = None,
                    variables: Optional[Mapping[str, str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiGatewayResult:
    """
    Get information about a Yandex Cloud API Gateway. For more information, see the official documentation [Yandex Cloud API Gateway](https://cloud.yandex.com/docs/api-gateway/).

    ## Example Usage

    {{ tffile "examples/api_gateway/d_api_gateway_1.tf" }}


    :param str api_gateway_id: Yandex Cloud API Gateway id used to define api gateway.
    :param Union['GetApiGatewayCanaryArgs', 'GetApiGatewayCanaryArgsDict'] canary: Canary release settings of gateway.
    :param Union['GetApiGatewayConnectivityArgs', 'GetApiGatewayConnectivityArgsDict'] connectivity: Gateway connectivity. If specified the gateway will be attached to specified network.
    :param Sequence[Union['GetApiGatewayCustomDomainArgs', 'GetApiGatewayCustomDomainArgsDict']] custom_domains: Set of custom domains attached to Yandex API Gateway. Each set item has the following properties: `domain_id`, `fqdn`, `certificate_id`.
    :param str execution_timeout: Execution timeout in seconds for the Yandex Cloud API Gateway.
    :param str folder_id: Folder ID for the Yandex Cloud API Gateway.
           
           > Either `api_gateway_id` or `name` must be specified.
    :param str name: Yandex Cloud API Gateway name used to define api gateway.
    :param Mapping[str, str] variables: A set of values for variables in gateway specification.
    """
    __args__ = dict()
    __args__['apiGatewayId'] = api_gateway_id
    __args__['canary'] = canary
    __args__['connectivity'] = connectivity
    __args__['customDomains'] = custom_domains
    __args__['executionTimeout'] = execution_timeout
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['variables'] = variables
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getApiGateway:getApiGateway', __args__, opts=opts, typ=GetApiGatewayResult).value

    return AwaitableGetApiGatewayResult(
        api_gateway_id=pulumi.get(__ret__, 'api_gateway_id'),
        canary=pulumi.get(__ret__, 'canary'),
        connectivity=pulumi.get(__ret__, 'connectivity'),
        created_at=pulumi.get(__ret__, 'created_at'),
        custom_domains=pulumi.get(__ret__, 'custom_domains'),
        description=pulumi.get(__ret__, 'description'),
        domain=pulumi.get(__ret__, 'domain'),
        execution_timeout=pulumi.get(__ret__, 'execution_timeout'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        log_group_id=pulumi.get(__ret__, 'log_group_id'),
        log_options=pulumi.get(__ret__, 'log_options'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'),
        user_domains=pulumi.get(__ret__, 'user_domains'),
        variables=pulumi.get(__ret__, 'variables'))
def get_api_gateway_output(api_gateway_id: Optional[pulumi.Input[Optional[str]]] = None,
                           canary: Optional[pulumi.Input[Optional[Union['GetApiGatewayCanaryArgs', 'GetApiGatewayCanaryArgsDict']]]] = None,
                           connectivity: Optional[pulumi.Input[Optional[Union['GetApiGatewayConnectivityArgs', 'GetApiGatewayConnectivityArgsDict']]]] = None,
                           custom_domains: Optional[pulumi.Input[Optional[Sequence[Union['GetApiGatewayCustomDomainArgs', 'GetApiGatewayCustomDomainArgsDict']]]]] = None,
                           execution_timeout: Optional[pulumi.Input[Optional[str]]] = None,
                           folder_id: Optional[pulumi.Input[Optional[str]]] = None,
                           name: Optional[pulumi.Input[Optional[str]]] = None,
                           variables: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiGatewayResult]:
    """
    Get information about a Yandex Cloud API Gateway. For more information, see the official documentation [Yandex Cloud API Gateway](https://cloud.yandex.com/docs/api-gateway/).

    ## Example Usage

    {{ tffile "examples/api_gateway/d_api_gateway_1.tf" }}


    :param str api_gateway_id: Yandex Cloud API Gateway id used to define api gateway.
    :param Union['GetApiGatewayCanaryArgs', 'GetApiGatewayCanaryArgsDict'] canary: Canary release settings of gateway.
    :param Union['GetApiGatewayConnectivityArgs', 'GetApiGatewayConnectivityArgsDict'] connectivity: Gateway connectivity. If specified the gateway will be attached to specified network.
    :param Sequence[Union['GetApiGatewayCustomDomainArgs', 'GetApiGatewayCustomDomainArgsDict']] custom_domains: Set of custom domains attached to Yandex API Gateway. Each set item has the following properties: `domain_id`, `fqdn`, `certificate_id`.
    :param str execution_timeout: Execution timeout in seconds for the Yandex Cloud API Gateway.
    :param str folder_id: Folder ID for the Yandex Cloud API Gateway.
           
           > Either `api_gateway_id` or `name` must be specified.
    :param str name: Yandex Cloud API Gateway name used to define api gateway.
    :param Mapping[str, str] variables: A set of values for variables in gateway specification.
    """
    __args__ = dict()
    __args__['apiGatewayId'] = api_gateway_id
    __args__['canary'] = canary
    __args__['connectivity'] = connectivity
    __args__['customDomains'] = custom_domains
    __args__['executionTimeout'] = execution_timeout
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['variables'] = variables
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getApiGateway:getApiGateway', __args__, opts=opts, typ=GetApiGatewayResult)
    return __ret__.apply(lambda __response__: GetApiGatewayResult(
        api_gateway_id=pulumi.get(__response__, 'api_gateway_id'),
        canary=pulumi.get(__response__, 'canary'),
        connectivity=pulumi.get(__response__, 'connectivity'),
        created_at=pulumi.get(__response__, 'created_at'),
        custom_domains=pulumi.get(__response__, 'custom_domains'),
        description=pulumi.get(__response__, 'description'),
        domain=pulumi.get(__response__, 'domain'),
        execution_timeout=pulumi.get(__response__, 'execution_timeout'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        log_group_id=pulumi.get(__response__, 'log_group_id'),
        log_options=pulumi.get(__response__, 'log_options'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status'),
        user_domains=pulumi.get(__response__, 'user_domains'),
        variables=pulumi.get(__response__, 'variables')))
