# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCdnResourceResult',
    'AwaitableGetCdnResourceResult',
    'get_cdn_resource',
    'get_cdn_resource_output',
]

@pulumi.output_type
class GetCdnResourceResult:
    """
    A collection of values returned by getCdnResource.
    """
    def __init__(__self__, active=None, cname=None, created_at=None, folder_id=None, id=None, labels=None, options=None, origin_group_id=None, origin_group_name=None, origin_protocol=None, provider_cname=None, resource_id=None, secondary_hostnames=None, ssl_certificate=None, updated_at=None):
        if active and not isinstance(active, bool):
            raise TypeError("Expected argument 'active' to be a bool")
        pulumi.set(__self__, "active", active)
        if cname and not isinstance(cname, str):
            raise TypeError("Expected argument 'cname' to be a str")
        pulumi.set(__self__, "cname", cname)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if options and not isinstance(options, dict):
            raise TypeError("Expected argument 'options' to be a dict")
        pulumi.set(__self__, "options", options)
        if origin_group_id and not isinstance(origin_group_id, int):
            raise TypeError("Expected argument 'origin_group_id' to be a int")
        pulumi.set(__self__, "origin_group_id", origin_group_id)
        if origin_group_name and not isinstance(origin_group_name, str):
            raise TypeError("Expected argument 'origin_group_name' to be a str")
        pulumi.set(__self__, "origin_group_name", origin_group_name)
        if origin_protocol and not isinstance(origin_protocol, str):
            raise TypeError("Expected argument 'origin_protocol' to be a str")
        pulumi.set(__self__, "origin_protocol", origin_protocol)
        if provider_cname and not isinstance(provider_cname, str):
            raise TypeError("Expected argument 'provider_cname' to be a str")
        pulumi.set(__self__, "provider_cname", provider_cname)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if secondary_hostnames and not isinstance(secondary_hostnames, list):
            raise TypeError("Expected argument 'secondary_hostnames' to be a list")
        pulumi.set(__self__, "secondary_hostnames", secondary_hostnames)
        if ssl_certificate and not isinstance(ssl_certificate, dict):
            raise TypeError("Expected argument 'ssl_certificate' to be a dict")
        pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def cname(self) -> str:
        return pulumi.get(self, "cname")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> str:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def options(self) -> 'outputs.GetCdnResourceOptionsResult':
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="originGroupId")
    def origin_group_id(self) -> Optional[int]:
        return pulumi.get(self, "origin_group_id")

    @property
    @pulumi.getter(name="originGroupName")
    def origin_group_name(self) -> Optional[str]:
        return pulumi.get(self, "origin_group_name")

    @property
    @pulumi.getter(name="originProtocol")
    def origin_protocol(self) -> Optional[str]:
        return pulumi.get(self, "origin_protocol")

    @property
    @pulumi.getter(name="providerCname")
    def provider_cname(self) -> str:
        return pulumi.get(self, "provider_cname")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="secondaryHostnames")
    def secondary_hostnames(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "secondary_hostnames")

    @property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> 'outputs.GetCdnResourceSslCertificateResult':
        return pulumi.get(self, "ssl_certificate")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        return pulumi.get(self, "updated_at")


class AwaitableGetCdnResourceResult(GetCdnResourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCdnResourceResult(
            active=self.active,
            cname=self.cname,
            created_at=self.created_at,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            options=self.options,
            origin_group_id=self.origin_group_id,
            origin_group_name=self.origin_group_name,
            origin_protocol=self.origin_protocol,
            provider_cname=self.provider_cname,
            resource_id=self.resource_id,
            secondary_hostnames=self.secondary_hostnames,
            ssl_certificate=self.ssl_certificate,
            updated_at=self.updated_at)


def get_cdn_resource(active: Optional[bool] = None,
                     cname: Optional[str] = None,
                     folder_id: Optional[str] = None,
                     labels: Optional[Mapping[str, str]] = None,
                     options: Optional[Union['GetCdnResourceOptionsArgs', 'GetCdnResourceOptionsArgsDict']] = None,
                     origin_group_id: Optional[int] = None,
                     origin_group_name: Optional[str] = None,
                     origin_protocol: Optional[str] = None,
                     resource_id: Optional[str] = None,
                     secondary_hostnames: Optional[Sequence[str]] = None,
                     ssl_certificate: Optional[Union['GetCdnResourceSslCertificateArgs', 'GetCdnResourceSslCertificateArgsDict']] = None,
                     updated_at: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCdnResourceResult:
    """
    Get information about a Yandex CDN Resource. For more information, see [the official documentation](https://yandex.cloud/docs/cdn/concepts/resource).

    > CDN provider must be activated prior usage of CDN resources, either via UI console or via yc cli command: `yc cdn provider activate --folder-id <folder-id> --type gcore`

    ## Example Usage

    {{ tffile "examples/cdn_resource/d_cdn_resource_1.tf" }}


    :param bool active: Flag to create Resource either in active or disabled state. True - the content from CDN is available to clients.
    :param str cname: CDN endpoint CNAME, must be unique among resources.
    :param str folder_id: Folder that the resource belongs to. If value is omitted, the default provider folder is used.
    :param Mapping[str, str] labels: Labels to assign to this CDN Resource. A list of key/value pairs.
    :param Union['GetCdnResourceOptionsArgs', 'GetCdnResourceOptionsArgsDict'] options: CDN Resource settings and options to tune CDN edge behavior.
    :param Sequence[str] secondary_hostnames: list of secondary hostname strings.
    :param Union['GetCdnResourceSslCertificateArgs', 'GetCdnResourceSslCertificateArgsDict'] ssl_certificate: SSL certificate of CDN resource.
    """
    __args__ = dict()
    __args__['active'] = active
    __args__['cname'] = cname
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['options'] = options
    __args__['originGroupId'] = origin_group_id
    __args__['originGroupName'] = origin_group_name
    __args__['originProtocol'] = origin_protocol
    __args__['resourceId'] = resource_id
    __args__['secondaryHostnames'] = secondary_hostnames
    __args__['sslCertificate'] = ssl_certificate
    __args__['updatedAt'] = updated_at
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getCdnResource:getCdnResource', __args__, opts=opts, typ=GetCdnResourceResult).value

    return AwaitableGetCdnResourceResult(
        active=pulumi.get(__ret__, 'active'),
        cname=pulumi.get(__ret__, 'cname'),
        created_at=pulumi.get(__ret__, 'created_at'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        options=pulumi.get(__ret__, 'options'),
        origin_group_id=pulumi.get(__ret__, 'origin_group_id'),
        origin_group_name=pulumi.get(__ret__, 'origin_group_name'),
        origin_protocol=pulumi.get(__ret__, 'origin_protocol'),
        provider_cname=pulumi.get(__ret__, 'provider_cname'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        secondary_hostnames=pulumi.get(__ret__, 'secondary_hostnames'),
        ssl_certificate=pulumi.get(__ret__, 'ssl_certificate'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_cdn_resource_output(active: Optional[pulumi.Input[Optional[bool]]] = None,
                            cname: Optional[pulumi.Input[Optional[str]]] = None,
                            folder_id: Optional[pulumi.Input[Optional[str]]] = None,
                            labels: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                            options: Optional[pulumi.Input[Optional[Union['GetCdnResourceOptionsArgs', 'GetCdnResourceOptionsArgsDict']]]] = None,
                            origin_group_id: Optional[pulumi.Input[Optional[int]]] = None,
                            origin_group_name: Optional[pulumi.Input[Optional[str]]] = None,
                            origin_protocol: Optional[pulumi.Input[Optional[str]]] = None,
                            resource_id: Optional[pulumi.Input[Optional[str]]] = None,
                            secondary_hostnames: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            ssl_certificate: Optional[pulumi.Input[Optional[Union['GetCdnResourceSslCertificateArgs', 'GetCdnResourceSslCertificateArgsDict']]]] = None,
                            updated_at: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCdnResourceResult]:
    """
    Get information about a Yandex CDN Resource. For more information, see [the official documentation](https://yandex.cloud/docs/cdn/concepts/resource).

    > CDN provider must be activated prior usage of CDN resources, either via UI console or via yc cli command: `yc cdn provider activate --folder-id <folder-id> --type gcore`

    ## Example Usage

    {{ tffile "examples/cdn_resource/d_cdn_resource_1.tf" }}


    :param bool active: Flag to create Resource either in active or disabled state. True - the content from CDN is available to clients.
    :param str cname: CDN endpoint CNAME, must be unique among resources.
    :param str folder_id: Folder that the resource belongs to. If value is omitted, the default provider folder is used.
    :param Mapping[str, str] labels: Labels to assign to this CDN Resource. A list of key/value pairs.
    :param Union['GetCdnResourceOptionsArgs', 'GetCdnResourceOptionsArgsDict'] options: CDN Resource settings and options to tune CDN edge behavior.
    :param Sequence[str] secondary_hostnames: list of secondary hostname strings.
    :param Union['GetCdnResourceSslCertificateArgs', 'GetCdnResourceSslCertificateArgsDict'] ssl_certificate: SSL certificate of CDN resource.
    """
    __args__ = dict()
    __args__['active'] = active
    __args__['cname'] = cname
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['options'] = options
    __args__['originGroupId'] = origin_group_id
    __args__['originGroupName'] = origin_group_name
    __args__['originProtocol'] = origin_protocol
    __args__['resourceId'] = resource_id
    __args__['secondaryHostnames'] = secondary_hostnames
    __args__['sslCertificate'] = ssl_certificate
    __args__['updatedAt'] = updated_at
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getCdnResource:getCdnResource', __args__, opts=opts, typ=GetCdnResourceResult)
    return __ret__.apply(lambda __response__: GetCdnResourceResult(
        active=pulumi.get(__response__, 'active'),
        cname=pulumi.get(__response__, 'cname'),
        created_at=pulumi.get(__response__, 'created_at'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        options=pulumi.get(__response__, 'options'),
        origin_group_id=pulumi.get(__response__, 'origin_group_id'),
        origin_group_name=pulumi.get(__response__, 'origin_group_name'),
        origin_protocol=pulumi.get(__response__, 'origin_protocol'),
        provider_cname=pulumi.get(__response__, 'provider_cname'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        secondary_hostnames=pulumi.get(__response__, 'secondary_hostnames'),
        ssl_certificate=pulumi.get(__response__, 'ssl_certificate'),
        updated_at=pulumi.get(__response__, 'updated_at')))
