# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCmCertificateResult',
    'AwaitableGetCmCertificateResult',
    'get_cm_certificate',
    'get_cm_certificate_output',
]

@pulumi.output_type
class GetCmCertificateResult:
    """
    A collection of values returned by getCmCertificate.
    """
    def __init__(__self__, certificate_id=None, challenges=None, created_at=None, deletion_protection=None, description=None, domains=None, folder_id=None, id=None, issued_at=None, issuer=None, labels=None, name=None, not_after=None, not_before=None, serial=None, status=None, subject=None, type=None, updated_at=None, wait_validation=None):
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if challenges and not isinstance(challenges, list):
            raise TypeError("Expected argument 'challenges' to be a list")
        pulumi.set(__self__, "challenges", challenges)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domains and not isinstance(domains, list):
            raise TypeError("Expected argument 'domains' to be a list")
        pulumi.set(__self__, "domains", domains)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issued_at and not isinstance(issued_at, str):
            raise TypeError("Expected argument 'issued_at' to be a str")
        pulumi.set(__self__, "issued_at", issued_at)
        if issuer and not isinstance(issuer, str):
            raise TypeError("Expected argument 'issuer' to be a str")
        pulumi.set(__self__, "issuer", issuer)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if not_after and not isinstance(not_after, str):
            raise TypeError("Expected argument 'not_after' to be a str")
        pulumi.set(__self__, "not_after", not_after)
        if not_before and not isinstance(not_before, str):
            raise TypeError("Expected argument 'not_before' to be a str")
        pulumi.set(__self__, "not_before", not_before)
        if serial and not isinstance(serial, str):
            raise TypeError("Expected argument 'serial' to be a str")
        pulumi.set(__self__, "serial", serial)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subject and not isinstance(subject, str):
            raise TypeError("Expected argument 'subject' to be a str")
        pulumi.set(__self__, "subject", subject)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if wait_validation and not isinstance(wait_validation, bool):
            raise TypeError("Expected argument 'wait_validation' to be a bool")
        pulumi.set(__self__, "wait_validation", wait_validation)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> str:
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter
    def challenges(self) -> Sequence['outputs.GetCmCertificateChallengeResult']:
        """
        Array of challenges. Structure is documented below.
        """
        return pulumi.get(self, "challenges")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Time the challenge was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Certificate description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domains(self) -> Sequence[str]:
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> str:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="issuedAt")
    def issued_at(self) -> str:
        """
        Certificate issue timestamp.
        """
        return pulumi.get(self, "issued_at")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        Certificate issuer.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels to assign to this certificate.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> str:
        """
        Certificate end valid period.
        """
        return pulumi.get(self, "not_after")

    @property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> str:
        """
        Certificate start valid period.
        """
        return pulumi.get(self, "not_before")

    @property
    @pulumi.getter
    def serial(self) -> str:
        """
        Certificate serial number.
        """
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Certificate status: `"VALIDATING"`, `"INVALID"`, `"ISSUED"`, `"REVOKED"`, `"RENEWING"` or `"RENEWAL_FAILED"`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        Certificate subject.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Challenge type `"DNS"` or `"HTTP"`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Last time the challenge was updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="waitValidation")
    def wait_validation(self) -> Optional[bool]:
        return pulumi.get(self, "wait_validation")


class AwaitableGetCmCertificateResult(GetCmCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCmCertificateResult(
            certificate_id=self.certificate_id,
            challenges=self.challenges,
            created_at=self.created_at,
            deletion_protection=self.deletion_protection,
            description=self.description,
            domains=self.domains,
            folder_id=self.folder_id,
            id=self.id,
            issued_at=self.issued_at,
            issuer=self.issuer,
            labels=self.labels,
            name=self.name,
            not_after=self.not_after,
            not_before=self.not_before,
            serial=self.serial,
            status=self.status,
            subject=self.subject,
            type=self.type,
            updated_at=self.updated_at,
            wait_validation=self.wait_validation)


def get_cm_certificate(certificate_id: Optional[str] = None,
                       description: Optional[str] = None,
                       folder_id: Optional[str] = None,
                       labels: Optional[Mapping[str, str]] = None,
                       name: Optional[str] = None,
                       wait_validation: Optional[bool] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCmCertificateResult:
    """
    Get information about a Yandex Certificate Manager Certificate. For more information, see [the official documentation](https://yandex.cloud/docs/certificate-manager/concepts/).

    ## Example Usage

    {{ tffile "examples/cm_certificate/d_cm_certificate_1.tf" }}

    This data source is used to define [Certificate Manager Certificate](https://yandex.cloud/docs/certificate-manager/concepts/) that can be used by other resources. Can also be used to wait for certificate validation.

    {{ tffile "examples/cm_certificate/d_cm_certificate_2.tf" }}


    :param str certificate_id: Certificate Id.
    :param str description: Certificate description.
    :param str folder_id: Folder that the resource belongs to. If value is omitted, the default provider folder is used.
    :param Mapping[str, str] labels: Labels to assign to this certificate.
    :param str name: Name of the Certificate.
    :param bool wait_validation: If `true`, the operation won't be completed while the certificate is in `VALIDATING`.
           
           > One of `certificate_id` or `name` should be specified.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    __args__['description'] = description
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['name'] = name
    __args__['waitValidation'] = wait_validation
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getCmCertificate:getCmCertificate', __args__, opts=opts, typ=GetCmCertificateResult).value

    return AwaitableGetCmCertificateResult(
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        challenges=pulumi.get(__ret__, 'challenges'),
        created_at=pulumi.get(__ret__, 'created_at'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        description=pulumi.get(__ret__, 'description'),
        domains=pulumi.get(__ret__, 'domains'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        issued_at=pulumi.get(__ret__, 'issued_at'),
        issuer=pulumi.get(__ret__, 'issuer'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        not_after=pulumi.get(__ret__, 'not_after'),
        not_before=pulumi.get(__ret__, 'not_before'),
        serial=pulumi.get(__ret__, 'serial'),
        status=pulumi.get(__ret__, 'status'),
        subject=pulumi.get(__ret__, 'subject'),
        type=pulumi.get(__ret__, 'type'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        wait_validation=pulumi.get(__ret__, 'wait_validation'))
def get_cm_certificate_output(certificate_id: Optional[pulumi.Input[Optional[str]]] = None,
                              description: Optional[pulumi.Input[Optional[str]]] = None,
                              folder_id: Optional[pulumi.Input[Optional[str]]] = None,
                              labels: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                              name: Optional[pulumi.Input[Optional[str]]] = None,
                              wait_validation: Optional[pulumi.Input[Optional[bool]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCmCertificateResult]:
    """
    Get information about a Yandex Certificate Manager Certificate. For more information, see [the official documentation](https://yandex.cloud/docs/certificate-manager/concepts/).

    ## Example Usage

    {{ tffile "examples/cm_certificate/d_cm_certificate_1.tf" }}

    This data source is used to define [Certificate Manager Certificate](https://yandex.cloud/docs/certificate-manager/concepts/) that can be used by other resources. Can also be used to wait for certificate validation.

    {{ tffile "examples/cm_certificate/d_cm_certificate_2.tf" }}


    :param str certificate_id: Certificate Id.
    :param str description: Certificate description.
    :param str folder_id: Folder that the resource belongs to. If value is omitted, the default provider folder is used.
    :param Mapping[str, str] labels: Labels to assign to this certificate.
    :param str name: Name of the Certificate.
    :param bool wait_validation: If `true`, the operation won't be completed while the certificate is in `VALIDATING`.
           
           > One of `certificate_id` or `name` should be specified.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    __args__['description'] = description
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['name'] = name
    __args__['waitValidation'] = wait_validation
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getCmCertificate:getCmCertificate', __args__, opts=opts, typ=GetCmCertificateResult)
    return __ret__.apply(lambda __response__: GetCmCertificateResult(
        certificate_id=pulumi.get(__response__, 'certificate_id'),
        challenges=pulumi.get(__response__, 'challenges'),
        created_at=pulumi.get(__response__, 'created_at'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        description=pulumi.get(__response__, 'description'),
        domains=pulumi.get(__response__, 'domains'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        issued_at=pulumi.get(__response__, 'issued_at'),
        issuer=pulumi.get(__response__, 'issuer'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        not_after=pulumi.get(__response__, 'not_after'),
        not_before=pulumi.get(__response__, 'not_before'),
        serial=pulumi.get(__response__, 'serial'),
        status=pulumi.get(__response__, 'status'),
        subject=pulumi.get(__response__, 'subject'),
        type=pulumi.get(__response__, 'type'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        wait_validation=pulumi.get(__response__, 'wait_validation')))
