# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetComputeSnapshotScheduleResult',
    'AwaitableGetComputeSnapshotScheduleResult',
    'get_compute_snapshot_schedule',
    'get_compute_snapshot_schedule_output',
]

@pulumi.output_type
class GetComputeSnapshotScheduleResult:
    """
    A collection of values returned by getComputeSnapshotSchedule.
    """
    def __init__(__self__, created_at=None, description=None, disk_ids=None, folder_id=None, id=None, labels=None, name=None, retention_period=None, schedule_policies=None, snapshot_count=None, snapshot_schedule_id=None, snapshot_specs=None, status=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disk_ids and not isinstance(disk_ids, list):
            raise TypeError("Expected argument 'disk_ids' to be a list")
        pulumi.set(__self__, "disk_ids", disk_ids)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if retention_period and not isinstance(retention_period, str):
            raise TypeError("Expected argument 'retention_period' to be a str")
        pulumi.set(__self__, "retention_period", retention_period)
        if schedule_policies and not isinstance(schedule_policies, list):
            raise TypeError("Expected argument 'schedule_policies' to be a list")
        pulumi.set(__self__, "schedule_policies", schedule_policies)
        if snapshot_count and not isinstance(snapshot_count, int):
            raise TypeError("Expected argument 'snapshot_count' to be a int")
        pulumi.set(__self__, "snapshot_count", snapshot_count)
        if snapshot_schedule_id and not isinstance(snapshot_schedule_id, str):
            raise TypeError("Expected argument 'snapshot_schedule_id' to be a str")
        pulumi.set(__self__, "snapshot_schedule_id", snapshot_schedule_id)
        if snapshot_specs and not isinstance(snapshot_specs, list):
            raise TypeError("Expected argument 'snapshot_specs' to be a list")
        pulumi.set(__self__, "snapshot_specs", snapshot_specs)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        SnapshotSchedule creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional description of this snapshot schedule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskIds")
    def disk_ids(self) -> Sequence[str]:
        """
        IDs of the disks of this snapshot schedule.
        """
        return pulumi.get(self, "disk_ids")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> str:
        """
        ID of the folder that the snapshot schedule belongs to.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        A map of labels applied to this snapshot schedule.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> str:
        """
        Retention period applied to snapshots created by this snapshot schedule.
        """
        return pulumi.get(self, "retention_period")

    @property
    @pulumi.getter(name="schedulePolicies")
    def schedule_policies(self) -> Sequence['outputs.GetComputeSnapshotScheduleSchedulePolicyResult']:
        """
        Schedule policy of the snapshot schedule.
        """
        return pulumi.get(self, "schedule_policies")

    @property
    @pulumi.getter(name="snapshotCount")
    def snapshot_count(self) -> int:
        """
        Maximum number of snapshots for every disk of the snapshot schedule.
        """
        return pulumi.get(self, "snapshot_count")

    @property
    @pulumi.getter(name="snapshotScheduleId")
    def snapshot_schedule_id(self) -> str:
        return pulumi.get(self, "snapshot_schedule_id")

    @property
    @pulumi.getter(name="snapshotSpecs")
    def snapshot_specs(self) -> Sequence['outputs.GetComputeSnapshotScheduleSnapshotSpecResult']:
        """
        Additional attributes for snapshots created by this snapshot schedule.
        """
        return pulumi.get(self, "snapshot_specs")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the snapshot schedule.
        """
        return pulumi.get(self, "status")


class AwaitableGetComputeSnapshotScheduleResult(GetComputeSnapshotScheduleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeSnapshotScheduleResult(
            created_at=self.created_at,
            description=self.description,
            disk_ids=self.disk_ids,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            retention_period=self.retention_period,
            schedule_policies=self.schedule_policies,
            snapshot_count=self.snapshot_count,
            snapshot_schedule_id=self.snapshot_schedule_id,
            snapshot_specs=self.snapshot_specs,
            status=self.status)


def get_compute_snapshot_schedule(description: Optional[str] = None,
                                  disk_ids: Optional[Sequence[str]] = None,
                                  folder_id: Optional[str] = None,
                                  labels: Optional[Mapping[str, str]] = None,
                                  name: Optional[str] = None,
                                  retention_period: Optional[str] = None,
                                  schedule_policies: Optional[Sequence[Union['GetComputeSnapshotScheduleSchedulePolicyArgs', 'GetComputeSnapshotScheduleSchedulePolicyArgsDict']]] = None,
                                  snapshot_count: Optional[int] = None,
                                  snapshot_schedule_id: Optional[str] = None,
                                  snapshot_specs: Optional[Sequence[Union['GetComputeSnapshotScheduleSnapshotSpecArgs', 'GetComputeSnapshotScheduleSnapshotSpecArgsDict']]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeSnapshotScheduleResult:
    """
    Get information about a Yandex Compute snapshot schedule. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/snapshot-schedule).

    ## Example Usage

    {{ tffile "examples/compute_snapshot_schedule/d_compute_snapshot_schedule_1.tf" }}


    :param str description: An optional description of this snapshot schedule.
    :param Sequence[str] disk_ids: IDs of the disks of this snapshot schedule.
    :param str folder_id: ID of the folder that the snapshot schedule belongs to.
    :param Mapping[str, str] labels: A map of labels applied to this snapshot schedule.
    :param str name: The name of the snapshot schedule.
           
           > One of `snapshot_schedule_id` or `name` should be specified.
    :param str retention_period: Retention period applied to snapshots created by this snapshot schedule.
    :param Sequence[Union['GetComputeSnapshotScheduleSchedulePolicyArgs', 'GetComputeSnapshotScheduleSchedulePolicyArgsDict']] schedule_policies: Schedule policy of the snapshot schedule.
    :param int snapshot_count: Maximum number of snapshots for every disk of the snapshot schedule.
    :param str snapshot_schedule_id: The ID of a specific snapshot schedule.
    :param Sequence[Union['GetComputeSnapshotScheduleSnapshotSpecArgs', 'GetComputeSnapshotScheduleSnapshotSpecArgsDict']] snapshot_specs: Additional attributes for snapshots created by this snapshot schedule.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['diskIds'] = disk_ids
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['name'] = name
    __args__['retentionPeriod'] = retention_period
    __args__['schedulePolicies'] = schedule_policies
    __args__['snapshotCount'] = snapshot_count
    __args__['snapshotScheduleId'] = snapshot_schedule_id
    __args__['snapshotSpecs'] = snapshot_specs
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getComputeSnapshotSchedule:getComputeSnapshotSchedule', __args__, opts=opts, typ=GetComputeSnapshotScheduleResult).value

    return AwaitableGetComputeSnapshotScheduleResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        disk_ids=pulumi.get(__ret__, 'disk_ids'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        retention_period=pulumi.get(__ret__, 'retention_period'),
        schedule_policies=pulumi.get(__ret__, 'schedule_policies'),
        snapshot_count=pulumi.get(__ret__, 'snapshot_count'),
        snapshot_schedule_id=pulumi.get(__ret__, 'snapshot_schedule_id'),
        snapshot_specs=pulumi.get(__ret__, 'snapshot_specs'),
        status=pulumi.get(__ret__, 'status'))
def get_compute_snapshot_schedule_output(description: Optional[pulumi.Input[Optional[str]]] = None,
                                         disk_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                         folder_id: Optional[pulumi.Input[Optional[str]]] = None,
                                         labels: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                                         name: Optional[pulumi.Input[Optional[str]]] = None,
                                         retention_period: Optional[pulumi.Input[Optional[str]]] = None,
                                         schedule_policies: Optional[pulumi.Input[Optional[Sequence[Union['GetComputeSnapshotScheduleSchedulePolicyArgs', 'GetComputeSnapshotScheduleSchedulePolicyArgsDict']]]]] = None,
                                         snapshot_count: Optional[pulumi.Input[Optional[int]]] = None,
                                         snapshot_schedule_id: Optional[pulumi.Input[Optional[str]]] = None,
                                         snapshot_specs: Optional[pulumi.Input[Optional[Sequence[Union['GetComputeSnapshotScheduleSnapshotSpecArgs', 'GetComputeSnapshotScheduleSnapshotSpecArgsDict']]]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComputeSnapshotScheduleResult]:
    """
    Get information about a Yandex Compute snapshot schedule. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/snapshot-schedule).

    ## Example Usage

    {{ tffile "examples/compute_snapshot_schedule/d_compute_snapshot_schedule_1.tf" }}


    :param str description: An optional description of this snapshot schedule.
    :param Sequence[str] disk_ids: IDs of the disks of this snapshot schedule.
    :param str folder_id: ID of the folder that the snapshot schedule belongs to.
    :param Mapping[str, str] labels: A map of labels applied to this snapshot schedule.
    :param str name: The name of the snapshot schedule.
           
           > One of `snapshot_schedule_id` or `name` should be specified.
    :param str retention_period: Retention period applied to snapshots created by this snapshot schedule.
    :param Sequence[Union['GetComputeSnapshotScheduleSchedulePolicyArgs', 'GetComputeSnapshotScheduleSchedulePolicyArgsDict']] schedule_policies: Schedule policy of the snapshot schedule.
    :param int snapshot_count: Maximum number of snapshots for every disk of the snapshot schedule.
    :param str snapshot_schedule_id: The ID of a specific snapshot schedule.
    :param Sequence[Union['GetComputeSnapshotScheduleSnapshotSpecArgs', 'GetComputeSnapshotScheduleSnapshotSpecArgsDict']] snapshot_specs: Additional attributes for snapshots created by this snapshot schedule.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['diskIds'] = disk_ids
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['name'] = name
    __args__['retentionPeriod'] = retention_period
    __args__['schedulePolicies'] = schedule_policies
    __args__['snapshotCount'] = snapshot_count
    __args__['snapshotScheduleId'] = snapshot_schedule_id
    __args__['snapshotSpecs'] = snapshot_specs
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getComputeSnapshotSchedule:getComputeSnapshotSchedule', __args__, opts=opts, typ=GetComputeSnapshotScheduleResult)
    return __ret__.apply(lambda __response__: GetComputeSnapshotScheduleResult(
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        disk_ids=pulumi.get(__response__, 'disk_ids'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        retention_period=pulumi.get(__response__, 'retention_period'),
        schedule_policies=pulumi.get(__response__, 'schedule_policies'),
        snapshot_count=pulumi.get(__response__, 'snapshot_count'),
        snapshot_schedule_id=pulumi.get(__response__, 'snapshot_schedule_id'),
        snapshot_specs=pulumi.get(__response__, 'snapshot_specs'),
        status=pulumi.get(__response__, 'status')))
