# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetContainerRegistryResult',
    'AwaitableGetContainerRegistryResult',
    'get_container_registry',
    'get_container_registry_output',
]

@pulumi.output_type
class GetContainerRegistryResult:
    """
    A collection of values returned by getContainerRegistry.
    """
    def __init__(__self__, created_at=None, folder_id=None, id=None, labels=None, name=None, registry_id=None, status=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if registry_id and not isinstance(registry_id, str):
            raise TypeError("Expected argument 'registry_id' to be a str")
        pulumi.set(__self__, "registry_id", registry_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Creation timestamp of this registry.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> str:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Labels to assign to this registry.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> str:
        return pulumi.get(self, "registry_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the registry.
        """
        return pulumi.get(self, "status")


class AwaitableGetContainerRegistryResult(GetContainerRegistryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerRegistryResult(
            created_at=self.created_at,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            registry_id=self.registry_id,
            status=self.status)


def get_container_registry(folder_id: Optional[str] = None,
                           labels: Optional[Mapping[str, str]] = None,
                           name: Optional[str] = None,
                           registry_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainerRegistryResult:
    """
    Get information about a Yandex Container Registry. For more information, see [the official documentation](https://cloud.yandex.com/docs/container-registry/concepts/registry)

    ## Example Usage

    {{ tffile "examples/container_registry/d_container_registry_1.tf" }}


    :param str folder_id: Folder that the resource belongs to. If value is omitted, the default provider folder is used.
    :param Mapping[str, str] labels: Labels to assign to this registry.
    :param str name: Name of the registry.
    :param str registry_id: The ID of a specific registry.
    """
    __args__ = dict()
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['name'] = name
    __args__['registryId'] = registry_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getContainerRegistry:getContainerRegistry', __args__, opts=opts, typ=GetContainerRegistryResult).value

    return AwaitableGetContainerRegistryResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        registry_id=pulumi.get(__ret__, 'registry_id'),
        status=pulumi.get(__ret__, 'status'))
def get_container_registry_output(folder_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  labels: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                                  name: Optional[pulumi.Input[Optional[str]]] = None,
                                  registry_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContainerRegistryResult]:
    """
    Get information about a Yandex Container Registry. For more information, see [the official documentation](https://cloud.yandex.com/docs/container-registry/concepts/registry)

    ## Example Usage

    {{ tffile "examples/container_registry/d_container_registry_1.tf" }}


    :param str folder_id: Folder that the resource belongs to. If value is omitted, the default provider folder is used.
    :param Mapping[str, str] labels: Labels to assign to this registry.
    :param str name: Name of the registry.
    :param str registry_id: The ID of a specific registry.
    """
    __args__ = dict()
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['name'] = name
    __args__['registryId'] = registry_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getContainerRegistry:getContainerRegistry', __args__, opts=opts, typ=GetContainerRegistryResult)
    return __ret__.apply(lambda __response__: GetContainerRegistryResult(
        created_at=pulumi.get(__response__, 'created_at'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        registry_id=pulumi.get(__response__, 'registry_id'),
        status=pulumi.get(__response__, 'status')))
