# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFunctionScalingPolicyResult',
    'AwaitableGetFunctionScalingPolicyResult',
    'get_function_scaling_policy',
    'get_function_scaling_policy_output',
]

@pulumi.output_type
class GetFunctionScalingPolicyResult:
    """
    A collection of values returned by getFunctionScalingPolicy.
    """
    def __init__(__self__, function_id=None, id=None, policies=None):
        if function_id and not isinstance(function_id, str):
            raise TypeError("Expected argument 'function_id' to be a str")
        pulumi.set(__self__, "function_id", function_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> str:
        return pulumi.get(self, "function_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetFunctionScalingPolicyPolicyResult']:
        """
        list definition for Yandex Cloud Function scaling policies
        * `policy.#` - number of Yandex Cloud Function scaling policies
        * `policy.{num}.tag` - Yandex Cloud Function version tag for Yandex Cloud Function scaling policy
        * `policy.{num}.zone_instances_limit` - max number of instances in one zone for Yandex Cloud Function with tag
        * `policy.{num}.zone_requests_limit` - max number of requests in one zone for Yandex Cloud Function with tag
        """
        return pulumi.get(self, "policies")


class AwaitableGetFunctionScalingPolicyResult(GetFunctionScalingPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFunctionScalingPolicyResult(
            function_id=self.function_id,
            id=self.id,
            policies=self.policies)


def get_function_scaling_policy(function_id: Optional[str] = None,
                                policies: Optional[Sequence[Union['GetFunctionScalingPolicyPolicyArgs', 'GetFunctionScalingPolicyPolicyArgsDict']]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFunctionScalingPolicyResult:
    """
    Get information about a Yandex Cloud Function Scaling Policy. For more information about Yandex Cloud Functions, see [Yandex Cloud Functions](https://cloud.yandex.com/docs/functions/).

    ## Example Usage

    {{ tffile "examples/function_scaling_policy/d_function_scaling_policy_1.tf" }}

    This data source is used to define [Yandex Cloud Function Scaling Policy](https://cloud.yandex.com/docs/functions/) that can be used by other resources.


    :param str function_id: Yandex Cloud Function id used to define function
    :param Sequence[Union['GetFunctionScalingPolicyPolicyArgs', 'GetFunctionScalingPolicyPolicyArgsDict']] policies: list definition for Yandex Cloud Function scaling policies
           * `policy.#` - number of Yandex Cloud Function scaling policies
           * `policy.{num}.tag` - Yandex Cloud Function version tag for Yandex Cloud Function scaling policy
           * `policy.{num}.zone_instances_limit` - max number of instances in one zone for Yandex Cloud Function with tag
           * `policy.{num}.zone_requests_limit` - max number of requests in one zone for Yandex Cloud Function with tag
    """
    __args__ = dict()
    __args__['functionId'] = function_id
    __args__['policies'] = policies
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getFunctionScalingPolicy:getFunctionScalingPolicy', __args__, opts=opts, typ=GetFunctionScalingPolicyResult).value

    return AwaitableGetFunctionScalingPolicyResult(
        function_id=pulumi.get(__ret__, 'function_id'),
        id=pulumi.get(__ret__, 'id'),
        policies=pulumi.get(__ret__, 'policies'))
def get_function_scaling_policy_output(function_id: Optional[pulumi.Input[str]] = None,
                                       policies: Optional[pulumi.Input[Optional[Sequence[Union['GetFunctionScalingPolicyPolicyArgs', 'GetFunctionScalingPolicyPolicyArgsDict']]]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFunctionScalingPolicyResult]:
    """
    Get information about a Yandex Cloud Function Scaling Policy. For more information about Yandex Cloud Functions, see [Yandex Cloud Functions](https://cloud.yandex.com/docs/functions/).

    ## Example Usage

    {{ tffile "examples/function_scaling_policy/d_function_scaling_policy_1.tf" }}

    This data source is used to define [Yandex Cloud Function Scaling Policy](https://cloud.yandex.com/docs/functions/) that can be used by other resources.


    :param str function_id: Yandex Cloud Function id used to define function
    :param Sequence[Union['GetFunctionScalingPolicyPolicyArgs', 'GetFunctionScalingPolicyPolicyArgsDict']] policies: list definition for Yandex Cloud Function scaling policies
           * `policy.#` - number of Yandex Cloud Function scaling policies
           * `policy.{num}.tag` - Yandex Cloud Function version tag for Yandex Cloud Function scaling policy
           * `policy.{num}.zone_instances_limit` - max number of instances in one zone for Yandex Cloud Function with tag
           * `policy.{num}.zone_requests_limit` - max number of requests in one zone for Yandex Cloud Function with tag
    """
    __args__ = dict()
    __args__['functionId'] = function_id
    __args__['policies'] = policies
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getFunctionScalingPolicy:getFunctionScalingPolicy', __args__, opts=opts, typ=GetFunctionScalingPolicyResult)
    return __ret__.apply(lambda __response__: GetFunctionScalingPolicyResult(
        function_id=pulumi.get(__response__, 'function_id'),
        id=pulumi.get(__response__, 'id'),
        policies=pulumi.get(__response__, 'policies')))
