# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetIamUserResult',
    'AwaitableGetIamUserResult',
    'get_iam_user',
    'get_iam_user_output',
]

@pulumi.output_type
class GetIamUserResult:
    """
    A collection of values returned by getIamUser.
    """
    def __init__(__self__, default_email=None, id=None, login=None, user_id=None):
        if default_email and not isinstance(default_email, str):
            raise TypeError("Expected argument 'default_email' to be a str")
        pulumi.set(__self__, "default_email", default_email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if login and not isinstance(login, str):
            raise TypeError("Expected argument 'login' to be a str")
        pulumi.set(__self__, "login", login)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="defaultEmail")
    def default_email(self) -> str:
        """
        Email address of user account.
        """
        return pulumi.get(self, "default_email")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def login(self) -> str:
        """
        Login name of IAM user account.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        ID of IAM user account.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetIamUserResult(GetIamUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIamUserResult(
            default_email=self.default_email,
            id=self.id,
            login=self.login,
            user_id=self.user_id)


def get_iam_user(login: Optional[str] = None,
                 user_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIamUserResult:
    """
    Get information about a Yandex IAM user account. For more information about accounts, see [Yandex Cloud IAM accounts](https://cloud.yandex.com/docs/iam/concepts/#accounts).

    ## Example Usage

    {{ tffile "examples/iam_user/d_iam_user_1.tf" }}

    This data source is used to define [IAM User](https://cloud.yandex.com/docs/iam/concepts/#passport) that can be used by other resources.


    :param str login: Login name used to sign in to Yandex Passport.
    :param str user_id: User ID used to manage IAM access bindings.
           
           > Either `login` or `user_id` must be specified.
    """
    __args__ = dict()
    __args__['login'] = login
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getIamUser:getIamUser', __args__, opts=opts, typ=GetIamUserResult).value

    return AwaitableGetIamUserResult(
        default_email=pulumi.get(__ret__, 'default_email'),
        id=pulumi.get(__ret__, 'id'),
        login=pulumi.get(__ret__, 'login'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_iam_user_output(login: Optional[pulumi.Input[Optional[str]]] = None,
                        user_id: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIamUserResult]:
    """
    Get information about a Yandex IAM user account. For more information about accounts, see [Yandex Cloud IAM accounts](https://cloud.yandex.com/docs/iam/concepts/#accounts).

    ## Example Usage

    {{ tffile "examples/iam_user/d_iam_user_1.tf" }}

    This data source is used to define [IAM User](https://cloud.yandex.com/docs/iam/concepts/#passport) that can be used by other resources.


    :param str login: Login name used to sign in to Yandex Passport.
    :param str user_id: User ID used to manage IAM access bindings.
           
           > Either `login` or `user_id` must be specified.
    """
    __args__ = dict()
    __args__['login'] = login
    __args__['userId'] = user_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getIamUser:getIamUser', __args__, opts=opts, typ=GetIamUserResult)
    return __ret__.apply(lambda __response__: GetIamUserResult(
        default_email=pulumi.get(__response__, 'default_email'),
        id=pulumi.get(__response__, 'id'),
        login=pulumi.get(__response__, 'login'),
        user_id=pulumi.get(__response__, 'user_id')))
