# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLbNetworkLoadBalancerResult',
    'AwaitableGetLbNetworkLoadBalancerResult',
    'get_lb_network_load_balancer',
    'get_lb_network_load_balancer_output',
]

@pulumi.output_type
class GetLbNetworkLoadBalancerResult:
    """
    A collection of values returned by getLbNetworkLoadBalancer.
    """
    def __init__(__self__, attached_target_groups=None, created_at=None, deletion_protection=None, description=None, folder_id=None, id=None, labels=None, listeners=None, name=None, network_load_balancer_id=None, region_id=None, type=None):
        if attached_target_groups and not isinstance(attached_target_groups, list):
            raise TypeError("Expected argument 'attached_target_groups' to be a list")
        pulumi.set(__self__, "attached_target_groups", attached_target_groups)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if listeners and not isinstance(listeners, list):
            raise TypeError("Expected argument 'listeners' to be a list")
        pulumi.set(__self__, "listeners", listeners)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_load_balancer_id and not isinstance(network_load_balancer_id, str):
            raise TypeError("Expected argument 'network_load_balancer_id' to be a str")
        pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        if region_id and not isinstance(region_id, str):
            raise TypeError("Expected argument 'region_id' to be a str")
        pulumi.set(__self__, "region_id", region_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="attachedTargetGroups")
    def attached_target_groups(self) -> Sequence['outputs.GetLbNetworkLoadBalancerAttachedTargetGroupResult']:
        """
        An attached target group is a group of targets that is attached to a load balancer. Structure is documented below.
        """
        return pulumi.get(self, "attached_target_groups")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Creation timestamp of this network load balancer.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        """
        Flag that protects the network load balancer from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the network load balancer.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> str:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels to assign to this network load balancer.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def listeners(self) -> Sequence['outputs.GetLbNetworkLoadBalancerListenerResult']:
        """
        Listener specification that will be used by a network load balancer. Structure is documented below.
        """
        return pulumi.get(self, "listeners")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the listener.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> str:
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        ID of the region where the network load balancer resides.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the network load balancer.
        """
        return pulumi.get(self, "type")


class AwaitableGetLbNetworkLoadBalancerResult(GetLbNetworkLoadBalancerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLbNetworkLoadBalancerResult(
            attached_target_groups=self.attached_target_groups,
            created_at=self.created_at,
            deletion_protection=self.deletion_protection,
            description=self.description,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            listeners=self.listeners,
            name=self.name,
            network_load_balancer_id=self.network_load_balancer_id,
            region_id=self.region_id,
            type=self.type)


def get_lb_network_load_balancer(folder_id: Optional[str] = None,
                                 name: Optional[str] = None,
                                 network_load_balancer_id: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLbNetworkLoadBalancerResult:
    """
    Get information about a Yandex Load Balancer network load balancer. For more information, see [the official documentation](https://cloud.yandex.com/docs/load-balancer/concepts/).

    ## Example Usage

    {{ tffile "examples/lb_network_load_balancer/d_lb_network_load_balancer_1.tf" }}

    This data source is used to define [Load Balancer Network Load Balancers](https://cloud.yandex.com/docs/load-balancer/concepts/) that can be used by other resources.


    :param str folder_id: Folder that the resource belongs to. If value is omitted, the default provider folder is used.
    :param str name: Name of the network load balancer.
           
           > One of `network_load_balancer_id` or `name` should be specified.
    :param str network_load_balancer_id: Network load balancer ID.
    """
    __args__ = dict()
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['networkLoadBalancerId'] = network_load_balancer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getLbNetworkLoadBalancer:getLbNetworkLoadBalancer', __args__, opts=opts, typ=GetLbNetworkLoadBalancerResult).value

    return AwaitableGetLbNetworkLoadBalancerResult(
        attached_target_groups=pulumi.get(__ret__, 'attached_target_groups'),
        created_at=pulumi.get(__ret__, 'created_at'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        listeners=pulumi.get(__ret__, 'listeners'),
        name=pulumi.get(__ret__, 'name'),
        network_load_balancer_id=pulumi.get(__ret__, 'network_load_balancer_id'),
        region_id=pulumi.get(__ret__, 'region_id'),
        type=pulumi.get(__ret__, 'type'))
def get_lb_network_load_balancer_output(folder_id: Optional[pulumi.Input[Optional[str]]] = None,
                                        name: Optional[pulumi.Input[Optional[str]]] = None,
                                        network_load_balancer_id: Optional[pulumi.Input[Optional[str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLbNetworkLoadBalancerResult]:
    """
    Get information about a Yandex Load Balancer network load balancer. For more information, see [the official documentation](https://cloud.yandex.com/docs/load-balancer/concepts/).

    ## Example Usage

    {{ tffile "examples/lb_network_load_balancer/d_lb_network_load_balancer_1.tf" }}

    This data source is used to define [Load Balancer Network Load Balancers](https://cloud.yandex.com/docs/load-balancer/concepts/) that can be used by other resources.


    :param str folder_id: Folder that the resource belongs to. If value is omitted, the default provider folder is used.
    :param str name: Name of the network load balancer.
           
           > One of `network_load_balancer_id` or `name` should be specified.
    :param str network_load_balancer_id: Network load balancer ID.
    """
    __args__ = dict()
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['networkLoadBalancerId'] = network_load_balancer_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getLbNetworkLoadBalancer:getLbNetworkLoadBalancer', __args__, opts=opts, typ=GetLbNetworkLoadBalancerResult)
    return __ret__.apply(lambda __response__: GetLbNetworkLoadBalancerResult(
        attached_target_groups=pulumi.get(__response__, 'attached_target_groups'),
        created_at=pulumi.get(__response__, 'created_at'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        listeners=pulumi.get(__response__, 'listeners'),
        name=pulumi.get(__response__, 'name'),
        network_load_balancer_id=pulumi.get(__response__, 'network_load_balancer_id'),
        region_id=pulumi.get(__response__, 'region_id'),
        type=pulumi.get(__response__, 'type')))
