# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLockboxSecretVersionResult',
    'AwaitableGetLockboxSecretVersionResult',
    'get_lockbox_secret_version',
    'get_lockbox_secret_version_output',
]

@pulumi.output_type
class GetLockboxSecretVersionResult:
    """
    A collection of values returned by getLockboxSecretVersion.
    """
    def __init__(__self__, entries=None, id=None, secret_id=None, version_id=None):
        if entries and not isinstance(entries, list):
            raise TypeError("Expected argument 'entries' to be a list")
        pulumi.set(__self__, "entries", entries)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)
        if version_id and not isinstance(version_id, str):
            raise TypeError("Expected argument 'version_id' to be a str")
        pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.GetLockboxSecretVersionEntryResult']:
        """
        List of entries in the Yandex Cloud Lockbox secret version.
        """
        return pulumi.get(self, "entries")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> str:
        return pulumi.get(self, "version_id")


class AwaitableGetLockboxSecretVersionResult(GetLockboxSecretVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLockboxSecretVersionResult(
            entries=self.entries,
            id=self.id,
            secret_id=self.secret_id,
            version_id=self.version_id)


def get_lockbox_secret_version(secret_id: Optional[str] = None,
                               version_id: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLockboxSecretVersionResult:
    """
    Get information about Yandex Cloud Lockbox secret version. For more information, see [the official documentation](https://yandex.cloud/docs/lockbox/).

    ## Example Usage

    {{ tffile "examples/lockbox_secret_version/d_lockbox_secret_version_1.tf" }}

    If you're creating the secret in the same project, then you should indicate `version_id`, since otherwise you may refer to a wrong version of the secret (e.g. the first version, when it is still empty).

    {{ tffile "examples/lockbox_secret_version/d_lockbox_secret_version_2.tf" }}


    :param str secret_id: The Yandex Cloud Lockbox secret ID.
    :param str version_id: The Yandex Cloud Lockbox secret version ID.
    """
    __args__ = dict()
    __args__['secretId'] = secret_id
    __args__['versionId'] = version_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getLockboxSecretVersion:getLockboxSecretVersion', __args__, opts=opts, typ=GetLockboxSecretVersionResult).value

    return AwaitableGetLockboxSecretVersionResult(
        entries=pulumi.get(__ret__, 'entries'),
        id=pulumi.get(__ret__, 'id'),
        secret_id=pulumi.get(__ret__, 'secret_id'),
        version_id=pulumi.get(__ret__, 'version_id'))
def get_lockbox_secret_version_output(secret_id: Optional[pulumi.Input[str]] = None,
                                      version_id: Optional[pulumi.Input[Optional[str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLockboxSecretVersionResult]:
    """
    Get information about Yandex Cloud Lockbox secret version. For more information, see [the official documentation](https://yandex.cloud/docs/lockbox/).

    ## Example Usage

    {{ tffile "examples/lockbox_secret_version/d_lockbox_secret_version_1.tf" }}

    If you're creating the secret in the same project, then you should indicate `version_id`, since otherwise you may refer to a wrong version of the secret (e.g. the first version, when it is still empty).

    {{ tffile "examples/lockbox_secret_version/d_lockbox_secret_version_2.tf" }}


    :param str secret_id: The Yandex Cloud Lockbox secret ID.
    :param str version_id: The Yandex Cloud Lockbox secret version ID.
    """
    __args__ = dict()
    __args__['secretId'] = secret_id
    __args__['versionId'] = version_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getLockboxSecretVersion:getLockboxSecretVersion', __args__, opts=opts, typ=GetLockboxSecretVersionResult)
    return __ret__.apply(lambda __response__: GetLockboxSecretVersionResult(
        entries=pulumi.get(__response__, 'entries'),
        id=pulumi.get(__response__, 'id'),
        secret_id=pulumi.get(__response__, 'secret_id'),
        version_id=pulumi.get(__response__, 'version_id')))
