# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetLoggingGroupResult',
    'AwaitableGetLoggingGroupResult',
    'get_logging_group',
    'get_logging_group_output',
]

@pulumi.output_type
class GetLoggingGroupResult:
    """
    A collection of values returned by getLoggingGroup.
    """
    def __init__(__self__, cloud_id=None, created_at=None, data_stream=None, description=None, folder_id=None, group_id=None, id=None, labels=None, name=None, retention_period=None, status=None):
        if cloud_id and not isinstance(cloud_id, str):
            raise TypeError("Expected argument 'cloud_id' to be a str")
        pulumi.set(__self__, "cloud_id", cloud_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if data_stream and not isinstance(data_stream, str):
            raise TypeError("Expected argument 'data_stream' to be a str")
        pulumi.set(__self__, "data_stream", data_stream)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if retention_period and not isinstance(retention_period, str):
            raise TypeError("Expected argument 'retention_period' to be a str")
        pulumi.set(__self__, "retention_period", retention_period)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> str:
        """
        ID of the cloud that the Yandex Cloud Logging group belong to.
        """
        return pulumi.get(self, "cloud_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The Yandex Cloud Logging group creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dataStream")
    def data_stream(self) -> str:
        return pulumi.get(self, "data_stream")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The Yandex Cloud Logging group description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> str:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        A set of key/value label pairs assigned to the Yandex Cloud Logging group.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> str:
        """
        The Yandex Cloud Logging group log entries retention period.
        """
        return pulumi.get(self, "retention_period")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The Yandex Cloud Logging group status.
        """
        return pulumi.get(self, "status")


class AwaitableGetLoggingGroupResult(GetLoggingGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoggingGroupResult(
            cloud_id=self.cloud_id,
            created_at=self.created_at,
            data_stream=self.data_stream,
            description=self.description,
            folder_id=self.folder_id,
            group_id=self.group_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            retention_period=self.retention_period,
            status=self.status)


def get_logging_group(folder_id: Optional[str] = None,
                      group_id: Optional[str] = None,
                      name: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoggingGroupResult:
    """
    Get information about a Yandex Cloud Logging group. For more information, see [the official documentation](https://yandex.cloud/docs/logging/concepts/log-group).

    ## Example Usage

    {{ tffile "examples/logging_group/d_logging_group_1.tf" }}


    :param str folder_id: ID of the folder that the Yandex Cloud Logging group belongs to. It will be deduced from provider configuration if not set explicitly.
           
           > If `group_id` is not specified `name` and `folder_id` will be used to designate Yandex Cloud Logging group.
    :param str group_id: The Yandex Cloud Logging group ID.
    :param str name: The Yandex Cloud Logging group name.
    """
    __args__ = dict()
    __args__['folderId'] = folder_id
    __args__['groupId'] = group_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getLoggingGroup:getLoggingGroup', __args__, opts=opts, typ=GetLoggingGroupResult).value

    return AwaitableGetLoggingGroupResult(
        cloud_id=pulumi.get(__ret__, 'cloud_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        data_stream=pulumi.get(__ret__, 'data_stream'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        retention_period=pulumi.get(__ret__, 'retention_period'),
        status=pulumi.get(__ret__, 'status'))
def get_logging_group_output(folder_id: Optional[pulumi.Input[Optional[str]]] = None,
                             group_id: Optional[pulumi.Input[Optional[str]]] = None,
                             name: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLoggingGroupResult]:
    """
    Get information about a Yandex Cloud Logging group. For more information, see [the official documentation](https://yandex.cloud/docs/logging/concepts/log-group).

    ## Example Usage

    {{ tffile "examples/logging_group/d_logging_group_1.tf" }}


    :param str folder_id: ID of the folder that the Yandex Cloud Logging group belongs to. It will be deduced from provider configuration if not set explicitly.
           
           > If `group_id` is not specified `name` and `folder_id` will be used to designate Yandex Cloud Logging group.
    :param str group_id: The Yandex Cloud Logging group ID.
    :param str name: The Yandex Cloud Logging group name.
    """
    __args__ = dict()
    __args__['folderId'] = folder_id
    __args__['groupId'] = group_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getLoggingGroup:getLoggingGroup', __args__, opts=opts, typ=GetLoggingGroupResult)
    return __ret__.apply(lambda __response__: GetLoggingGroupResult(
        cloud_id=pulumi.get(__response__, 'cloud_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        data_stream=pulumi.get(__response__, 'data_stream'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        retention_period=pulumi.get(__response__, 'retention_period'),
        status=pulumi.get(__response__, 'status')))
