# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetMdbKafkaUserResult',
    'AwaitableGetMdbKafkaUserResult',
    'get_mdb_kafka_user',
    'get_mdb_kafka_user_output',
]

@pulumi.output_type
class GetMdbKafkaUserResult:
    """
    A collection of values returned by getMdbKafkaUser.
    """
    def __init__(__self__, cluster_id=None, id=None, name=None, password=None, permissions=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def permissions(self) -> Sequence['outputs.GetMdbKafkaUserPermissionResult']:
        """
        (Optional) Set of permissions granted to the user. The structure is documented below.
        """
        return pulumi.get(self, "permissions")


class AwaitableGetMdbKafkaUserResult(GetMdbKafkaUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMdbKafkaUserResult(
            cluster_id=self.cluster_id,
            id=self.id,
            name=self.name,
            password=self.password,
            permissions=self.permissions)


def get_mdb_kafka_user(cluster_id: Optional[str] = None,
                       name: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMdbKafkaUserResult:
    """
    Get information about a user of the Yandex Managed Kafka cluster. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-kafka/concepts).

    ## Example Usage

    {{ tffile "examples/mdb_kafka_user/d_mdb_kafka_user_1.tf" }}


    :param str cluster_id: The ID of the Kafka cluster.
    :param str name: The name of the Kafka user.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getMdbKafkaUser:getMdbKafkaUser', __args__, opts=opts, typ=GetMdbKafkaUserResult).value

    return AwaitableGetMdbKafkaUserResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        password=pulumi.get(__ret__, 'password'),
        permissions=pulumi.get(__ret__, 'permissions'))
def get_mdb_kafka_user_output(cluster_id: Optional[pulumi.Input[str]] = None,
                              name: Optional[pulumi.Input[str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMdbKafkaUserResult]:
    """
    Get information about a user of the Yandex Managed Kafka cluster. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-kafka/concepts).

    ## Example Usage

    {{ tffile "examples/mdb_kafka_user/d_mdb_kafka_user_1.tf" }}


    :param str cluster_id: The ID of the Kafka cluster.
    :param str name: The name of the Kafka user.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getMdbKafkaUser:getMdbKafkaUser', __args__, opts=opts, typ=GetMdbKafkaUserResult)
    return __ret__.apply(lambda __response__: GetMdbKafkaUserResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        password=pulumi.get(__response__, 'password'),
        permissions=pulumi.get(__response__, 'permissions')))
