# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMdbMysqlClusterResult',
    'AwaitableGetMdbMysqlClusterResult',
    'get_mdb_mysql_cluster',
    'get_mdb_mysql_cluster_output',
]

@pulumi.output_type
class GetMdbMysqlClusterResult:
    """
    A collection of values returned by getMdbMysqlCluster.
    """
    def __init__(__self__, access=None, backup_retain_period_days=None, backup_window_starts=None, cluster_id=None, created_at=None, databases=None, deletion_protection=None, description=None, environment=None, folder_id=None, health=None, host_group_ids=None, hosts=None, id=None, labels=None, maintenance_windows=None, mysql_config=None, name=None, network_id=None, performance_diagnostics=None, resources=None, security_group_ids=None, status=None, users=None, version=None):
        if access and not isinstance(access, dict):
            raise TypeError("Expected argument 'access' to be a dict")
        pulumi.set(__self__, "access", access)
        if backup_retain_period_days and not isinstance(backup_retain_period_days, int):
            raise TypeError("Expected argument 'backup_retain_period_days' to be a int")
        pulumi.set(__self__, "backup_retain_period_days", backup_retain_period_days)
        if backup_window_starts and not isinstance(backup_window_starts, list):
            raise TypeError("Expected argument 'backup_window_starts' to be a list")
        pulumi.set(__self__, "backup_window_starts", backup_window_starts)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if databases and not isinstance(databases, list):
            raise TypeError("Expected argument 'databases' to be a list")
        pulumi.set(__self__, "databases", databases)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if health and not isinstance(health, str):
            raise TypeError("Expected argument 'health' to be a str")
        pulumi.set(__self__, "health", health)
        if host_group_ids and not isinstance(host_group_ids, list):
            raise TypeError("Expected argument 'host_group_ids' to be a list")
        pulumi.set(__self__, "host_group_ids", host_group_ids)
        if hosts and not isinstance(hosts, list):
            raise TypeError("Expected argument 'hosts' to be a list")
        pulumi.set(__self__, "hosts", hosts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if maintenance_windows and not isinstance(maintenance_windows, list):
            raise TypeError("Expected argument 'maintenance_windows' to be a list")
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if mysql_config and not isinstance(mysql_config, dict):
            raise TypeError("Expected argument 'mysql_config' to be a dict")
        pulumi.set(__self__, "mysql_config", mysql_config)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if performance_diagnostics and not isinstance(performance_diagnostics, list):
            raise TypeError("Expected argument 'performance_diagnostics' to be a list")
        pulumi.set(__self__, "performance_diagnostics", performance_diagnostics)
        if resources and not isinstance(resources, list):
            raise TypeError("Expected argument 'resources' to be a list")
        pulumi.set(__self__, "resources", resources)
        if security_group_ids and not isinstance(security_group_ids, list):
            raise TypeError("Expected argument 'security_group_ids' to be a list")
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def access(self) -> 'outputs.GetMdbMysqlClusterAccessResult':
        """
        Access policy to the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter(name="backupRetainPeriodDays")
    def backup_retain_period_days(self) -> int:
        """
        The period in days during which backups are stored.
        """
        return pulumi.get(self, "backup_retain_period_days")

    @property
    @pulumi.getter(name="backupWindowStarts")
    def backup_window_starts(self) -> Sequence['outputs.GetMdbMysqlClusterBackupWindowStartResult']:
        return pulumi.get(self, "backup_window_starts")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Creation timestamp of the key.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def databases(self) -> Sequence['outputs.GetMdbMysqlClusterDatabaseResult']:
        """
        A database of the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the MySQL cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> str:
        """
        Deployment environment of the MySQL cluster.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> str:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        Aggregated health of the cluster.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Sequence[str]:
        return pulumi.get(self, "host_group_ids")

    @property
    @pulumi.getter
    def hosts(self) -> Sequence['outputs.GetMdbMysqlClusterHostResult']:
        """
        A host of the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        A set of key/value label pairs to assign to the MySQL cluster.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetMdbMysqlClusterMaintenanceWindowResult']:
        """
        Maintenance window settings of the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="mysqlConfig")
    def mysql_config(self) -> Mapping[str, str]:
        """
        MySQL cluster config.
        """
        return pulumi.get(self, "mysql_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the database.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> str:
        """
        ID of the network, to which the MySQL cluster belongs.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="performanceDiagnostics")
    def performance_diagnostics(self) -> Sequence['outputs.GetMdbMysqlClusterPerformanceDiagnosticResult']:
        """
        Cluster performance diagnostics settings. The structure is documented below. [YC Documentation](https://cloud.yandex.com/docs/managed-mysql/api-ref/grpc/cluster_service#PerformanceDiagnostics)
        """
        return pulumi.get(self, "performance_diagnostics")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetMdbMysqlClusterResourceResult']:
        """
        Resources allocated to hosts of the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        A set of ids of security groups assigned to hosts of the cluster.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetMdbMysqlClusterUserResult']:
        """
        A user of the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of the MySQL cluster.
        """
        return pulumi.get(self, "version")


class AwaitableGetMdbMysqlClusterResult(GetMdbMysqlClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMdbMysqlClusterResult(
            access=self.access,
            backup_retain_period_days=self.backup_retain_period_days,
            backup_window_starts=self.backup_window_starts,
            cluster_id=self.cluster_id,
            created_at=self.created_at,
            databases=self.databases,
            deletion_protection=self.deletion_protection,
            description=self.description,
            environment=self.environment,
            folder_id=self.folder_id,
            health=self.health,
            host_group_ids=self.host_group_ids,
            hosts=self.hosts,
            id=self.id,
            labels=self.labels,
            maintenance_windows=self.maintenance_windows,
            mysql_config=self.mysql_config,
            name=self.name,
            network_id=self.network_id,
            performance_diagnostics=self.performance_diagnostics,
            resources=self.resources,
            security_group_ids=self.security_group_ids,
            status=self.status,
            users=self.users,
            version=self.version)


def get_mdb_mysql_cluster(access: Optional[Union['GetMdbMysqlClusterAccessArgs', 'GetMdbMysqlClusterAccessArgsDict']] = None,
                          cluster_id: Optional[str] = None,
                          deletion_protection: Optional[bool] = None,
                          description: Optional[str] = None,
                          folder_id: Optional[str] = None,
                          labels: Optional[Mapping[str, str]] = None,
                          mysql_config: Optional[Mapping[str, str]] = None,
                          name: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMdbMysqlClusterResult:
    """
    Get information about a Yandex Managed MySQL cluster. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-mysql/).

    ## Example Usage

    {{ tffile "examples/mdb_mysql_cluster/d_mdb_mysql_cluster_1.tf" }}


    :param Union['GetMdbMysqlClusterAccessArgs', 'GetMdbMysqlClusterAccessArgsDict'] access: Access policy to the MySQL cluster. The structure is documented below.
    :param str cluster_id: The ID of the MySQL cluster.
    :param str description: Description of the MySQL cluster.
    :param str folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
    :param Mapping[str, str] labels: A set of key/value label pairs to assign to the MySQL cluster.
    :param Mapping[str, str] mysql_config: MySQL cluster config.
    :param str name: The name of the MySQL cluster.
           
           > Either `cluster_id` or `name` should be specified.
    """
    __args__ = dict()
    __args__['access'] = access
    __args__['clusterId'] = cluster_id
    __args__['deletionProtection'] = deletion_protection
    __args__['description'] = description
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['mysqlConfig'] = mysql_config
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getMdbMysqlCluster:getMdbMysqlCluster', __args__, opts=opts, typ=GetMdbMysqlClusterResult).value

    return AwaitableGetMdbMysqlClusterResult(
        access=pulumi.get(__ret__, 'access'),
        backup_retain_period_days=pulumi.get(__ret__, 'backup_retain_period_days'),
        backup_window_starts=pulumi.get(__ret__, 'backup_window_starts'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        databases=pulumi.get(__ret__, 'databases'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        description=pulumi.get(__ret__, 'description'),
        environment=pulumi.get(__ret__, 'environment'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        health=pulumi.get(__ret__, 'health'),
        host_group_ids=pulumi.get(__ret__, 'host_group_ids'),
        hosts=pulumi.get(__ret__, 'hosts'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        maintenance_windows=pulumi.get(__ret__, 'maintenance_windows'),
        mysql_config=pulumi.get(__ret__, 'mysql_config'),
        name=pulumi.get(__ret__, 'name'),
        network_id=pulumi.get(__ret__, 'network_id'),
        performance_diagnostics=pulumi.get(__ret__, 'performance_diagnostics'),
        resources=pulumi.get(__ret__, 'resources'),
        security_group_ids=pulumi.get(__ret__, 'security_group_ids'),
        status=pulumi.get(__ret__, 'status'),
        users=pulumi.get(__ret__, 'users'),
        version=pulumi.get(__ret__, 'version'))
def get_mdb_mysql_cluster_output(access: Optional[pulumi.Input[Optional[Union['GetMdbMysqlClusterAccessArgs', 'GetMdbMysqlClusterAccessArgsDict']]]] = None,
                                 cluster_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 deletion_protection: Optional[pulumi.Input[Optional[bool]]] = None,
                                 description: Optional[pulumi.Input[Optional[str]]] = None,
                                 folder_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 labels: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                                 mysql_config: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                                 name: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMdbMysqlClusterResult]:
    """
    Get information about a Yandex Managed MySQL cluster. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-mysql/).

    ## Example Usage

    {{ tffile "examples/mdb_mysql_cluster/d_mdb_mysql_cluster_1.tf" }}


    :param Union['GetMdbMysqlClusterAccessArgs', 'GetMdbMysqlClusterAccessArgsDict'] access: Access policy to the MySQL cluster. The structure is documented below.
    :param str cluster_id: The ID of the MySQL cluster.
    :param str description: Description of the MySQL cluster.
    :param str folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
    :param Mapping[str, str] labels: A set of key/value label pairs to assign to the MySQL cluster.
    :param Mapping[str, str] mysql_config: MySQL cluster config.
    :param str name: The name of the MySQL cluster.
           
           > Either `cluster_id` or `name` should be specified.
    """
    __args__ = dict()
    __args__['access'] = access
    __args__['clusterId'] = cluster_id
    __args__['deletionProtection'] = deletion_protection
    __args__['description'] = description
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['mysqlConfig'] = mysql_config
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getMdbMysqlCluster:getMdbMysqlCluster', __args__, opts=opts, typ=GetMdbMysqlClusterResult)
    return __ret__.apply(lambda __response__: GetMdbMysqlClusterResult(
        access=pulumi.get(__response__, 'access'),
        backup_retain_period_days=pulumi.get(__response__, 'backup_retain_period_days'),
        backup_window_starts=pulumi.get(__response__, 'backup_window_starts'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        databases=pulumi.get(__response__, 'databases'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        description=pulumi.get(__response__, 'description'),
        environment=pulumi.get(__response__, 'environment'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        health=pulumi.get(__response__, 'health'),
        host_group_ids=pulumi.get(__response__, 'host_group_ids'),
        hosts=pulumi.get(__response__, 'hosts'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        maintenance_windows=pulumi.get(__response__, 'maintenance_windows'),
        mysql_config=pulumi.get(__response__, 'mysql_config'),
        name=pulumi.get(__response__, 'name'),
        network_id=pulumi.get(__response__, 'network_id'),
        performance_diagnostics=pulumi.get(__response__, 'performance_diagnostics'),
        resources=pulumi.get(__response__, 'resources'),
        security_group_ids=pulumi.get(__response__, 'security_group_ids'),
        status=pulumi.get(__response__, 'status'),
        users=pulumi.get(__response__, 'users'),
        version=pulumi.get(__response__, 'version')))
