# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMdbMysqlUserResult',
    'AwaitableGetMdbMysqlUserResult',
    'get_mdb_mysql_user',
    'get_mdb_mysql_user_output',
]

@pulumi.output_type
class GetMdbMysqlUserResult:
    """
    A collection of values returned by getMdbMysqlUser.
    """
    def __init__(__self__, authentication_plugin=None, cluster_id=None, connection_limits=None, global_permissions=None, id=None, name=None, permissions=None):
        if authentication_plugin and not isinstance(authentication_plugin, str):
            raise TypeError("Expected argument 'authentication_plugin' to be a str")
        pulumi.set(__self__, "authentication_plugin", authentication_plugin)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if connection_limits and not isinstance(connection_limits, list):
            raise TypeError("Expected argument 'connection_limits' to be a list")
        pulumi.set(__self__, "connection_limits", connection_limits)
        if global_permissions and not isinstance(global_permissions, list):
            raise TypeError("Expected argument 'global_permissions' to be a list")
        pulumi.set(__self__, "global_permissions", global_permissions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="authenticationPlugin")
    def authentication_plugin(self) -> str:
        """
        Authentication plugin. Allowed values: `MYSQL_NATIVE_PASSWORD`, `CACHING_SHA2_PASSWORD`, `SHA256_PASSWORD`
        """
        return pulumi.get(self, "authentication_plugin")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="connectionLimits")
    def connection_limits(self) -> Sequence['outputs.GetMdbMysqlUserConnectionLimitResult']:
        """
        User's connection limits. The structure is documented below.
        """
        return pulumi.get(self, "connection_limits")

    @property
    @pulumi.getter(name="globalPermissions")
    def global_permissions(self) -> Sequence[str]:
        """
        List user's global permissions. Allowed values: `REPLICATION_CLIENT`, `REPLICATION_SLAVE`, `PROCESS` or empty list.
        """
        return pulumi.get(self, "global_permissions")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permissions(self) -> Sequence['outputs.GetMdbMysqlUserPermissionResult']:
        """
        Set of permissions granted to the user. The structure is documented below.
        """
        return pulumi.get(self, "permissions")


class AwaitableGetMdbMysqlUserResult(GetMdbMysqlUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMdbMysqlUserResult(
            authentication_plugin=self.authentication_plugin,
            cluster_id=self.cluster_id,
            connection_limits=self.connection_limits,
            global_permissions=self.global_permissions,
            id=self.id,
            name=self.name,
            permissions=self.permissions)


def get_mdb_mysql_user(cluster_id: Optional[str] = None,
                       name: Optional[str] = None,
                       permissions: Optional[Sequence[Union['GetMdbMysqlUserPermissionArgs', 'GetMdbMysqlUserPermissionArgsDict']]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMdbMysqlUserResult:
    """
    Get information about a Yandex Managed MySQL user. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-mysql/).

    ## Example Usage

    {{ tffile "examples/mdb_mysql_user/d_mdb_mysql_user_1.tf" }}


    :param str cluster_id: The ID of the MySQL cluster.
    :param str name: The name of the MySQL user.
    :param Sequence[Union['GetMdbMysqlUserPermissionArgs', 'GetMdbMysqlUserPermissionArgsDict']] permissions: Set of permissions granted to the user. The structure is documented below.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['permissions'] = permissions
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getMdbMysqlUser:getMdbMysqlUser', __args__, opts=opts, typ=GetMdbMysqlUserResult).value

    return AwaitableGetMdbMysqlUserResult(
        authentication_plugin=pulumi.get(__ret__, 'authentication_plugin'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        connection_limits=pulumi.get(__ret__, 'connection_limits'),
        global_permissions=pulumi.get(__ret__, 'global_permissions'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        permissions=pulumi.get(__ret__, 'permissions'))
def get_mdb_mysql_user_output(cluster_id: Optional[pulumi.Input[str]] = None,
                              name: Optional[pulumi.Input[str]] = None,
                              permissions: Optional[pulumi.Input[Optional[Sequence[Union['GetMdbMysqlUserPermissionArgs', 'GetMdbMysqlUserPermissionArgsDict']]]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMdbMysqlUserResult]:
    """
    Get information about a Yandex Managed MySQL user. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-mysql/).

    ## Example Usage

    {{ tffile "examples/mdb_mysql_user/d_mdb_mysql_user_1.tf" }}


    :param str cluster_id: The ID of the MySQL cluster.
    :param str name: The name of the MySQL user.
    :param Sequence[Union['GetMdbMysqlUserPermissionArgs', 'GetMdbMysqlUserPermissionArgsDict']] permissions: Set of permissions granted to the user. The structure is documented below.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['permissions'] = permissions
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getMdbMysqlUser:getMdbMysqlUser', __args__, opts=opts, typ=GetMdbMysqlUserResult)
    return __ret__.apply(lambda __response__: GetMdbMysqlUserResult(
        authentication_plugin=pulumi.get(__response__, 'authentication_plugin'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        connection_limits=pulumi.get(__response__, 'connection_limits'),
        global_permissions=pulumi.get(__response__, 'global_permissions'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        permissions=pulumi.get(__response__, 'permissions')))
