# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetOrganizationmanagerUserSshKeyResult',
    'AwaitableGetOrganizationmanagerUserSshKeyResult',
    'get_organizationmanager_user_ssh_key',
    'get_organizationmanager_user_ssh_key_output',
]

@pulumi.output_type
class GetOrganizationmanagerUserSshKeyResult:
    """
    A collection of values returned by getOrganizationmanagerUserSshKey.
    """
    def __init__(__self__, created_at=None, data=None, expires_at=None, fingerprint=None, id=None, name=None, organization_id=None, subject_id=None, user_ssh_key_id=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if data and not isinstance(data, str):
            raise TypeError("Expected argument 'data' to be a str")
        pulumi.set(__self__, "data", data)
        if expires_at and not isinstance(expires_at, str):
            raise TypeError("Expected argument 'expires_at' to be a str")
        pulumi.set(__self__, "expires_at", expires_at)
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if subject_id and not isinstance(subject_id, str):
            raise TypeError("Expected argument 'subject_id' to be a str")
        pulumi.set(__self__, "subject_id", subject_id)
        if user_ssh_key_id and not isinstance(user_ssh_key_id, str):
            raise TypeError("Expected argument 'user_ssh_key_id' to be a str")
        pulumi.set(__self__, "user_ssh_key_id", user_ssh_key_id)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        User ssh key creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def data(self) -> Optional[str]:
        """
        Data of the user ssh key.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[str]:
        """
        User ssh key will be no longer valid after expiration timestamp.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        """
        Auto generated fingerprint of the user ssh key.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the user ssh key.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[str]:
        """
        Organization that the user ssh key belongs to.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="subjectId")
    def subject_id(self) -> Optional[str]:
        """
        Subject that the user ssh key belongs to.
        """
        return pulumi.get(self, "subject_id")

    @property
    @pulumi.getter(name="userSshKeyId")
    def user_ssh_key_id(self) -> str:
        return pulumi.get(self, "user_ssh_key_id")


class AwaitableGetOrganizationmanagerUserSshKeyResult(GetOrganizationmanagerUserSshKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationmanagerUserSshKeyResult(
            created_at=self.created_at,
            data=self.data,
            expires_at=self.expires_at,
            fingerprint=self.fingerprint,
            id=self.id,
            name=self.name,
            organization_id=self.organization_id,
            subject_id=self.subject_id,
            user_ssh_key_id=self.user_ssh_key_id)


def get_organizationmanager_user_ssh_key(data: Optional[str] = None,
                                         expires_at: Optional[str] = None,
                                         name: Optional[str] = None,
                                         organization_id: Optional[str] = None,
                                         subject_id: Optional[str] = None,
                                         user_ssh_key_id: Optional[str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationmanagerUserSshKeyResult:
    """
    Get information about a Yandex Cloud User SSH Key.

    ## Example Usage

    {{ tffile "examples/organizationmanager_user_ssh_key/d_organizationmanager_user_ssh_key_1.tf" }}


    :param str data: Data of the user ssh key.
    :param str expires_at: User ssh key will be no longer valid after expiration timestamp.
    :param str name: Name of the user ssh key.
    :param str organization_id: Organization that the user ssh key belongs to.
    :param str subject_id: Subject that the user ssh key belongs to.
    :param str user_ssh_key_id: ID of the user ssh key.
    """
    __args__ = dict()
    __args__['data'] = data
    __args__['expiresAt'] = expires_at
    __args__['name'] = name
    __args__['organizationId'] = organization_id
    __args__['subjectId'] = subject_id
    __args__['userSshKeyId'] = user_ssh_key_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getOrganizationmanagerUserSshKey:getOrganizationmanagerUserSshKey', __args__, opts=opts, typ=GetOrganizationmanagerUserSshKeyResult).value

    return AwaitableGetOrganizationmanagerUserSshKeyResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        data=pulumi.get(__ret__, 'data'),
        expires_at=pulumi.get(__ret__, 'expires_at'),
        fingerprint=pulumi.get(__ret__, 'fingerprint'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        subject_id=pulumi.get(__ret__, 'subject_id'),
        user_ssh_key_id=pulumi.get(__ret__, 'user_ssh_key_id'))
def get_organizationmanager_user_ssh_key_output(data: Optional[pulumi.Input[Optional[str]]] = None,
                                                expires_at: Optional[pulumi.Input[Optional[str]]] = None,
                                                name: Optional[pulumi.Input[Optional[str]]] = None,
                                                organization_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                subject_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                user_ssh_key_id: Optional[pulumi.Input[str]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrganizationmanagerUserSshKeyResult]:
    """
    Get information about a Yandex Cloud User SSH Key.

    ## Example Usage

    {{ tffile "examples/organizationmanager_user_ssh_key/d_organizationmanager_user_ssh_key_1.tf" }}


    :param str data: Data of the user ssh key.
    :param str expires_at: User ssh key will be no longer valid after expiration timestamp.
    :param str name: Name of the user ssh key.
    :param str organization_id: Organization that the user ssh key belongs to.
    :param str subject_id: Subject that the user ssh key belongs to.
    :param str user_ssh_key_id: ID of the user ssh key.
    """
    __args__ = dict()
    __args__['data'] = data
    __args__['expiresAt'] = expires_at
    __args__['name'] = name
    __args__['organizationId'] = organization_id
    __args__['subjectId'] = subject_id
    __args__['userSshKeyId'] = user_ssh_key_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getOrganizationmanagerUserSshKey:getOrganizationmanagerUserSshKey', __args__, opts=opts, typ=GetOrganizationmanagerUserSshKeyResult)
    return __ret__.apply(lambda __response__: GetOrganizationmanagerUserSshKeyResult(
        created_at=pulumi.get(__response__, 'created_at'),
        data=pulumi.get(__response__, 'data'),
        expires_at=pulumi.get(__response__, 'expires_at'),
        fingerprint=pulumi.get(__response__, 'fingerprint'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        subject_id=pulumi.get(__response__, 'subject_id'),
        user_ssh_key_id=pulumi.get(__response__, 'user_ssh_key_id')))
